/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.AutoOrientationJDialog;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.JFixedTextField;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class UserSearch
extends AutoOrientationJDialog
implements ActionListener,
ItemListener {
    static SafeResourceBundle userSearchBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    public static final int BTN_CANCEL = 0;
    public static final int BTN_OK = 1;
    private Frame _parent;
    private Vector result = new Vector(20);
    private Vector selectedUsers = new Vector(20);
    private Vector origUsers = new Vector(20);
    private Vector selectedUsersCheck = new Vector(20);
    private String[] servers = null;
    private iIMListModel model;
    private iIMListModel selModel;
    private iIMListRenderer renderer;
    private iIMListRenderer selRenderer;
    private static boolean _is_searching = false;
    private boolean limitWasExceeded = false;
    private boolean _isSelectionView = true;
    private boolean _expandGroupsOnAdd = false;
    JPanel pnlTop = new JPanel();
    JComboBox cmbSearchType = new JComboBox();
    JLabel lblSearchBy = new JLabel();
    JFixedTextField txtSearchID = new JFixedTextField();
    JLabel lblSearchOptions = new JLabel();
    JButton btnSearch = new JButton();
    JComboBox cmbSearchOptions = new JComboBox();
    JPanel pnlCenter = new JPanel();
    JPanel pnlSearch = new JPanel();
    JLabel lblResult = new JLabel();
    JLabel lblExtra = new JLabel();
    JScrollPane scrResult = new JScrollPane();
    JList lstResult = new JList();
    JPanel pnlSelection = new JPanel();
    JButton btnAddSel = new JButton();
    JButton btnRemoveSel = new JButton();
    JLabel lblSelection = new JLabel();
    JScrollPane scrSelect = new JScrollPane();
    JList lstSelect = new JList();
    JPanel pnlAdd = new JPanel();
    JLabel lblAddToGroup = new JLabel();
    JComboBox cmbGroups = new JComboBox();
    JButton btnAdd = new JButton();
    DialogButtonsPanel pnlButtons;
    private int clickedButton = -1;

    public UserSearch(Frame p, boolean b, boolean expand_groups) {
        super(p);
        this._parent = p;
        this._isSelectionView = b;
        this._expandGroupsOnAdd = expand_groups;
        this.initComponents();
        this.refresh();
    }

    private void initComponents() {
        this.pnlButtons = new DialogButtonsPanel(this);
        this.pnlButtons.setCancelButtonLabel(4);
        String title = userSearchBundle.getString("US_title");
        this.setTitle(title);
        this.getAccessibleContext().setAccessibleDescription(title);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(570, 454);
        this.setVisible(false);
        this.pnlTop.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pnlTop, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 10, 1, new Insets(4, 0, 0, 5), 100, 0));
        this.pnlTop.add((Component)this.cmbSearchType, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 2, 0, 2), 0, 0));
        this.lblSearchBy.setText(userSearchBundle.getString("US_search_by"));
        this.lblSearchBy.setLabelFor(this.cmbSearchType);
        this.pnlTop.add((Component)this.lblSearchBy, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.pnlTop.add((Component)this.txtSearchID, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 2, 0, 2), 40, 2));
        this.lblSearchOptions.setText(userSearchBundle.getString("US_search_options"));
        this.lblSearchOptions.setLabelFor(this.cmbSearchOptions);
        this.pnlTop.add((Component)this.lblSearchOptions, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 5, 2, 2), 0, 0));
        this.pnlTop.add((Component)this.cmbSearchOptions, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.btnSearch.setText(userSearchBundle.getString("US_search"));
        this.btnSearch.setMnemonic(userSearchBundle.getString("US_search_M").charAt(0));
        this.getRootPane().setDefaultButton(this.btnSearch);
        this.pnlTop.add((Component)this.btnSearch, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 35, 0));
        this.pnlCenter.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pnlCenter, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 10, 1, new Insets(5, 2, 2, 1), 0, 0));
        this.pnlSearch.setLayout(new GridBagLayout());
        this.pnlCenter.add((Component)this.pnlSearch, new GridBagConstraints(0, 0, 2, 2, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.lblExtra.setText("");
        this.pnlSearch.add((Component)this.lblExtra, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 0, 1, 0), 0, 0));
        this.lblResult.setText(userSearchBundle.getString("US_results"));
        this.lblResult.setLabelFor(this.lstResult);
        this.pnlSearch.add((Component)this.lblResult, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 0, 1, 0), 0, 0));
        this.pnlSearch.add((Component)this.scrResult, new GridBagConstraints(-1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 150, 0));
        this.scrResult.setViewportView(this.lstResult);
        this.pnlSelection.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pnlSelection, new GridBagConstraints(2, 1, 3, 2, 1.0, 1.0, 10, 1, new Insets(5, 0, 2, 2), 0, 0));
        this.btnAddSel.setText(userSearchBundle.getString("US_add"));
        this.btnAddSel.setMnemonic(userSearchBundle.getString("US_add_M").charAt(0));
        this.pnlSelection.add((Component)this.btnAddSel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(50, 0, 0, 2), 35, 0));
        this.btnRemoveSel.setText(userSearchBundle.getString("US_remove"));
        this.btnRemoveSel.setMnemonic(userSearchBundle.getString("US_remove_M").charAt(0));
        this.pnlSelection.add((Component)this.btnRemoveSel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 2), 35, 0));
        this.lblSelection.setText(userSearchBundle.getString("US_select"));
        this.lblSelection.setLabelFor(this.lstSelect);
        this.pnlSelection.add((Component)this.lblSelection, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.pnlSelection.add((Component)this.scrSelect, new GridBagConstraints(1, 1, 2, 4, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 2), 150, 0));
        this.scrSelect.setViewportView(this.lstSelect);
        this.pnlAdd.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pnlAdd, new GridBagConstraints(0, 4, 5, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 4, 0), 0, 0));
        this.lblAddToGroup.setText(userSearchBundle.getString("US_add_group"));
        this.lblAddToGroup.setLabelFor(this.cmbGroups);
        this.pnlAdd.add((Component)this.lblAddToGroup, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 4, 0, 0), 0, 0));
        this.pnlAdd.add((Component)this.cmbGroups, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 5, 0, 2), 25, 0));
        this.btnAdd.setText(userSearchBundle.getString("US_add1"));
        this.pnlAdd.add((Component)this.btnAdd, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 0, 0, 10), 65, 0));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int pointX = (double)(this._parent.getX() + 100 + 450) > d.getWidth() ? (int)d.getWidth() - 450 - 100 : this._parent.getX() + 100;
        int pointY = (double)(this._parent.getY() + 100 + 454) > d.getHeight() ? (int)d.getHeight() - 454 - 100 : this._parent.getY() + 100;
        this.setLocation(pointX, pointY);
        if (!this._isSelectionView) {
            this.pnlSelection.setVisible(false);
        } else {
            this.pnlAdd.setVisible(false);
        }
        this.btnSearch.addActionListener(this);
        this.btnAdd.addActionListener(this);
        this.btnAddSel.addActionListener(this);
        this.btnRemoveSel.addActionListener(this);
        this.cmbSearchType.addItem(userSearchBundle.getString("US_cmbId"));
        this.cmbSearchType.addItem(userSearchBundle.getString("US_cmbName"));
        this.cmbSearchType.setSelectedIndex(1);
        this.cmbSearchType.addItemListener(this);
        this.cmbSearchOptions.setEnabled(true);
        this.btnAddSel.setMargin(new Insets(0, 0, 0, 0));
        this.btnRemoveSel.setMargin(new Insets(0, 0, 0, 0));
        this.cmbSearchOptions.addItem(userSearchBundle.getString("cmbSearchOptions_Contains"));
        this.cmbSearchOptions.addItem(userSearchBundle.getString("cmbSearchOptions_StartsWith"));
        this.cmbSearchOptions.addItem(userSearchBundle.getString("cmbSearchOptions_EndsWith"));
        this.model = new iIMListModel(this.lstResult, this.result);
        this.selModel = new iIMListModel(this.lstSelect, this.selectedUsers);
        this.renderer = new iIMListRenderer(this.model);
        this.lstResult.setCellRenderer(this.renderer);
        this.lstResult.setModel(this.model);
        this.selRenderer = new iIMListRenderer(this.selModel);
        this.lstSelect.setCellRenderer(this.selRenderer);
        this.lstSelect.setModel(this.selModel);
    }

    public UserSearch(Frame p, CollaborationPrincipal[] list, boolean show_selection_change, boolean expand_groups) {
        this(p, show_selection_change, expand_groups);
        this.selectedUsers = Manager.getVectorFromArray(list);
        this.origUsers = Manager.getVectorFromArray(list);
        this.selectedUsersCheck = Manager.getVectorFromArray(UserCache.getUIDsFromUsers(Manager.getVectorFromArray(list)));
        this.selModel.changed(this.selectedUsers);
    }

    public void itemStateChanged(ItemEvent evt) {
        if (this.cmbSearchType.getSelectedIndex() == 0) {
            this.cmbSearchOptions.setEnabled(false);
        } else {
            this.cmbSearchOptions.setEnabled(true);
        }
    }

    public void refresh() {
        this.cmbGroups.removeAllItems();
        String[] grps = BuddyListManager.getBuddyListGroups();
        for (int x = 0; x < grps.length; ++x) {
            this.cmbGroups.addItem(grps[x]);
            if (this._isSelectionView || !grps[x].equals(((Communicator)this._parent).getCurrentBuddyListGroup())) continue;
            this.cmbGroups.setSelectedIndex(x);
        }
        this.result.removeAllElements();
        this.model.changed(this.result);
    }

    public void addGroup(String g) {
        this.cmbGroups.addItem(g);
        this.cmbGroups.revalidate();
    }

    public void removeGroup(String g) {
        this.cmbGroups.removeItem(g);
        this.cmbGroups.revalidate();
    }

    public void refresh(String searchFor, CollaborationPrincipal[] u, String group) {
        this.refresh();
        this.result = Manager.getVectorFromArray(u);
        this.model.changed(StringUtility.sort((Vector)this.result));
        this.txtSearchID.setText(searchFor);
        this.cmbGroups.removeAllItems();
        String[] grps = BuddyListManager.getBuddyListGroups();
        int sel = 0;
        for (int x = 0; x < grps.length; ++x) {
            if (grps[x].equals(group)) {
                sel = x;
            }
            this.cmbGroups.addItem(grps[x]);
        }
        this.result.removeAllElements();
        this.model.changed(this.result);
        this.cmbGroups.setSelectedIndex(sel);
    }

    public boolean isSearchByID() {
        return this.cmbSearchType.getSelectedIndex() == 0;
    }

    public void search() {
        int searchType = 0;
        if (this.txtSearchID.getText().length() <= 0) {
            String msg = userSearchBundle.getString("Enter_a_String_to_search_for");
            JOptionPane.showMessageDialog(this, msg, userSearchBundle.getString("Search_Message_Title"), 1);
            return;
        }
        if (!this.isSearchByID()) {
            int length;
            int minLength = 3;
            String slen = userSearchBundle.getString("Minimum_search_length");
            if (slen != null) {
                try {
                    Integer ilen = new Integer(slen);
                    minLength = ilen;
                }
                catch (Exception e) {
                    System.err.println("UserSearch.search(): Exception thrown: " + e);
                }
            }
            try {
                byte[] x = this.txtSearchID.getText().getBytes("UTF-8");
                length = x.length;
            }
            catch (Exception e1) {
                length = this.txtSearchID.getText().length();
                System.err.println("UserSearch.search(): Exception thrown: " + e1);
            }
            if (length < minLength) {
                String msg = StringUtility.substitute((String)userSearchBundle.getString("Enter_at_least_num"), (String)"__MACRO__", (String)Integer.toString(minLength));
                JOptionPane.showMessageDialog(this, msg, userSearchBundle.getString("Search_Message_Title"), 1);
                return;
            }
        }
        this.btnSearch.setEnabled(false);
        if (_is_searching) {
            return;
        }
        _is_searching = true;
        this.lblResult.setText(userSearchBundle.getString("lblResult_text"));
        String txt = this.txtSearchID.getText();
        if (!this.isSearchByID()) {
            switch (this.cmbSearchOptions.getSelectedIndex()) {
                case 0: {
                    searchType = 1;
                    break;
                }
                case 1: {
                    searchType = 2;
                    break;
                }
                case 2: {
                    searchType = 3;
                }
            }
        }
        Manager.worker.addRunnable((Runnable)new UserSearchThread("", txt, searchType));
    }

    private void _srch(String serv, String txt, int searchType) {
        this.limitWasExceeded = false;
        CollaborationPrincipal[] users = null;
        try {
            users = UserCache.search(txt, searchType);
        }
        catch (CollaborationException ce) {
            users = null;
        }
        if (users == null || users.length == 0) {
            String msg = userSearchBundle.getString("An_unknown_error_was_encountered");
            JOptionPane.showMessageDialog(this, msg, userSearchBundle.getString("Search_Message_Title"), 1);
            return;
        }
        this.result.removeAllElements();
        if (users != null) {
            for (int n = 0; n < users.length; ++n) {
                this.result.addElement(users[n]);
            }
        }
        this.model.changed(StringUtility.sort((Vector)this.result));
        _is_searching = false;
        this.btnSearch.setEnabled(true);
    }

    public CollaborationPrincipal[] getUserSelectionList() {
        Object[] ret = new CollaborationPrincipal[this.selectedUsers.size()];
        this.selectedUsers.copyInto(ret);
        Manager.Out(this.selectedUsers);
        return ret;
    }

    private CollaborationPrincipal[] getSelectedUsers() {
        Object uids = null;
        int[] sel = this.lstResult.getSelectedIndices();
        Vector<CollaborationPrincipal> tmp = new Vector<CollaborationPrincipal>();
        if (sel.length > 0) {
            for (int n = 0; n < sel.length; ++n) {
                CollaborationPrincipal ip = (CollaborationPrincipal)this.result.elementAt(sel[n]);
                if (!this._expandGroupsOnAdd) {
                    tmp.addElement(ip);
                    continue;
                }
                if (ip instanceof CollaborationGroup) {
                    CollaborationPrincipal[] u = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(ip.getUID());
                    if (u == null) continue;
                    for (int x = 0; x < u.length; ++x) {
                        tmp.addElement(u[x]);
                    }
                    continue;
                }
                tmp.addElement(ip);
            }
        } else {
            return null;
        }
        Object[] ret = new CollaborationPrincipal[tmp.size()];
        tmp.copyInto(ret);
        return ret;
    }

    private void addTeamUsers(String grp) {
        if (this.result.size() != 0) {
            Vector<String> tmp = new Vector<String>();
            CollaborationPrincipal[] sel = this.getSelectedUsers();
            if (sel == null) {
                String msg = userSearchBundle.getString("No_users_selected");
                JOptionPane.showMessageDialog(this, msg, userSearchBundle.getString("Search_Message_Title"), 1);
                return;
            }
            for (int n = 0; n < sel.length; ++n) {
                if (sel[n] instanceof CollaborationGroup) {
                    if (!this._expandGroupsOnAdd) {
                        tmp.addElement("g:" + sel[n].getUID());
                    } else {
                        Object[] users = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(sel[n].getUID());
                        String[] ids = UserCache.getUIDsFromUsers(Manager.getVectorFromArray(users));
                        if (ids == null) continue;
                        for (int x = 0; x < ids.length; ++x) {
                            tmp.addElement(ids[x]);
                        }
                    }
                } else {
                    tmp.addElement(sel[n].getUID());
                }
                tmp.addElement(sel[n].getUID());
            }
            Object[] ret = new String[tmp.size()];
            tmp.copyInto(ret);
            ((Communicator)this._parent).addElementsToBuddyListGroup((String[])ret, grp);
        } else {
            String msg = userSearchBundle.getString("No_users_selected_1");
            JOptionPane.showMessageDialog(this, msg, userSearchBundle.getString("Search_Message_Title"), 1);
        }
    }

    public void removeListeners() {
        this.btnAdd.removeActionListener(this);
        this.btnSearch.removeActionListener(this);
        this.btnAddSel.removeActionListener(this);
        this.btnRemoveSel.removeActionListener(this);
        this.cmbSearchType.removeItemListener(this);
    }

    public void close() {
        this.setVisible(false);
        this.removeListeners();
        if (!this._isSelectionView) {
            ((Communicator)this._parent).startUserSearch = true;
            ((Communicator)this._parent).updateUserSearch = false;
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(new Cursor(3));
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.clickedButton = 1;
            this.close();
        } else if (actionCommand == "cancel") {
            this.clickedButton = 0;
            this.selectedUsers = this.origUsers;
            this.close();
        } else if (object == this.btnSearch) {
            this.search();
        } else if (actionCommand == "help") {
            HelpManager.showHelp("usersearch");
        } else if (object == this.btnAdd) {
            this.addTeamUsers((String)this.cmbGroups.getSelectedItem());
        } else if (object == this.btnAddSel) {
            CollaborationPrincipal[] users = this.getSelectedUsers();
            if (users == null) {
                this.setCursor(new Cursor(0));
                return;
            }
            for (int n = 0; n < users.length; ++n) {
                if (this.selectedUsersCheck.contains(users[n].getUID())) continue;
                this.selectedUsers.addElement(users[n]);
                this.selectedUsersCheck.addElement(users[n].getUID());
            }
            this.selModel.changed(this.selectedUsers);
        } else if (object == this.btnRemoveSel) {
            int[] sel = this.lstSelect.getSelectedIndices();
            if (sel.length == 0) {
                this.setCursor(new Cursor(0));
                return;
            }
            Vector ret = (Vector)this.selectedUsers.clone();
            for (int n = 0; n < sel.length; ++n) {
                CollaborationPrincipal u = (CollaborationPrincipal)this.selectedUsers.elementAt(sel[n]);
                ret.removeElement(u);
                this.selectedUsersCheck.removeElement(u.getUID());
            }
            this.selectedUsers = ret;
            this.selModel.changed(this.selectedUsers);
            this.lstSelect.getSelectionModel().clearSelection();
        }
        this.setCursor(new Cursor(0));
    }

    public int getClickedButton() {
        return this.clickedButton;
    }

    class UserSearchThread
    implements Runnable {
        String serv;
        String txt;
        int searchType;

        public UserSearchThread(String serv, String txt, int searchType) {
            this.txt = txt;
            this.serv = serv;
            this.searchType = searchType;
        }

        public void run() {
            UserSearch.this._srch(this.serv, this.txt, this.searchType);
            SwingUtilities.invokeLater(new ResetView());
        }
    }

    class ResetView
    implements Runnable {
        ResetView() {
        }

        public void run() {
            UserSearch.this.btnSearch.setEnabled(true);
            _is_searching = false;
            if (UserSearch.this.lstResult != null) {
                UserSearch.this.lstResult.clearSelection();
            }
            int matchesFound = UserSearch.this.result.size();
            String msg = new String();
            UserSearch.this.lblExtra.setText("");
            if (matchesFound == 0) {
                msg = userSearchBundle.getString("No_Matches_Found");
            } else if (UserSearch.this.limitWasExceeded) {
                UserSearch.this.lblExtra.setText(userSearchBundle.getString("More_matches_exist1"));
                msg = userSearchBundle.getString("More_matches_exist2");
            } else {
                msg = StringUtility.substitute((String)userSearchBundle.getString("Matches_found"), (String)"__MACRO__", (String)Integer.toString(matchesFound));
            }
            UserSearch.this.lblResult.setText(msg);
        }
    }
}

