/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.AutoOrientationJDialog;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.JFixedTextField;
import com.iplanet.im.client.util.JTextFieldLimit;
import com.iplanet.im.client.util.SafeResourceBundle;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class Status
extends AutoOrientationJDialog
implements ActionListener {
    public boolean OK = false;
    public String STATUS = "NOSTATUS";
    public static final int INDEX_AWAY = 0;
    public static final int INDEX_ON = 1;
    private DialogButtonsPanel pnlButtons;
    private JRadioButton chkAway;
    private JRadioButton chkOnline;
    private JFixedTextField txtStatus;
    static SafeResourceBundle statusBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    private static final int MAX_STATUS_LENGTH = 1024;

    public Status(Frame parent, String cur_stat, String msg) {
        super(parent);
        this.STATUS = cur_stat;
        this.initComponents();
        this.pack();
        this.initStatus(msg);
    }

    private void initComponents() {
        this.pnlButtons = new DialogButtonsPanel(this, 6);
        JPanel pnlStatus = new JPanel();
        ButtonGroup statusGroup = new ButtonGroup();
        this.chkAway = new JRadioButton();
        this.chkOnline = new JRadioButton();
        this.txtStatus = new JFixedTextField(30);
        String acc_status = statusBundle.getString("acc_txtStatus");
        if (acc_status != null && !"".equals(acc_status)) {
            this.txtStatus.getAccessibleContext().setAccessibleName(acc_status);
        }
        this.setTitle(statusBundle.getString("Status_title"));
        this.getContentPane().setLayout(new GridBagLayout());
        pnlStatus.setLayout(new GridLayout(1, 0, 5, 0));
        this.chkAway.setText(statusBundle.getString("chkAway_text"));
        statusGroup.add(this.chkAway);
        pnlStatus.add(this.chkAway);
        this.chkOnline.setText(statusBundle.getString("chkOnline_text"));
        statusGroup.add(this.chkOnline);
        pnlStatus.add(this.chkOnline);
        int rdbMargin = this.chkAway.getMargin().left;
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weightx = 1.0;
        gbConstraints.anchor = 17;
        gbConstraints.insets = new Insets(12, 12 - rdbMargin, 0, 0);
        this.getContentPane().add((Component)pnlStatus, gbConstraints);
        this.txtStatus.setDocument(new JTextFieldLimit(1024));
        gbConstraints.gridy = 1;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(11, 12, 0, 12);
        this.getContentPane().add((Component)this.txtStatus, gbConstraints);
        gbConstraints.gridy = 2;
        gbConstraints.insets = new Insets(17, 12, 12, 12);
        this.getContentPane().add((Component)this.pnlButtons, gbConstraints);
        this.pnlButtons.setDefaultButton(4);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Status.this.cancel();
            }
        });
    }

    private final void initStatus(String reason) {
        if (this.STATUS.equals("AWAY")) {
            this.chkAway.setSelected(true);
        } else {
            this.chkOnline.setSelected(true);
        }
        this.txtStatus.setText(reason);
    }

    private final void close() {
        this.chkAway.removeActionListener(this);
        this.chkOnline.removeActionListener(this);
        this.setVisible(false);
        this.dispose();
    }

    public String getMessage() {
        return this.txtStatus.getText();
    }

    public void ok() {
        this.OK = true;
        this.STATUS = this.chkAway.isSelected() ? "AWAY" : "OPEN";
        this.close();
    }

    public void cancel() {
        this.close();
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            String msg = statusBundle.getString("custom_status_title");
            if (this.getMessage().trim().equals("")) {
                JOptionPane.showMessageDialog(this, msg, null, 2, SwingImageManager.getIcon("/com/iplanet/im/client/images/warning.png", (Object)this));
            } else {
                this.ok();
            }
        } else if (actionCommand == "cancel") {
            this.cancel();
        }
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Status.this.setVisible(false);
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }
}

