/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.AutoOrientationJDialog;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SearchResults
extends AutoOrientationJDialog
implements ActionListener,
MouseListener {
    static SafeResourceBundle searchResultsBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    private Frame _parentFrame;
    private Vector _recipientList;
    private String _label1 = null;
    private String _label2 = null;
    private iIMListModel recptModel;
    private iIMListRenderer recptRenderer;
    private boolean _expandGroupsOnAdd = false;
    JPanel pnlTop = new JPanel();
    DialogButtonsPanel pnlButtons;
    JLabel lblRecipients = new JLabel();
    JLabel lblRecipients2 = new JLabel();
    JScrollPane scrRecipients = new JScrollPane();
    JList lstRecipients = new JList();

    public SearchResults(Frame p, Vector list, boolean expand_groups, String label1, String label2) {
        super(p);
        this._parentFrame = p;
        this._label1 = label1;
        this._label2 = label2;
        this._recipientList = StringUtility.sort((Vector)list);
        this._expandGroupsOnAdd = expand_groups;
        this.initComponents();
    }

    private void initComponents() {
        this.pnlButtons = new DialogButtonsPanel(this);
        this.setTitle(searchResultsBundle.getString("SearchResults_title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(380, 350);
        this.centerWindow();
        this.pnlTop.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.pnlTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 383, 203));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 13, 0, new Insets(17, 12, 12, 12), 0, 0));
        this.pnlButtons.setDefaultButton(4);
        this.lblRecipients.setText(this._label1);
        this.pnlTop.add((Component)this.lblRecipients, new GridBagConstraints(-1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.lblRecipients2.setText(this._label2);
        this.lblRecipients2.setLabelFor(this.lstRecipients);
        this.pnlTop.add((Component)this.lblRecipients2, new GridBagConstraints(-1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        this.pnlTop.add((Component)this.scrRecipients, new GridBagConstraints(0, 2, 2, 3, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 216, 168));
        this.scrRecipients.setViewportView(this.lstRecipients);
        this.lstRecipients.addMouseListener(this);
        this.recptModel = new iIMListModel(this.lstRecipients, this._recipientList);
        this.recptRenderer = new iIMListRenderer(this.recptModel);
        this.lstRecipients.setCellRenderer(this.recptRenderer);
        this.lstRecipients.setModel(this.recptModel);
        this.recptModel.changed(this._recipientList);
    }

    public CollaborationPrincipal[] getSelectedUsers() {
        Object uids = null;
        int[] sel = this.lstRecipients.getSelectedIndices();
        Vector<CollaborationPrincipal> tmp = new Vector<CollaborationPrincipal>();
        if (sel.length > 0) {
            for (int n = 0; n < sel.length; ++n) {
                CollaborationPrincipal ip = (CollaborationPrincipal)this._recipientList.elementAt(sel[n]);
                if (!this._expandGroupsOnAdd) {
                    tmp.addElement(ip);
                    continue;
                }
                if (ip instanceof CollaborationGroup) {
                    CollaborationPrincipal[] u = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(ip.getUID());
                    if (u == null) continue;
                    for (int x = 0; x < u.length; ++x) {
                        tmp.addElement(u[x]);
                    }
                    continue;
                }
                tmp.addElement(ip);
            }
        } else {
            return null;
        }
        Object[] ret = new CollaborationPrincipal[tmp.size()];
        tmp.copyInto(ret);
        return ret;
    }

    public CollaborationPrincipal[] getUserSelectionList() {
        Object[] ret = new CollaborationPrincipal[this._recipientList.size()];
        this._recipientList.copyInto(ret);
        Manager.Out(this._recipientList);
        return ret;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.close();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(new Cursor(3));
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.close();
        } else if (actionCommand == "cancel") {
            this.lstRecipients.clearSelection();
            this.close();
        } else if (actionCommand == "help") {
            HelpManager.showHelp("selectcontacts");
        }
        this.setCursor(new Cursor(0));
    }

    private void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
}

