/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.dialogs.MessageBoxListener;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class MessageBox
extends AutoOrientationJFrame {
    private Frame parent;
    private Point position = new Point(50, 50);
    private String title;
    private String message;
    private String b1;
    private String b2;
    private String b3;
    private boolean modal = true;
    private int _clickedButton = -1;
    private MessageBoxListener _listener = null;
    static SafeResourceBundle messageBoxBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");

    public MessageBox(Frame f, Point p, String title, String msg, String b1txt, String b2txt, String b3txt, boolean modal, boolean ontop) {
        this.setTitle(title);
        this.setLocation(-55, -55);
        this.b1 = b1txt;
        this.b2 = b2txt;
        this.b3 = b3txt;
        this.modal = modal;
        this.title = title;
        this.message = msg;
        this.setTitle(messageBoxBundle.getString("MessageBox_title"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(1, 1);
        if (PlatformUtil.isSun()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
        this.toFront();
        this.parent = this;
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.viewOptionPane(p, title, this.message, b1txt, b2txt, b3txt, modal);
    }

    public MessageBox(Frame f, Point p, String title, String msg) {
        this(f, p, title, msg, messageBoxBundle.getString("OK"), "", "", true, false);
    }

    public MessageBox(Frame f, Point p, String title, String msg, boolean modal, boolean ontop) {
        this(f, p, title, msg, messageBoxBundle.getString("OK_1"), "", "", modal, ontop);
    }

    public MessageBox(Frame f, Point p, String title, String msg, String a, String b, String c, boolean ontop) {
        this(f, p, title, msg, a, b, c, true, ontop);
    }

    public MessageBox(Frame f, Point p, String title, String msg, String a, String b, String c, boolean ontop, MessageBoxListener msgBoxListener) {
        this(f, p, title, msg, a, b, c, false, ontop);
        this._listener = msgBoxListener;
    }

    public int getClickedButton() {
        return this._clickedButton;
    }

    private final void viewOptionPane(Point p, String title, String msg, String b1, String b2, String b3, boolean m) {
        if (this.parent == null) {
            this.parent = this;
        }
        MessageBoxView v = new MessageBoxView(this.parent);
    }

    class MessageBoxView
    extends JDialog
    implements ActionListener {
        DialogButtonsPanel pnlButtons;

        public MessageBoxView(Frame parent) {
            super(parent);
            this.setTitle(MessageBox.this.title);
            this.setModal(MessageBox.this.modal);
            int buttons = 0;
            if (MessageBox.this.b1 != null && !"".equals(MessageBox.this.b1)) {
                buttons = 4;
            }
            if (MessageBox.this.b2 != null && !"".equals(MessageBox.this.b2)) {
                buttons |= 2;
            }
            if (MessageBox.this.b3 != null && !"".equals(MessageBox.this.b3)) {
                buttons |= 1;
            }
            this.pnlButtons = new DialogButtonsPanel(this, buttons);
            if ((buttons & 4) == 4) {
                this.pnlButtons.setOkButtonLabel(MessageBox.this.b1);
            }
            if ((buttons & 2) == 2) {
                this.pnlButtons.setCancelButtonLabel(MessageBox.this.b2);
            }
            if ((buttons & 1) == 1) {
                this.pnlButtons.setHelpButtonLabel(MessageBox.this.b3);
            }
            JLabel lblHeader = new JLabel();
            JLabel lblMessage = new JLabel();
            JLabel lblImgIcon = new JLabel();
            this.getContentPane().setLayout(new GridBagLayout());
            this.setVisible(false);
            this.setTitle(MessageBox.this.title);
            lblHeader.setText(MessageBox.this.title);
            String msg = "<html>" + MessageBox.this.message + "</html>";
            lblMessage.setText(msg);
            lblImgIcon.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/warning.png", (Object)this));
            Font font = lblHeader.getFont().deriveFont(1);
            lblHeader.setFont(font);
            this.getContentPane().add((Component)lblImgIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
            this.getContentPane().add((Component)lblHeader, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 11, 0, 12), 0, 0));
            this.getContentPane().add((Component)lblMessage, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 11, 0, 12), 0, 0));
            this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(17, 11, 12, 12), 0, 0));
            this.pack();
            this.setLocation(MessageBox.this.position);
            this.setVisible(true);
        }

        public final void close() {
            this.setVisible(false);
            this.dispose();
            MessageBox.this.parent.setVisible(false);
            MessageBox.this.parent.dispose();
        }

        public int getClickedButton() {
            return MessageBox.this._clickedButton;
        }

        public void actionPerformed(ActionEvent event) {
            String actionCommand = event.getActionCommand();
            if (actionCommand == "ok") {
                MessageBox.this._clickedButton = 0;
            } else if (actionCommand == "cancel") {
                MessageBox.this._clickedButton = 1;
            } else if (actionCommand == "help") {
                MessageBox.this._clickedButton = 2;
            }
            if (!MessageBox.this.modal && MessageBox.this._listener != null) {
                if (MessageBox.this._listener.actionPerformed(MessageBox.this._clickedButton)) {
                    this.close();
                }
            } else {
                this.close();
            }
        }
    }
}

