/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.dialogs.AlertDialog;
import com.iplanet.im.client.swing.dialogs.SearchResults;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FindContact
extends JPanel
implements ActionListener {
    private static SafeResourceBundle findContact = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    private JRadioButton rdbName = null;
    private JRadioButton rdbUID = null;
    private JTextField txtName = null;
    private JTextField txtUID = null;
    private JComboBox cmbServers = null;
    private JButton btnSearch = null;
    private String[] serverList;
    private JDialog _f = null;
    private boolean _flag;
    private ArrayList listenerList = null;

    public FindContact(JDialog f, String header) {
        this._f = f;
        this.InitComponents(header);
    }

    private void InitComponents(String header) {
        this.listenerList = new ArrayList();
        ButtonGroup bg = new ButtonGroup();
        JLabel lblAt = new JLabel();
        JLabel lblHeader = new JLabel();
        this.rdbName = new JRadioButton();
        this.rdbUID = new JRadioButton();
        this.txtName = new JTextField();
        this.txtUID = new JTextField();
        this.cmbServers = new JComboBox();
        this.btnSearch = new JButton();
        this.setLayout(new GridBagLayout());
        this.rdbName.setText(findContact.getString("Select_Name"));
        lblAt.setText(findContact.getString("lbl_at"));
        this.rdbUID.setText(findContact.getString("Select_UID"));
        this.addServers();
        this.addGateways();
        bg.add(this.rdbName);
        bg.add(this.rdbUID);
        this.rdbName.addActionListener(this);
        this.rdbUID.addActionListener(this);
        this.btnSearch.addActionListener(this);
        this.rdbName.setSelected(true);
        this.txtUID.setEnabled(false);
        this.cmbServers.setEnabled(false);
        this.cmbServers.setEditable(true);
        lblHeader.setText(header);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)lblHeader, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.rdbName, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 12);
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.rdbUID, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtUID, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)lblAt, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 12);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cmbServers, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.btnSearch, gridBagConstraints);
        this.txtName.requestFocus();
    }

    public void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.btnSearch);
    }

    public void addSelectRecipientsListener(SelectRecipientsListener listener) {
        this.listenerList.add(listener);
    }

    public void removeSelectRecipientsListener(SelectRecipientsListener listener) {
        this.listenerList.remove(listener);
    }

    private void addGateways() {
        try {
            PersonalStoreEntry[] gtw = Manager._personalStoreSession.search(1, "*", "gateway");
            if (gtw != null) {
                for (int i = 0; i < gtw.length; ++i) {
                    String entryID = gtw[i].getEntryId();
                    String gtwDisplayName = gtw[i].getDisplayName();
                    this.cmbServers.addItem(new DomainSelector(entryID, gtwDisplayName));
                }
            }
        }
        catch (CollaborationException e) {
            Manager.warning("Unable to search for hgateway entries " + (Object)((Object)e));
        }
    }

    private void addServers() {
        this.cmbServers.setEditable(true);
        this.cmbServers.setLightWeightPopupEnabled(false);
        this.serverList = ServerGroupManager.getServerList();
        for (int i = 0; i < this.serverList.length; ++i) {
            this.cmbServers.addItem(new DomainSelector(this.serverList[i]));
        }
    }

    public JTextField getTxtSearchPattern() {
        return this.txtName;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.btnSearch) {
            this.search();
        } else if (object == this.rdbName) {
            this.txtName.setEnabled(true);
            this.txtUID.setEnabled(false);
            this.cmbServers.setEnabled(false);
            this.txtUID.setText("");
            this.txtName.setText("");
        } else if (object == this.rdbUID) {
            this.txtUID.setEnabled(true);
            this.txtName.setEnabled(false);
            this.txtUID.setText("");
            this.txtName.setText("");
            this.cmbServers.setEnabled(true);
        }
    }

    public void setSearchButton(String buttonTitle) {
        this.btnSearch.setText(buttonTitle);
    }

    public void search() {
        if (this.rdbName.isSelected() && this.txtName.getText().toString().trim().equals("")) {
            String msg = findContact.getString("Enter_a_String_to_search_for");
            String title = findContact.getString("Search_Message_Title");
            JOptionPane.showMessageDialog(this, msg, title, 2, SwingImageManager.getIcon("/com/iplanet/im/client/images/warning.png", (Object)this));
            return;
        }
        if (this.rdbUID.isSelected() && this.txtUID.getText().toString().trim().equals("")) {
            String msg = findContact.getString("Enter_a_UID_to_search_for");
            String title = findContact.getString("Search_Message_Title");
            JOptionPane.showMessageDialog(this, msg, title, 2, SwingImageManager.getIcon("/com/iplanet/im/client/images/warning.png", (Object)this));
            return;
        }
        String name = this.txtName.getText().toString().trim();
        if (!this.rdbUID.isSelected()) {
            int minLength = 3;
            int length = 0;
            String slen = findContact.getString("Minimum_search_length");
            if (slen != null) {
                try {
                    Integer ilen = new Integer(slen);
                    minLength = ilen;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                length = name.length();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (length < minLength) {
                String msg = StringUtility.substitute((String)findContact.getString("Enter_at_least_num"), (String)"__MACRO__", (String)Integer.toString(minLength));
                String title = findContact.getString("Search_Message_Title");
                JOptionPane.showMessageDialog(this, msg, title, 2, SwingImageManager.getIcon("/com/iplanet/im/client/images/warning.png", (Object)this));
                return;
            }
        }
        this.btnSearch.setEnabled(false);
        String txt = null;
        int searchType = 0;
        String displayName = "";
        if (this.rdbName.isSelected()) {
            txt = name;
            searchType = 1;
        } else {
            String domain;
            txt = this.txtUID.getText().toString().trim();
            Object obj = this.cmbServers.getSelectedItem();
            if (obj instanceof DomainSelector) {
                DomainSelector ds = (DomainSelector)obj;
                domain = ds.getDomain();
                displayName = ds.getDisplayName(txt);
            } else {
                domain = obj.toString();
                if ("".equals(domain)) {
                    domain = CurrentUserManager.getCurrentUserServer();
                }
                displayName = StringUtility.appendDomainToAddress((String)txt, (String)domain);
            }
            if (!"".equals(domain) && !CurrentUserManager.getCurrentUserServer().equalsIgnoreCase(domain)) {
                txt = StringUtility.appendDomainToAddress((String)txt, (String)domain);
            }
            searchType = 0;
        }
        Manager.worker.addRunnable((Runnable)new UserSearchThread(txt, searchType, displayName));
    }

    private void fireSelectRecipientsListener(CollaborationPrincipal[] selectedElements) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ((SelectRecipientsListener)this.listenerList.get(i)).selectedRecipients(selectedElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void _srch(String txt, int searchType, String displayName) {
        block11: {
            try {
                Object[] users = Manager._personalStoreSession.searchPrincipals(searchType, txt);
                UserCache.addPrincipalToCache((CollaborationPrincipal[])users);
                if (users == null || users.length == 0) {
                    String message;
                    String title = message = findContact.getString("no_match");
                    String msg = findContact.getString("no_match_text");
                    AlertDialog wDialog = new AlertDialog((Frame)this._f.getOwner(), title, message, msg, null);
                    wDialog.setLocationRelativeTo(this);
                    wDialog.setModal(true);
                    wDialog.setVisible(true);
                    break block11;
                }
                if (users.length == 1) {
                    this.setFireSelection((CollaborationPrincipal[])users, true);
                    break block11;
                }
                if (users.length <= 1) break block11;
                String lblTxt1 = StringUtility.substitute((String)findContact.getString("Matches_found"), (String)"__MACRO__", (String)Integer.toString(users.length));
                String lblTxt2 = findContact.getString("AddContact_lblTxt3");
                SearchResults sr = new SearchResults((Frame)this._f.getOwner(), Manager.getVectorFromArray(users), false, lblTxt1, lblTxt2);
                sr.setModal(true);
                sr.setVisible(true);
                CollaborationPrincipal[] ip = sr.getSelectedUsers();
                if (ip == null) break block11;
                this.setFireSelection(ip, false);
            }
            catch (ServiceUnavailableException e) {
                Manager.Out("Search service is unavialable. Add the uid without search");
                CollaborationPrincipal[] users = new CollaborationPrincipal[1];
                try {
                    users[0] = Manager._session.createPrincipal(txt, displayName);
                }
                catch (CollaborationException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            FindContact.this.btnSearch.setEnabled(true);
                        }
                    });
                    return;
                }
                this.setFireSelection(users, true);
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            catch (CollaborationException e2) {
                Manager.Out((Object)e2);
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void setFireSelection(CollaborationPrincipal[] cp, boolean flag) {
        this.fireSelectRecipientsListener(cp);
        this._flag = flag;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (FindContact.this.rdbName.isSelected()) {
                    if (FindContact.this._flag) {
                        FindContact.this.txtName.setText("");
                    }
                    FindContact.this.txtName.requestFocus();
                } else {
                    if (FindContact.this._flag) {
                        FindContact.this.txtUID.setText("");
                    }
                    FindContact.this.txtUID.requestFocus();
                }
            }
        });
    }

    static interface SelectRecipientsListener
    extends EventListener {
        public void selectedRecipients(CollaborationPrincipal[] var1);
    }

    class UserSearchThread
    implements Runnable {
        String txt;
        int searchType;
        String displayName;

        public UserSearchThread(String txt, int searchType, String displayName) {
            this.txt = txt;
            this.searchType = searchType;
            this.displayName = displayName;
        }

        public void run() {
            FindContact.this._srch(this.txt, this.searchType, this.displayName);
        }
    }

    private class DomainSelector {
        private String _domain;
        private String _displayDomainName;
        private int OTHER = 0;
        private int GATEWAY;
        private int type = this.GATEWAY = 1;

        DomainSelector(String domain, String displayDomainName) {
            this._domain = domain;
            this._displayDomainName = displayDomainName;
        }

        DomainSelector(String domain) {
            this(domain, domain);
            this.type = this.OTHER;
        }

        public String getDomain() {
            return this._domain;
        }

        public String getDisplayDomainName() {
            return this._displayDomainName;
        }

        public String toString() {
            return this._displayDomainName;
        }

        public String getDisplayName(String userID) {
            if (this.type == this.GATEWAY) {
                return StringUtility.appendDomainToAddress((String)StringUtility.getLocalPartFromAddress((String)userID), (String)this._displayDomainName);
            }
            return StringUtility.appendDomainToAddress((String)userID, (String)this._displayDomainName);
        }
    }
}

