/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.AutoOrientationJDialog;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class AuthSubscription
extends AutoOrientationJDialog
implements ActionListener,
ItemListener {
    public static final int ACCEPTED = 0;
    public static final int REJECTED = 1;
    public static final int CANCELLED = 2;
    private static SafeResourceBundle authSubscription = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    private JRadioButton rdbDeny = null;
    private JRadioButton rdbAccept = null;
    private JCheckBox chkAdd = null;
    private JComboBox cmbAdd = null;
    private PresenceTuple pt;
    private int _status = 2;
    private Frame _parentFrame;
    private boolean _addContacts;

    public AuthSubscription(Frame f, Presence p, boolean addContacts) {
        super(f);
        Manager.Out("DEBUG: Authorization.<init>");
        this._parentFrame = f;
        Object[] o = p.getTuples().toArray();
        this.pt = (PresenceTuple)o[0];
        this._addContacts = addContacts;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        JLabel lblUserText = new JLabel();
        JLabel lblHeader = new JLabel();
        JLabel lblImgIcon = new JLabel();
        ButtonGroup bg = new ButtonGroup();
        this.setVisible(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.rdbDeny = new JRadioButton();
        this.rdbAccept = new JRadioButton();
        String title = authSubscription.getString("Auth_Title");
        this.setTitle(title);
        this.getContentPane().setLayout(gridBagLayout);
        lblImgIcon.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/auth_pending.png", (Object)this));
        Font font = lblHeader.getFont().deriveFont(1);
        lblHeader.setFont(font);
        lblHeader.setText(authSubscription.getString("Auth_Title"));
        String str = StringUtility.substitute((String)authSubscription.getString("Auth_labelTxt"), (String)"__MACRO__", (String)UserCache.getDisplayName(this.pt.getContact()));
        lblUserText = new JLabel(str);
        this.rdbAccept.setText(authSubscription.getString("Authorization_Accept"));
        this.rdbDeny.setText(authSubscription.getString("Authorization_Deny"));
        DialogButtonsPanel pnlButtons = new DialogButtonsPanel(this);
        bg.add(this.rdbAccept);
        bg.add(this.rdbDeny);
        this.rdbAccept.setSelected(true);
        this.rdbAccept.addActionListener(this);
        this.rdbDeny.addActionListener(this);
        this.getContentPane().add((Component)lblImgIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)lblHeader, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 10, 0, 12), 0, 0));
        this.getContentPane().add((Component)lblUserText, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.rdbAccept, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(11, 10 - this.rdbAccept.getMargin().left, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.rdbDeny, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10 - this.rdbDeny.getMargin().left, 0, 0), 0, 0));
        if (this._addContacts) {
            this._initAddContatcts();
        }
        this.getContentPane().add((Component)pnlButtons, new GridBagConstraints(1, -1, 2, 1, 0.0, 0.0, 17, 0, new Insets(17, 10, 12, 12), 0, 0));
        pnlButtons.setDefaultButton(4);
    }

    private void _initAddContatcts() {
        this.chkAdd = new JCheckBox();
        this.chkAdd.setText(authSubscription.getString("Auth_chk_add"));
        this.cmbAdd = new JComboBox();
        this.getContentPane().add((Component)this.chkAdd, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 10 - this.chkAdd.getMargin().left, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.cmbAdd, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 0, 12), 0, 0));
        this.chkAdd.addItemListener(this);
        this.chkAdd.setSelected(true);
        this.refresh();
    }

    public void itemStateChanged(ItemEvent evt) {
        this.cmbAdd.setEnabled(this.chkAdd.isSelected());
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.ok();
        } else if (actionCommand == "cancel") {
            this.setVisible(false);
            this.dispose();
        } else if (actionCommand == "help") {
            this.help();
        } else if (this._addContacts) {
            Object source = event.getSource();
            if (source == this.rdbAccept) {
                this.chkAdd.setEnabled(true);
                this.cmbAdd.setEnabled(this.chkAdd.isSelected());
            } else if (source == this.rdbDeny) {
                this.chkAdd.setEnabled(false);
                this.cmbAdd.setEnabled(false);
            }
        }
    }

    public void refresh() {
        String[] buddyListGroups = BuddyListManager.getBuddyListGroups();
        for (int x = 0; x < buddyListGroups.length; ++x) {
            this.cmbAdd.addItem(buddyListGroups[x]);
        }
    }

    public int getStatus() {
        return this._status;
    }

    private void ok() {
        String uid = StringUtility.removeResource((String)this.pt.getContact());
        this._status = this.rdbAccept.isSelected() ? 0 : 1;
        if (this._addContacts && this.cmbAdd.isEnabled()) {
            String grp = (String)this.cmbAdd.getSelectedItem();
            iIM.addUsersToBuddyListGroup(new String[]{uid}, grp);
            iIM.getBuddyList().update(true);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void help() {
        HelpManager.showHelp("authorizecontact");
    }
}

