/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.communicator.RoomListPanel;
import com.iplanet.im.client.swing.dialogs.RoomSearchResults;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.AutoOrientationJDialog;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.JFixedTextField;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AddRoomDialog
extends AutoOrientationJDialog
implements ActionListener,
ItemListener,
KeyListener {
    static SafeResourceBundle bundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    private Frame _parentFrame;
    private Vector result = new Vector(20);
    private String[] servers = null;
    private iIMListModel model;
    private iIMListRenderer renderer;
    private static boolean _isSearching = false;
    private boolean limitWasExceeded = false;
    private RoomListPanel roomPanel;
    public boolean room_added = false;
    private boolean _expandGroupsOnAdd = false;
    JPanel pnlTop = new JPanel();
    public JFixedTextField txtSearchPattern = new JFixedTextField();
    JLabel lblSearchPattern = new JLabel();
    TitledBorder titledBorder = new TitledBorder(bundle.getString("Conf_Title"));
    JLabel lblSearchOptions = new JLabel();
    JLabel lblFindConf = new JLabel();
    JButton btnSearch = new JButton();
    JButton btnBrowse = new JButton();
    JComboBox cmbSearchOptions = new JComboBox();
    JPanel pnlCenter = new JPanel();
    JPanel pnlFindTop = new JPanel();
    JLabel lblSearch = new JLabel();
    JPanel pnlSearch = new JPanel();
    JLabel lblResult = new JLabel();
    JScrollPane scrResult = new JScrollPane();
    JList lstResult = new JList();
    JButton btnRemove = new JButton();
    JPanel FindContact = new JPanel();
    JPanel pnlAddToGroup = new JPanel();
    JLabel lblAddToGroup;
    JComboBox cmbAddToGroup = new JComboBox();
    DialogButtonsPanel pnlButtons;

    public AddRoomDialog(Frame p, boolean expand_groups) {
        super(p);
        Manager.Out("DEBUG: AddRoomDialog.<init>");
        this._parentFrame = p;
        this.roomPanel = Communicator.getRoomListPanel();
        this._expandGroupsOnAdd = expand_groups;
        this.initComponents();
        this.setVisible(true);
        this.setModal(true);
        this.txtSearchPattern.requestDefaultFocus();
    }

    private void initComponents() {
        JPanel plnLbl = new JPanel();
        this.pnlButtons = new DialogButtonsPanel(this, 7);
        this.pnlButtons.setOkButtonLabel(3);
        String title = bundle.getString("AddRoomDialog_title");
        this.setTitle(title);
        this.getAccessibleContext().setAccessibleDescription(title);
        this.getContentPane().setLayout(new GridBagLayout());
        if (PlatformUtil.isUnix()) {
            this.setSize(490, 340);
        } else {
            this.setSize(430, 310);
        }
        this.setVisible(false);
        this.lstResult.addKeyListener(this);
        plnLbl.setLayout(new GridBagLayout());
        this.pnlTop.setLayout(new GridBagLayout());
        this.pnlFindTop.setLayout(new GridBagLayout());
        this.FindContact.setLayout(new GridBagLayout());
        this.lblFindConf.setText(bundle.getString("Conf_Title"));
        plnLbl.add(this.lblFindConf);
        this.pnlTop.add((Component)this.FindContact, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 12, 12), 0, 0));
        this.lblSearchPattern = SwingUtils.makeLabelItem(bundle, "AddRoomDialog_search_pattern", "AddRoomDialog_search_pattern_M", this.txtSearchPattern);
        this.FindContact.add((Component)this.lblFindConf, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.FindContact.add((Component)this.lblSearchPattern, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 0), 0, 0));
        if (PlatformUtil.isUnix()) {
            this.FindContact.add((Component)this.txtSearchPattern, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 50, 2, 0), 0, 0));
        } else {
            this.FindContact.add((Component)this.txtSearchPattern, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 40, 2, 0), 0, 0));
        }
        this.btnSearch.setText(bundle.getString("US_search_conf"));
        this.btnSearch.setMnemonic(bundle.getString("US_search_conf_M").charAt(0));
        this.getRootPane().setDefaultButton(this.btnSearch);
        this.FindContact.add((Component)this.btnSearch, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 15, 2, new Insets(2, 10, 2, 0), 0, 0));
        this.lblSearchOptions = SwingUtils.makeLabelItem(bundle, "US_search_options", "US_search_options_M", this.cmbSearchOptions);
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(0, 2));
        separator.setMinimumSize(new Dimension(0, 2));
        String browseLabel_M = "AddRoomDialog_browse_label_M";
        if (SwingUtils.gotBug4919244(bundle, browseLabel_M, "AddRoomDialog_btnBrowse_M")) {
            browseLabel_M = null;
        }
        JLabel lblBrowse = SwingUtils.makeLabelItem(bundle, "AddRoomDialog_browse_label", browseLabel_M, this.btnBrowse);
        this.btnBrowse.setText(bundle.getString("AddRoomDialog_btnBrowse"));
        String mnemonicStr = bundle.getString("AddRoomDialog_btnBrowse_M");
        if (mnemonicStr != null && mnemonicStr.length() > 0) {
            this.btnBrowse.setMnemonic(mnemonicStr.charAt(0));
        }
        this.getContentPane().add((Component)this.pnlTop, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JSeparator separator1 = new JSeparator();
        separator1.setPreferredSize(new Dimension(0, 2));
        separator1.setMinimumSize(new Dimension(0, 2));
        this.pnlCenter.setLayout(new GridBagLayout());
        this.lblSearch.setText(bundle.getString("AddRoomDialog_addList"));
        this.FindContact.add((Component)this.makeSeparator(), new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 11, 2, new Insets(2, 0, 2, 0), 0, 0));
        this.FindContact.add((Component)this.btnBrowse, new GridBagConstraints(1, 3, 0, 1, 1.0, 0.0, 15, 2, new Insets(5, 140, 0, 0), 0, 0));
        this.FindContact.add((Component)this.lblSearch, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.FindContact.add((Component)this.scrResult, new GridBagConstraints(0, 5, 0, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        this.pnlSearch.setLayout(new GridBagLayout());
        this.scrResult.setViewportView(this.lstResult);
        this.btnRemove.setText(bundle.getString("AddRoomDialog_btnRemove"));
        this.btnRemove.setMnemonic(bundle.getString("AddRoomDialog_btnRemove_M").charAt(0));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 6, 0, 1, 0.0, 0.0, 13, 2, new Insets(17, 12, 12, 12), 0, 0));
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int pointX = (double)(this._parentFrame.getX() + 100 + 450) > d.getWidth() ? (int)d.getWidth() - 450 - 100 : this._parentFrame.getX() + 100;
        int pointY = (double)(this._parentFrame.getY() + 100 + 454) > d.getHeight() ? (int)d.getHeight() - 454 - 100 : this._parentFrame.getY() + 100;
        this.setLocation(pointX, pointY);
        this.btnSearch.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnBrowse.addActionListener(this);
        this.btnSearch.setRequestFocusEnabled(false);
        this.btnRemove.setRequestFocusEnabled(false);
        this.btnBrowse.setRequestFocusEnabled(false);
        this.cmbSearchOptions.setEnabled(true);
        this.cmbSearchOptions.addItem(bundle.getString("AddRoomDialog_cmbContains"));
        this.cmbSearchOptions.addItem(bundle.getString("AddRoomDialog_cmbStarts"));
        this.cmbSearchOptions.addItem(bundle.getString("AddRoomDialog_cmbEnds"));
        this.cmbSearchOptions.setLightWeightPopupEnabled(false);
        this.model = new iIMListModel(this.lstResult, this.result);
        this.renderer = new iIMListRenderer(this.model);
        this.lstResult.setCellRenderer(this.renderer);
        this.lstResult.setModel(this.model);
        Manager.Out("AddRoomDialog.initComponents(): before calling refresh()");
        this.refresh();
    }

    private JSeparator makeSeparator() {
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(0, 2));
        separator.setMinimumSize(new Dimension(0, 2));
        separator.setEnabled(false);
        return separator;
    }

    public void itemStateChanged(ItemEvent evt) {
        this.cmbSearchOptions.setEnabled(true);
    }

    public void refresh() {
        this.cmbAddToGroup.removeAllItems();
        String[] buddyListGroups = BuddyListManager.getBuddyListGroups();
        Manager.Out("AddRoomDialog.refresh(): buddyListGroups.length: " + buddyListGroups.length);
        for (int x = 0; x < buddyListGroups.length; ++x) {
            this.cmbAddToGroup.addItem(buddyListGroups[x]);
        }
        if (this._parentFrame instanceof Communicator) {
            this.cmbAddToGroup.setSelectedItem(((Communicator)this._parentFrame).getCurrentBuddyListGroup());
        }
        if (this.cmbAddToGroup.getSelectedIndex() == -1 && this.cmbAddToGroup.getItemCount() > 0) {
            this.cmbAddToGroup.setSelectedIndex(0);
        }
        this.result.removeAllElements();
        this.model.changed(this.result);
    }

    public void addGroup(String g) {
        this.cmbAddToGroup.addItem(g);
        this.cmbAddToGroup.revalidate();
    }

    public void removeGroup(String g) {
        this.cmbAddToGroup.removeItem(g);
        this.cmbAddToGroup.revalidate();
    }

    public void refresh(String searchFor, Conference[] u, String group) {
        this.refresh();
        this.result = Manager.getVectorFromArray(u);
        this.model.changed(StringUtility.sort((Vector)this.result));
        this.txtSearchPattern.setText(searchFor);
        this.cmbAddToGroup.removeAllItems();
        String[] grps = BuddyListManager.getBuddyListGroups();
        int sel = 0;
        for (int x = 0; x < grps.length; ++x) {
            if (grps[x].equals(group)) {
                sel = x;
            }
            this.cmbAddToGroup.addItem(grps[x]);
        }
        this.result.removeAllElements();
        this.model.changed(this.result);
        this.cmbAddToGroup.setSelectedIndex(sel);
    }

    public void search() {
        int length;
        int search_type = 0;
        if (this.txtSearchPattern.getText().equals("")) {
            String msg = bundle.getString("Enter_a_String_to_search_for");
            JOptionPane.showMessageDialog(this, msg, bundle.getString("Search_Message_Title"), 1);
            return;
        }
        int minLength = 3;
        String slen = bundle.getString("Minimum_search_length");
        if (slen != null) {
            try {
                Integer ilen = new Integer(slen);
                minLength = ilen;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            byte[] x = this.txtSearchPattern.getText().getBytes("UTF-8");
            length = x.length;
        }
        catch (Exception e) {
            length = this.txtSearchPattern.getText().length();
            System.out.println(e);
        }
        if (length < minLength) {
            String msg = StringUtility.substitute((String)bundle.getString("Enter_at_least_num"), (String)"__MACRO__", (String)Integer.toString(minLength));
            JOptionPane.showMessageDialog(this, msg, bundle.getString("Search_Message_Title"), 1);
            return;
        }
        this.btnSearch.setEnabled(false);
        this.btnBrowse.setEnabled(false);
        if (_isSearching) {
            return;
        }
        _isSearching = true;
        this.lblResult.setText(bundle.getString("lblResult_text"));
        String txt = this.txtSearchPattern.getText();
        switch (this.cmbSearchOptions.getSelectedIndex()) {
            case 0: {
                search_type = 1;
                break;
            }
            case 1: {
                search_type = 2;
                break;
            }
            case 2: {
                search_type = 3;
            }
        }
        Manager.worker.addRunnable((Runnable)new UserSearchThread("", txt, search_type));
    }

    private void _srch(String serv, String txt, int search_type) {
        this.limitWasExceeded = false;
        Manager.Out("_srch, text is: " + txt);
        Object[] nu = RoomManager.searchRooms(txt, search_type);
        if (nu == null || nu.length == 0) {
            String msg = bundle.getString("No_Matches_Found");
            JOptionPane.showMessageDialog(this, msg, bundle.getString("Search_Message_Title"), 1);
        } else if (nu != null) {
            Vector<String> selectedUsersCheck = new Vector<String>(20);
            for (int i = 0; i < this.result.size(); ++i) {
                Conference r = (Conference)this.result.elementAt(i);
                selectedUsersCheck.addElement(r.getDestination());
            }
            if (nu.length == 1) {
                if (!selectedUsersCheck.contains(nu[0].getDestination())) {
                    selectedUsersCheck.addElement(nu[0].getDestination());
                    this.result.addElement(nu[0]);
                }
                this.txtSearchPattern.setText("");
                this.txtSearchPattern.requestFocus();
                this.txtSearchPattern.setCaretPosition(0);
            } else if (nu.length > 1) {
                String lblTxt2;
                String lblTxt1;
                if (this.limitWasExceeded) {
                    lblTxt1 = StringUtility.substitute((String)bundle.getString("AddRoomDialog_lblTxt1"), (String)"__MACRO__", (String)Integer.toString(nu.length));
                    lblTxt2 = bundle.getString("AddRoomDialog_lblTxt2");
                } else {
                    lblTxt1 = StringUtility.substitute((String)bundle.getString("AddRoomDialog_total_rooms"), (String)"__MACRO__", (String)Integer.toString(nu.length));
                    lblTxt2 = bundle.getString("RoomSearchResults_lblTxt3");
                }
                RoomSearchResults sr = new RoomSearchResults(this._parentFrame, Manager.getVectorFromArray(nu), false, lblTxt1, lblTxt2);
                sr.setModal(true);
                sr.setVisible(true);
                Conference[] ip = sr.getSelectedUsers();
                if (ip != null) {
                    for (int n = 0; n < ip.length; ++n) {
                        if (selectedUsersCheck.contains(ip[n].getDestination())) continue;
                        selectedUsersCheck.addElement(ip[0].getDestination());
                        this.result.addElement(ip[n]);
                    }
                }
            }
            this.model.changed(StringUtility.sort((Vector)this.result));
        }
        _isSearching = false;
        this.btnSearch.setEnabled(true);
        this.btnBrowse.setEnabled(true);
    }

    public Conference[] getUserSelectionList() {
        Object[] ret = new Conference[this.result.size()];
        this.result.copyInto(ret);
        Manager.Out(this.result);
        return ret;
    }

    private Conference[] getSelectedUsers() {
        Object uids = null;
        int[] sel = this.lstResult.getSelectedIndices();
        Vector<Conference> tmp = new Vector<Conference>();
        if (sel.length > 0) {
            for (int n = 0; n < sel.length; ++n) {
                Conference ip = (Conference)this.result.elementAt(sel[n]);
                if (!this._expandGroupsOnAdd) {
                    tmp.addElement(ip);
                    continue;
                }
                tmp.addElement(ip);
            }
        } else {
            return null;
        }
        Object[] ret = new Conference[tmp.size()];
        tmp.copyInto(ret);
        return ret;
    }

    public Vector getValues() {
        return RoomManager.getFavorites();
    }

    private void addElementsToRoomList(String grp) {
        if (this.result.size() != 0) {
            Vector<String> tmp = new Vector<String>();
            Conference[] sel = this.getUserSelectionList();
            if (sel == null) {
                String msg = bundle.getString("AddRoomDialog_noContacts");
                JOptionPane.showMessageDialog(this, msg, bundle.getString("Search_Message_Title"), 1);
                return;
            }
            for (int n = 0; n < sel.length; ++n) {
                try {
                    Manager.Out("DEBUG: Subscribing to room: " + sel[n].getDestination());
                    RoomManager.subscribe(sel[n]);
                    RoomManager.refreshRooms();
                    this.roomPanel.refresh();
                }
                catch (CollaborationException e) {
                    System.out.println((Object)e);
                }
                tmp.addElement(sel[n].getDestination());
            }
            Object[] ret = new String[tmp.size()];
            tmp.copyInto(ret);
            this.roomPanel.requestDefaultFocus();
            this.roomPanel.getlstRooms().setSelectionInterval(0, 0);
            this.close();
        } else {
            String msg = bundle.getString("AddRoomDialog_noContacts");
            JOptionPane.showMessageDialog(this, msg, bundle.getString("Search_Message_Title"), 1);
        }
    }

    public void removeListeners() {
        this.btnRemove.removeActionListener(this);
        this.btnSearch.removeActionListener(this);
        this.btnBrowse.removeActionListener(this);
    }

    public void close() {
        this.setVisible(false);
        this.removeListeners();
        if (this._parentFrame instanceof Communicator) {
            ((Communicator)this._parentFrame).startUserSearch = true;
            ((Communicator)this._parentFrame).updateUserSearch = false;
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.addElementsToRoomList((String)this.cmbAddToGroup.getSelectedItem());
        } else if (actionCommand == "cancel") {
            this.close();
        } else if (object == this.btnSearch) {
            this.search();
        } else if (object == this.btnBrowse) {
            Manager.worker.addRunnable((Runnable)new UserSearchThread("", "*", 0));
        } else if (actionCommand == "help") {
            HelpManager.showHelp("subscriberoom");
        } else if (object == this.btnRemove) {
            int[] sel = this.lstResult.getSelectedIndices();
            if (sel.length == 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            for (int n = 0; n < sel.length; ++n) {
                Conference u = (Conference)this.result.elementAt(sel[n] - n);
                this.result.removeElement(u);
            }
            this.model.changed(this.result);
            this.lstResult.getSelectionModel().clearSelection();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void keyPressed(KeyEvent event) {
        Object o = event.getSource();
        int k = event.getKeyCode();
        int m = event.getModifiers();
        if (o == this.lstResult && k == 127) {
            this.selectedDelete();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.close();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private final void selectedDelete() {
        int[] rem = this.lstResult.getSelectedIndices();
        for (int n = 0; n < rem.length; ++n) {
            this.result.removeElementAt(rem[n] - n);
        }
        this.lstResult.clearSelection();
        this.model.changed(this.result);
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddRoomDialog.this.setVisible(false);
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    class UserSearchThread
    implements Runnable {
        String serv;
        String txt;
        int search_type;

        public UserSearchThread(String serv, String txt, int search_type) {
            this.txt = txt;
            this.serv = serv;
            this.search_type = search_type;
        }

        public void run() {
            AddRoomDialog.this._srch(this.serv, this.txt, this.search_type);
            SwingUtilities.invokeLater(new ResetView());
        }
    }

    class ResetView
    implements Runnable {
        ResetView() {
        }

        public void run() {
            int matchesFound;
            AddRoomDialog.this.btnSearch.setEnabled(true);
            AddRoomDialog.this.btnBrowse.setEnabled(true);
            _isSearching = false;
            if (AddRoomDialog.this.lstResult != null) {
                AddRoomDialog.this.lstResult.clearSelection();
            }
            if ((matchesFound = AddRoomDialog.this.result.size()) == 0) {
                String msg = bundle.getString("No_Matches_Found");
                AddRoomDialog.this.lblResult.setText(msg);
                return;
            }
            String msg = AddRoomDialog.this.limitWasExceeded ? bundle.getString("More_matches_exist") : StringUtility.substitute((String)bundle.getString("Matches_found"), (String)"__MACRO__", (String)Integer.toString(matchesFound));
            AddRoomDialog.this.lblResult.setText(msg);
        }
    }
}

