/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.dialogs.FindContact;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.AutoOrientationJDialog;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class AddContact
extends AutoOrientationJDialog
implements ActionListener,
KeyListener {
    static SafeResourceBundle addContactBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    private Frame _parentFrame;
    private Vector result = new Vector(20);
    private String[] servers = null;
    private iIMListModel model;
    private iIMListRenderer renderer;
    private static boolean _isSearching = false;
    private boolean limitWasExceeded = false;
    private FindContact findContact;
    private boolean _expandGroupsOnAdd = false;
    private ButtonGroup bg = new ButtonGroup();
    private String[] serverList;
    Frame _p;
    JPanel pnlTop = new JPanel();
    JLabel lblResult = new JLabel();
    JLabel lblSearchHeader = new JLabel();
    JScrollPane scrResult = new JScrollPane();
    JList lstResult = new JList();
    JButton btnRemove = new JButton();
    JPanel pnlAddToGroup = new JPanel();
    JLabel lblAddToGroup;
    JComboBox cmbAddToGroup = new JComboBox();
    DialogButtonsPanel pnlButtons;

    public AddContact(Frame p, boolean expand_groups) {
        super(p);
        this._p = p;
        Manager.Out("DEBUG: AddContact.<init>");
        this._parentFrame = p;
        this._expandGroupsOnAdd = expand_groups;
        this.initComponents();
    }

    private void initComponents() {
        this.pnlButtons = new DialogButtonsPanel(this, 7);
        this.pnlButtons.setOkButtonLabel(3);
        String title = addContactBundle.getString("AddContact_title");
        this.setTitle(title);
        this.getAccessibleContext().setAccessibleDescription(title);
        this.getContentPane().setLayout(new GridBagLayout());
        this.lstResult.addKeyListener(this);
        if (PlatformUtil.isUnix()) {
            this.setSize(460, 430);
        } else if (PlatformUtil.isMac()) {
            this.setSize(470, 430);
        } else {
            this.setSize(400, 400);
        }
        this.model = new iIMListModel(this.lstResult, this.result);
        this.findContact = new FindContact(this, addContactBundle.getString("Contact_Title"));
        this.findContact.addSelectRecipientsListener(new FindContact.SelectRecipientsListener(){

            public void selectedRecipients(CollaborationPrincipal[] selectedElements) {
                if (selectedElements != null) {
                    for (int n = 0; n < selectedElements.length; ++n) {
                        if (AddContact.this.result.contains(selectedElements[n])) continue;
                        AddContact.this.result.addElement(selectedElements[n]);
                    }
                }
                AddContact.this.model.changed(StringUtility.sort((Vector)AddContact.this.result));
            }
        });
        this.getContentPane().add((Component)this.findContact, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.findContact.setSearchButton(addContactBundle.getString("us_find"));
        this.findContact.setDefaultButton();
        this.getContentPane().add((Component)this.makeSeparator(), new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 11, 2, new Insets(11, 12, 11, 12), 0, 0));
        this.lblAddToGroup = SwingUtils.makeLabelItem(addContactBundle, "AddContact_addLabel", "AddContact_addLabel_M", this.cmbAddToGroup);
        this.getContentPane().add((Component)this.lblAddToGroup, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.cmbAddToGroup, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.lblSearchHeader.setText(addContactBundle.getString("Contact_Header"));
        this.getContentPane().add((Component)this.lblSearchHeader, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.scrResult, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 10, 1, new Insets(5, 12, 0, 12), 250, 110));
        this.scrResult.setViewportView(this.lstResult);
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 5, 0, 1, 0.0, 0.0, 13, 2, new Insets(17, 12, 12, 12), 0, 0));
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int pointX = (double)(this._parentFrame.getX() + 100 + 450) > d.getWidth() ? (int)d.getWidth() - 450 - 100 : this._parentFrame.getX() + 100;
        int pointY = (double)(this._parentFrame.getY() + 100 + 454) > d.getHeight() ? (int)d.getHeight() - 454 - 100 : this._parentFrame.getY() + 100;
        this.setLocation(pointX, pointY);
        this.btnRemove.addActionListener(this);
        this.btnRemove.setRequestFocusEnabled(false);
        this.renderer = new iIMListRenderer(this.model);
        this.lstResult.setCellRenderer(this.renderer);
        this.lstResult.setModel(this.model);
        Manager.Out("AddContact.initComponents(): before calling refresh()");
        this.refresh();
    }

    public AddContact(Frame p, Vector users, boolean expand_groups) {
        this(p, expand_groups);
        this.result = users;
        this.model.changed(this.result);
    }

    public JTextField getTxtSearchPattern() {
        return this.findContact.getTxtSearchPattern();
    }

    private JSeparator makeSeparator() {
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(0, 2));
        separator.setMinimumSize(new Dimension(0, 2));
        separator.setEnabled(false);
        return separator;
    }

    public void refresh() {
        this.cmbAddToGroup.removeAllItems();
        String[] buddyListGroups = BuddyListManager.getBuddyListGroups();
        Manager.Out("AddContact.refresh(): buddyListGroups.length: " + buddyListGroups.length);
        for (int x = 0; x < buddyListGroups.length; ++x) {
            this.cmbAddToGroup.addItem(buddyListGroups[x]);
        }
        if (this._parentFrame instanceof Communicator) {
            this.cmbAddToGroup.setSelectedItem(((Communicator)this._parentFrame).getCurrentBuddyListGroup());
        }
        if (this.cmbAddToGroup.getSelectedIndex() == -1 && this.cmbAddToGroup.getItemCount() > 0) {
            this.cmbAddToGroup.setSelectedIndex(0);
        }
        this.result.removeAllElements();
        this.model.changed(this.result);
    }

    public void addGroup(String g) {
        this.cmbAddToGroup.addItem(g);
        this.cmbAddToGroup.revalidate();
    }

    public void removeGroup(String g) {
        this.cmbAddToGroup.removeItem(g);
        this.cmbAddToGroup.revalidate();
    }

    public void refresh(String searchFor, CollaborationPrincipal[] u, String group) {
        this.refresh();
        this.result = Manager.getVectorFromArray(u);
        this.model.changed(StringUtility.sort((Vector)this.result));
        this.cmbAddToGroup.removeAllItems();
        String[] grps = BuddyListManager.getBuddyListGroups();
        int sel = 0;
        for (int x = 0; x < grps.length; ++x) {
            if (grps[x].equals(group)) {
                sel = x;
            }
            this.cmbAddToGroup.addItem(grps[x]);
        }
        this.result.removeAllElements();
        this.model.changed(this.result);
        this.cmbAddToGroup.setSelectedIndex(sel);
    }

    public CollaborationPrincipal[] getUserSelectionList() {
        Object[] ret = new CollaborationPrincipal[this.result.size()];
        this.result.copyInto(ret);
        return ret;
    }

    private CollaborationPrincipal[] getSelectedUsers() {
        try {
            Object uids = null;
            int[] sel = this.lstResult.getSelectedIndices();
            Vector<CollaborationPrincipal> tmp = new Vector<CollaborationPrincipal>();
            if (sel.length > 0) {
                for (int n = 0; n < sel.length; ++n) {
                    CollaborationPrincipal ip = (CollaborationPrincipal)this.result.elementAt(sel[n]);
                    if (!this._expandGroupsOnAdd) {
                        tmp.addElement(ip);
                        continue;
                    }
                    if (ip instanceof CollaborationGroup) {
                        CollaborationPrincipal[] u = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(ip.getUID());
                        if (u == null) continue;
                        for (int x = 0; x < u.length; ++x) {
                            tmp.addElement(u[x]);
                        }
                        continue;
                    }
                    tmp.addElement(ip);
                }
            } else {
                return null;
            }
            Object[] ret = new CollaborationPrincipal[tmp.size()];
            tmp.copyInto(ret);
            return ret;
        }
        catch (Exception e) {
            Manager.Out(e);
            e.printStackTrace();
            return null;
        }
    }

    private void addElementsToBuddyListGroup(String grp) {
        Communicator c = null;
        if (this._parentFrame instanceof Communicator) {
            c = (Communicator)this._parentFrame;
        }
        if (this.result.size() != 0) {
            Vector<String> tmp = new Vector<String>();
            CollaborationPrincipal[] sel = this.getUserSelectionList();
            if (sel == null) {
                String msg = addContactBundle.getString("AddContact_noContacts");
                JOptionPane.showMessageDialog(this, msg, addContactBundle.getString("Search_Message_Title"), 1);
                return;
            }
            for (int n = 0; n < sel.length; ++n) {
                if (sel[n] instanceof CollaborationGroup) {
                    Vector v;
                    Manager.Out("DEBUG group: " + sel[n]);
                    tmp.addElement("g:" + sel[n].getUID());
                    PersonalGroup g = null;
                    try {
                        g = (PersonalGroup)Manager._personalStoreSession.createEntry("group", sel[n].getDisplayName());
                        g.setDistinguishedName(sel[n].getUID());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Object[] users = ServerGroupManager.getUsersInGroup(g);
                    if (users == null || (v = Manager.getVectorFromArray(UserCache.getUIDsFromUsers(Manager.getVectorFromArray(users)))) == null) continue;
                    String[] ids = new String[v.size()];
                    if (c == null) continue;
                    c.updateUserStatus(v.toArray(ids), true);
                    continue;
                }
                tmp.addElement(sel[n].getUID());
            }
            Object[] ret = new String[tmp.size()];
            tmp.copyInto(ret);
            if (c != null) {
                c.addElementsToBuddyListGroup(sel, grp);
                boolean b = BuddyListManager.setBuddyListGroupExpanded(grp);
                c.updateBuddylist(false);
            } else {
                iIM.addUsersToBuddyListGroup(sel, grp);
                iIM.getBuddyList().update(false);
            }
            this.close();
        } else {
            String msg = addContactBundle.getString("AddContact_noContacts");
            JOptionPane.showMessageDialog(this, msg, addContactBundle.getString("Search_Message_Title"), 1);
        }
    }

    public void removeListeners() {
        this.btnRemove.removeActionListener(this);
    }

    public void close() {
        this.setVisible(false);
        this.removeListeners();
        if (this._parentFrame instanceof Communicator) {
            ((Communicator)this._parentFrame).startUserSearch = true;
            ((Communicator)this._parentFrame).updateUserSearch = false;
        }
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.addElementsToBuddyListGroup((String)this.cmbAddToGroup.getSelectedItem());
        } else if (actionCommand == "cancel") {
            this.close();
        } else if (actionCommand == "help") {
            HelpManager.showHelp("addnewcontact");
        } else if (object == this.btnRemove) {
            int[] sel = this.lstResult.getSelectedIndices();
            if (sel.length == 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            for (int n = 0; n < sel.length; ++n) {
                CollaborationPrincipal u = (CollaborationPrincipal)this.result.elementAt(sel[n] - n);
                this.result.removeElement(u);
            }
            this.model.changed(this.result);
            this.lstResult.getSelectionModel().clearSelection();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void keyPressed(KeyEvent event) {
        Object o = event.getSource();
        int k = event.getKeyCode();
        int m = event.getModifiers();
        if (o == this.lstResult && k == 127) {
            this.selectedDelete();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private final void selectedDelete() {
        int[] rem = this.lstResult.getSelectedIndices();
        for (int n = 0; n < rem.length; ++n) {
            this.result.removeElementAt(rem[n] - n);
        }
        this.lstResult.clearSelection();
        this.model.changed(this.result);
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddContact.this.setVisible(false);
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    class ResetView
    implements Runnable {
        ResetView() {
        }

        public void run() {
            int matchesFound;
            _isSearching = false;
            if (AddContact.this.lstResult != null) {
                AddContact.this.lstResult.clearSelection();
            }
            if ((matchesFound = AddContact.this.result.size()) == 0) {
                String msg = addContactBundle.getString("No_Matches_Found");
                AddContact.this.lblResult.setText(msg);
                return;
            }
            String msg = AddContact.this.limitWasExceeded ? addContactBundle.getString("More_matches_exist") : StringUtility.substitute((String)addContactBundle.getString("Matches_found"), (String)"__MACRO__", (String)Integer.toString(matchesFound));
            AddContact.this.lblResult.setText(msg);
        }
    }
}

