/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.dialogs;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.AutoOrientationJDialog;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AboutDialog
extends AutoOrientationJDialog {
    static SafeResourceBundle aboutBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");

    public AboutDialog(Frame p) {
        super(p);
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        JTabbedPane tabs = new JTabbedPane();
        JLabel lblFooterimage = new JLabel();
        JLabel lblVersion = new JLabel();
        JLabel lblImage = new JLabel();
        JPanel aboutPanel = new JPanel();
        JPanel infoPanel = new JPanel();
        JEditorPane editor = new JEditorPane();
        editor.setContentType("text/html");
        editor.setEditable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        String server_host = null;
        String server_port = null;
        String server = Manager.NetLertProperties.getProperty("net.nms");
        String resource = Manager.NetLertProperties.getProperty("net.resource");
        int k = server.lastIndexOf(":");
        if (k > 0) {
            server_host = server.substring(0, k);
            server_port = server.substring(k + 1);
        } else {
            server_host = server;
            server_port = "5222";
        }
        String ssl = Manager._use_ssl ? aboutBundle.getString("about_usessl") : aboutBundle.getString("about_notssl");
        String[] columnNames = new String[]{aboutBundle.getString("about_info"), aboutBundle.getString("about_details")};
        Object[][] data = new Object[][]{{aboutBundle.getString("about_currentuid"), StringUtility.getLocalPartFromAddress((String)CurrentUserManager.getCurrentUserID())}, {aboutBundle.getString("about_session"), resource}, {aboutBundle.getString("about_priority"), Manager.getSessionPriority() + ""}, {aboutBundle.getString("about_jvm"), PlatformUtil.getVMVersion()}, {aboutBundle.getString("about_os"), PlatformUtil.getOSName()}, {aboutBundle.getString("about_osv"), PlatformUtil.getOSVersion()}, {aboutBundle.getString("about_softwarev"), aboutBundle.getString("about_javaim")}, {aboutBundle.getString("about_serverhost"), server_host}, {aboutBundle.getString("about_serverport"), server_port}, {aboutBundle.getString("about_sslstatus"), ssl}};
        InfoTableModel infoModel = new InfoTableModel(data, columnNames);
        JTable infoTable = new JTable(infoModel);
        JScrollPane infoScrollPane = new JScrollPane(infoTable);
        infoTable.getTableHeader().setReorderingAllowed(false);
        tabs.add(aboutPanel);
        tabs.add(infoPanel);
        infoPanel.setPreferredSize(new Dimension(10, 10));
        tabs.setTitleAt(0, aboutBundle.getString("About"));
        tabs.setTitleAt(1, aboutBundle.getString("about_details"));
        Font font = lblVersion.getFont().deriveFont(1);
        lblVersion.setFont(font);
        aboutPanel.setLayout(new GridBagLayout());
        infoPanel.setLayout(new GridLayout());
        infoPanel.add(infoScrollPane);
        ImageIcon ico = SwingImageManager.getIcon("/com/sun/im/desktop/brand/logo_sun.png", "/com/sun/im/desktop/default/brand/logo_sun.png", this);
        lblImage.setIcon(ico);
        this.setTitle(aboutBundle.getString("About"));
        lblVersion.setText(aboutBundle.getString("about_version"));
        lblFooterimage.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/default/brand/logo_login_footer.png", (Object)this));
        editor.setBackground(this.getBackground());
        editor.setText(this.getLabelText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        aboutPanel.add((Component)lblImage, gridBagConstraints);
        aboutPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        aboutPanel.add((Component)lblVersion, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        aboutPanel.add((Component)editor, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        aboutPanel.add((Component)lblFooterimage, gridBagConstraints);
        this.getContentPane().add((Component)tabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setResizable(false);
    }

    private final String getLabelText() {
        String s = new String();
        s = "<html><font size=3>Copyright &#169;2004 Sun Microsystems,Inc.All rights reserved.U.S.Gover-<br>nment Rights-Commercial software.Government users are subject to the<br>Sun Microsystems,Inc.standard license agreement and applicable provi-<br>sions of the FAR distribution and its supplements.Use is subject to lice-<br>nse terms.This may include materials developed by third partiesSun,Sun.<br>Microsystems,the Sun logo,Java and Sun Java<font size=1><sup>TM</sup></font>Studio Creator are<br>trademarks or registered trademarks of Sun Microsystems,.Inc.in the<br>U.S and other countries.<br><br>Copyright &#169; 2004 Sun Microsystems,Inc.Tous droits.L'utilisation est<br>soumise aux termes du contrat de licence.Cette distribution peut compre-<br>ndre des composants developpes par des tierces parties.Sun,Sun Micro-<br>systems,le,logo Sun Java,et Sun Java<font size=1><sup>TM</sup></font>Studio Creator sont des marques<br>de fabrique ou des marques deposees de Sun Microsystems,<br>Inc.aux Etats-Unis et dans d'autres pays.</html>";
        return s;
    }

    class InfoTableModel
    extends AbstractTableModel {
        private String[] columnNames = null;
        private Object[][] data = null;

        private InfoTableModel(Object[][] data, String[] columnnames) {
            this.data = data;
            this.columnNames = columnnames;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

