/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TopicSettingsPanel
extends JPanel {
    public static final String ID_POSITION_TOP = "Top";
    public static final String ID_POSITION_BOTTOM = "Bottom";
    public static final String ID_POSITION_RIGHT = "Right";
    public static final String ID_POSITION_LEFT = "Left";
    private Vector scroll_values = new Vector(10);
    private SymItem lSymItem = new SymItem();
    private LinkedList tabPositions;
    JCheckBox chkShowTopic;
    JCheckBox chkRotateTopic;
    JCheckBox chkHideTopicTabs;
    JCheckBox chkTopicAlertNewMsg;
    JCheckBox chkAlertChannel;
    JCheckBox chkHideTopicTools;
    JComboBox cmbTabPlacement;
    static SafeResourceBundle topicSettingsPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");

    public TopicSettingsPanel() {
        String[] positions = new String[]{ID_POSITION_TOP, ID_POSITION_BOTTOM, ID_POSITION_RIGHT, ID_POSITION_LEFT};
        this.tabPositions = new LinkedList<String>(Arrays.asList(positions));
        this.initComponents();
    }

    private void initComponents() {
        JPanel pnlCenter = new JPanel();
        this.chkTopicAlertNewMsg = new JCheckBox();
        JPanel pnlTabPlacement = new JPanel();
        JLabel lblTabPlacement = new JLabel();
        this.cmbTabPlacement = new JComboBox();
        this.setLayout(new GridBagLayout());
        pnlCenter.setToolTipText(topicSettingsPanelBundle.getString("pnlBorderTopic_toolTipText").length() != 0 ? topicSettingsPanelBundle.getString("pnlBorderTopic_toolTipText") : null);
        pnlCenter.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)pnlCenter, gridBagConstraints);
        this.chkRotateTopic = SwingUtils.checkBoxItem(topicSettingsPanelBundle, null, "chkRotateTopic_text", "chkRotateTopic_text_M", "chkRotateTopic_toolTipText");
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        pnlCenter.add((Component)this.chkRotateTopic, gridBagConstraints);
        this.chkHideTopicTabs = SwingUtils.checkBoxItem(topicSettingsPanelBundle, null, "chkHideTopicTabs_text", "chkHideTopicTabs_text_M", "chkHideTopicTabs_toolTipText");
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        gridBagConstraints.gridy = 2;
        pnlCenter.add((Component)this.chkHideTopicTabs, gridBagConstraints);
        this.chkAlertChannel = SwingUtils.checkBoxItem(topicSettingsPanelBundle, null, "chkAlertChannel_text", "chkAlertChannel_text_M", "chkAlertChannel_toolTipText");
        gridBagConstraints.gridy = 3;
        pnlCenter.add((Component)this.chkAlertChannel, gridBagConstraints);
        this.chkHideTopicTools = SwingUtils.checkBoxItem(topicSettingsPanelBundle, null, "chkHideTopicTools_text", "chkHideTopicTools_text_M", "chkHideTopicTools_toolTipText");
        gridBagConstraints.gridy = 4;
        pnlCenter.add((Component)this.chkHideTopicTools, gridBagConstraints);
        pnlTabPlacement.setLayout(new FlowLayout(3));
        lblTabPlacement.setText(topicSettingsPanelBundle.getString("lblTabPlacement_text"));
        lblTabPlacement.setToolTipText(topicSettingsPanelBundle.getString("lblTabPlacement_toolTipText").length() != 0 ? topicSettingsPanelBundle.getString("lblTabPlacement_toolTipText") : null);
        lblTabPlacement.setLabelFor(this.cmbTabPlacement);
        lblTabPlacement.setDisplayedMnemonic(topicSettingsPanelBundle.getString("lblTabPlacement_text_M").charAt(0));
        pnlTabPlacement.add(lblTabPlacement);
        this.cmbTabPlacement.setToolTipText(topicSettingsPanelBundle.getString("cmbTabPlacement_toolTipText").length() != 0 ? topicSettingsPanelBundle.getString("cmbTabPlacement_toolTipText") : null);
        pnlTabPlacement.add(this.cmbTabPlacement);
        gridBagConstraints.gridy = 5;
        pnlCenter.add((Component)pnlTabPlacement, gridBagConstraints);
        this.fillCombo();
        this.chkHideTopicTabs.addItemListener(this.lSymItem);
    }

    public final void initProperties(Properties p) {
        this.chkRotateTopic.setSelected(iIMPropsUtil.isRotateTopicEnabled(p));
        this.chkHideTopicTabs.setSelected(iIMPropsUtil.isHideTopicTabEnabled(p));
        this.chkAlertChannel.setSelected(iIMPropsUtil.isTopicAlertChannelEnabled(p));
        String pos = iIMPropsUtil.getTabPlacement(p);
        if (this.tabPositions.indexOf(pos) > -1) {
            this.cmbTabPlacement.setSelectedIndex(this.tabPositions.indexOf(pos));
        }
        this.chkTopicAlertNewMsg.setSelected(iIMPropsUtil.isTopicNewMsgAlertEnabled(p));
        this.chkHideTopicTools.setSelected(iIMPropsUtil.isHideTopicToolsEnabled(p));
    }

    public final void putProperties(Properties p) {
        iIMPropsUtil.setHideTopicTabEnabled(p, this.chkHideTopicTabs.isSelected());
        iIMPropsUtil.setRotateTopicEnabled(p, this.chkRotateTopic.isSelected());
        if (iIM.getTopics() != null) {
            iIM.getTopics().updatePauseButton();
        }
        iIMPropsUtil.setTopicAlertChannelEnabled(p, this.chkAlertChannel.isSelected());
        iIMPropsUtil.setTabPlacement(p, (String)this.tabPositions.get(this.cmbTabPlacement.getSelectedIndex()));
        iIMPropsUtil.setTopicNewMsgAlertEnabled(p, this.chkTopicAlertNewMsg.isSelected());
        iIMPropsUtil.setHideTopicToolsEnabled(p, this.chkHideTopicTools.isSelected());
    }

    public final void close() {
        this.chkHideTopicTabs.removeItemListener(this.lSymItem);
    }

    private final void fillCombo() {
        this.cmbTabPlacement.addItem(topicSettingsPanelBundle.getString("cmbTabPlacement_value_Top"));
        this.cmbTabPlacement.addItem(topicSettingsPanelBundle.getString("cmbTabPlacement_value_Bottom"));
        this.cmbTabPlacement.addItem(topicSettingsPanelBundle.getString("cmbTabPlacement_value_Right"));
        this.cmbTabPlacement.addItem(topicSettingsPanelBundle.getString("cmbTabPlacement_value_Left"));
    }

    public boolean isShowTopicSelected() {
        return this.chkShowTopic.isSelected();
    }

    void chkHideTopicTabs_itemStateChanged(ItemEvent event) {
        if (this.chkHideTopicTabs.isSelected()) {
            this.chkRotateTopic.setSelected(true);
            this.chkRotateTopic.setEnabled(false);
        } else {
            this.chkRotateTopic.setEnabled(true);
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == TopicSettingsPanel.this.chkHideTopicTabs) {
                TopicSettingsPanel.this.chkHideTopicTabs_itemStateChanged(event);
            }
        }
    }
}

