/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SoundSettingsPanel
extends JPanel {
    private JCheckBox chkOnSendMessage;
    private JCheckBox chkSoundEnabled;
    private JCheckBox chkOnAlert;
    private JLabel chkEnableSounds;
    private JCheckBox chkOnReceiveMessage;
    private JCheckBox chkOnStatusChange;
    private JCheckBox chkOnNewNewsMessage;
    private JPanel pnlPlaySoundWhen;
    static SafeResourceBundle settingsBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");

    public SoundSettingsPanel() {
        this.initComponents();
    }

    public boolean isSoundEnabled() {
        return this.chkSoundEnabled.isSelected();
    }

    public final void initProperties(Properties p) {
        this.chkSoundEnabled.setSelected(iIMPropsUtil.isSoundEnabled(p));
        this.chkOnSendMessage.setSelected(iIMPropsUtil.isPlaySoundOnSendMessageEnabled(p));
        this.chkOnReceiveMessage.setSelected(iIMPropsUtil.isPlaySoundOnReceiveMessageEnabled(p));
        this.chkOnAlert.setSelected(iIMPropsUtil.isPlaySoundOnAlertEnabled(p));
        this.chkOnNewNewsMessage.setSelected(iIMPropsUtil.isPlaySoundOnNewNewsMessageEnabled(p));
        this.chkOnStatusChange.setSelected(iIMPropsUtil.isPlaySoundOnStatusChangeEnabled(p));
        this.refreshComponents();
    }

    public final void putProperties(Properties p) {
        iIMPropsUtil.setSoundEnabled(p, this.chkSoundEnabled.isSelected());
        if (Manager.ALLOW_CHAT) {
            iIMPropsUtil.setPlaySoundOnSendMessageEnabled(p, this.chkOnSendMessage.isSelected());
            iIMPropsUtil.setPlaySoundOnReceiveMessageEnabled(p, this.chkOnReceiveMessage.isSelected());
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            iIMPropsUtil.setPlaySoundOnAlertEnabled(p, this.chkOnAlert.isSelected());
        }
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            iIMPropsUtil.setPlaySoundOnStatusChangeEnabled(p, this.chkOnStatusChange.isSelected());
        }
        if (Manager.ALLOW_NEWS_ACCESS) {
            iIMPropsUtil.setPlaySoundOnNewNewsMessageEnabled(p, this.chkOnNewNewsMessage.isSelected());
        }
    }

    private void initComponents() {
        this.pnlPlaySoundWhen = new JPanel();
        this.chkOnReceiveMessage = new JCheckBox();
        this.chkOnAlert = new JCheckBox();
        this.chkOnStatusChange = new JCheckBox();
        this.chkOnSendMessage = new JCheckBox();
        this.chkSoundEnabled = new JCheckBox();
        this.chkOnNewNewsMessage = new JCheckBox();
        this.chkEnableSounds = new JLabel();
        this.setLayout(new GridBagLayout());
        this.pnlPlaySoundWhen.setLayout(new GridBagLayout());
        this.chkEnableSounds.setText(settingsBundle.getString("pnlPlaySoundWhenBorder_text"));
        this.chkOnReceiveMessage.setText(settingsBundle.getString("chkOnReceiveMessage_text"));
        this.chkOnReceiveMessage.setMnemonic(settingsBundle.getString("chkOnReceiveMessage_text_M").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.pnlPlaySoundWhen, gridBagConstraints);
        this.chkSoundEnabled.setText(settingsBundle.getString("chkSoundEnabled_text"));
        this.chkSoundEnabled.setMnemonic(settingsBundle.getString("chkSoundEnabled_text_M").charAt(0));
        this.chkSoundEnabled.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SoundSettingsPanel.this.refreshComponents();
            }
        });
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.pnlPlaySoundWhen.add((Component)this.chkSoundEnabled, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 36, 0, 0);
        this.pnlPlaySoundWhen.add((Component)this.chkEnableSounds, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 32, 0, 0);
        if (Manager.ALLOW_CHAT) {
            this.pnlPlaySoundWhen.add((Component)this.chkOnReceiveMessage, gridBagConstraints);
        } else {
            this.chkOnReceiveMessage.setEnabled(false);
            this.chkOnReceiveMessage.setVisible(false);
        }
        this.chkOnAlert.setText(settingsBundle.getString("chkOnAlert_text"));
        this.chkOnAlert.setMnemonic(settingsBundle.getString("chkOnAlert_text_M").charAt(0));
        gridBagConstraints.gridy = 3;
        if (Manager.ALLOW_SEND_ALERTS) {
            this.pnlPlaySoundWhen.add((Component)this.chkOnAlert, gridBagConstraints);
        } else {
            this.chkOnAlert.setEnabled(false);
            this.chkOnAlert.setVisible(false);
        }
        this.chkOnStatusChange.setText(settingsBundle.getString("chkOnStatusChange_text"));
        this.chkOnStatusChange.setMnemonic(settingsBundle.getString("chkOnStatusChange_text_M").charAt(0));
        gridBagConstraints.gridy = 4;
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.pnlPlaySoundWhen.add((Component)this.chkOnStatusChange, gridBagConstraints);
        } else {
            this.chkOnStatusChange.setEnabled(false);
            this.chkOnStatusChange.setVisible(false);
        }
        this.chkOnSendMessage.setText(settingsBundle.getString("chkOnSendMessage_text"));
        this.chkOnSendMessage.setMnemonic(settingsBundle.getString("chkOnSendMessage_text_M").charAt(0));
        gridBagConstraints.gridy = 5;
        if (Manager.ALLOW_CHAT) {
            this.pnlPlaySoundWhen.add((Component)this.chkOnSendMessage, gridBagConstraints);
        } else {
            this.chkOnSendMessage.setEnabled(false);
            this.chkOnSendMessage.setVisible(false);
        }
        this.chkOnNewNewsMessage.setText(settingsBundle.getString("chkOnNewNewsMessage_text"));
        this.chkOnNewNewsMessage.setMnemonic(settingsBundle.getString("chkOnNewNewsMessage_text_M").charAt(0));
        gridBagConstraints.gridy = 6;
        if (Manager.ALLOW_NEWS_ACCESS) {
            this.pnlPlaySoundWhen.add((Component)this.chkOnNewNewsMessage, gridBagConstraints);
        } else {
            this.chkOnNewNewsMessage.setEnabled(false);
            this.chkOnNewNewsMessage.setVisible(false);
        }
    }

    private void refreshComponents() {
        boolean b = this.chkSoundEnabled.isSelected();
        this.pnlPlaySoundWhen.setEnabled(b);
        if (Manager.ALLOW_CHAT) {
            this.chkOnSendMessage.setEnabled(b);
            this.chkOnReceiveMessage.setEnabled(b);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.chkOnAlert.setEnabled(b);
        }
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.chkOnStatusChange.setEnabled(b);
        }
        if (Manager.ALLOW_NEWS_ACCESS) {
            this.chkOnNewNewsMessage.setEnabled(b);
        }
    }
}

