/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.MBeanManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.config.AdvancedPanel;
import com.iplanet.im.client.swing.config.AlertSettingsPanel;
import com.iplanet.im.client.swing.config.ChatSettingsPanel;
import com.iplanet.im.client.swing.config.CommunicatorSettingsPanel;
import com.iplanet.im.client.swing.config.PrivacySettingsPanel;
import com.iplanet.im.client.swing.config.SoundSettingsPanel;
import com.iplanet.im.client.swing.config.TopicSettingsPanel;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.desktop.MessengerBeanFactory;
import com.sun.im.desktop.MessengerPreferencesPanel;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class Settings
extends AutoOrientationJFrame
implements ActionListener {
    static SafeResourceBundle settingsBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");
    private Vector memberListCheckAcl = new Vector(5);
    private SymWindow aSymWindow = new SymWindow();
    private static final String ID_NO_USERS = settingsBundle.getString("The_user_list_is_empty");
    private static boolean _isSettingsViewOpen = false;
    public static final int SHOW_STATUS_NEVER = 0;
    public static final int SHOW_STATUS_ALWAYS = 1;
    public static final int SHOW_STATUS_MINIMIZED = 2;
    public static final String PRIVACY_TABKEY = "Privacy";
    private AlertSettingsPanel alertPanel = new AlertSettingsPanel();
    private CommunicatorSettingsPanel communicatorPanel = new CommunicatorSettingsPanel();
    private ChatSettingsPanel chatPanel = new ChatSettingsPanel();
    private TopicSettingsPanel topicPanel = new TopicSettingsPanel();
    private SoundSettingsPanel soundPanel = new SoundSettingsPanel();
    private AdvancedPanel advancedPanel = new AdvancedPanel();
    private PrivacySettingsPanel privacyPanel = new PrivacySettingsPanel(this);
    private LinkedList _mbeanPanels = new LinkedList();
    private PersonalProfile _user = null;
    private Properties _userProperties = null;
    private boolean _privacy;
    private String _value;
    JPanel pnlView = new JPanel();
    private JTabbedPane tabs = new JTabbedPane();
    private DialogButtonsPanel pnlButtons;

    public Settings() {
    }

    public Settings(PersonalProfile user, String value) {
        Manager.Out("DEBUG: Settings.<init>: Opening settings for user: " + user.getDisplayName());
        this._user = user;
        this._userProperties = UserPropsManager.loadUserProperties(this._user);
        this._value = value;
        this.initComponents();
    }

    private void initComponents() {
        this.pnlButtons = new DialogButtonsPanel(this, 15);
        this.pnlView.setLayout(new GridBagLayout());
        if (PlatformUtil.isUnix()) {
            this.setSize(520, 460);
        } else if (PlatformUtil.isMac()) {
            this.setSize(550, 470);
        } else if (PlatformUtil.isWin()) {
            this.setSize(400, 425);
        }
        String title = StringUtility.substitute((String)settingsBundle.getString("Settings_title_"), (String)"__MACRO__", (String)this._user.getDisplayName());
        this.setTitle(settingsBundle.getString("Settings_Title"));
        this.getAccessibleContext().setAccessibleDescription(title);
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.getContentPane().setLayout(new GridBagLayout());
        ApplicationManager.addActiveObject(this);
        _isSettingsViewOpen = true;
        this.tabs.setToolTipText(settingsBundle.getString("tabs_toolTipText").length() != 0 ? settingsBundle.getString("tabs_toolTipText") : null);
        this.pnlView.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 0, 2), 0, 0));
        this.getContentPane().add((Component)this.pnlView, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(17, 12, 12, 12), 0, 0));
        this.pnlButtons.setDefaultButton(4);
        this.pnlButtons.setCancelButtonLabel(4);
        this.tabs.add(this.communicatorPanel);
        if (Manager.ALLOW_CHAT) {
            this.tabs.add(this.chatPanel);
        }
        if (Manager.ALLOW_NEWS_ACCESS) {
            this.tabs.add(this.topicPanel);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.tabs.add(this.alertPanel);
        }
        this.tabs.add(this.soundPanel);
        this.tabs.add(this.privacyPanel);
        this.tabs.add(this.advancedPanel);
        if (this._value != null) {
            if (this._value.equals(settingsBundle.getString(PRIVACY_TABKEY))) {
                this.tabs.setSelectedComponent(this.privacyPanel);
            }
        } else {
            this.tabs.setSelectedComponent(this.communicatorPanel);
        }
        int ix = 0;
        this.tabs.setTitleAt(ix++, settingsBundle.getString("General"));
        if (Manager.ALLOW_CHAT) {
            this.tabs.setTitleAt(ix++, settingsBundle.getString("Chat"));
        }
        if (Manager.ALLOW_NEWS_ACCESS) {
            this.tabs.setTitleAt(ix++, settingsBundle.getString("Topics"));
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.tabs.setTitleAt(ix++, settingsBundle.getString("Alerts"));
        }
        this.tabs.setTitleAt(ix++, settingsBundle.getString("Sound"));
        this.tabs.setTitleAt(ix++, settingsBundle.getString(PRIVACY_TABKEY));
        this.tabs.setTitleAt(ix++, settingsBundle.getString("Advanced"));
        Iterator i = MBeanManager.getBeans().iterator();
        while (i.hasNext()) {
            MessengerBeanFactory f = (MessengerBeanFactory)i.next();
            MessengerPreferencesPanel panel = f.getPreferencesPanel();
            if (panel == null) continue;
            this._mbeanPanels.add(panel);
            this.tabs.add((Component)panel);
            this.tabs.setTitleAt(ix++, panel.getTitle());
        }
        this.addWindowListener(this.aSymWindow);
        this.loadSettings(this._userProperties);
    }

    public static void displayNonAdminDialog() {
        String msg = settingsBundle.getString("User_settings_could_not_be_loaded");
        JOptionPane.showMessageDialog(null, msg);
    }

    public final void loadSettings(Properties p) {
        Manager.Out("DEBUG SETTINGS: Settings.loadSettings()");
        if (p == null) {
            Settings.displayNonAdminDialog();
            return;
        }
        this.topicPanel.initProperties(p);
        this.communicatorPanel.initProperties(p);
        this.chatPanel.initProperties(p);
        this.alertPanel.initProperties(p);
        this.soundPanel.initProperties(p);
        this.advancedPanel.initProperties(p);
        Iterator i = this._mbeanPanels.iterator();
        while (i.hasNext()) {
            MessengerPreferencesPanel panel = (MessengerPreferencesPanel)i.next();
            try {
                panel.loadPreferences(this._userProperties);
            }
            catch (Exception e) {
                Manager.Out("Settings.loadSettings(): An error has occured while trying to load preferences for a bean: " + e);
            }
        }
    }

    private final int save() {
        int ret = 0;
        Manager.Out("DEBUG: Settings.save()");
        ret = this.alertPanel.checkSettings();
        if (ret != 0) {
            return ret;
        }
        this._userProperties.put("FIRST_TIME_IN", "false");
        this.topicPanel.putProperties(this._userProperties);
        this.communicatorPanel.putProperties(this._userProperties);
        this.chatPanel.putProperties(this._userProperties);
        this.alertPanel.putProperties(this._userProperties, true);
        this.soundPanel.putProperties(this._userProperties);
        this.advancedPanel.putProperties(this._userProperties);
        Iterator i = this._mbeanPanels.iterator();
        while (i.hasNext()) {
            MessengerPreferencesPanel panel = (MessengerPreferencesPanel)i.next();
            try {
                panel.savePreferences(this._userProperties);
            }
            catch (Exception e) {
                System.err.println("Settings.save(): Exception while saving properties for bean");
            }
        }
        UserPropsManager.saveUserSettings(this._user, this._userProperties, true);
        if (CurrentUserManager.isCurrentUserID(this._user.getEntryId())) {
            CurrentUserManager.setCurrentUserProperties(this._userProperties);
            Sound.on = this.soundPanel.isSoundEnabled();
            iIM.refreshWindows();
        }
        return ret;
    }

    public void close() {
        Manager.Out("DEBUG: Settings.close()");
        this.removeListeners();
        this.topicPanel.close();
        ApplicationManager.removeActiveObject(this);
        _isSettingsViewOpen = false;
        this.setVisible(false);
        this.dispose();
        iIM.GarbageCollect();
    }

    private final void removeListeners() {
        this.removeWindowListener(this.aSymWindow);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setCursor(new Cursor(3));
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand == "apply") {
            this.save();
        } else if (actionCommand == "ok") {
            if (this.save() == 0) {
                this.close();
            }
        } else if (actionCommand == "cancel") {
            this.close();
        } else if (actionCommand == "help") {
            HelpManager.showHelp("usersettings");
        }
        this.setCursor(new Cursor(0));
    }

    public static boolean isSettingsViewOpen() {
        return _isSettingsViewOpen;
    }

    public static SafeResourceBundle getSettingsBundle() {
        return settingsBundle;
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Settings.this.close();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Settings.this.close();
        }
    }
}

