/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.config.PrivacyEditorDialog;
import com.iplanet.im.client.swing.dialogs.WatcherStatusDialog;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.PrivacyItem;
import com.sun.im.service.PrivacyList;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PrivacySettingsPanel
extends JPanel
implements ActionListener {
    private static SafeResourceBundle privacySettingBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");
    private PrivacyEditorDialog privacyEditorDialog = null;
    private JList privacyList = new JList();
    private iIMListModel model;
    private iIMListRenderer renderer;
    private Vector plistNames;
    private Frame _parent;
    private JButton btnNew = null;
    private JButton btnDefault = null;
    private JButton btnEdit = null;
    private JButton btnActivate = null;
    private JButton btnViewUser = null;
    private JButton btnDelete = null;

    public PrivacySettingsPanel(Frame p) {
        this._parent = p;
        this.initComponents();
    }

    private void initComponents() {
        this.btnNew = new JButton();
        this.btnDefault = new JButton();
        this.btnEdit = new JButton();
        this.btnActivate = new JButton();
        this.btnViewUser = new JButton();
        this.btnDelete = new JButton();
        JPanel profileTopPanel = new JPanel();
        JScrollPane privacyScrollPane = new JScrollPane();
        JLabel lblShow = new JLabel();
        JLabel lblHeading = new JLabel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JLabel lblPrivacyHeader = new JLabel();
        this.setLayout(gridBagLayout);
        profileTopPanel.setLayout(gridBagLayout);
        SwingUtils.setupButton(this.btnNew, privacySettingBundle, "Privacy_New", "Privacy_New_M", null, null);
        SwingUtils.setupButton(this.btnViewUser, privacySettingBundle, "Privacy_View_Users", "Privacy_View_Users_M", null, null);
        SwingUtils.setupButton(this.btnDefault, privacySettingBundle, "Privacy_Default", "Privacy_Default_M", null, null);
        SwingUtils.setupButton(this.btnEdit, privacySettingBundle, "Privacy_Edit", "Privacy_Edit_M", null, null);
        SwingUtils.setupButton(this.btnActivate, privacySettingBundle, "Privacy_Activate", "Privacy_Activate_M", null, null);
        String lblViewTxt = "<html>" + privacySettingBundle.getString("view_others") + "</html>";
        lblShow.setText(lblViewTxt);
        String labelText = "<html>" + privacySettingBundle.getString("privacy_msg") + "</html>";
        lblHeading = new JLabel(labelText);
        SwingUtils.setupButton(this.btnDelete, privacySettingBundle, "Privacy_Delete", "Privacy_Delete_M", null, null);
        lblPrivacyHeader.setText(privacySettingBundle.getString("Privacy_Header"));
        this.btnNew.addActionListener(this);
        this.btnDefault.addActionListener(this);
        this.btnViewUser.addActionListener(this);
        this.btnEdit.addActionListener(this);
        this.btnActivate.addActionListener(this);
        this.btnDelete.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.fill = 2;
        this.add((Component)lblHeading, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.add((Component)lblPrivacyHeader, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)profileTopPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        profileTopPanel.add((Component)privacyScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        profileTopPanel.add((Component)this.btnNew, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        gridBagConstraints.gridy = 1;
        profileTopPanel.add((Component)this.btnEdit, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        profileTopPanel.add((Component)this.btnDelete, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        profileTopPanel.add((Component)this.btnActivate, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        profileTopPanel.add((Component)this.btnDefault, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        profileTopPanel.add((Component)this.makeSeparator(), gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        profileTopPanel.add((Component)lblShow, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        profileTopPanel.add((Component)this.btnViewUser, gridBagConstraints);
        privacyScrollPane.getViewport().add(this.privacyList);
        this.btnDefault.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnActivate.setEnabled(false);
        this.btnDelete.setEnabled(false);
        try {
            this.plistNames = UserAccessControl.initPrivacyLists();
        }
        catch (CollaborationException ce) {
            Manager.debug("Failed to intialized PrivacySettings Panel");
            ce.printStackTrace();
        }
        this.model = new iIMListModel(this.privacyList, this.plistNames){

            public String getName(Object object) {
                StringBuffer ret = new StringBuffer();
                try {
                    Object o = this.v.elementAt(this.v.indexOf(object));
                    String name = null;
                    if (o == null) {
                        return "";
                    }
                    name = o.toString();
                    boolean defaultList = false;
                    boolean activeList = false;
                    boolean default_activeList = false;
                    if (UserAccessControl.isDefaultPrivacyList(name)) {
                        defaultList = true;
                    }
                    if (UserAccessControl.isActivePrivacyList(name)) {
                        if (defaultList) {
                            default_activeList = true;
                        }
                        activeList = true;
                    }
                    if (default_activeList) {
                        PrivacySettingsPanel.appendDefaultActive(ret, name);
                    } else if (defaultList) {
                        PrivacySettingsPanel.appendDefault(ret, name);
                    } else if (activeList) {
                        PrivacySettingsPanel.appendActive(ret, name);
                    } else {
                        ret.append(name);
                    }
                }
                catch (CollaborationException ce) {
                    ce.printStackTrace();
                }
                return ret.toString();
            }
        };
        this.renderer = new iIMListRenderer(this.model);
        this.privacyList.setModel(this.model);
        this.privacyList.setCellRenderer(this.renderer);
        this.privacyList.setSelectionMode(0);
        this.privacyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                try {
                    PrivacySettingsPanel.this.applyUIRestrictions();
                }
                catch (CollaborationException ce) {
                    ce.printStackTrace();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.btnNew) {
            this.newProfile();
        } else if (object == this.btnEdit) {
            this.edit();
        } else if (object == this.btnDefault) {
            this.setDefault();
        } else if (object == this.btnActivate) {
            this.activate();
        } else if (object == this.btnDelete) {
            this.delete();
        } else if (object == this.btnViewUser) {
            this.viewWatchers();
        }
    }

    public boolean privacyListExists(String name) {
        return this.plistNames.contains(name) || UserAccessControl.visibleToAllPrivListName.equals(name) || UserAccessControl.invisibleToAllPrivListName.equals(name);
    }

    private void edit() {
        if (!this.validateIndex(true)) {
            return;
        }
        String pListName = (String)this.privacyList.getSelectedValue();
        if (pListName != null) {
            try {
                PrivacyList plist = UserAccessControl.getPrivacyList(pListName);
                if (plist != null) {
                    String privacyEditProfileStr = privacySettingBundle.getString("Privacy_Edit_Profile");
                    privacyEditProfileStr = StringUtility.substitute((String)privacyEditProfileStr, (String)"__MACRO__", (String)pListName);
                    this.privacyEditorDialog = new PrivacyEditorDialog(this._parent, this, privacyEditProfileStr, true, pListName, plist, this.plistNames);
                    this.privacyEditorDialog.setModal(true);
                    this.privacyEditorDialog.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(this, privacySettingBundle.getString("PrivacyList") + pListName + privacySettingBundle.getString("Privacy_doesnot_exists"));
                }
                if (this.privacyEditorDialog.changesApplied()) {
                    String newName = this.privacyEditorDialog.getPrivacyProfileName();
                    if (newName.equals(pListName)) {
                        UserAccessControl.setPrivacyList(pListName, plist);
                    } else {
                        UserAccessControl.deletePrivacyList(pListName);
                        UserAccessControl.setPrivacyList(newName, plist);
                        this.plistNames.remove(pListName);
                        this.plistNames.add(newName);
                    }
                    this.model.changed();
                }
            }
            catch (CollaborationException ce) {
                ce.printStackTrace();
            }
        }
    }

    private void viewWatchers() {
        WatcherStatusDialog watcherStatusDialog = new WatcherStatusDialog(this._parent, privacySettingBundle.getString("watchers_title"), true);
        watcherStatusDialog.setLocationRelativeTo(this);
        watcherStatusDialog.setVisible(true);
        watcherStatusDialog.setModal(true);
    }

    private void newProfile() {
        try {
            String new_Msg = privacySettingBundle.getString("Privacy_New_MSG");
            this.privacyEditorDialog = new PrivacyEditorDialog(this._parent, this, new_Msg, true, null, null, this.plistNames);
            this.privacyEditorDialog.setModal(true);
            this.privacyEditorDialog.setVisible(true);
            String pListName = this.privacyEditorDialog.getPrivacyProfileName();
            PrivacyList plist = this.privacyEditorDialog.getPrivacyList();
            if (this.privacyEditorDialog.changesApplied()) {
                this.plistNames.add(pListName);
                this.model.changed();
                UserAccessControl.setPrivacyList(pListName, plist);
            }
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
    }

    private void setDefault() {
        if (!this.validateIndex(true)) {
            return;
        }
        String pListName = (String)this.privacyList.getSelectedValue();
        try {
            this.btnDefault.setEnabled(false);
            UserAccessControl.setDefaultPrivacyList(pListName);
            this.model.changed();
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
    }

    private void delete() {
        try {
            if (!this.validateIndex(true)) {
                return;
            }
            String pListName = (String)this.privacyList.getSelectedValue();
            if (UserAccessControl.deletePrivacyList(pListName)) {
                this.plistNames.remove(pListName);
                this.model.changed();
            }
            this.applyUIRestrictions();
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
    }

    private void rename() {
        String msg = privacySettingBundle.getString("Privacy_Enter");
        String pListName = (String)this.privacyList.getSelectedValue();
        String newName = JOptionPane.showInputDialog(this, msg, msg, 3);
        if (newName == null || newName.equals("")) {
            JOptionPane.showMessageDialog(this, privacySettingBundle.getString("Privacy_Enter_List"));
            return;
        }
        if (newName != null && this.plistNames.contains(newName)) {
            JOptionPane.showMessageDialog(this, privacySettingBundle.getString("Privacy_cannot_rename"));
            return;
        }
        Manager.worker.addRunnable((Runnable)new RenamePrivListRunnable(pListName, newName));
    }

    private void activate() {
        try {
            if (!this.validateIndex(true)) {
                return;
            }
            String pListName = (String)this.privacyList.getSelectedValue();
            this.btnActivate.setEnabled(false);
            PrivacySettingsPanel.activatePrivacyList(pListName);
            this.model.changed();
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
    }

    private String[] getPrivacySummary(String name) throws CollaborationException {
        String[] privacyInfo = new String[2];
        PrivacyList plist = Manager._session.getPrivacyList(name);
        if (plist == null) {
            return null;
        }
        Collection c = plist.getPrivacyItems();
        int messageIndex = 1;
        int presenceIndex = 0;
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            PrivacyItem pitem = (PrivacyItem)itr.next();
            String type = pitem.getType();
            if (type != null) {
                if (type.equals("group")) {
                    if (pitem.getResource() == 4) {
                        privacyInfo[messageIndex] = privacySettingBundle.getString("Privacy_Edit_rdbBlockAll");
                        continue;
                    }
                    if (pitem.getResource() != 2) continue;
                    privacyInfo[presenceIndex] = privacySettingBundle.getString("Privacy_UsersContactFolder");
                    continue;
                }
                if (type.equals("jid")) {
                    if (pitem.getResource() == 4) {
                        privacyInfo[messageIndex] = privacySettingBundle.getString("Privacy_Edit_rdbBlock");
                        continue;
                    }
                    if (pitem.getResource() != 2) continue;
                    privacyInfo[presenceIndex] = privacySettingBundle.getString("Privacy_Edit_rdbBlock");
                    continue;
                }
                if (!type.equals("subscription")) continue;
                if (pitem.getResource() == 4) {
                    privacyInfo[messageIndex] = privacySettingBundle.getString("Privacy_Edit_rdbBlockanyone");
                    continue;
                }
                if (pitem.getResource() != 2) continue;
                privacyInfo[presenceIndex] = privacySettingBundle.getString("Privacy_UsersContact");
                continue;
            }
            if (pitem.getResource() != 2 || pitem.getAccess() != 1) continue;
            privacyInfo[presenceIndex] = privacySettingBundle.getString("Privacy_UsersAll");
        }
        return privacyInfo;
    }

    public static void appendDefault(StringBuffer buf, String name) {
        String defaultString = privacySettingBundle.getString("Privacy_Default_List");
        defaultString = StringUtility.substitute((String)defaultString, (String)"__MACRO__", (String)name);
        buf.append(defaultString);
    }

    public static void appendActive(StringBuffer buf, String name) {
        String activeString = privacySettingBundle.getString("Privacy_Active_List");
        activeString = StringUtility.substitute((String)activeString, (String)"__MACRO__", (String)name);
        buf.append(activeString);
    }

    public static void appendDefaultActive(StringBuffer buf, String name) {
        String activeString = privacySettingBundle.getString("Privacy_Default_Active_List");
        activeString = StringUtility.substitute((String)activeString, (String)"__MACRO__", (String)name);
        buf.append(activeString);
    }

    public static final void activatePrivacyList(String pListName) throws CollaborationException {
        UserInfo.ResourceInfo ri;
        UserInfo ui;
        String currActivePrivList = UserAccessControl.getActivePrivacyList();
        if (UserAccessControl.localizedInvisibleToAll.equals(currActivePrivList) && (ui = UserStatusManager.getUserInfoObject(CurrentUserManager.getCurrentUserID())) != null && (ri = UserStatusManager.getCurrUsersPrevResourceInfo()) != null) {
            String prevStatus = ri.getStatus();
            String prevStatusMsg = ri.getReason();
            System.out.println("Setting something else: " + ri.getStatus() + ri.getReason());
            Communicator commWindow = iIM.getBuddyList().getCommunicator();
            ImageIcon icon = UserStatusManager.getIcon(prevStatus, commWindow);
            commWindow.setCurrentStatus(prevStatus, prevStatusMsg, icon, true);
        }
        if (pListName.equals(UserAccessControl.localizedInvisibleToAll) && !UserAccessControl.isActivePrivacyList(pListName)) {
            Communicator commWindow = iIM.getBuddyList().getCommunicator();
            ImageIcon icon = UserStatusManager.getIcon("CLOSED", commWindow);
            UserInfo ui2 = UserStatusManager.getUserInfoObject(CurrentUserManager.getCurrentUserID());
            UserInfo.ResourceInfo ri2 = ui2.getResourceInfo(CurrentUserManager.getCurrUsrUIDWithResource());
            if (ri2 != null) {
                UserStatusManager.setCurrUsersPrevResourceInfo(ri2);
            }
            commWindow.setCurrentStatus("Invisible", Communicator.getCommBundle().getString("mi_status_invisibleMenuItem"), icon, true);
        }
        UserAccessControl.setActivePrivacyList(pListName);
    }

    private void applyUIRestrictions() throws CollaborationException {
        if (!this.validateIndex(false)) {
            return;
        }
        String pListName = (String)this.privacyList.getSelectedValue();
        if (UserAccessControl.isDummyPrivacyProfile(pListName)) {
            this.btnEdit.setEnabled(false);
            this.btnDelete.setEnabled(false);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnDelete.setEnabled(true);
        }
        if (UserAccessControl.isActivePrivacyList(pListName)) {
            this.btnActivate.setEnabled(false);
        } else {
            this.btnActivate.setEnabled(true);
        }
        if (UserAccessControl.isDefaultPrivacyList(pListName)) {
            this.btnDefault.setEnabled(false);
        } else {
            this.btnDefault.setEnabled(true);
        }
    }

    private boolean validateIndex(boolean showDialog) {
        int selIndex = this.privacyList.getSelectedIndex();
        if (selIndex < 0 || selIndex >= this.privacyList.getModel().getSize()) {
            if (showDialog) {
                String msg = privacySettingBundle.getString("select_value");
                JOptionPane.showMessageDialog(this, msg);
            }
            return false;
        }
        return true;
    }

    private JSeparator makeSeparator() {
        JSeparator separator = new JSeparator();
        separator.setMinimumSize(new Dimension(0, 2));
        return separator;
    }

    static {
        try {
            if (UserAccessControl.getPrivacyList(UserAccessControl.localizedInvisibleToAll) == null) {
                UserAccessControl.setPrivacyList(UserAccessControl.localizedInvisibleToAll, null);
            }
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
    }

    class RenamePrivListRunnable
    implements Runnable {
        String oldName;
        String newName;

        public RenamePrivListRunnable(String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
        }

        public void run() {
            try {
                UserAccessControl.renamePrivacyList(this.oldName, this.newName);
            }
            catch (CollaborationException ce) {
                ce.printStackTrace();
                return;
            }
            SwingUtilities.invokeLater(new UpdateUIRunnable());
        }

        class UpdateUIRunnable
        implements Runnable {
            UpdateUIRunnable() {
            }

            public void run() {
                PrivacySettingsPanel.this.plistNames.remove(RenamePrivListRunnable.this.oldName);
                PrivacySettingsPanel.this.plistNames.add(RenamePrivListRunnable.this.newName);
                PrivacySettingsPanel.this.model.changed();
            }
        }
    }
}

