/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.config.PrivacySettingsPanel;
import com.iplanet.im.client.swing.dialogs.InviteUsers;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PrivacyItem;
import com.sun.im.service.PrivacyList;
import com.sun.im.service.util.PlatformUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class PrivacyEditorDialog
extends JDialog
implements ActionListener {
    static SafeResourceBundle bundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");
    private JTextField txtEnter = new JTextField();
    private JRadioButton rdbShowAllUsers = new JRadioButton();
    private JRadioButton rdbShowOnlyUsersInMyContactList = new JRadioButton();
    private JRadioButton rdbShowUsersInMyContactFolder = new JRadioButton();
    private JRadioButton rdbShowOnlyTheseUsers = new JRadioButton();
    private JButton btnShowAdd = new JButton();
    private JButton btnShowRemove = new JButton();
    private JComboBox cmbShowOnlyUsersInFolder = new JComboBox();
    private JList listShowOnlyTheseUsers = new JList();
    private JRadioButton rdbBlkNobody = new JRadioButton();
    private JRadioButton rdbBlkAnyOneNotInMyContactList = new JRadioButton();
    private JRadioButton rdbBlkAllUsersExceptUsersInFolder = new JRadioButton();
    private JRadioButton rdbBlkOnlyTheseUsers = new JRadioButton();
    private JComboBox cmbBlkAllUsersExceptInFolder = new JComboBox();
    private JList listBlkOnlyTheseUsers = new JList();
    private JButton btnBlkAdd = new JButton();
    private JButton btnBlkRemove = new JButton();
    private Frame _parentFrame;
    public static boolean _removeProfile = false;
    private PrivacyList _plist;
    private PrivacySettingsPanel _privacySettingsPanel;
    private boolean _changesApplied = false;
    private boolean _newProfile = false;
    private String _privacyProfileName;
    private Vector plistNames;
    private Vector _showPresToUsers = new Vector();
    private Vector _blockMsgToUsers = new Vector();
    private iIMListModel _showPresToUsersModel = new iIMListModel(this.listShowOnlyTheseUsers, this._showPresToUsers);
    private iIMListModel _blockMsgToUsersModel = new iIMListModel(this.listBlkOnlyTheseUsers, this._blockMsgToUsers);

    public PrivacyEditorDialog(Frame p, PrivacySettingsPanel privSettings, String plistName, PrivacyList list) {
        super(p);
        this._parentFrame = p;
        this._privacySettingsPanel = privSettings;
        this._plist = list == null ? UserAccessControl.createNewPrivacyList(plistName) : list;
        this._privacyProfileName = plistName;
        if (plistName == null) {
            this._newProfile = true;
        } else {
            this.txtEnter.setText(plistName);
        }
        try {
            this.InitComponents();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrivacyEditorDialog(Frame frame, PrivacySettingsPanel privSettings, String title, boolean modal, String plistName, PrivacyList list, Vector pListNames) {
        super(frame, title, modal);
        this._parentFrame = frame;
        this._privacySettingsPanel = privSettings;
        this._plist = list == null ? UserAccessControl.createNewPrivacyList(plistName) : list;
        this._privacyProfileName = plistName;
        if (plistName == null) {
            this._newProfile = true;
        } else {
            this.txtEnter.setText(plistName);
        }
        this.plistNames = pListNames;
        try {
            this.InitComponents();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrivacyEditorDialog(PrivacyList list) {
        this(null, null, "", false, null, list, null);
    }

    void InitComponents() throws Exception {
        DialogButtonsPanel pnlButtons = new DialogButtonsPanel(this);
        JPanel northPanel = new JPanel();
        FlowLayout northFlowLayout = new FlowLayout(0);
        JPanel centerGridPanel = new JPanel();
        JPanel showPanel = new JPanel();
        JPanel blockPanel = new JPanel();
        JLabel lblName = new JLabel();
        JLabel lblShowTitle = new JLabel();
        JLabel lblBlkTitle = new JLabel();
        JScrollPane usersScrollpane = new JScrollPane();
        ButtonGroup blkButtonGroup = new ButtonGroup();
        ButtonGroup showButtonGroup = new ButtonGroup();
        JScrollPane scrlpaneBlkFolder = new JScrollPane();
        GridBagLayout mainGridBagLayout = new GridBagLayout();
        GridBagLayout centerGridBagLayout = new GridBagLayout();
        GridBagLayout blkGridBagLayout = new GridBagLayout();
        GridBagLayout showGridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(mainGridBagLayout);
        centerGridPanel.setLayout(centerGridBagLayout);
        blockPanel.setLayout(blkGridBagLayout);
        showPanel.setLayout(showGridBagLayout);
        lblName = SwingUtils.makeLabelItem(bundle, "Privacy_Profile_Name", "Privacy_Profile_Name_M", this.txtEnter);
        lblShowTitle.setText(bundle.getString("Privacy_Show_Status"));
        lblBlkTitle.setText(bundle.getString("Privacy_Block_Text"));
        this.txtEnter.setPreferredSize(new Dimension(150, 23));
        SwingUtils.setupButton(this.rdbShowAllUsers, bundle, "Privacy_UsersAll", "Privacy_UsersAll_M", null, null);
        SwingUtils.setupButton(this.rdbShowOnlyUsersInMyContactList, bundle, "Privacy_UsersContact", "Privacy_UsersContact_M", null, null);
        SwingUtils.setupButton(this.rdbShowUsersInMyContactFolder, bundle, "Privacy_UsersContactFolder", "Privacy_UsersContactFolder_M", null, null);
        SwingUtils.setupButton(this.rdbShowOnlyTheseUsers, bundle, "Privacy_UsersOnlythese", "Privacy_UsersOnlythese_M", null, null);
        SwingUtils.setupButton(this.btnShowAdd, bundle, "Privacy_btnAdd", "Privacy_btnAdd_M", null, null);
        SwingUtils.setupButton(this.btnShowRemove, bundle, "Privacy_btnRemomeusers", "Privacy_btnRemoveusers_M", null, null);
        SwingUtils.setupButton(this.rdbBlkNobody, bundle, "Privacy_Edit_rdbBlockanyone", "Privacy_Edit_rdbBlockanyone_M", null, null);
        SwingUtils.setupButton(this.rdbBlkAnyOneNotInMyContactList, bundle, "Privacy_Edit_rdbBlockmessages", "Privacy_Edit_rdbBlockmessages_M", null, null);
        SwingUtils.setupButton(this.rdbBlkAllUsersExceptUsersInFolder, bundle, "Privacy_Edit_rdbBlockAll", "Privacy_Edit_rdbBlockAll_M", null, null);
        SwingUtils.setupButton(this.rdbBlkOnlyTheseUsers, bundle, "Privacy_Edit_rdbBlock", "Privacy_Edit_rdbBlock_M", null, null);
        SwingUtils.setupButton(this.btnBlkAdd, bundle, "Privacy_btnAdd", "Privacy_btnBlockAdd_M", null, null);
        SwingUtils.setupButton(this.btnBlkRemove, bundle, "Privacy_btnRemomeusers", "Privacy_btnBlockRemoveusers_M", null, null);
        this.rdbShowOnlyTheseUsers.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    PrivacyEditorDialog.this.btnShowAdd.setEnabled(true);
                    PrivacyEditorDialog.this.btnShowRemove.setEnabled(true);
                } else {
                    PrivacyEditorDialog.this.btnShowAdd.setEnabled(false);
                    PrivacyEditorDialog.this.btnShowRemove.setEnabled(false);
                }
            }
        });
        this.rdbBlkOnlyTheseUsers.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    PrivacyEditorDialog.this.btnBlkAdd.setEnabled(true);
                    PrivacyEditorDialog.this.btnBlkRemove.setEnabled(true);
                } else {
                    PrivacyEditorDialog.this.btnBlkAdd.setEnabled(false);
                    PrivacyEditorDialog.this.btnBlkRemove.setEnabled(false);
                }
            }
        });
        showButtonGroup.add(this.rdbShowAllUsers);
        showButtonGroup.add(this.rdbShowOnlyUsersInMyContactList);
        showButtonGroup.add(this.rdbShowUsersInMyContactFolder);
        showButtonGroup.add(this.rdbShowOnlyTheseUsers);
        blkButtonGroup.add(this.rdbBlkNobody);
        blkButtonGroup.add(this.rdbBlkAllUsersExceptUsersInFolder);
        blkButtonGroup.add(this.rdbBlkOnlyTheseUsers);
        blkButtonGroup.add(this.rdbBlkAnyOneNotInMyContactList);
        this.btnShowAdd.setEnabled(false);
        this.btnRegisterListener();
        this.getContentPane().add((Component)northPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 8, 0, 0), 320, 0));
        northPanel.setLayout(northFlowLayout);
        northPanel.add(lblName);
        northPanel.add(this.txtEnter);
        this.getContentPane().add((Component)centerGridPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 49, -5));
        showPanel.add((Component)this.rdbShowOnlyUsersInMyContactList, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 13, -5));
        showPanel.add((Component)this.rdbShowUsersInMyContactFolder, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 1, -5));
        showPanel.add((Component)this.rdbShowOnlyTheseUsers, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 1, -5));
        showPanel.add((Component)this.rdbShowAllUsers, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 36), 13, -5));
        showPanel.add((Component)this.cmbShowOnlyUsersInFolder, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 78, -1));
        showPanel.add((Component)usersScrollpane, new GridBagConstraints(1, 4, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        showPanel.add((Component)this.btnShowRemove, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 12, 2, new Insets(5, 5, 0, 12), 0, -5));
        showPanel.add((Component)this.btnShowAdd, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 12), 27, -5));
        showPanel.add((Component)lblShowTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 6, 5, 0), 0, 0));
        blockPanel.add((Component)scrlpaneBlkFolder, new GridBagConstraints(1, 4, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        blockPanel.add((Component)this.btnBlkAdd, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 12), 27, -5));
        blockPanel.add((Component)this.btnBlkRemove, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 12, 2, new Insets(5, 5, 0, 12), 0, -5));
        blockPanel.add((Component)this.cmbBlkAllUsersExceptInFolder, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 50, 2, 0), 112, -1));
        blockPanel.add((Component)lblBlkTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 6, 5, 0), 0, 0));
        blockPanel.add((Component)this.rdbBlkAnyOneNotInMyContactList, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 6), 62, -5));
        blockPanel.add((Component)this.rdbBlkNobody, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 6), 23, -5));
        blockPanel.add((Component)this.rdbBlkAllUsersExceptUsersInFolder, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 1, -5));
        blockPanel.add((Component)this.rdbBlkOnlyTheseUsers, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 1, -5));
        centerGridPanel.add((Component)this.makeSeparator(), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 11, 2, new Insets(0, 14, 2, 12), 0, 0));
        centerGridPanel.add((Component)showPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
        centerGridPanel.add((Component)this.makeSeparator(), new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 11, 2, new Insets(5, 14, 0, 12), 0, 0));
        centerGridPanel.add((Component)blockPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 0), 0, 0));
        centerGridPanel.add((Component)this.makeSeparator(), new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 11, 2, new Insets(10, 14, 2, 12), 0, 0));
        usersScrollpane.getViewport().add(this.listShowOnlyTheseUsers);
        scrlpaneBlkFolder.getViewport().add(this.listBlkOnlyTheseUsers);
        this.getContentPane().add((Component)pnlButtons, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 13, 2, new Insets(17, 12, 12, 12), 0, 0));
        pnlButtons.setDefaultButton(4);
        this.cmbShowOnlyUsersInFolder.setEnabled(false);
        this.cmbBlkAllUsersExceptInFolder.setEnabled(false);
        if (PlatformUtil.isUnix()) {
            this.setSize(530, 480);
            this.centerWindow();
        } else if (PlatformUtil.isMac()) {
            this.setSize(580, 480);
            this.centerWindow();
        } else {
            this.setSize(480, 430);
            this.centerWindow();
        }
        this.listBlkOnlyTheseUsers.setModel(this._blockMsgToUsersModel);
        this.listShowOnlyTheseUsers.setModel(this._showPresToUsersModel);
        iIMListRenderer blockMsgToUsersRenderer = new iIMListRenderer(this._blockMsgToUsersModel);
        iIMListRenderer showPresToUsersRenderer = new iIMListRenderer(this._showPresToUsersModel);
        this.listShowOnlyTheseUsers.setCellRenderer(showPresToUsersRenderer);
        this.listBlkOnlyTheseUsers.setCellRenderer(blockMsgToUsersRenderer);
        this.refreshContactFolders(this.cmbBlkAllUsersExceptInFolder);
        this.refreshContactFolders(this.cmbShowOnlyUsersInFolder);
        this.classifyPrivacyList(this._plist);
        Manager.Out("After setting it to visible");
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "ok") {
            this.apply();
        } else if (actionCommand == "cancel") {
            this.close();
        } else if (actionCommand == "help") {
            this.help();
        }
        if (object == this.btnShowAdd) {
            this.addUsers();
        }
        if (object == this.btnShowRemove) {
            this.removeUsers();
        }
        if (object == this.btnBlkAdd) {
            this.addBlockUsers();
        }
        if (object == this.btnBlkRemove) {
            this.removeBlockUsers();
        }
        if (object == this.rdbBlkAllUsersExceptUsersInFolder) {
            this.cmbBlkAllUsersExceptInFolder.setEnabled(true);
            this.refreshContactFolders(this.cmbBlkAllUsersExceptInFolder);
            Manager.Out("rdbBlockAll");
        }
        if (object == this.rdbBlkAnyOneNotInMyContactList) {
            this.cmbBlkAllUsersExceptInFolder.setEnabled(false);
        }
        if (object == this.rdbBlkNobody) {
            this.cmbBlkAllUsersExceptInFolder.setEnabled(false);
        }
        if (object == this.rdbBlkOnlyTheseUsers) {
            this.cmbBlkAllUsersExceptInFolder.setEnabled(false);
            this.btnBlkAdd.setEnabled(true);
            Manager.Out("rdbBlockOnlyUsers");
        }
        if (object == this.rdbShowOnlyTheseUsers) {
            this.cmbShowOnlyUsersInFolder.setEnabled(false);
            this.btnShowAdd.setEnabled(true);
            Manager.Out("rdbOnlyUsers");
        }
        if (object == this.rdbShowAllUsers) {
            this.cmbShowOnlyUsersInFolder.setEnabled(false);
            Manager.Out("rdbOnlyUsers");
        }
        if (object == this.rdbShowOnlyUsersInMyContactList) {
            this.cmbShowOnlyUsersInFolder.setEnabled(false);
            Manager.Out("rdbOnlyUsers");
        }
        if (object == this.rdbShowUsersInMyContactFolder) {
            this.cmbShowOnlyUsersInFolder.setEnabled(true);
            this.refreshContactFolders(this.cmbShowOnlyUsersInFolder);
            Manager.Out("rdbUsersInContactF");
        }
    }

    public boolean changesApplied() {
        return this._changesApplied;
    }

    public String getPrivacyProfileName() {
        return this._privacyProfileName;
    }

    public PrivacyList getPrivacyList() {
        return this._plist;
    }

    private void apply() {
        try {
            String[] users;
            String[] folders;
            boolean listNameChanged;
            String name = this.txtEnter.getText().trim().toString();
            if (name == null || name.equals("")) {
                JOptionPane.showMessageDialog(this, bundle.getString("Name_Privacy_Profile"));
                return;
            }
            boolean listExists = this._privacySettingsPanel.privacyListExists(name);
            boolean bl = listNameChanged = this._privacyProfileName != null && !this._privacyProfileName.equals(name);
            if (this._newProfile && listExists || listNameChanged && listExists) {
                JOptionPane.showMessageDialog(this, bundle.getString("Privacy_Exists"));
                this._changesApplied = false;
                return;
            }
            this._privacyProfileName = name;
            this._plist.reset();
            if (this.rdbShowAllUsers.isSelected()) {
                Manager.Out("showPresenceToAllUsers invoked");
                UserAccessControl.showPresenceToAllUsers(this._plist);
            }
            if (this.rdbShowUsersInMyContactFolder.isSelected()) {
                folders = new String[]{(String)this.cmbShowOnlyUsersInFolder.getSelectedItem()};
                Manager.Out("showPresenceUsersInContactFolder invoked");
                UserAccessControl.showPresenceToUsersInContactFolders(folders, this._plist);
            }
            if (this.rdbShowOnlyUsersInMyContactList.isSelected()) {
                Manager.Out("showPresenceToAllUsersInContactList invoked");
                UserAccessControl.showPresenceToUsersInContactList(this._plist);
            }
            if (this.rdbShowOnlyTheseUsers.isSelected()) {
                users = UserCache.getUIDsFromUsers(this._showPresToUsers);
                Manager.Out("showPresenceToOnlyUsers invoked");
                UserAccessControl.showPresenceToUsers(users, this._plist);
            }
            if (this.rdbBlkNobody.isSelected()) {
                Manager.Out("blockMessagesFromNonBuddy invoked");
                UserAccessControl.blockMessagesFromNonBuddy(this._plist);
            }
            if (this.rdbBlkAllUsersExceptUsersInFolder.isSelected()) {
                folders = new String[]{(String)this.cmbBlkAllUsersExceptInFolder.getSelectedItem()};
                Manager.Out("blockMessagesExceptContactFolders invoked");
                UserAccessControl.blockMessagesExceptContactFolders(folders, this._plist);
            }
            if (this.rdbBlkOnlyTheseUsers.isSelected()) {
                users = UserCache.getUIDsFromUsers(this._blockMsgToUsers);
                Manager.Out("blockMessagesFromUsers invoked");
                UserAccessControl.blockMessageFromUsers(users, this._plist);
            }
            if (this.rdbBlkAnyOneNotInMyContactList.isSelected()) {
                UserAccessControl.allowMessageFromEveryOne(this._plist);
            }
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
        this._changesApplied = true;
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void help() {
        HelpManager.showHelp("privacynewedit");
    }

    private void addUsers() {
        this.popupUserSearchDialog(this._showPresToUsers, this._showPresToUsersModel, bundle.getString("allow_users"));
    }

    private void removeUsers() {
        int index = this.listShowOnlyTheseUsers.getSelectedIndex();
        if (index >= 0) {
            this._showPresToUsers.remove(index);
            this._showPresToUsersModel.changed();
            this.listShowOnlyTheseUsers.clearSelection();
        }
    }

    private void addBlockUsers() {
        this.popupUserSearchDialog(this._blockMsgToUsers, this._blockMsgToUsersModel, bundle.getString("block_users"));
    }

    private void removeBlockUsers() {
        int index = this.listBlkOnlyTheseUsers.getSelectedIndex();
        if (index >= 0) {
            this._blockMsgToUsers.remove(index);
            this._blockMsgToUsersModel.changed();
            this.listBlkOnlyTheseUsers.clearSelection();
        }
    }

    private void btnRegisterListener() {
        this.btnShowAdd.addActionListener(this);
        this.btnShowRemove.addActionListener(this);
        this.btnBlkAdd.addActionListener(this);
        this.btnBlkRemove.addActionListener(this);
        this.rdbShowUsersInMyContactFolder.addActionListener(this);
        this.rdbShowOnlyTheseUsers.addActionListener(this);
        this.rdbBlkAllUsersExceptUsersInFolder.addActionListener(this);
        this.rdbBlkOnlyTheseUsers.addActionListener(this);
        this.rdbShowOnlyUsersInMyContactList.addActionListener(this);
        this.rdbShowAllUsers.addActionListener(this);
        this.rdbBlkAnyOneNotInMyContactList.addActionListener(this);
        this.rdbBlkNobody.addActionListener(this);
    }

    private final void popupUserSearchDialog(Vector existingUsers, iIMListModel listModel, String title) {
        Vector allUsers = Manager.getVectorFromArray(BuddyListManager.getAllElements());
        Manager.Out("Printing the all users in contact list");
        Iterator iter = allUsers.iterator();
        while (iter.hasNext()) {
            Manager.Out("AllUsers...... " + iter.next());
        }
        InviteUsers iv = new InviteUsers(this._parentFrame, existingUsers, allUsers, false);
        iv.setTitle(title);
        iv.setModal(true);
        iv.setVisible(true);
        iv.setLocationRelativeTo(this);
        CollaborationPrincipal[] principals = iv.getUserSelectionList();
        existingUsers.clear();
        for (int i = 0; i < principals.length; ++i) {
            Manager.Out("principal " + principals[i].getDisplayName());
            if (existingUsers.contains(principals[i])) continue;
            existingUsers.addElement(principals[i]);
        }
        listModel.changed();
    }

    public void refreshContactFolders(JComboBox comboBox) {
        comboBox.removeAllItems();
        String[] buddyListGroups = BuddyListManager.getBuddyListGroups();
        Manager.Out("AddContact.refresh(): buddyListGroups.length: " + buddyListGroups.length);
        for (int x = 0; x < buddyListGroups.length; ++x) {
            comboBox.addItem(buddyListGroups[x]);
        }
        if (comboBox.getSelectedIndex() == -1 && comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    public void refreshUsers(JComboBox comboBox) {
        comboBox.removeAllItems();
        String[] buddyListUsers = BuddyListManager.getAllElementsIDs();
        Manager.Out("AddContact.refresh(): buddyListGroups.length: " + buddyListUsers.length);
        for (int x = 0; x < buddyListUsers.length; ++x) {
            comboBox.addItem(buddyListUsers[x]);
        }
        if (comboBox.getSelectedIndex() == -1 && comboBox.getItemCount() > 0) {
            comboBox.setSelectedIndex(0);
        }
    }

    private void classifyPrivacyList(PrivacyList plist) throws CollaborationException {
        Manager.Out("classifyPrivacyList getting invoked");
        if (plist == null) {
            return;
        }
        Collection c = plist.getPrivacyItems();
        int messageIndex = 1;
        int presenceIndex = 0;
        Object[] radioButtonsToCheck = new Object[]{this.rdbShowAllUsers, this.rdbBlkAnyOneNotInMyContactList};
        String showStatusToGroup = null;
        String blockMessageToGroup = null;
        boolean concretePrivacyItemsFound = false;
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            PrivacyItem pitem = (PrivacyItem)itr.next();
            String type = pitem.getType();
            if (type != null) {
                if (type.equals("group")) {
                    if (pitem.getResource() == 4) {
                        blockMessageToGroup = pitem.getSubject();
                        if (pitem.getAccess() != 1) continue;
                        concretePrivacyItemsFound = true;
                        radioButtonsToCheck[messageIndex] = this.rdbBlkAllUsersExceptUsersInFolder;
                        continue;
                    }
                    if (pitem.getResource() != 2) continue;
                    showStatusToGroup = pitem.getSubject();
                    if (pitem.getAccess() != 1) continue;
                    concretePrivacyItemsFound = true;
                    radioButtonsToCheck[presenceIndex] = this.rdbShowUsersInMyContactFolder;
                    continue;
                }
                if (type.equals("jid")) {
                    String user = null;
                    CollaborationPrincipal principal = null;
                    if (pitem.getResource() == 4) {
                        user = pitem.getSubject();
                        principal = UserCache.getPrincipal(user);
                        if (pitem.getAccess() != 2) continue;
                        concretePrivacyItemsFound = true;
                        this._blockMsgToUsers.addElement(principal);
                        radioButtonsToCheck[messageIndex] = this.rdbBlkOnlyTheseUsers;
                        continue;
                    }
                    if (pitem.getResource() != 2) continue;
                    user = pitem.getSubject();
                    principal = UserCache.getPrincipal(user);
                    if (pitem.getAccess() != 1) continue;
                    concretePrivacyItemsFound = true;
                    this._showPresToUsers.addElement(principal);
                    radioButtonsToCheck[presenceIndex] = this.rdbShowOnlyTheseUsers;
                    continue;
                }
                if (!type.equals("subscription")) continue;
                if (pitem.getResource() == 4) {
                    if (pitem.getAccess() != 1) continue;
                    concretePrivacyItemsFound = true;
                    radioButtonsToCheck[messageIndex] = this.rdbBlkNobody;
                    continue;
                }
                if (pitem.getResource() != 2 || pitem.getAccess() != 1) continue;
                concretePrivacyItemsFound = true;
                radioButtonsToCheck[presenceIndex] = this.rdbShowOnlyUsersInMyContactList;
                continue;
            }
            if (pitem.getResource() == 2 && pitem.getAccess() == 1 && !concretePrivacyItemsFound) {
                radioButtonsToCheck[presenceIndex] = this.rdbShowAllUsers;
            }
            if (pitem.getResource() != 4 || pitem.getAccess() != 1 || concretePrivacyItemsFound) continue;
            radioButtonsToCheck[messageIndex] = this.rdbBlkAnyOneNotInMyContactList;
        }
        ((JRadioButton)radioButtonsToCheck[presenceIndex]).setSelected(true);
        ((JRadioButton)radioButtonsToCheck[messageIndex]).setSelected(true);
        if (radioButtonsToCheck[presenceIndex] == this.rdbShowOnlyTheseUsers) {
            this.btnShowAdd.setEnabled(true);
            this.btnShowRemove.setEnabled(true);
        } else {
            this.btnShowAdd.setEnabled(false);
            this.btnShowRemove.setEnabled(false);
        }
        if (radioButtonsToCheck[messageIndex] == this.rdbBlkOnlyTheseUsers) {
            this.btnBlkAdd.setEnabled(true);
            this.btnBlkRemove.setEnabled(true);
        } else {
            this.btnBlkAdd.setEnabled(false);
            this.btnBlkRemove.setEnabled(false);
        }
        if (showStatusToGroup != null) {
            Manager.Out("showStatusToGroup " + showStatusToGroup);
            this.cmbShowOnlyUsersInFolder.setEnabled(true);
            this.cmbShowOnlyUsersInFolder.setSelectedItem(showStatusToGroup);
        }
        if (blockMessageToGroup != null) {
            Manager.Out("blockMessageToGroup " + blockMessageToGroup);
            this.cmbBlkAllUsersExceptInFolder.setEnabled(true);
            this.cmbBlkAllUsersExceptInFolder.setSelectedItem(blockMessageToGroup);
        }
        this._blockMsgToUsersModel.changed();
        this._showPresToUsersModel.changed();
        Manager.Out("classifyPrivacyList method exiting");
    }

    private void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private JSeparator makeSeparator() {
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(0, 2));
        separator.setMinimumSize(new Dimension(0, 2));
        separator.setEnabled(false);
        return separator;
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrivacyEditorDialog.this.close();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }
}

