/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.manager.TopicManager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.communicator.RoomListPanel;
import com.iplanet.im.client.swing.dialogs.AddDestination;
import com.iplanet.im.client.swing.dialogs.InviteUsers;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.swing.models.iIMTable;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.DialogButtonsPanel;
import com.iplanet.im.client.util.JComponentCellEditor;
import com.iplanet.im.client.util.JComponentCellRenderer;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.util.StringUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class DestinationAdmin
extends AutoOrientationJFrame
implements ActionListener,
ItemListener,
ListSelectionListener,
TableModelListener {
    static SafeResourceBundle destinationAdminBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");
    static SafeResourceBundle dialogsBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
    static SafeResourceBundle swingBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    static String searchResultUserFormat = null;
    static String searchResultGroupFormat = null;
    private Point _frameLocation;
    private iIMTable tblUsers;
    private Vector memberList = new Vector(10);
    private Vector memberListCheck = new Vector(10);
    private Vector destList = new Vector(10);
    private Vector memberBox = new Vector(10);
    private iIMListModel aclModel;
    private static int _openedManageConf;
    private static int _openedManageNewsConf;
    private iIMListRenderer aclRenderer;
    private NLACLTableModel userTableModel;
    private Conference currentConference = null;
    private Map currentAccessList = null;
    private String[] _servers;
    private int _type = -1;
    private int LAST_INDEX = -1;
    private final String[] defaults = new String[]{destinationAdminBundle.getString("NONE"), destinationAdminBundle.getString("READ"), destinationAdminBundle.getString("WRITE")};
    private final String[] userAccess = new String[]{destinationAdminBundle.getString("NONE"), destinationAdminBundle.getString("READ"), destinationAdminBundle.getString("WRITE"), destinationAdminBundle.getString("MANAGE")};
    private static final int MANAGE = 3;
    private static final int WRITE = 2;
    private static final int READ = 1;
    private static final int NONE = 0;
    private SymWindow aSymWindow = new SymWindow();
    public static final String ID_DELETE_ME;
    public static final String ID_DELETE_GROUP;
    public static boolean TOPIC_ADMIN_OPEN;
    public static boolean ROOM_ADMIN_OPEN;
    private JFrame _parent;
    private JPanel pnlServer = new JPanel();
    private JLabel lblServer = new JLabel();
    private JPanel pnlLists = new JPanel();
    private JPanel pnlCreateConf = new JPanel();
    private JPanel pnlAcl = new JPanel();
    private JPanel pnlNewDelete = new JPanel();
    private JLabel lblAccessList;
    private JScrollPane spnlAccessList = new JScrollPane();
    private JList lstDestinations = new JList();
    private JPanel pnlMembers = new JPanel();
    private JLabel lblMembers;
    private JScrollPane spnlMembers = new JScrollPane();
    private JPanel pnlRoomAdmin = new JPanel();
    private JPanel pnlRoomAccessList = new JPanel();
    private JPanel pnlRoomOptions = new JPanel();
    private JLabel lblDefaultAccess;
    private JLabel lblCreateRoom;
    private JComboBox cmbDefaultAccess = new JComboBox();
    private JPanel pnlBottom = new JPanel();
    private JButton btnDelRoom = new JButton();
    private JButton btnCreate = new JButton();
    private JButton btnAdd = new JButton();
    private JButton btnRemove = new JButton();
    private DialogButtonsPanel pnlButtons;

    public DestinationAdmin(JFrame parent, String[] servers, int type) {
        this._parent = parent;
        this._servers = servers;
        this._frameLocation = parent.getLocation();
        this._type = type;
        ApplicationManager.addActiveObject(this);
        if (this._type == 0 ? TOPIC_ADMIN_OPEN : ROOM_ADMIN_OPEN) {
            return;
        }
        this.cmbDefaultAccess.setLightWeightPopupEnabled(false);
        this.createTable();
        this.setDefaultCloseOperation(0);
        this.initComponents();
        this.initTitles();
        iIM.refreshTopics();
        this.createModels();
        ++_openedManageConf;
        ++_openedManageNewsConf;
        this.setDestinationListSelectedIndex(0);
        this.pnlButtons.setApplyButtonEnabled(false);
    }

    public DestinationAdmin(JFrame p, String[] servs, int t, Conference selectedRoom) {
        this(p, servs, t);
        this.lstDestinations.setSelectedValue(selectedRoom, true);
    }

    private JSeparator makeSeparator() {
        JSeparator separator = new JSeparator();
        separator.setPreferredSize(new Dimension(0, 2));
        separator.setMinimumSize(new Dimension(0, 2));
        return separator;
    }

    private void initComponents() {
        int REL = -1;
        boolean REM = false;
        int HORIZONTAL = 2;
        boolean BOTH = true;
        boolean NONE = false;
        this.pnlButtons = new DialogButtonsPanel(this, 15);
        this.setSize(new Dimension(435, 425));
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.pnlCreateConf.setLayout(new GridBagLayout());
        this.pnlAcl.setLayout(new BorderLayout());
        this.pnlLists.setLayout(new GridBagLayout());
        this.lblAccessList = SwingUtils.makeLabelItem(destinationAdminBundle, "DestinationAdmin_access_list", "DestinationAdmin_access_list_M", this.lstDestinations);
        this.pnlAcl.add((Component)this.lblAccessList, "North");
        this.spnlAccessList.setViewportView(this.lstDestinations);
        this.pnlAcl.add((Component)this.spnlAccessList, "Center");
        String btnLabelKey = "DestinationAdmin_createRoom";
        String btnLabel_MKey = "DestinationAdmin_createRoom_M";
        String labelKey = "DestinationAdmin_lblCreateRoom";
        String label_MKey = "DestinationAdmin_lblCreateRoom_M";
        if (this._type == 0) {
            btnLabelKey = "DestinationAdmin_createChannel";
            btnLabel_MKey = "DestinationAdmin_createChannel_M";
            labelKey = "DestinationAdmin_lblCreateChannel";
            label_MKey = "DestinationAdmin_lblCreateChannel_M";
        }
        if (SwingUtils.gotBug4919244(destinationAdminBundle, label_MKey, btnLabel_MKey)) {
            label_MKey = null;
        }
        SwingUtils.setupButton(this.btnCreate, destinationAdminBundle, btnLabelKey, btnLabel_MKey, null, null);
        boolean hasPermission = false;
        if (this._type == 2 && UserAccessControl.canCreateRoom()) {
            hasPermission = true;
        }
        if (this._type == 0 && UserAccessControl.canCreateTopic()) {
            hasPermission = true;
        }
        if (UserAccessControl.isAdmin()) {
            hasPermission = true;
        }
        this.btnCreate.setEnabled(hasPermission);
        this.lblCreateRoom = SwingUtils.makeLabelItem(destinationAdminBundle, labelKey, label_MKey, this.btnCreate);
        this.pnlNewDelete.setLayout(new FlowLayout(0));
        this.pnlCreateConf.add((Component)this.pnlAcl, new GridBagConstraints(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.pnlLists.add((Component)this.pnlCreateConf, new GridBagConstraints(-1, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        btnLabelKey = "DestinationAdmin_deleteRoom";
        btnLabel_MKey = "DestinationAdmin_deleteRoom_M";
        if (this._type == 0) {
            btnLabelKey = "DestinationAdmin_deleteChannel";
            btnLabel_MKey = "DestinationAdmin_deleteChannel_M";
        }
        this.pnlCreateConf.add((Component)this.pnlNewDelete, new GridBagConstraints(-1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 5, 2, 2), 0, 0));
        this.btnDelRoom.setEnabled(false);
        this.btnAdd.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.cmbDefaultAccess.setEnabled(false);
        SwingUtils.setupButton(this.btnDelRoom, destinationAdminBundle, btnLabelKey, btnLabel_MKey, null, null);
        this.pnlNewDelete.add(this.btnCreate);
        this.pnlNewDelete.add(this.btnDelRoom);
        this.pnlMembers.setLayout(new BorderLayout());
        this.lblMembers = SwingUtils.makeLabelItem(destinationAdminBundle, "DestinationAdmin_members", "DestinationAdmin_members_M", this.tblUsers);
        this.pnlMembers.add((Component)this.lblMembers, "North");
        this.spnlMembers.setViewportView(this.tblUsers);
        this.pnlMembers.add((Component)this.spnlMembers, "Center");
        this.pnlLists.add((Component)this.pnlMembers, new GridBagConstraints(0, -1, 0, 1, 1.0, 0.75, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.pnlLists, "Center");
        this.pnlRoomAdmin.setLayout(new GridBagLayout());
        this.pnlRoomAccessList.setLayout(new FlowLayout(3));
        this.lblDefaultAccess = SwingUtils.makeLabelItem(destinationAdminBundle, "DestinationAdmin_default_access", "DestinationAdmin_default_access_M", this.cmbDefaultAccess);
        this.pnlRoomAccessList.add(this.lblDefaultAccess);
        for (int i = 0; i < this.defaults.length; ++i) {
            this.cmbDefaultAccess.addItem(this.defaults[i]);
        }
        this.pnlRoomAccessList.add(this.cmbDefaultAccess);
        SwingUtils.setupButton(this.btnAdd, destinationAdminBundle, "DestinationAdmin_add", "DestinationAdmin_add_M", null, null);
        this.pnlRoomAccessList.add(this.btnAdd);
        SwingUtils.setupButton(this.btnRemove, destinationAdminBundle, "DestinationAdmin_remove", "DestinationAdmin_remove_M", null, null);
        this.pnlRoomAccessList.add(this.btnRemove);
        this.pnlRoomAdmin.add((Component)this.pnlRoomAccessList, new GridBagConstraints(-1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRoomOptions.setLayout(new FlowLayout(3));
        this.pnlRoomAdmin.add((Component)this.pnlRoomOptions, new GridBagConstraints(-1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.setLayout(new GridBagLayout());
        this.pnlBottom.add((Component)this.pnlRoomAdmin, new GridBagConstraints(-1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
        this.pnlBottom.add((Component)this.pnlButtons, new GridBagConstraints(-1, 1, 0, 1, 1.0, 0.0, 13, 2, new Insets(17, 12, 12, 12), 0, 0));
        this.getContentPane().add((Component)this.pnlBottom, "South");
        this.pnlButtons.setDefaultButton(4);
        this.addWindowListener(this.aSymWindow);
        this.lstDestinations.addListSelectionListener(this);
        this.btnDelRoom.addActionListener(this);
        this.btnCreate.addActionListener(this);
        this.btnAdd.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.cmbDefaultAccess.addItemListener(this);
    }

    private final void initTitles() {
        if (this._type == 2) {
            this.lblAccessList.setText(destinationAdminBundle.getString("DestinationAdmin_select_a_conference_room"));
            this.setTitle(destinationAdminBundle.getString("DestinationAdmin_title"));
        } else if (this._type == 0) {
            this.lblAccessList.setText(destinationAdminBundle.getString("DestinationAdmin_select_a_news_channel"));
            this.setTitle(destinationAdminBundle.getString("DestinationAdmin_title_1"));
        }
    }

    private final void createModels() {
        this.aclModel = new iIMListModel(this.lstDestinations, this.destList);
        this.aclRenderer = new iIMListRenderer(this.aclModel);
        this.lstDestinations.setCellRenderer(this.aclRenderer);
        this.lstDestinations.setModel(this.aclModel);
        this.fillDestinationList();
    }

    private final void createTable() {
        this.tblUsers = new iIMTable();
        this.userTableModel = new NLACLTableModel();
        this.tblUsers.setModel(this.userTableModel);
        this.tblUsers.setEnabled(this.tblUsers.getRowCount() > 0);
        this.userTableModel.addTableModelListener(this);
        this.tblUsers.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.tblUsers.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        this.spnlMembers.setViewportView(this.tblUsers);
        this.tblUsers.setSelectionBackground(Color.gray);
        this.tblUsers.setSelectionForeground(Color.red);
        this.tblUsers.setCellSelectionEnabled(true);
        this.tblUsers.getTableHeader().setReorderingAllowed(false);
        this.tblUsers.setRowHeight(20);
        iIMUtility.setColumn(this.tblUsers, 0, false, 74, destinationAdminBundle.getString("Type"));
        iIMUtility.setColumn(this.tblUsers, 1, false, 249, destinationAdminBundle.getString("User_Group"));
        iIMUtility.setColumn(this.tblUsers, 2, false, 150, destinationAdminBundle.getString("Access"));
    }

    public void tableChanged(TableModelEvent e) {
        this.tblUsers.setEnabled(this.tblUsers.getRowCount() > 0);
    }

    private final int getIndex(int value) {
        switch (value) {
            case 30: {
                Manager.Out("value = " + value + "return = " + 3);
                return 3;
            }
            case 4: {
                Manager.Out("value = " + value + "return = " + 2);
                return 2;
            }
            case 2: {
                Manager.Out("value = " + value + "return = " + 1);
                return 1;
            }
        }
        Manager.Out("value = " + value + "return = " + 0);
        return 0;
    }

    private final void changeServer() {
        if (!this.checkSelectionChange()) {
            return;
        }
        this.setDestinationListSelectedIndex(0);
        this.initTitles();
        this.cleanUserList();
        this.fillDestinationList();
        this.tblUsers.getSelectionModel().clearSelection();
    }

    private final boolean checkSelectionChange() {
        if (this.pnlButtons.isApplyButtonEnabled() && this.isVisible()) {
            String msg = destinationAdminBundle.getString("Do_you_want_to_save_your_changes_first");
            int x = JOptionPane.showConfirmDialog(this, msg);
            if (x == 0) {
                this.saveAccessControl(this.LAST_INDEX);
            } else if (x == 2) {
                this.lstDestinations.setSelectedIndex(this.LAST_INDEX);
                return false;
            }
        }
        this.LAST_INDEX = this.lstDestinations.getSelectedIndex();
        return true;
    }

    private final void fillMemberList() {
        try {
            if (!this.checkSelectionChange()) {
                return;
            }
            if (this.destList.size() == 0) {
                return;
            }
            int index = this.lstDestinations.getSelectedIndex();
            if (index == -1) {
                return;
            }
            Conference d = (Conference)this.destList.elementAt(index);
            if (d == null) {
                return;
            }
            Manager.Out("Filing member list for " + d.getDestination());
            this.currentConference = d;
            this.currentAccessList = d.listPrivileges();
            this.fillList();
            TableCellEditor e = this.tblUsers.getCellEditor();
            if (e != null) {
                e.stopCellEditing();
            }
            this.tblUsers.clearSelection();
            this.userTableModel.changed();
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private final void fillList() {
        try {
            this.cleanUserList();
            if (this.currentConference == null) {
                return;
            }
            int tmp = this.currentConference.getDefaultPrivilege();
            Manager.Out("default access = " + tmp);
            this.cmbDefaultAccess.removeItemListener(this);
            switch (tmp) {
                case 30: {
                    this.cmbDefaultAccess.setSelectedIndex(3);
                    break;
                }
                case 4: {
                    this.cmbDefaultAccess.setSelectedIndex(2);
                    break;
                }
                case 2: {
                    this.cmbDefaultAccess.setSelectedIndex(1);
                    break;
                }
                default: {
                    this.cmbDefaultAccess.setSelectedIndex(0);
                }
            }
            this.cmbDefaultAccess.addItemListener(this);
            if (this.currentAccessList == null) {
                return;
            }
            Iterator i = this.currentAccessList.keySet().iterator();
            while (i.hasNext()) {
                String uid = (String)i.next();
                if (CurrentUserManager.isCurrentUserID(uid)) continue;
                CollaborationPrincipal principal = UserCache.getPrincipal(uid);
                this.memberList.addElement(principal);
                this.memberListCheck.addElement(uid);
                JComboBox<String> box = new JComboBox<String>(this.userAccess);
                box.setLightWeightPopupEnabled(false);
                this.memberBox.addElement(box);
                box.setSelectedIndex(this.getIndex((Integer)this.currentAccessList.get(uid)));
                box.addItemListener(this);
                Manager.Out("member" + uid + " access = " + this.currentAccessList.get(uid));
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private boolean hasPersmissionToDeleteAll() {
        boolean hasPermission = true;
        if (!UserAccessControl.canCreateRoom()) {
            return false;
        }
        int[] sel = this.lstDestinations.getSelectedIndices();
        for (int i = 0; i < sel.length; ++i) {
            Conference r = (Conference)this.destList.elementAt(sel[i]);
            if (UserAccessControl.hasPrivilege(r, 30) || UserAccessControl.isAdmin()) continue;
            hasPermission = false;
        }
        return hasPermission;
    }

    private void deleteRoom() {
        if (!this.hasPersmissionToDeleteAll()) {
            JOptionPane.showMessageDialog(this, destinationAdminBundle.getString("DestinationAdmin_insufficient_privileges"));
        }
        int[] sel = this.lstDestinations.getSelectedIndices();
        int selIndx = this.lstDestinations.getSelectedIndex();
        if (this._type == 2 && sel != null) {
            int listSize;
            for (int i = 0; i < sel.length; ++i) {
                Conference r = (Conference)this.destList.elementAt(sel[i]);
                Manager.Out("DEBUG: DestinationAdmin: deleteRoom(): " + r.getDestination());
                try {
                    RoomManager.unsubscribe(r);
                }
                catch (CollaborationException ne) {
                    System.out.println("DestinationAdmin / deleteRoom():" + ne.getMessage());
                }
                RoomManager.deleteManagedRoom(r);
            }
            this.cleanUserList();
            this.fillDestinationList();
            RoomListPanel panel = Communicator.getRoomListPanel();
            if (panel != null) {
                panel.refresh();
            }
            if (selIndx >= (listSize = this.lstDestinations.getModel().getSize()) - 1) {
                this.lstDestinations.setSelectedIndex(listSize - 1);
            }
            if (listSize == 0) {
                this.btnDelRoom.setEnabled(false);
                this.btnAdd.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.cmbDefaultAccess.setEnabled(false);
                this.lstDestinations.clearSelection();
            }
        }
    }

    protected final void addNewDestination(int dialogType) {
        Manager.Out("DEBUG: started addNewDestination");
        if (dialogType == 0) {
            if (!UserAccessControl.canCreateTopic()) {
                JOptionPane.showMessageDialog(this, iIM.ID_NO_PRIVILEGE);
                return;
            }
        } else if (dialogType == 2 && !UserAccessControl.canCreateRoom()) {
            JOptionPane.showMessageDialog(this, iIM.ID_NO_PRIVILEGE);
            return;
        }
        Manager.Out("DEBUG: about to do new AddDestination(this, dialogType);");
        AddDestination addDialog = new AddDestination(this, dialogType);
        addDialog.setModal(true);
        addDialog.setVisible(true);
        Manager.Out("DEBUG: did  AddDestination(this, dialogType);");
        if (!addDialog.hasOkBeenPressed()) {
            return;
        }
        if (addDialog.getDestinationName().equals("")) {
            return;
        }
        if (dialogType == 0) {
            String s = Manager.getValidDestinationName(addDialog.getDestinationName());
            if (!iIM.addTopic(s, addDialog.getServer(), addDialog.getAccess())) {
                return;
            }
            iIM.refreshTopics();
        } else if (dialogType == 2) {
            String name = addDialog.getDestinationName();
            if (RoomManager.roomExists(name)) {
                JOptionPane.showMessageDialog(this, swingBundle.getString("BuddyList_Room_already_exists"));
                return;
            }
            iIM.addRoom(Manager.getValidDestinationName(name), addDialog.getServer(), addDialog.getAccess(), addDialog.isShowUserListSelected());
            RoomManager.refreshRooms();
            RoomListPanel panel = Communicator.getRoomListPanel();
            if (panel != null) {
                panel.refresh();
            }
        }
        this.cleanUserList();
        this.fillDestinationList();
        this.lstDestinations.setSelectionInterval(0, 0);
    }

    private void deleteTopic() {
        int[] sel = this.lstDestinations.getSelectedIndices();
        int selIndx = this.lstDestinations.getSelectedIndex();
        if (this._type == 0 && sel != null) {
            for (int i = 0; i < sel.length; ++i) {
                NewsChannel t = (NewsChannel)this.destList.elementAt(sel[i]);
                Manager.Out("DEBUG: DestinationAdmin: deleteTopic(): " + t.getDestination());
                iIM.deleteTopic(t);
            }
        }
        this.cleanUserList();
        this.fillDestinationList();
        iIM.refreshTopics();
        int listSize = this.lstDestinations.getModel().getSize();
        if (selIndx >= listSize - 1) {
            this.lstDestinations.setSelectedIndex(listSize - 1);
        }
        if (listSize == 0) {
            this.btnDelRoom.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.cmbDefaultAccess.setEnabled(false);
            this.lstDestinations.clearSelection();
        }
    }

    private final void saveAccessControl(int x) {
        try {
            Manager.Out("DEBUG: DestinationAdmin.saveAccessControl()");
            this.pnlButtons.setApplyButtonEnabled(false);
            if (this.currentConference == null) {
                return;
            }
            switch (this.cmbDefaultAccess.getSelectedIndex()) {
                case 3: {
                    this.currentConference.setDefaultPrivilege(30);
                    break;
                }
                case 2: {
                    this.currentConference.setDefaultPrivilege(4);
                    break;
                }
                case 1: {
                    this.currentConference.setDefaultPrivilege(2);
                    break;
                }
                default: {
                    this.currentConference.setDefaultPrivilege(1);
                }
            }
            this.currentConference.setPrivileges(this.currentAccessList);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private final void fillDestinationList() {
        Manager.Out("   DEBUG ADMIN: fillDestinationList");
        this.destList.removeAllElements();
        this.aclModel.changed();
        NewsChannel[] d = null;
        if (this._type == 0) {
            d = TopicManager.getManagedTopics();
        } else if (this._type == 2) {
            d = RoomManager.getManagedRooms("*");
        }
        if (d == null) {
            return;
        }
        for (int i = 0; i < d.length; ++i) {
            this.destList.addElement(d[i]);
        }
        StringUtility.sort((Vector)this.destList);
        this.aclModel.changed();
        Manager.Out("   DEBUG ADMIN: finished fillDestinationList() ");
    }

    public final void setDestinationListSelectedIndex(int i) {
        if (this.destList.size() != 0) {
            StringUtility.sort((Vector)this.destList);
            this.lstDestinations.setSelectedIndex(i);
            this.LAST_INDEX = 0;
        } else {
            this.LAST_INDEX = -1;
        }
    }

    private final void cleanBoxes() {
        for (int i = 0; i < this.memberBox.size(); ++i) {
            JComboBox j = (JComboBox)this.memberBox.elementAt(i);
            j.removeItemListener(this);
        }
        this.memberBox.removeAllElements();
    }

    private final void cleanUserList() {
        this.memberList.removeAllElements();
        this.memberListCheck.removeAllElements();
        this.cleanBoxes();
        this.tblUsers.clearSelection();
        this.userTableModel.changed();
    }

    private final int getType(String value) {
        if (value.equals(destinationAdminBundle.getString("MANAGE")) || value.equals(destinationAdminBundle.getString("FULL"))) {
            return 30;
        }
        if (value.equals(destinationAdminBundle.getString("WRITE")) || value.equals(destinationAdminBundle.getString("JOIN")) || value.equals(destinationAdminBundle.getString("VIEW"))) {
            return 4;
        }
        if (value.equals(destinationAdminBundle.getString("READ"))) {
            return 2;
        }
        return 1;
    }

    private final void refreshTable() {
        int start;
        int diff = this.memberList.size() - this.memberBox.size();
        for (int i = start = this.memberBox.size(); i < this.memberList.size(); ++i) {
            JComboBox<String> box = new JComboBox<String>(this.userAccess);
            CollaborationPrincipal np = (CollaborationPrincipal)this.memberList.elementAt(i);
            box.setSelectedIndex(0);
            box.addItemListener(this);
            this.memberBox.addElement(box);
        }
        TableCellEditor e = this.tblUsers.getCellEditor();
        if (e != null) {
            e.stopCellEditing();
        }
        this.tblUsers.clearSelection();
        this.userTableModel.changed();
    }

    private final void fillListHack() {
        this.cleanBoxes();
        for (int n = 0; n < this.memberList.size(); ++n) {
            JComboBox<String> box = new JComboBox<String>(this.userAccess);
            box.setLightWeightPopupEnabled(false);
            box.addItemListener(this);
            this.memberBox.addElement(box);
            box.setSelectedIndex(0);
            String uid = (String)this.memberListCheck.elementAt(n);
            if (this.currentAccessList.containsKey(uid)) {
                int access = (Integer)this.currentAccessList.get(this.memberListCheck.elementAt(n));
                this.setComboType(box, access);
                continue;
            }
            this.currentAccessList.put(uid, new Integer(3));
        }
        TableCellEditor ce = this.tblUsers.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
        this.tblUsers.clearSelection();
        this.userTableModel.changed();
    }

    private final void setComboType(JComboBox cmb, int value) {
        switch (value) {
            case 30: {
                cmb.setSelectedIndex(3);
                break;
            }
            case 4: {
                cmb.setSelectedIndex(2);
                break;
            }
            case 2: {
                cmb.setSelectedIndex(1);
                break;
            }
            case 1: {
                cmb.setSelectedIndex(0);
                break;
            }
            default: {
                cmb.setSelectedIndex(3);
            }
        }
    }

    private final void addUser() {
        Manager.Out("   DEBUG ADMIN: addUser");
        if (this.destList.size() <= 0) {
            return;
        }
        Object[] nu = new CollaborationPrincipal[this.memberList.size()];
        Vector oldMemberList = new Vector(this.memberList);
        this.memberList.copyInto(nu);
        InviteUsers iv = new InviteUsers((Frame)this, this.memberList, this.memberListCheck, true);
        SafeResourceBundle userSearchBundle = new SafeResourceBundle("com.iplanet.im.client.swing.dialogs.dialogs");
        iv.setTitle(userSearchBundle.getString("US_title"));
        iv.setLocationRelativeTo(this);
        iv.setModal(true);
        iv.setVisible(true);
        this.memberList = Manager.getVectorFromArray(iv.getUserSelectionList());
        this.memberListCheck = Manager.getVectorFromArray(UserCache.getUIDsFromUsers(this.memberList));
        if (iv.getClickedButton() == 1) {
            this.pnlButtons.setApplyButtonEnabled(true);
        }
        this.fillListHack();
        this.refreshTable();
    }

    private final boolean shouldDeletePrincipal(CollaborationPrincipal np) {
        boolean result = false;
        if (CurrentUserManager.isCurrentUserID(np.getUID()) || ServerGroupManager.isMember(CurrentUserManager.getCurrentUserID(), np.getUID())) {
            int opt = JOptionPane.showConfirmDialog(this, ID_DELETE_ME);
            if (opt == 0) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private final void removeUser() {
        Manager.Out("   DEBUG ADMIN: removeUser");
        if (this.destList.size() <= 0) {
            return;
        }
        int x = this.tblUsers.getSelectedRow();
        if (x < 0 || x == this.memberList.size()) {
            return;
        }
        CollaborationPrincipal cp = (CollaborationPrincipal)this.memberList.elementAt(x);
        if (this.shouldDeletePrincipal(cp)) {
            this.currentAccessList.remove(cp.getUID());
            this.memberList.removeElement(cp);
            this.memberListCheck.removeElement(cp.getUID());
            this.memberBox.removeElementAt(x);
        }
        this.userTableModel.changed();
        this.pnlButtons.setApplyButtonEnabled(true);
    }

    private final void showHelp() {
        if (this._type == 0) {
            HelpManager.showHelp("room_topicadmin");
        } else {
            HelpManager.showHelp("room_topicadmin");
        }
    }

    public static int getNumInstances(int type) {
        if (type == 0) {
            return _openedManageNewsConf;
        }
        if (type == 2) {
            return _openedManageConf;
        }
        return 0;
    }

    public void setVisible(boolean b) {
        if (b) {
            if (this._type == 0) {
                TOPIC_ADMIN_OPEN = true;
            } else {
                ROOM_ADMIN_OPEN = true;
            }
        }
        super.setVisible(b);
    }

    public void close(boolean validate) {
        if (validate && this.pnlButtons.isApplyButtonEnabled()) {
            String msg = destinationAdminBundle.getString("Do_Yo_Want_To_Save_Your_Changes_Before");
            int x = JOptionPane.showConfirmDialog(this, msg);
            if (x == 0) {
                this.saveAccessControl(this.lstDestinations.getSelectedIndex());
            } else if (x == 2) {
                return;
            }
        }
        if (this._type == 0) {
            TOPIC_ADMIN_OPEN = false;
        } else {
            ROOM_ADMIN_OPEN = false;
        }
        this.aclModel = null;
        this.userTableModel = null;
        this.cleanBoxes();
        this.removeListeners();
        ApplicationManager.removeActiveObject(this);
        this.setVisible(false);
        this.dispose();
        --_openedManageConf;
        --_openedManageNewsConf;
        iIM.GarbageCollect();
    }

    private final void removeListeners() {
        this.lstDestinations.removeListSelectionListener(this);
        this.btnDelRoom.removeActionListener(this);
        this.btnCreate.removeActionListener(this);
        this.btnAdd.removeActionListener(this);
        this.btnRemove.removeActionListener(this);
        this.removeWindowListener(this.aSymWindow);
        this.cmbDefaultAccess.removeItemListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        String actionCommand = event.getActionCommand();
        if (actionCommand == "cancel") {
            this.close(true);
        } else if (object == this.btnDelRoom) {
            if (this._type == 2) {
                this.deleteRoom();
            } else if (this._type == 0) {
                this.deleteTopic();
            }
        } else if (object == this.btnCreate) {
            Manager.Out("DEBUG: calling addNewDestination");
            this.addNewDestination(this._type);
        } else if (object == this.btnAdd) {
            this.addUser();
        } else if (object == this.btnRemove) {
            this.removeUser();
        } else if (actionCommand == "apply") {
            int selectedIndex = this.lstDestinations.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.saveAccessControl(selectedIndex);
            }
        } else if (actionCommand == "ok") {
            int selectedIndex = this.lstDestinations.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.saveAccessControl(selectedIndex);
            }
            this.close(true);
        } else if (actionCommand == "help") {
            this.showHelp();
        }
    }

    boolean hasPermissionOnAllSelectedItems(int permission) {
        boolean ok = true;
        int[] sel = this.lstDestinations.getSelectedIndices();
        if ((this._type == 0 || this._type == 2) && sel != null) {
            for (int i = 0; i < sel.length; ++i) {
                Conference c = (Conference)this.destList.elementAt(sel[i]);
                if (UserAccessControl.hasPrivilege(c, permission)) continue;
                ok = false;
            }
        }
        return ok;
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.lstDestinations && !event.getValueIsAdjusting()) {
            this.pnlButtons.setApplyButtonEnabled(false);
            boolean hasPermission = false;
            if (this.lstDestinations.getSelectedIndex() == -1) {
                hasPermission = false;
            } else if (this._type == 2) {
                hasPermission = UserAccessControl.canCreateRoom();
            } else if (this._type == 0) {
                hasPermission = UserAccessControl.canCreateTopic();
            }
            this.btnDelRoom.setEnabled(hasPermission);
            int[] k = this.lstDestinations.getSelectedIndices();
            if (k != null && k.length > 1) {
                hasPermission = false;
            }
            this.btnAdd.setEnabled(hasPermission);
            this.btnRemove.setEnabled(hasPermission);
            this.cmbDefaultAccess.setEnabled(hasPermission);
            if (this.lstDestinations.getSelectedIndex() != -1 && this.lstDestinations.getMinSelectionIndex() == this.lstDestinations.getMaxSelectionIndex()) {
                this.fillMemberList();
            } else {
                this.cleanUserList();
            }
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object o = event.getSource();
        if (o instanceof JComboBox || o instanceof JCheckBox) {
            if (this.memberBox.contains(o) && this.memberList.size() > 0) {
                JComboBox b = (JComboBox)o;
                int x = this.getType((String)b.getSelectedItem());
                CollaborationPrincipal cp = (CollaborationPrincipal)this.memberList.elementAt(this.memberBox.indexOf(b));
                if (this.currentConference != null) {
                    this.currentAccessList.put(cp.getUID(), new Integer(x));
                }
            }
            this.pnlButtons.setApplyButtonEnabled(true);
        }
    }

    static {
        SafeResourceBundle brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        searchResultUserFormat = brandBundle.getString("messenger.searchresult.format");
        if ((searchResultUserFormat == null || "".equals(searchResultUserFormat)) && ((searchResultUserFormat = dialogsBundle.getString("searchresults_format")) == null || "".equals(searchResultUserFormat))) {
            searchResultUserFormat = "{displayname} <${attr:uid}@{domainname}>";
        }
        if ((searchResultGroupFormat = brandBundle.getString("messenger.searchresult.group.format")) == null || "".equals(searchResultGroupFormat)) {
            searchResultGroupFormat = "{domainname}/${attr:dn}";
        }
        _openedManageConf = 0;
        _openedManageNewsConf = 0;
        ID_DELETE_ME = destinationAdminBundle.getString("Are_you_sure_you_want_to_delete_yourself");
        ID_DELETE_GROUP = destinationAdminBundle.getString("deleteGroup");
        TOPIC_ADMIN_OPEN = false;
        ROOM_ADMIN_OPEN = false;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            DestinationAdmin.this.close(true);
        }
    }

    private class NLACLTableModel
    extends AbstractTableModel {
        private NLACLTableModel() {
        }

        public final int getRowCount() {
            return DestinationAdmin.this.memberList.size();
        }

        public final int getColumnCount() {
            return 3;
        }

        public final boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public final Object getValueAt(int row, int column) {
            CollaborationPrincipal np = (CollaborationPrincipal)DestinationAdmin.this.memberList.elementAt(row);
            if (column == 0) {
                if (np instanceof CollaborationGroup) {
                    return SwingImageManager.getIcon("/com/iplanet/im/client/images/groups15.png", (Object)this);
                }
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/sr_active.gif", (Object)this);
            }
            if (column == 1) {
                return UserCache.formatUserGroupDisplay(np, searchResultUserFormat, searchResultGroupFormat);
            }
            if (column == 2) {
                return DestinationAdmin.this.memberBox.elementAt(row);
            }
            return "";
        }

        public final void changed() {
            this.fireTableDataChanged();
        }
    }
}

