/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.util.PlatformUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CommunicatorSettingsPanel
extends JPanel
implements ChangeListener {
    static SafeResourceBundle communicatorSettingsPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");
    SymItem symItem = new SymItem();
    String alert_msg = null;
    JCheckBox chkAutoLogon;
    JCheckBox chkShowBuddy;
    JCheckBox chkHideWhenMinimized;
    JCheckBox chkShowTrayIcon;
    JCheckBox chkOfflineStatus;
    JCheckBox chkShowUserStatusChange;
    JComboBox cmbIdle;
    JComboBox cmbFontSize;
    JComboBox cmbFontColor;
    JCheckBox chkShowTopic;
    JCheckBox chkTabChat;

    public CommunicatorSettingsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.alert_msg = communicatorSettingsPanelBundle.getString("communicator_alert_msg");
        JPanel centerPanel = new JPanel();
        JLabel lblStartUPSettings = new JLabel();
        JLabel lblDesktopSettings = new JLabel();
        JLabel lblMisellaneousSettings = new JLabel();
        this.chkHideWhenMinimized = new JCheckBox();
        this.chkShowTrayIcon = new JCheckBox();
        this.chkShowUserStatusChange = new JCheckBox();
        this.setLayout(new GridBagLayout());
        lblStartUPSettings.setText(communicatorSettingsPanelBundle.getString("communicatorSettingsBorder_title"));
        lblDesktopSettings.setText(communicatorSettingsPanelBundle.getString("communicatorDesktopSettings_title"));
        lblMisellaneousSettings.setText(communicatorSettingsPanelBundle.getString("communicatorMiscellaneousSettings_title"));
        centerPanel.setToolTipText(communicatorSettingsPanelBundle.getString("pnlBorderCommunicator_toolTipText").length() != 0 ? communicatorSettingsPanelBundle.getString("pnlBorderCommunicator_toolTipText") : null);
        centerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)centerPanel, gridBagConstraints);
        this.chkAutoLogon = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkAutoLogon_text", "chkAutoLogon_text_M", "chkAutoLogon_toolTipText");
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        centerPanel.add((Component)lblStartUPSettings, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        centerPanel.add((Component)this.chkAutoLogon, gridBagConstraints);
        this.chkShowBuddy = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkShowBuddy_text", "chkShowBuddy_text_M", "chkShowBuddy_toolTipText");
        gridBagConstraints.gridy = 2;
        centerPanel.add((Component)this.chkShowBuddy, gridBagConstraints);
        this.chkShowTopic = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkShowTopic_text", "chkShowTopic_text_M", "chkShowTopic_toolTipText");
        gridBagConstraints.gridy = 3;
        centerPanel.add((Component)this.chkShowTopic, gridBagConstraints);
        if (PlatformUtil.isWin()) {
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(5, 12, 0, 0);
            centerPanel.add((Component)lblDesktopSettings, gridBagConstraints);
            this.chkShowTrayIcon = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkShowTrayIcon_text", "chkShowTrayIcon_text_M", "chkShowTrayIcon_toolTipText");
            gridBagConstraints.gridy = 5;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            centerPanel.add((Component)this.chkShowTrayIcon, gridBagConstraints);
            this.chkShowTrayIcon.addChangeListener(this);
            this.chkHideWhenMinimized = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkHideWhenMinimized_text", "chkHideWhenMinimized_text_M", "chkHideWhenMinimized_toolTipText");
            gridBagConstraints.gridy = 6;
            gridBagConstraints.insets = new Insets(0, 40, 0, 0);
            centerPanel.add((Component)this.chkHideWhenMinimized, gridBagConstraints);
            this.chkHideWhenMinimized.setEnabled(this.chkShowTrayIcon.isSelected());
            gridBagConstraints.gridy = 7;
            gridBagConstraints.insets = new Insets(5, 12, 0, 0);
            centerPanel.add((Component)lblMisellaneousSettings, gridBagConstraints);
            gridBagConstraints.gridy = 8;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            this.chkOfflineStatus = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkOfflineStatus_text", "chkOfflineStatus_text_M", "chkOfflineStatus_toolTipText");
            this.chkShowUserStatusChange = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkShowUserStatusChange_text", "chkShowUserStatusChange_text_M", "chkShowUserStatusChange_toolTipText");
            if (Manager.ALLOW_PRESENCE_ACCESS) {
                centerPanel.add((Component)this.chkShowUserStatusChange, gridBagConstraints);
            } else {
                this.chkShowUserStatusChange.setVisible(false);
                this.chkShowUserStatusChange.setEnabled(false);
            }
            gridBagConstraints.gridy = 9;
            this.chkTabChat = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "Start_multiple", "Start_multiple_M", null);
            centerPanel.add((Component)this.chkTabChat, gridBagConstraints);
        } else {
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(5, 12, 0, 0);
            centerPanel.add((Component)lblMisellaneousSettings, gridBagConstraints);
            this.chkOfflineStatus = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkOfflineStatus_text", "chkOfflineStatus_text_M", "chkOfflineStatus_toolTipText");
            this.chkShowUserStatusChange = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "chkShowUserStatusChange_text", "chkShowUserStatusChange_text_M", "chkShowUserStatusChange_toolTipText");
            if (Manager.ALLOW_PRESENCE_ACCESS) {
                gridBagConstraints.gridy = 5;
                gridBagConstraints.insets = new Insets(0, 24, 0, 0);
                centerPanel.add((Component)this.chkShowUserStatusChange, gridBagConstraints);
            } else {
                this.chkShowUserStatusChange.setVisible(false);
                this.chkShowUserStatusChange.setEnabled(false);
            }
            this.chkTabChat = SwingUtils.checkBoxItem(communicatorSettingsPanelBundle, null, "Start_multiple", "Start_multiple_M", null);
            gridBagConstraints.gridy = 6;
            centerPanel.add((Component)this.chkTabChat, gridBagConstraints);
        }
        this.chkShowTopic.addItemListener(this.symItem);
        this.chkShowBuddy.addItemListener(this.symItem);
    }

    public final void initProperties(Properties p) {
        this.chkAutoLogon.setSelected(Manager._auto_logon);
        if (Manager._auto_logon) {
            this.chkAutoLogon.setEnabled(true);
        } else {
            this.chkAutoLogon.setEnabled(false);
        }
        if (Manager._is_portal_env) {
            this.chkAutoLogon.setEnabled(false);
        }
        Manager.Out("DEBUG: CommunicatorSettings, initProperties p: " + p);
        this.chkShowBuddy.setSelected(iIMPropsUtil.getShowBuddyWin(p));
        Manager.Out("DEBUG: CommunicatorSettings, Prop: " + iIMPropsUtil.getShowTrayIcon(p));
        this.chkShowTrayIcon.setSelected(iIMPropsUtil.getShowTrayIcon(p));
        this.chkHideWhenMinimized.setSelected(iIMPropsUtil.getHideWhenMinimizedStatus(p));
        this.chkShowUserStatusChange.setSelected(iIMPropsUtil.getShowUserStatusWin(p) == 1);
        this.chkOfflineStatus.setSelected(iIMPropsUtil.getSetOfflineStatus(p));
        this.chkShowTopic.setSelected(iIMPropsUtil.getShowTopicEnabled(p));
        this.chkTabChat.setSelected(!iIMPropsUtil.getChatTab(p));
    }

    public final void putProperties(Properties p) {
        iIMPropsUtil.setOfflineStatus(p, this.chkOfflineStatus.isSelected());
        iIMPropsUtil.setShowBuddyWin(p, this.chkShowBuddy.isSelected());
        iIMPropsUtil.setShowTrayIcon(p, this.chkShowTrayIcon.isSelected());
        iIMPropsUtil.setHideWhenMinimizedStatus(p, this.chkHideWhenMinimized.isSelected());
        iIMPropsUtil.setShowTopicEnabled(p, this.chkShowTopic.isSelected());
        iIMPropsUtil.setChatTab(p, !this.chkTabChat.isSelected());
        iIMPropsUtil.setShowUserStatusWin(p, this.chkShowUserStatusChange.isSelected() ? 1 : 0);
        Manager._auto_logon = this.isAutoLogOn();
        if (!Manager._auto_logon) {
            iIMPropsUtil.saveNetLertProperties(Manager.NetLertProperties, Manager._propFileName, false, true);
        }
    }

    public void chkShowTopic_itemStateChanged(ItemEvent event) {
        if (!this.chkShowTopic.isSelected() && !this.chkShowBuddy.isSelected()) {
            JOptionPane.showMessageDialog(this, this.alert_msg);
            this.chkShowTopic.setSelected(true);
        }
    }

    public void chkShowBuddy_itemStateChanged(ItemEvent event) {
        if (!this.chkShowTopic.isSelected() && !this.chkShowBuddy.isSelected()) {
            JOptionPane.showMessageDialog(this, this.alert_msg);
            this.chkShowBuddy.setSelected(true);
        }
    }

    public final boolean isAutoLogOn() {
        return this.chkAutoLogon.isSelected();
    }

    public final boolean isHideWhenMinimized() {
        return this.chkHideWhenMinimized.isSelected();
    }

    public final boolean isShowCommunicatorSelected() {
        return this.chkShowBuddy.isSelected();
    }

    public void setShowCommunicatorSelected() {
        this.chkShowBuddy.setSelected(true);
    }

    private final void fillIdleCombo() {
        this.cmbIdle.addItem(communicatorSettingsPanelBundle.getString("Never"));
        this.cmbIdle.addItem(communicatorSettingsPanelBundle.getString("after5"));
        this.cmbIdle.addItem(communicatorSettingsPanelBundle.getString("after10"));
        this.cmbIdle.addItem(communicatorSettingsPanelBundle.getString("after15"));
        this.cmbIdle.addItem(communicatorSettingsPanelBundle.getString("after20"));
        this.cmbIdle.addItem(communicatorSettingsPanelBundle.getString("after30"));
        this.cmbIdle.addItem(communicatorSettingsPanelBundle.getString("after1"));
    }

    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o == this.chkShowTrayIcon) {
            this.chkHideWhenMinimized.setEnabled(this.chkShowTrayIcon.isSelected());
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == CommunicatorSettingsPanel.this.chkShowTopic) {
                CommunicatorSettingsPanel.this.chkShowTopic_itemStateChanged(event);
            }
            if (object == CommunicatorSettingsPanel.this.chkShowBuddy) {
                CommunicatorSettingsPanel.this.chkShowBuddy_itemStateChanged(event);
            }
        }
    }
}

