/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.config;

import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.ColorFillIcon;
import com.iplanet.im.client.util.ComboUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ChatSettingsPanel
extends JPanel {
    JComboBox cmbConactListFontSize;
    JComboBox cmbConactListFontColor;
    JComboBox cmbChatNotifyFontSize;
    JComboBox cmbChatNotifyFontColor;
    JLabel lblContactListText;
    JLabel lblChatNotifyText;
    JLabel lblTextSettings;
    JLabel lblBackgroundTheames;
    JButton textureButton;
    JTable bgTexPalTable;
    JPopupMenu popupMenu;
    static SafeResourceBundle chatSettingsPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.config.config");
    static /* synthetic */ Class class$javax$swing$ImageIcon;

    public ChatSettingsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        Insets inset;
        this.lblTextSettings = new JLabel();
        JPanel optionsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.insets = inset = new Insets(24, 24, 0, 24);
        gc.anchor = 18;
        this.add((Component)this.lblTextSettings, gc);
        gc.gridy = 1;
        inset.top = 12;
        inset.bottom = 24;
        gc.weighty = 1.0;
        this.add((Component)optionsPanel, gc);
        this.cmbConactListFontSize = new JComboBox();
        this.cmbConactListFontColor = new JComboBox();
        this.cmbChatNotifyFontSize = new JComboBox();
        this.cmbChatNotifyFontColor = new JComboBox();
        this.lblContactListText = new JLabel();
        this.lblChatNotifyText = new JLabel();
        this.lblBackgroundTheames = new JLabel();
        this.textureButton = new JButton("<html><img src =\"" + SwingImageManager.getImageURL("/com/iplanet/im/client/images/d_arrow.gif", "/com/iplanet/im/client/images/d_arrow.gif", this) + "\">");
        this.textureButton.setVerticalAlignment(0);
        this.textureButton.setHorizontalAlignment(0);
        this.textureButton.setHorizontalTextPosition(11);
        this.textureButton.setVerticalTextPosition(0);
        this.textureButton.setMargin(new Insets(1, 1, 1, 1));
        this.lblTextSettings.setText(chatSettingsPanelBundle.getString("Text_Settings"));
        this.lblBackgroundTheames.setText(chatSettingsPanelBundle.getString("Background_Themes"));
        String mnemonic = chatSettingsPanelBundle.getString("Background_Themes_M");
        if (mnemonic != null && mnemonic.length() > 0) {
            this.lblBackgroundTheames.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        this.lblBackgroundTheames.setLabelFor(this.textureButton);
        this.lblContactListText.setText(chatSettingsPanelBundle.getString("Contact_List_Text"));
        mnemonic = chatSettingsPanelBundle.getString("Contact_List_Text_M");
        if (mnemonic != null && mnemonic.length() > 0) {
            this.lblContactListText.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        this.lblContactListText.setLabelFor(this.cmbConactListFontSize);
        this.lblChatNotifyText.setText(chatSettingsPanelBundle.getString("Chat_Notify_Text"));
        mnemonic = chatSettingsPanelBundle.getString("Chat_Notify_Text_M");
        if (mnemonic != null && mnemonic.length() > 0) {
            this.lblChatNotifyText.setDisplayedMnemonic(mnemonic.charAt(0));
        }
        this.lblChatNotifyText.setLabelFor(this.cmbChatNotifyFontSize);
        optionsPanel.setLayout(new GridBagLayout());
        gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.insets = inset = new Insets(0, 12, 0, 0);
        optionsPanel.add((Component)this.lblContactListText, gc);
        gc.gridx = 1;
        gc.fill = 2;
        optionsPanel.add((Component)this.cmbConactListFontSize, gc);
        gc.gridx = 2;
        inset.left = 5;
        inset.right = 24;
        gc.fill = 0;
        optionsPanel.add((Component)this.cmbConactListFontColor, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        inset.top = 5;
        inset.left = 12;
        inset.right = 0;
        optionsPanel.add((Component)this.lblChatNotifyText, gc);
        gc.gridx = 1;
        gc.fill = 2;
        optionsPanel.add((Component)this.cmbChatNotifyFontSize, gc);
        gc.gridx = 2;
        inset.left = 5;
        inset.right = 24;
        gc.fill = 0;
        optionsPanel.add((Component)this.cmbChatNotifyFontColor, gc);
        inset.top = 12;
        inset.left = 0;
        inset.bottom = 24;
        inset.right = 0;
        gc.gridx = 0;
        gc.gridy = 2;
        optionsPanel.add((Component)this.lblBackgroundTheames, gc);
        gc.gridx = 1;
        inset.left = 12;
        gc.fill = 2;
        this.textureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ChatSettingsPanel.this.popupMenu == null) {
                    ChatSettingsPanel.this.popupMenu = new JPopupMenu();
                }
                if (ChatSettingsPanel.this.bgTexPalTable == null) {
                    ChatSettingsPanel.this._createBgTexPalTable();
                }
                ChatSettingsPanel.this.popupMenu.add(ChatSettingsPanel.this.bgTexPalTable);
                ChatSettingsPanel.this.popupMenu.show(ChatSettingsPanel.this.textureButton, 0, ChatSettingsPanel.this.textureButton.getHeight());
                Icon icon = ChatSettingsPanel.this.textureButton.getIcon();
                int col = 0;
                int row = 0;
                if (icon instanceof ImageIcon) {
                    ImageIcon imgIcon = (ImageIcon)icon;
                    TableModel model = ChatSettingsPanel.this.bgTexPalTable.getModel();
                    int colCount = model.getColumnCount();
                    int rowCount = model.getRowCount();
                    block0: for (int i = 0; i < rowCount; ++i) {
                        for (int j = 0; j < colCount; ++j) {
                            ImageIcon temp = (ImageIcon)model.getValueAt(i, j);
                            if (!temp.getDescription().equals(imgIcon.getDescription())) continue;
                            col = j;
                            row = i;
                            continue block0;
                        }
                    }
                }
                ChatSettingsPanel.this.bgTexPalTable.setColumnSelectionInterval(col, col);
                ChatSettingsPanel.this.bgTexPalTable.setRowSelectionInterval(row, row);
                ChatSettingsPanel.this.bgTexPalTable.requestFocus();
            }
        });
        optionsPanel.add((Component)this.textureButton, gc);
        this.fillContactListFontColorCombo();
        this.fillContactListFontSizeCombo();
        this.fillChatAlertFontSizeCombo();
        this.fillChatAlertFontColorCombo();
    }

    private final void fillContactListFontColorCombo() {
        for (int i = 0; i < ComboUtility.colorTextChatData.length; ++i) {
            this.cmbConactListFontColor.addItem(ComboUtility.colorTextChatData[i]);
        }
    }

    private final void fillContactListFontSizeCombo() {
        this.cmbConactListFontSize.addItem("10");
        this.cmbConactListFontSize.addItem("12");
        this.cmbConactListFontSize.addItem("14");
        this.cmbConactListFontSize.addItem("18");
        this.cmbConactListFontSize.addItem("24");
        this.cmbConactListFontSize.addItem("36");
    }

    private final void fillChatAlertFontSizeCombo() {
        this.cmbChatNotifyFontSize.addItem("10");
        this.cmbChatNotifyFontSize.addItem("12");
        this.cmbChatNotifyFontSize.addItem("14");
        this.cmbChatNotifyFontSize.addItem("18");
        this.cmbChatNotifyFontSize.addItem("24");
        this.cmbChatNotifyFontSize.addItem("36");
    }

    private final void fillChatAlertFontColorCombo() {
        for (int i = 0; i < ComboUtility.colorTextChatData.length; ++i) {
            this.cmbChatNotifyFontColor.addItem(ComboUtility.colorTextChatData[i]);
        }
    }

    public final Color getFontColor() {
        ColorFillIcon icon = (ColorFillIcon)ComboUtility.colorTextComboData[this.cmbConactListFontColor.getSelectedIndex()];
        return icon.getColor();
    }

    public final int getFontSize() {
        int size = Integer.parseInt((String)this.cmbConactListFontSize.getSelectedItem());
        return size;
    }

    public final void initProperties(Properties p) {
        this.cmbConactListFontColor.setSelectedIndex(ComboUtility.getTextColorIndex(ComboUtility.colorTextChatData, iIMPropsUtil.getContactListFontColor(p)));
        this.cmbConactListFontSize.setSelectedItem(String.valueOf(iIMPropsUtil.getContactListSize(p)));
        this.cmbChatNotifyFontColor.setSelectedIndex(ComboUtility.getTextColorIndex(ComboUtility.colorTextChatData, iIMPropsUtil.getChatFontColor(p)));
        this.cmbChatNotifyFontSize.setSelectedItem(String.valueOf(iIMPropsUtil.getChatFontSize(p)));
        Icon icon = SwingImageManager.getBgIcon(String.valueOf(iIMPropsUtil.getBackgroundTexture(p)));
        if (icon == null) {
            ImageIcon[] icons = SwingImageManager.getBgPltTexIcons();
            icon = icons.length > 0 ? new NullIcon(icons[0].getIconWidth(), icons[0].getIconHeight()) : new NullIcon();
        }
        this.textureButton.setIcon(icon);
    }

    public final void putProperties(Properties p) {
        iIMPropsUtil.setContactListFontColor(p, ((ColorFillIcon)this.cmbConactListFontColor.getSelectedItem()).getColor());
        iIMPropsUtil.setContactListSize(p, (String)this.cmbConactListFontSize.getSelectedItem());
        iIMPropsUtil.setChatFontColor(p, ((ColorFillIcon)this.cmbChatNotifyFontColor.getSelectedItem()).getColor());
        iIMPropsUtil.setChatFontSize(p, (String)this.cmbChatNotifyFontSize.getSelectedItem());
        Icon icon = this.textureButton.getIcon();
        if (icon instanceof ImageIcon) {
            iIMPropsUtil.setBackgroundTexture(p, ((ImageIcon)icon).getDescription());
        }
    }

    private void _createBgTexPalTable() {
        ImageIcon[] icons = SwingImageManager.getBgPltTexIcons();
        int cols = SwingImageManager.getPrefBgTexPltCols();
        int rows = SwingImageManager.getPrefBgTexPltRows();
        if (cols != -1) {
            if (rows == -1) {
                rows = icons.length / cols;
                if (icons.length % cols != 0) {
                    ++rows;
                }
            }
        } else if (rows != -1) {
            cols = icons.length / rows;
            if (icons.length % rows != 0) {
                ++cols;
            }
        } else {
            rows = cols = (int)Math.ceil(Math.sqrt(icons.length));
        }
        final ImageIcon[][] tmp = new ImageIcon[rows][cols];
        int i = 0;
        block0: for (int j = 0; j < rows; ++j) {
            for (int k = 0; k < cols; ++k) {
                if (i >= icons.length) break block0;
                tmp[j][k] = icons[i++];
            }
        }
        final int modelCols = cols;
        final int modelRows = rows;
        AbstractTableModel model = new AbstractTableModel(){

            public int getRowCount() {
                return modelRows;
            }

            public int getColumnCount() {
                return modelCols;
            }

            public Object getValueAt(int row, int column) {
                return tmp[row][column];
            }

            public Class getColumnClass(int col) {
                return class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = ChatSettingsPanel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon;
            }
        };
        this.bgTexPalTable = new JTable(model);
        this.bgTexPalTable.setShowGrid(false);
        this.bgTexPalTable.setSelectionMode(0);
        this.bgTexPalTable.setBorder(null);
        this.bgTexPalTable.setCellSelectionEnabled(true);
        InputMap map = this.bgTexPalTable.getInputMap(0);
        map.put(KeyStroke.getKeyStroke("pressed ENTER"), "EnterAction");
        map.put(KeyStroke.getKeyStroke("pressed SPACE"), "EnterAction");
        AbstractAction enterAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int col = ChatSettingsPanel.this.bgTexPalTable.getSelectedColumn();
                int row = ChatSettingsPanel.this.bgTexPalTable.getSelectedRow();
                if (row != -1 && col != -1) {
                    ImageIcon icon = (ImageIcon)ChatSettingsPanel.this.bgTexPalTable.getModel().getValueAt(row, col);
                    ChatSettingsPanel.this.textureButton.setIcon(icon);
                }
                ChatSettingsPanel.this.popupMenu.setVisible(false);
            }
        };
        this.bgTexPalTable.getActionMap().put("EnterAction", enterAction);
        map.put(KeyStroke.getKeyStroke("pressed ESCAPE"), "EscapeAction");
        this.bgTexPalTable.getActionMap().put("EscapeAction", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChatSettingsPanel.this.popupMenu.setVisible(false);
            }
        });
        if (icons.length > 0) {
            ImageIcon icon = (ImageIcon)this.bgTexPalTable.getModel().getValueAt(0, 0);
            int height = icon.getIconHeight() + 10;
            this.bgTexPalTable.setRowHeight(height);
            int width = icon.getIconWidth() + 10;
            TableColumnModel colModel = this.bgTexPalTable.getColumnModel();
            for (i = 0; i < colModel.getColumnCount(); ++i) {
                colModel.getColumn(i).setPreferredWidth(width);
            }
        }
        MouseInputAdapter adapter = new MouseInputAdapter(){

            private void _changeSelection(MouseEvent e) {
                int col;
                Point p = e.getPoint();
                int row = ChatSettingsPanel.this.bgTexPalTable.rowAtPoint(p);
                if (row != -1 && (col = ChatSettingsPanel.this.bgTexPalTable.columnAtPoint(p)) != -1) {
                    ChatSettingsPanel.this.bgTexPalTable.setColumnSelectionInterval(col, col);
                    ChatSettingsPanel.this.bgTexPalTable.setRowSelectionInterval(row, row);
                }
            }

            public void mousePressed(MouseEvent e) {
                this._changeSelection(e);
            }

            public void mouseReleased(MouseEvent e) {
                int col;
                Point p = e.getPoint();
                int row = ChatSettingsPanel.this.bgTexPalTable.rowAtPoint(p);
                if (row != -1 && (col = ChatSettingsPanel.this.bgTexPalTable.columnAtPoint(p)) != -1) {
                    ImageIcon icon = (ImageIcon)ChatSettingsPanel.this.bgTexPalTable.getModel().getValueAt(row, col);
                    ChatSettingsPanel.this.textureButton.setIcon(icon);
                    ChatSettingsPanel.this.popupMenu.setVisible(false);
                }
            }

            public void mouseEntered(MouseEvent e) {
                this._changeSelection(e);
            }

            public void mouseDragged(MouseEvent e) {
                this._changeSelection(e);
            }

            public void mouseMoved(MouseEvent e) {
                this._changeSelection(e);
            }
        };
        this.bgTexPalTable.addMouseListener(adapter);
        this.bgTexPalTable.addMouseMotionListener(adapter);
    }

    private class NullIcon
    implements Icon {
        private int _width = 18;
        private int _height = 18;

        NullIcon(int width, int height) {
            this._width = width;
            this._height = height;
        }

        NullIcon() {
        }

        public int getIconHeight() {
            return this._height;
        }

        public int getIconWidth() {
            return this._width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }
}

