/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.ContactFolderTreeNode;
import com.iplanet.im.client.swing.communicator.ServicesFolderTreeNode;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.util.StringUtility;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;

public class RootTreeNode
extends BaseTreeNode {
    private boolean _onlyContacts;

    public RootTreeNode(JTree tree) {
        this(tree, false);
    }

    public RootTreeNode(JTree tree, boolean onlyContacts) {
        this._onlyContacts = onlyContacts;
        this.reload();
    }

    public void reload() {
        PersonalGateway[] gtws;
        this.removeAllChildren();
        String[] buddyListGroups = BuddyListManager.getBuddyListGroups();
        ArrayList<ContactFolderTreeNode> nodes = new ArrayList<ContactFolderTreeNode>();
        boolean createServiceFolder = false;
        for (int i = 0; i < buddyListGroups.length; ++i) {
            boolean showFolder = true;
            if (BuddyListManager.getDummyFolderName().equals(buddyListGroups[i]) && BuddyListManager.getGroupMemberCount(buddyListGroups[i]) == 0) {
                showFolder = false;
            }
            if (!showFolder) continue;
            if (!this._onlyContacts && ServicesFolderTreeNode.NAME_SERVICES_FOLDER.equals(buddyListGroups[i])) {
                createServiceFolder = true;
                continue;
            }
            nodes.add(new ContactFolderTreeNode(buddyListGroups[i]));
        }
        if (!createServiceFolder && !this._onlyContacts && (gtws = BuddyListManager.getGateways()) != null && gtws.length > 0) {
            createServiceFolder = true;
        }
        if (createServiceFolder) {
            nodes.add(new ServicesFolderTreeNode());
        }
        Object[] combinedNodes = nodes.toArray(new BaseTreeNode[nodes.size()]);
        StringUtility.sort((Object[])combinedNodes);
        for (int i = 0; i < combinedNodes.length; ++i) {
            this.add((MutableTreeNode)combinedNodes[i]);
        }
    }
}

