/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.communicator.roomListTransferable;
import com.iplanet.im.client.swing.dialogs.AddDestination;
import com.iplanet.im.client.swing.dialogs.AddRoomDialog;
import com.iplanet.im.client.swing.models.iIMListModel;
import com.iplanet.im.client.swing.models.iIMListRenderer;
import com.iplanet.im.client.util.ImagePaintingViewport;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RoomListPanel
extends JPanel
implements MouseListener,
ActionListener,
DragSourceListener,
DragGestureListener,
PropertyChangeListener {
    static SafeResourceBundle roomListPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");
    private iIMListModel roomModel;
    private iIMListRenderer listRenderer;
    private SymKey aSymKey;
    Communicator parent;
    private Object[] draggedValues;
    JScrollPane roomScrollPane = new JScrollPane();
    ImagePaintingViewport imagePaintingVP;
    JList lstRooms = new JList();
    JToolBar toolBar = new JToolBar();
    JButton btnSubscribe = new JButton();
    JButton btnDelete = new JButton();
    JButton btnManage = new JButton();
    JButton btnEnter = new JButton();

    public RoomListPanel(Communicator parent) {
        this.parent = parent;
        this.initComponents();
        this.aSymKey = new SymKey();
        this.initRoomModel();
        this.refresh();
        this.lstRooms.addKeyListener(this.aSymKey);
    }

    private void initComponents() {
        Insets ins = new Insets(0, 2, 0, 2);
        this.setToolTipText(roomListPanelBundle.getString("RoomListPanel_toolTipText").length() != 0 ? roomListPanelBundle.getString("RoomListPanel_toolTipText") : null);
        this.setLayout(new GridBagLayout());
        this.roomScrollPane.setOpaque(true);
        this.imagePaintingVP = new ImagePaintingViewport();
        this.roomScrollPane.setViewport(this.imagePaintingVP);
        this._loadBgTexIcon();
        UserPropsManager.addPropertyChangeListener(this);
        this.roomScrollPane.setToolTipText(roomListPanelBundle.getString("JScrollPane1_toolTipText").length() != 0 ? roomListPanelBundle.getString("JScrollPane1_toolTipText") : null);
        this.add((Component)this.roomScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.lstRooms.setToolTipText(roomListPanelBundle.getString("lstRooms_toolTipText").length() != 0 ? roomListPanelBundle.getString("lstRooms_toolTipText") : null);
        this.roomScrollPane.setViewportView(this.lstRooms);
        this.lstRooms.addMouseListener(this);
        this.lstRooms.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (RoomListPanel.this.lstRooms.getSelectedIndex() < 0 && RoomListPanel.this.lstRooms.isSelectionEmpty()) {
                    RoomListPanel.this.parent.conferencedeSelected();
                } else {
                    RoomListPanel.this.parent.conferenceSelected();
                }
            }
        });
    }

    private void commonButtonSetup(JButton button, String actionCommandKey, String toolTipKey, String mnemonicKey, String imageName, Insets ins) {
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setVerticalAlignment(3);
        button.setActionCommand(roomListPanelBundle.getString(actionCommandKey));
        String tooltip = roomListPanelBundle.getString(toolTipKey);
        if (tooltip != null && tooltip.length() > 0) {
            button.setToolTipText(tooltip);
        }
        String mnemonic = roomListPanelBundle.getString(mnemonicKey);
        if (mnemonicKey != null && mnemonicKey.length() > 0) {
            button.setMnemonic(mnemonic.charAt(0));
        }
        button.setIcon(SwingImageManager.getIcon(imageName, (Object)this));
        button.setBorderPainted(false);
        button.setMargin(ins);
        button.setFocusPainted(false);
        button.addActionListener(this);
        button.addMouseListener(this);
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        this.draggedValues = this.lstRooms.getSelectedValues();
        roomListTransferable transferable = new roomListTransferable(this.draggedValues);
        event.startDrag(null, transferable, this);
    }

    public void dragEnter(DragSourceDragEvent event) {
    }

    public void dragOver(DragSourceDragEvent event) {
    }

    public void dragExit(DragSourceEvent event) {
    }

    public void dropActionChanged(DragSourceDragEvent event) {
    }

    public void dragDropEnd(DragSourceDropEvent event) {
    }

    public void changeFont() {
        this.listRenderer.setFontSize(iIMPropsUtil.getCommunicatorFontSize(CurrentUserManager.getCurrentUserProperties()));
        this.listRenderer.setFontColor(iIMPropsUtil.getCommunicatorFontColor(CurrentUserManager.getCurrentUserProperties()));
        this.refresh();
    }

    private void setBarVisible(boolean b) {
        this.toolBar.setVisible(b);
    }

    public void setToolBarDisable() {
        this.parent.setRoomMenu();
    }

    public void close() {
        this.lstRooms.removeKeyListener(this.aSymKey);
        UserPropsManager.removePropertyChangeListener(this);
        this.btnManage.removeActionListener(this);
        this.btnSubscribe.removeActionListener(this);
        this.btnDelete.removeActionListener(this);
        this.lstRooms.removeMouseListener(this);
    }

    public void setToolBarEnable() {
        this.parent.setRoomListMenu();
    }

    private void initRoomModel() {
        this.roomModel = new iIMListModel(this.lstRooms, StringUtility.sort((Vector)StringUtility.sort((Vector)RoomManager.getFavorites())));
        this.listRenderer = new iIMListRenderer(this.roomModel){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JComponent com = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                com.setOpaque(isSelected);
                return com;
            }
        };
        this.listRenderer.setFontSize(iIMPropsUtil.getCommunicatorFontSize(CurrentUserManager.getCurrentUserProperties()));
        this.listRenderer.setFontColor(iIMPropsUtil.getCommunicatorFontColor(CurrentUserManager.getCurrentUserProperties()));
        this.lstRooms.setCellRenderer(this.listRenderer);
        this.lstRooms.setModel(this.roomModel);
        this.lstRooms.setSelectionMode(0);
    }

    public void refresh() {
        Manager.Out("** Refresh Room List");
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.btnSubscribe.setVisible(true);
            this.btnDelete.setVisible(true);
        } else {
            this.btnSubscribe.setVisible(false);
            this.btnDelete.setVisible(false);
        }
        if (Manager.ALLOW_ROOM_MANAGEMENT) {
            // empty if block
        }
        if (this.roomModel != null) {
            iIM.refreshRooms();
            Vector v = RoomManager.getFavorites();
            for (int i = 0; i < v.size(); ++i) {
                Conference r = (Conference)v.elementAt(i);
                Manager.Out("RoomListPanel/refresh. Room : " + r.getDestination());
            }
            this.roomModel.changed(StringUtility.sort((Vector)StringUtility.sort((Vector)v)));
            if (v.size() == 0) {
                this.addDefaultText();
                this.lstRooms.clearSelection();
                this.lstRooms.setEnabled(false);
            } else {
                this.lstRooms.setEnabled(true);
                if (this.lstRooms.getSelectedIndex() == 0) {
                    this.lstRooms.addSelectionInterval(0, 0);
                } else {
                    this.lstRooms.addSelectionInterval(this.lstRooms.getLastVisibleIndex(), this.lstRooms.getLastVisibleIndex());
                }
            }
        }
    }

    public void setSelectedRoom(Conference r) {
        for (int i = 0; i < this.roomModel.getSize(); ++i) {
            Conference tmp = (Conference)this.roomModel.getElementAt(i);
            if (!tmp.getDestination().equals(r.getDestination())) continue;
            this.lstRooms.setSelectedIndex(i);
            this.lstRooms.ensureIndexIsVisible(i);
            break;
        }
        this.lstRooms.repaint();
    }

    public boolean isSelectionEmpty() {
        return this.lstRooms.isSelectionEmpty();
    }

    public void enterSelectedRoom() {
        if (this.lstRooms.isSelectionEmpty()) {
            return;
        }
        Conference r = (Conference)this.lstRooms.getSelectedValue();
        if (r == null) {
            return;
        }
        iIM.enterRoom(r);
    }

    public final void unsubscribeSelectedRoom() {
        String titledelete;
        if (this.lstRooms.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(this.parent, roomListPanelBundle.getString("first_select_a_conference"));
            return;
        }
        int index = this.lstRooms.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Conference r = (Conference)this.lstRooms.getSelectedValue();
        String userdeletemsg = roomListPanelBundle.getString("delete_conf_list_message");
        int confirmdelete = JOptionPane.showConfirmDialog(this, userdeletemsg, titledelete = roomListPanelBundle.getString("Confirm_Delete"), 0);
        if (confirmdelete == 0) {
            try {
                RoomManager.unsubscribe(r);
            }
            catch (CollaborationException ne) {
                ne.printStackTrace();
                Manager.Out("unsubscribeSelectedRoom: " + ne.getMessage());
            }
        }
        iIM.updateChatRoomModels();
        this.refresh();
    }

    protected final void addNewDestination() {
        if (!UserAccessControl.canCreateRoom()) {
            JOptionPane.showMessageDialog(this, iIM.ID_NO_PRIVILEGE);
            return;
        }
        AddDestination addNewRoomDialog = new AddDestination(this.parent, 2);
        addNewRoomDialog.setModal(true);
        addNewRoomDialog.setVisible(true);
        if (!addNewRoomDialog.hasOkBeenPressed() || addNewRoomDialog.getDestinationName().equals("")) {
            return;
        }
        iIM.addRoom(Manager.getValidDestinationName(addNewRoomDialog.getDestinationName()), addNewRoomDialog.getServer(), addNewRoomDialog.getAccess(), addNewRoomDialog.isShowUserListSelected());
        RoomManager.refreshRooms();
        this.refresh();
    }

    protected final void manageDestination() {
        if (this.lstRooms.getSelectedIndex() != -1) {
            iIM.openDestinationAdmin(this.parent, 2, (Conference)this.lstRooms.getSelectedValue());
        } else {
            iIM.openDestinationAdmin(this.parent, 2);
        }
    }

    public void setListEnable(boolean listEnable) {
        this.lstRooms.setEnabled(listEnable);
    }

    public JList getlstRooms() {
        return this.lstRooms;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._loadBgTexIcon();
    }

    private void _loadBgTexIcon() {
        String name = iIMPropsUtil.getBackgroundTexture(UserPropsManager.loadUserProperties(CurrentUserManager.getCurrentProfile()));
        ImageIcon icon = SwingImageManager.getBgPatternIcon(name);
        this.imagePaintingVP.setIcon(icon);
        this.lstRooms.setOpaque(icon == null);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.btnManage) {
            this.manageDestination();
        } else if (o == this.btnSubscribe) {
            new AddRoomDialog((Frame)this.parent, false);
        } else if (o == this.btnDelete) {
            this.unsubscribeSelectedRoom();
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.parent.setRoomMenu();
        if (e.getSource() == this.lstRooms && this.roomModel.getSize() == 0) {
            this.parent.tellUserToSubscribe(this);
        }
        if (e.getClickCount() > 1) {
            this.enterSelectedRoom();
        } else {
            RoomManager.refreshRoomParticipants(false);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.btnManage) {
            this.btnManage.setBorderPainted(true);
        } else if (e.getSource() == this.btnDelete) {
            this.btnDelete.setBorderPainted(true);
        } else if (e.getSource() == this.btnSubscribe) {
            this.btnSubscribe.setBorderPainted(true);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.btnManage) {
            this.btnManage.setBorderPainted(false);
        } else if (e.getSource() == this.btnDelete) {
            this.btnDelete.setBorderPainted(false);
        } else if (e.getSource() == this.btnSubscribe) {
            // empty if block
        }
    }

    public boolean requestDefaultFocus() {
        this.lstRooms.requestFocus();
        return this.lstRooms.hasFocus();
    }

    public void addDefaultText() {
        Vector<String> default_text = new Vector<String>();
        String l5 = roomListPanelBundle.getString("Empty_Conferences_5");
        if (l5 != null) {
            // empty if block
        }
        default_text.add(roomListPanelBundle.getString("Empty_Conferences_1"));
        default_text.add(roomListPanelBundle.getString("Empty_Conferences_2"));
        default_text.add(roomListPanelBundle.getString("Empty_Conferences_3"));
        this.roomModel.changed(default_text);
    }

    class roomDropDelTargetListener
    implements DropTargetListener {
        private JList roomList;

        public roomDropDelTargetListener(JList b) {
            this.roomList = b;
        }

        public void dragEnter(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        public void dragExit(DropTargetEvent event) {
        }

        public void dragOver(DropTargetDragEvent event) {
        }

        public void dropActionChanged(DropTargetDragEvent event) {
            if (!this.isDragAcceptable(event)) {
                event.rejectDrag();
                return;
            }
        }

        public void drop(DropTargetDropEvent event) {
            if (!this.isDropAcceptable(event)) {
                event.rejectDrop();
                return;
            }
            event.acceptDrop(2);
            Transferable transferable = event.getTransferable();
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                DataFlavor d = flavors[i];
                Manager.Out("MIME type=" + d.getMimeType() + "\n");
                try {
                    if (!d.equals(DataFlavor.javaFileListFlavor)) continue;
                    RoomListPanel.this.unsubscribeSelectedRoom();
                    continue;
                }
                catch (Exception e) {
                    Manager.Out("Error: " + e + "\n");
                }
            }
            event.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent event) {
            return (event.getDropAction() & 2) != 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent event) {
            return (event.getDropAction() & 2) != 0;
        }
    }

    class SymKey
    extends KeyAdapter {
        SymKey() {
        }

        public void keyPressed(KeyEvent event) {
            if (!RoomListPanel.this.isVisible()) {
                return;
            }
            if (event.getKeyCode() == 10) {
                RoomListPanel.this.enterSelectedRoom();
            } else if (event.getKeyCode() == 127) {
                RoomListPanel.this.unsubscribeSelectedRoom();
            }
        }
    }
}

