/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.ContactTreeNode;
import com.iplanet.im.client.swing.communicator.TreeNodeVisitor;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public class LDAPGroupTreeNode
extends BaseTreeNode {
    private boolean _loaded = false;
    private static Icon ICON_LDAP_GROUP;

    public LDAPGroupTreeNode(CollaborationPrincipal principal) {
        this.setUserObject(principal);
        if (ICON_LDAP_GROUP == null) {
            ICON_LDAP_GROUP = SwingImageManager.getIcon(9, (Object)this);
        }
    }

    public String getName() {
        return this.getPrincipal().getDisplayName();
    }

    public Icon getOpenIcon() {
        return ICON_LDAP_GROUP;
    }

    public Icon getClosedIcon() {
        return ICON_LDAP_GROUP;
    }

    public boolean isLeaf() {
        return false;
    }

    public int getChildCount() {
        if (!this._loaded) {
            return 1;
        }
        return super.getChildCount();
    }

    public void load() {
        CollaborationPrincipal[] principals = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(this.getPrincipal().getUID());
        if (principals != null) {
            int i;
            Object[] nodes = new BaseTreeNode[principals.length];
            for (i = 0; i < principals.length; ++i) {
                nodes[i] = new ContactTreeNode(principals[i]);
            }
            StringUtility.sort((Object[])nodes);
            for (i = principals.length - 1; i >= 0; --i) {
                this.insert((MutableTreeNode)nodes[i], 0);
            }
            this._loaded = true;
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public void accept(TreeNodeVisitor v) {
        v.visit(this);
    }

    public CollaborationPrincipal getPrincipal() {
        return (CollaborationPrincipal)this.getUserObject();
    }

    public String toString() {
        return this.getPrincipal().getDisplayName();
    }
}

