/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.ContactTreeNode;
import com.iplanet.im.client.swing.communicator.LDAPGroupTreeNode;
import com.iplanet.im.client.swing.communicator.TreeNodeVisitor;
import com.sun.im.service.CollaborationPrincipal;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DragTreeNodeVisitor
extends TreeNodeVisitor {
    private ArrayList _principals;
    private ArrayList _nodes;
    private JTree _tree;

    public DragTreeNodeVisitor(JTree tree) {
        this._tree = tree;
        this.reset();
    }

    public void traverse() {
        if (!this._tree.isSelectionEmpty()) {
            TreePath[] paths = this._tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                ((BaseTreeNode)paths[i].getLastPathComponent()).accept(this);
            }
        }
    }

    public void visit(ContactTreeNode node) {
        if (!(node.getParent() instanceof LDAPGroupTreeNode)) {
            this._principals.add(node.getPrincipal());
            this._nodes.add(node);
        }
    }

    public void visit(LDAPGroupTreeNode node) {
        this._principals.add(node.getPrincipal());
        this._nodes.add(node);
    }

    public CollaborationPrincipal[] getCollaborationPrincipals() {
        return this._principals.toArray(new CollaborationPrincipal[this._principals.size()]);
    }

    public BaseTreeNode[] getTreeNodes() {
        return this._nodes.toArray(new BaseTreeNode[this._nodes.size()]);
    }

    public void reset() {
        this._principals = new ArrayList();
        this._nodes = new ArrayList();
    }
}

