/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.ContactFolderTreeNode;
import com.iplanet.im.client.swing.communicator.ContactTreeNode;
import com.iplanet.im.client.swing.communicator.LDAPGroupTreeNode;
import com.iplanet.im.client.swing.communicator.TreeNodeVisitor;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DeleteTreeNodeVisitor
extends TreeNodeVisitor {
    private JTree _tree;
    private boolean _notDeletable;
    private ArrayList _folders;
    private ArrayList _contacts;
    private ArrayList _LDAPGroups;
    private static SafeResourceBundle bundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");

    public DeleteTreeNodeVisitor(JTree tree) {
        this._tree = tree;
        this.reset();
    }

    public void deleteSelectedItems(JComponent dialogParent) {
        BaseTreeNode node;
        int i;
        if (this._tree.isSelectionEmpty()) {
            return;
        }
        TreePath[] selectedPaths = this._tree.getSelectionPaths();
        for (i = 0; i < selectedPaths.length; ++i) {
            ((BaseTreeNode)selectedPaths[i].getLastPathComponent()).accept(this);
            if (!this._notDeletable) continue;
            return;
        }
        if (this._folders.size() >= BuddyListManager.getBuddyListGroups().length) {
            JOptionPane.showMessageDialog(dialogParent, bundle.getString("BuddyListPanel_You_need_at_least_one_group"));
            return;
        }
        for (i = 0; i < this._folders.size(); ++i) {
            String title;
            node = (BaseTreeNode)this._folders.get(i);
            String msg = StringUtility.substitute((String)bundle.getString("BuddyListPanel_Confirm_BuddyListGroup_deletion"), (String)"__MACRO__", (String)node.getName());
            int confirm = JOptionPane.showConfirmDialog(dialogParent, msg, title = bundle.getString("Confirm_Delete"), 0);
            if (confirm != 0) continue;
            BuddyListManager.removeBuddyListGroup(node.getName());
        }
        for (i = 0; i < this._contacts.size(); ++i) {
            String titledelete;
            node = (ContactTreeNode)this._contacts.get(i);
            CollaborationPrincipal principal = ((ContactTreeNode)node).getPrincipal();
            String userdeletemsg = StringUtility.substitute((String)bundle.getString("delete_user_list_message"), (String)"__MACRO__", (String)principal.getDisplayName());
            int confirmdelete = JOptionPane.showConfirmDialog(dialogParent, userdeletemsg, titledelete = bundle.getString("Confirm_Delete"), 0);
            if (confirmdelete != 0) continue;
            BuddyListManager.removeBuddyListGroupMember(principal.getUID(), ((ContactFolderTreeNode)node.getParent()).getName());
        }
        for (i = 0; i < this._LDAPGroups.size(); ++i) {
            String titledelete;
            node = (BaseTreeNode)this._LDAPGroups.get(i);
            String userdeletemsg = StringUtility.substitute((String)bundle.getString("delete_user_list_message"), (String)"__MACRO__", (String)node.getName());
            int confirmdelete = JOptionPane.showConfirmDialog(dialogParent, userdeletemsg, titledelete = bundle.getString("Confirm_Delete"), 0);
            if (confirmdelete != 0) continue;
            BuddyListManager.removeBuddyListGroupMember(((LDAPGroupTreeNode)node).getPrincipal().getUID(), ((ContactFolderTreeNode)node.getParent()).getName());
        }
    }

    public void visit(ContactTreeNode node) {
        if (node.getParent() instanceof LDAPGroupTreeNode) {
            this._notDeletable = true;
            return;
        }
        this._contacts.add(node);
    }

    public void visit(ContactFolderTreeNode node) {
        this._folders.add(node);
    }

    public void visit(LDAPGroupTreeNode node) {
        this._LDAPGroups.add(node);
    }

    public void reset() {
        this._folders = new ArrayList();
        this._contacts = new ArrayList();
        this._LDAPGroups = new ArrayList();
        this._notDeletable = false;
    }
}

