/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.TreeNodeVisitor;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Icon;

public class ContactTreeNode
extends BaseTreeNode {
    private static final SafeResourceBundle bundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");
    private static String _contactTooltipFormat = null;

    public ContactTreeNode(CollaborationPrincipal principal) {
        this.setUserObject(principal);
        this.reload();
    }

    public String getName() {
        CollaborationPrincipal principal = this.getPrincipal();
        String displayName = this.getPrincipal().getDisplayName();
        if (displayName == null) {
            return "?";
        }
        String label = null;
        if (BuddyListManager.isAuthorizationReq(principal)) {
            label = StringUtility.substitute((String)bundle.getString("BuddyListPanel_user_label_txt_Authorize"), (String)"__MACRO1__", (String)displayName);
        } else {
            UserInfo ui = UserStatusManager.getUserInfoObject(principal.getUID());
            if (ui != null) {
                label = StringUtility.substitute((String)bundle.getString("BuddyListPanel_user_label_txt"), (String)"__MACRO1__", (String)displayName);
                label = StringUtility.substitute((String)label, (String)"__MACRO2__", (String)ui.curMsg);
                label = ui.isWatchedAny() ? StringUtility.substitute((String)label, (String)"__MACRO3__", (String)bundle.getString("BuddyListPanel_user_label_status_watch_indicator")) : StringUtility.substitute((String)label, (String)"__MACRO3__", (String)"");
            } else {
                label = StringUtility.substitute((String)bundle.getString("BuddyListPanel_user_label_txt_unknown"), (String)"__MACRO1__", (String)displayName);
            }
        }
        return label;
    }

    public String getToolTip() {
        CollaborationPrincipal principal = this.getPrincipal();
        if (BuddyListManager.isAuthorizationReq(principal)) {
            return bundle.getString("BuddyListPanel_user_tooltip_Authorize");
        }
        UserInfo ui = UserStatusManager.getUserInfoObject(principal.getUID());
        if (ui == null) {
            return bundle.getString("BuddyListPanel_user_default_tooltip_unknown");
        }
        String tmp = ui.getTooltip();
        if (tmp == null) {
            if (_contactTooltipFormat != null && !_contactTooltipFormat.equals("")) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                Enumeration e = principal.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    attributes.put(key, principal.getProperty(key));
                }
                tmp = _contactTooltipFormat;
                if (!attributes.isEmpty()) {
                    tmp = StringUtility.substituteMacros((String)_contactTooltipFormat, attributes, (String)"${attr:", (String)"}");
                    tmp = StringUtility.substituteMacros((String)tmp, (String)"${attr:", (String)"}", (String)"");
                }
                tmp = StringUtility.substitute((String)tmp, (String)"{displayname}", (String)principal.getDisplayName());
                tmp = StringUtility.substitute((String)tmp, (String)"{status}", (String)ui.curMsg);
                ui.setTooltip(tmp);
            } else {
                tmp = StringUtility.substitute((String)bundle.getString("BuddyListPanel_user_default_tooltip"), (String)"__MACRO1__", (String)principal.getDisplayName());
                tmp = StringUtility.substitute((String)tmp, (String)"__MACRO2__", (String)ui.curMsg);
            }
        }
        return tmp;
    }

    public Icon getOpenIcon() {
        return this.getLeafIcon();
    }

    public Icon getClosedIcon() {
        return this.getLeafIcon();
    }

    public Icon getLeafIcon() {
        UserInfo userInfo = UserStatusManager.getUserInfoObject(this.getPrincipal().getUID());
        if (userInfo == null) {
            return SwingImageManager.getIcon(2, (Object)this);
        }
        if (userInfo.isIdle()) {
            return SwingImageManager.getIcon(5, (Object)this);
        }
        if (userInfo.isAway()) {
            return SwingImageManager.getIcon(6, (Object)this);
        }
        if (userInfo.isOnLine()) {
            return SwingImageManager.getIcon(0, (Object)this);
        }
        if (userInfo.isPending()) {
            return SwingImageManager.getIcon(10, (Object)this);
        }
        if (userInfo.isBusy()) {
            return SwingImageManager.getIcon(12, (Object)this);
        }
        if (userInfo.isChat()) {
            return SwingImageManager.getIcon(13, (Object)this);
        }
        if (userInfo.isOffLineFwd()) {
            return SwingImageManager.getIcon(4, (Object)this);
        }
        return SwingImageManager.getIcon(2, (Object)this);
    }

    public void reload() {
    }

    public void accept(TreeNodeVisitor v) {
        v.visit(this);
    }

    public CollaborationPrincipal getPrincipal() {
        return (CollaborationPrincipal)this.getUserObject();
    }

    public String toString() {
        return this.getPrincipal().getDisplayName();
    }

    static {
        SafeResourceBundle brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        _contactTooltipFormat = brandBundle.getString("messenger.contact.tooltip.html");
    }
}

