/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.ContactTreeNode;
import com.iplanet.im.client.swing.communicator.LDAPGroupTreeNode;
import com.iplanet.im.client.swing.communicator.TreeNodeVisitor;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;

public class ContactFolderTreeNode
extends BaseTreeNode {
    private static Icon ICON_EXP;
    private static Icon ICON_COL;

    public ContactFolderTreeNode(String groupName) {
        this.setUserObject(groupName);
        if (ICON_EXP == null) {
            this._initializeIcons();
        }
        this.reload();
    }

    private void _initializeIcons() {
        ICON_EXP = SwingImageManager.getIcon(8, (Object)this);
        ICON_COL = SwingImageManager.getIcon(7, (Object)this);
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public Icon getOpenIcon() {
        return ICON_EXP;
    }

    public Icon getClosedIcon() {
        return ICON_COL;
    }

    public boolean isLeaf() {
        return false;
    }

    public void reload() {
        this.removeAllChildren();
        CollaborationPrincipal[] buddyListGroupContent = BuddyListManager.getBuddyListGroupElements(this.getName());
        if (buddyListGroupContent != null) {
            ArrayList<BaseTreeNode> list = new ArrayList<BaseTreeNode>(buddyListGroupContent.length);
            for (int i = 0; i < buddyListGroupContent.length; ++i) {
                UserInfo ui;
                if (buddyListGroupContent[i] instanceof CollaborationGroup) {
                    list.add(new LDAPGroupTreeNode(buddyListGroupContent[i]));
                    continue;
                }
                boolean add = true;
                if (!(Manager.SHOW_ONLY_OFFLINE && Manager.SHOW_PENDING_CONTACTS || BuddyListManager.isAuthorizationReq(buddyListGroupContent[i]) || (ui = UserStatusManager.getUserInfoObject(buddyListGroupContent[i].getUID())) == null)) {
                    if (ui.isOffLine() && !Manager.SHOW_ONLY_OFFLINE) {
                        add = false;
                    } else if (ui.isPending() && !Manager.SHOW_PENDING_CONTACTS) {
                        add = false;
                    }
                }
                if (!add) continue;
                list.add(new ContactTreeNode(buddyListGroupContent[i]));
            }
            Object[] nodes = list.toArray(new BaseTreeNode[list.size()]);
            StringUtility.sort((Object[])nodes);
            for (int i = 0; i < nodes.length; ++i) {
                this.add((MutableTreeNode)nodes[i]);
            }
        }
    }

    public void accept(TreeNodeVisitor v) {
        v.visit(this);
    }

    public String toString() {
        return this.getName();
    }
}

