/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.iIM;
import com.iplanet.im.client.jni.JNILink;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.swing.Alert;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.BuddyButtonPanel;
import com.iplanet.im.client.swing.communicator.BuddyExitPanel;
import com.iplanet.im.client.swing.communicator.BuddyListPanel;
import com.iplanet.im.client.swing.communicator.BuddyStatusPanel;
import com.iplanet.im.client.swing.communicator.ContactTreeNode;
import com.iplanet.im.client.swing.communicator.DefaultCommunicator;
import com.iplanet.im.client.swing.communicator.LDAPGroupTreeNode;
import com.iplanet.im.client.swing.communicator.RoomListPanel;
import com.iplanet.im.client.swing.config.PrivacySettingsPanel;
import com.iplanet.im.client.swing.config.Settings;
import com.iplanet.im.client.swing.dialogs.AboutDialog;
import com.iplanet.im.client.swing.dialogs.AddContact;
import com.iplanet.im.client.swing.dialogs.AddContactByUID;
import com.iplanet.im.client.swing.dialogs.AddRoomDialog;
import com.iplanet.im.client.swing.dialogs.AlertDialog;
import com.iplanet.im.client.swing.dialogs.AuthSubscription;
import com.iplanet.im.client.swing.dialogs.Status;
import com.iplanet.im.client.swing.dialogs.WatcherStatusDialog;
import com.iplanet.im.client.swing.login.ServiceRegistration;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.StatusWindow;
import com.iplanet.im.client.util.StickyFileChooser;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Message;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.PrivacyList;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Communicator
extends DefaultCommunicator
implements ChangeListener,
MenuListener,
PopupMenuListener {
    static SafeResourceBundle communicatorBundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");
    static SafeResourceBundle brandBundle = null;
    private SmartJPopupMenu popup;
    private ArrayList privacyArray = new ArrayList();
    private JMenuItem miProps;
    private JTabbedPane tabbedPane;
    private ArrayList customStatusMenuItems;
    private ArrayList customPrivacyMenuItems;
    private ArrayList customStatusTypes;
    private ArrayList customStatusMessages;
    private ArrayList tmpArryMenuItems;
    public static final String CONTACT_FILE_GROUP_SUFFIX = "~~~";
    private final String defaultContactsExtension = ".iim";
    private String defaultContactsFilename;
    private String currentImportContactsFilename = this.defaultContactsFilename = "mycontacts.iim";
    private String currentSaveContactsFilename = this.defaultContactsFilename;
    private boolean LOG_LAST_VIEWED = false;
    private static int MAX_POPUP_ITEM_LENGTH;
    private StatusWindow statusWin;
    private JLabel statusLabel;
    public static final int TAB_VIEW_LIST = 0;
    public static final int TAB_VIEW_ROOM = 1;
    BuddyListPanel pnlBuddy;
    static RoomListPanel pnlRooms;
    JPanel activePanel;
    BuddyButtonPanel pnlButtons;
    BuddyStatusPanel pnlStatus;
    BuddyExitPanel pnlTop;
    private JMenu fileMenu;
    private JMenu statusMenu;
    private JMenu privacyProfileMenu;
    private JCheckBoxMenuItem miprivacyVisible;
    private JMenuItem miPrivacyProfile;
    private ButtonGroup bgrpStatusMenu;
    private ButtonGroup bgrpEditBlockMenu;
    private ButtonGroup bgrpActiveBlockMenu;
    private ButtonGroup bgrpDefaultBlockMenu;
    private JRadioButtonMenuItem miStatusOnline;
    private JRadioButtonMenuItem miStatusAway;
    private JRadioButtonMenuItem miStatusAway1;
    private JRadioButtonMenuItem miStatusAway2;
    private JRadioButtonMenuItem miStatusAway3;
    private JRadioButtonMenuItem miStatusAway4;
    private JRadioButtonMenuItem miStatusInvisible;
    private JRadioButtonMenuItem miStatusBusy;
    private JMenuItem miStatusCustom;
    public JCheckBoxMenuItem miWatchUserStatus;
    private JMenuItem miNewGroup;
    private JMenuItem privacyMenu;
    private JMenuItem newBlockList;
    private JMenu activeBlockList;
    private JMenuItem showProfile;
    private JMenu editBlockList;
    private JMenu defaultBlockList;
    private JMenuItem miRenameGroup;
    private JMenuItem miDelete;
    private JMenuItem miAddUsers;
    private JMenu registerMenu;
    private JMenuItem miAddUsersById;
    private JMenuItem miSave;
    private JMenuItem miAuthorize_Again;
    private JMenuItem miRename_Contact;
    private JMenuItem miImport;
    private JMenuItem miAddConf;
    private JMenuItem miManage;
    private JMenuItem miUnsubscribe;
    private JMenuItem miViewOthers;
    private JMenuItem miExit;
    private JMenu viewMenu;
    private JCheckBoxMenuItem miToolBar;
    private JCheckBoxMenuItem miStatusBar;
    private JCheckBoxMenuItem miOfflineOnly;
    private JCheckBoxMenuItem miPending;
    private JMenu toolsMenu;
    private JMenuItem miChat;
    private JMenuItem miAlert;
    private JMenuItem miPoll;
    private JMenuItem miRoom;
    private JMenuItem miNews;
    private JMenuItem miFind;
    private JMenuItem miSettings;
    private JMenu helpMenu;
    private JMenuItem miHelp;
    private JMenuItem miAbout;
    private JMenuItem miInfo;
    private JMenuItem miPopupExpand;
    private JMenuItem miPopupCollapse;
    private JMenuItem miPopupChat;
    private JMenuItem miPopupSubscribe;
    private JMenuItem miPopupAlert;
    private JMenuItem miGtwLogin;
    private JMenuItem miGtwLogout;
    private JMenuItem miGtwUnregister;
    private JMenuBar menuBar;
    private JScrollPane scrollPane;
    private Thread _importContactsThread;
    private boolean _showInfoDialog = StringUtility.getBoolean((String)iIMPropsUtil.getShowInvisibleInfoDialog(Manager.NetLertProperties, "true"));
    private idleCheckThread idleCheck;
    private boolean killIdleCheckThread = false;
    AddContact addContact;
    public boolean startUserSearch = true;
    public boolean updateUserSearch = false;
    PrivacyList plist = null;
    private Hashtable _services = null;

    public static SafeResourceBundle getCommBundle() {
        return communicatorBundle;
    }

    public static SafeResourceBundle getBrandBundle() {
        return brandBundle;
    }

    public Communicator() {
        this.initComponents();
        this.pack();
        BuddyListManager.init();
        this.pnlBuddy.clear();
        this.pnlBuddy.expandGroups();
        Manager.SHOW_ONLY_OFFLINE = iIMPropsUtil.getShowOnlyOfflineContacts(CurrentUserManager.getCurrentUserProperties());
        this.doInit();
        Manager.Out("BUDDYLIST: COMMUNICATOR STARTED");
        UserStatusManager.setCurrentUserStatus("OPEN", "");
        if (JNILink.JNI_LOADED) {
            idleCheckThread idleCheck = new idleCheckThread();
            idleCheck.start();
        }
        this.requestDefaultFocus();
    }

    private void initComponents() {
        int effectiveRoomTabIndex;
        this.tabbedPane = new JTabbedPane();
        this.scrollPane = new JScrollPane();
        this.pnlButtons = new BuddyButtonPanel(this);
        this.pnlBuddy = new BuddyListPanel(this, this.pnlButtons);
        this.scrollPane.add(this.pnlBuddy);
        pnlRooms = null;
        this.pnlStatus = new BuddyStatusPanel(this);
        if (Manager.ALLOW_ROOM_ACCESS || Manager.ALLOW_ROOM_MANAGEMENT) {
            pnlRooms = new RoomListPanel(this);
        }
        this.popup = new SmartJPopupMenu();
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel pnlTab = new JPanel();
        this.getContentPane().add("North", this.pnlButtons);
        this.getContentPane().add("Center", this.tabbedPane);
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.tabbedPane.add(this.pnlBuddy);
            this.tabbedPane.setSelectedIndex(0);
            this.tabbedPane.setSelectedComponent(this.pnlBuddy);
            this.tabbedPane.setTitleAt(0, communicatorBundle.getString("contact_list"));
            effectiveRoomTabIndex = 1;
        } else {
            effectiveRoomTabIndex = 0;
        }
        if (Manager.ALLOW_ROOM_ACCESS || Manager.ALLOW_ROOM_MANAGEMENT) {
            this.tabbedPane.add(pnlRooms);
            this.tabbedPane.setTitleAt(effectiveRoomTabIndex, communicatorBundle.getString("conference"));
        }
        this.pnlButtons.setVisible(iIMPropsUtil.getShowToolBar(CurrentUserManager.getCurrentUserProperties()));
        this.displayStatusPanelAtPostion("South");
        if (!iIMPropsUtil.getShowStatusBar(CurrentUserManager.getCurrentUserProperties())) {
            this.pnlStatus.setVisible(false);
        }
        this.initStatusMenuItems();
        this.initMenuBar();
        this.populateMenuBar();
        this.listGateways();
        this.miPopupExpand = SwingUtils.menuItem(this, communicatorBundle, "mi_Expand", null, null);
        this.miPopupExpand.setFont(this.miPopupExpand.getFont().deriveFont(1));
        this.miPopupCollapse = SwingUtils.menuItem(this, communicatorBundle, "mi_Collapse", null, null);
        this.miPopupCollapse.setFont(this.miPopupCollapse.getFont().deriveFont(1));
        if (Manager.ALLOW_CHAT) {
            this.miPopupChat = SwingUtils.menuItem(this, communicatorBundle, "Chat", "Chat_M", "Chat_A");
            this.miPopupChat.setFont(this.miPopupChat.getFont().deriveFont(1));
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.miPopupAlert = SwingUtils.menuItem(this, this.miAlert.getText(), null, null);
            this.miPopupAlert.setFont(this.miPopupAlert.getFont().deriveFont(1));
        }
        this.miGtwLogin = SwingUtils.menuItem(this, communicatorBundle, "logon", null, null);
        this.miGtwLogin.setFont(this.miGtwLogin.getFont().deriveFont(1));
        this.miGtwLogout = SwingUtils.menuItem(this, communicatorBundle, "logoff", null, null);
        this.miGtwLogout.setFont(this.miGtwLogout.getFont().deriveFont(1));
        this.miGtwUnregister = SwingUtils.menuItem(this, communicatorBundle, "remove_service", null, null);
        this.miGtwUnregister.setFont(this.miGtwUnregister.getFont().deriveFont(1));
        this.tabbedPane.addChangeListener(this);
        this.popup.addPopupMenuListener(this);
    }

    private void listGateways() {
        try {
            PersonalStoreEntry[] gtw = Manager._personalStoreSession.search(1, "*", "gateway");
            if (gtw == null) {
                this.registerMenu.setEnabled(false);
            } else {
                this.registerMenu.removeAll();
                this._services = new Hashtable();
                for (int i = 0; i < gtw.length; ++i) {
                    JCheckBoxMenuItem tmpMenuItem = new JCheckBoxMenuItem(gtw[i].getDisplayName());
                    if (tmpMenuItem != null) {
                        tmpMenuItem.addActionListener(this);
                    }
                    this._services.put(gtw[i].getEntryId(), tmpMenuItem);
                    boolean selected = Manager._personalStoreSession.getEntry("gateway", gtw[i].getEntryId()) != null;
                    tmpMenuItem.setSelected(selected);
                    tmpMenuItem.setEnabled(!selected);
                    this.registerMenu.add(tmpMenuItem);
                }
            }
        }
        catch (CollaborationException e) {
            System.err.println("Communicator.initComponents(): CollaborationException thrown: " + (Object)((Object)e));
        }
    }

    private void setTitle() {
        String title = null;
        if (brandBundle != null) {
            title = brandBundle.getString("messenger.title");
        }
        if (title.compareTo("") == 0 || title == null) {
            title = communicatorBundle.getString("Communicator_title");
        }
        this.setTitle(title);
        this.getAccessibleContext().setAccessibleDescription(title);
    }

    public void doInit() {
        this.setTitle();
        this.pnlBuddy.refresh();
        if (Manager.ALLOW_ROOM_ACCESS || Manager.ALLOW_ROOM_MANAGEMENT) {
            pnlRooms.refresh();
        }
        this.setSize(iIMPropsUtil.getBuddyWindowDim(CurrentUserManager.getCurrentUserProperties()));
        this.setLocation(iIMPropsUtil.getBuddyWindowPoint(CurrentUserManager.getCurrentUserProperties()));
        Manager.Out("refreshUserList()");
        this.setVisible(true);
    }

    private void initStatusMenuItems() {
        this.bgrpStatusMenu = new ButtonGroup();
        this.miStatusOnline = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_onlineMenuItem"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_online.png", "/com/sun/im/desktop/default/presenceicons/cl_online.png", this));
        this.miStatusOnline.setSelected(true);
        this.miStatusAway = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_awayMenuItem"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", this));
        this.miStatusAway1 = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_awayMenuItem1"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", this));
        this.miStatusAway2 = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_awayMenuItem2"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", this));
        this.miStatusAway3 = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_awayMenuItem3"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", this));
        this.miStatusAway4 = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_awayMenuItem4"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", this));
        this.miStatusInvisible = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_invisibleMenuItem"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_offline.png", "/com/sun/im/desktop/default/presenceicons/cl_offline.png", this));
        this.miStatusBusy = new JRadioButtonMenuItem(communicatorBundle.getString("mi_status_busyMenuItem"), SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_dnd.png", "/com/sun/im/desktop/default/presenceicons/cl_dnd.png", this));
        this.miStatusCustom = SwingUtils.menuItem(null, communicatorBundle, "mi_status_customMenuItem", "mi_status_customMenuItem_M", null);
        this.bgrpStatusMenu.add(this.miStatusOnline);
        this.bgrpStatusMenu.add(this.miStatusBusy);
        this.bgrpStatusMenu.add(this.miStatusAway);
        this.bgrpStatusMenu.add(this.miStatusAway);
        this.bgrpStatusMenu.add(this.miStatusAway1);
        this.bgrpStatusMenu.add(this.miStatusAway2);
        this.bgrpStatusMenu.add(this.miStatusAway3);
        this.bgrpStatusMenu.add(this.miStatusAway4);
        this.bgrpStatusMenu.add(this.miStatusInvisible);
        this.miStatusOnline.addActionListener(this);
        this.miStatusBusy.addActionListener(this);
        this.miStatusAway.addActionListener(this);
        this.miStatusAway1.addActionListener(this);
        this.miStatusAway2.addActionListener(this);
        this.miStatusAway3.addActionListener(this);
        this.miStatusAway4.addActionListener(this);
        this.miStatusInvisible.addActionListener(this);
        this.miStatusCustom.addActionListener(this);
        this.customStatusTypes = new ArrayList();
        this.customStatusMessages = new ArrayList();
        this.buildCustomStatusMenuItems();
    }

    private void initMenuBar() {
        this.fileMenu = new JMenu(communicatorBundle.getString("File"));
        this.fileMenu.setMnemonic(communicatorBundle.getString("File_M").charAt(0));
        this.statusMenu = new JMenu(communicatorBundle.getString("Change_my_status"));
        this.privacyProfileMenu = new JMenu(communicatorBundle.getString("Privacy_Profile"));
        this.newBlockList = SwingUtils.menuItem(this, communicatorBundle, "New_Block_List", "New_Block_List_M", null);
        this.activeBlockList = new JMenu(communicatorBundle.getString("Active_Block_List"));
        this.editBlockList = new JMenu(communicatorBundle.getString("Edit_Block_List"));
        this.defaultBlockList = new JMenu(communicatorBundle.getString("Default_Block_List"));
        this.statusMenu.setMnemonic(communicatorBundle.getString("Change_my_status_M").charAt(0));
        this.privacyProfileMenu.setMnemonic(communicatorBundle.getString("Privacy_Profile_M").charAt(0));
        this.miNewGroup = SwingUtils.menuItem(this, communicatorBundle, "New_Contact_Group", "New_Contact_Group_M", null);
        this.miPrivacyProfile = SwingUtils.menuItem(this, communicatorBundle, "Manage_Profile", "Manage_Profile_M", null);
        this.miprivacyVisible = new JCheckBoxMenuItem(communicatorBundle.getString("mi_visible"), null);
        this.miRenameGroup = SwingUtils.menuItem(this, communicatorBundle, "Rename_Contact_Group", "Rename_Contact_Group_M", null);
        this.miDelete = SwingUtils.menuItem(this, communicatorBundle, "Delete", "Delete_M", "Delete_A");
        this.miAddUsers = SwingUtils.menuItem(this, communicatorBundle, "Add_Users", "Add_Users_M", null);
        this.registerMenu = new JMenu(communicatorBundle.getString("mi_register"));
        String mnemonicStr = communicatorBundle.getString("mi_register_M");
        if (mnemonicStr != null && !"".equals(mnemonicStr)) {
            this.registerMenu.setMnemonic(mnemonicStr.charAt(0));
        }
        this.miViewOthers = SwingUtils.menuItem(this, communicatorBundle, "Manage_Contacts", "Manage_Contacts_M", null);
        this.miAddUsersById = SwingUtils.menuItem(this, communicatorBundle, "Add_Users_by_ID", "Add_Users_by_ID_M", null);
        this.miSave = SwingUtils.menuItem(this, communicatorBundle, "Save_Contacts", "Save_Contacts_M", null);
        this.miAuthorize_Again = SwingUtils.menuItem(this, communicatorBundle, "mi_Request_Authorization_Again", "mi_Request_Authorization_Again_M", null);
        this.miRename_Contact = SwingUtils.menuItem(this, communicatorBundle, "Rename_Contact", "Rename_Contact_M", null);
        this.miImport = SwingUtils.menuItem(this, communicatorBundle, "Import_Contacts", "Import_Contacts_M", null);
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.miAddConf = SwingUtils.menuItem(this, communicatorBundle, "Add_Conference", "Add_Conference_M", null);
            if (Manager.ALLOW_ROOM_MANAGEMENT) {
                this.miManage = SwingUtils.menuItem(this, communicatorBundle, "Manage_Conference", "Manage_Conference_M", null);
            }
            this.miUnsubscribe = SwingUtils.menuItem(this, communicatorBundle, "btnDelete_text", "btnDelete_text_M", null);
        }
        this.miExit = SwingUtils.menuItem(this, communicatorBundle, "Exit", "Exit_M", "Exit_A");
        this.viewMenu = new JMenu(communicatorBundle.getString("View"));
        this.viewMenu.setMnemonic(communicatorBundle.getString("View_M").charAt(0));
        this.miToolBar = SwingUtils.checkBoxMenuItem(this, communicatorBundle, "Tool_Bar", "Tool_Bar_M", null);
        this.miStatusBar = SwingUtils.checkBoxMenuItem(this, communicatorBundle, "Status_Bar", "Status_Bar_M", null);
        this.miOfflineOnly = SwingUtils.checkBoxMenuItem(this, communicatorBundle, "Show_Only_Offline_Contacts", "Show_Only_Offline_Contacts_M", null);
        this.miPending = SwingUtils.checkBoxMenuItem(this, communicatorBundle, "Show_Pending_Contacts", "Show_Pending_Contacts_M", null);
        this.miToolBar.setSelected(iIMPropsUtil.getShowToolBar(CurrentUserManager.getCurrentUserProperties()));
        this.miStatusBar.setSelected(iIMPropsUtil.getShowStatusBar(CurrentUserManager.getCurrentUserProperties()));
        Manager.SHOW_ONLY_OFFLINE = iIMPropsUtil.getShowOnlyOfflineContacts(CurrentUserManager.getCurrentUserProperties());
        this.miOfflineOnly.setSelected(Manager.SHOW_ONLY_OFFLINE);
        Manager.SHOW_PENDING_CONTACTS = iIMPropsUtil.getShowPendingContacts(CurrentUserManager.getCurrentUserProperties());
        this.miPending.setSelected(Manager.SHOW_PENDING_CONTACTS);
        this.toolsMenu = new JMenu(communicatorBundle.getString("Tools"));
        this.toolsMenu.setMnemonic(communicatorBundle.getString("Tools_M").charAt(0));
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.miWatchUserStatus = SwingUtils.checkBoxMenuItem(this, communicatorBundle, "Alert_if_User_Status_Changes", "Alert_if_User_Status_Changes_M", null);
        }
        if (Manager.ALLOW_CHAT) {
            this.miChat = SwingUtils.menuItem(this, communicatorBundle, "Chat", "Chat_M", "Chat_A");
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.miAlert = SwingUtils.menuItem(this, communicatorBundle, "Alert", "Alert_M", "Alert_A");
        }
        if (Manager.ALLOW_POLLS) {
            this.miPoll = SwingUtils.menuItem(this, communicatorBundle, "Poll", "Poll_M", "Poll_A");
        }
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.miRoom = SwingUtils.menuItem(this, communicatorBundle, "Enter_Room", "Enter_Room_M", null);
            this.miRoom.setEnabled(false);
        }
        if (Manager.ALLOW_NEWS_ACCESS) {
            this.miNews = SwingUtils.menuItem(this, communicatorBundle, "News", "News_M", "News_A");
        }
        if (Manager.ALLOW_SETTINGS_CHANGES) {
            this.miSettings = SwingUtils.menuItem(this, communicatorBundle, "Settings", "Settings_M", "Settings_A");
        }
        this.miProps = SwingUtils.menuItem(this, "DEBUG: Show User Properties", null, null);
        this.helpMenu = new JMenu(communicatorBundle.getString("Help"));
        this.helpMenu.setMnemonic(communicatorBundle.getString("Help_M").charAt(0));
        this.miHelp = SwingUtils.menuItem(this, communicatorBundle, "Help_Topics", "Help_Topics_M", "Help_Topics_A");
        this.miAbout = SwingUtils.menuItem(this, communicatorBundle, "About", null, null);
        this.miInfo = SwingUtils.menuItem(this, communicatorBundle, "Info", null, null);
        this.miAbout.setMnemonic(communicatorBundle.getString("About_M").charAt(0));
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.menuBar.setToolTipText("");
        this.fileMenu.addMenuListener(this);
        this.privacyProfileMenu.addMenuListener(this);
        this.viewMenu.addMenuListener(this);
        this.toolsMenu.addMenuListener(this);
        this.helpMenu.addMenuListener(this);
        this.miprivacyVisible.addActionListener(this);
        this.miprivacyVisible.setSelected(true);
        this.registerMenu.addMenuListener(this);
        this.setContactMenu();
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.miWatchUserStatus.setEnabled(false);
        }
    }

    private void reloadViewMenu() {
        this.viewMenu.removeAll();
        this.viewMenu.add(this.miToolBar);
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.viewMenu.add(this.miStatusBar);
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.miOfflineOnly);
            this.viewMenu.add(this.miPending);
        }
        this.viewMenu.addSeparator();
        ApplicationManager.setFrameListInMenu(this, this.viewMenu);
    }

    private void updateStatusMenu() {
        this.statusMenu.removeAll();
        this.statusMenu.add(this.miStatusAway);
        this.statusMenu.add(this.miStatusOnline);
        this.statusMenu.add(this.miStatusBusy);
        this.statusMenu.addSeparator();
        this.statusMenu.add(this.miStatusAway1);
        this.statusMenu.add(this.miStatusAway2);
        this.statusMenu.add(this.miStatusAway3);
        this.statusMenu.add(this.miStatusAway4);
        if (this.customStatusMenuItems.size() > 0) {
            this.statusMenu.addSeparator();
            for (int i = 0; i < this.customStatusMenuItems.size(); ++i) {
                this.statusMenu.add((JMenuItem)this.customStatusMenuItems.get(i));
            }
        }
        this.statusMenu.addSeparator();
        this.statusMenu.add(this.miStatusCustom);
        this.statusMenu.addSeparator();
        this.statusMenu.add(this.miStatusInvisible);
    }

    private void updatePrivacyMenu() {
        this.buildPrivacyProfileMenuItems();
        this.privacyProfileMenu.removeAll();
        if (this.privacyArray != null) {
            Iterator i = this.privacyArray.iterator();
            while (i.hasNext()) {
                this.privacyProfileMenu.add((JMenuItem)i.next());
            }
        }
        this.privacyProfileMenu.addSeparator();
        this.privacyProfileMenu.add(this.miPrivacyProfile);
    }

    private void updateFileMenu(boolean forContactList) {
        this.fileMenu.removeAll();
        if (Manager.ALLOW_PRESENCE_PUBLISH) {
            this.fileMenu.add(this.statusMenu);
            this.fileMenu.add(this.privacyProfileMenu);
            this.fileMenu.add(this.registerMenu);
            this.fileMenu.add(this.miDelete);
            this.fileMenu.addSeparator();
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.fileMenu.add(this.miNewGroup);
            this.fileMenu.add(this.miRenameGroup);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.miAddUsers);
            this.fileMenu.add(this.miAddUsersById);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.miSave);
            this.fileMenu.add(this.miImport);
            this.fileMenu.addSeparator();
        }
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.fileMenu.add(this.miAddConf);
            if (Manager.ALLOW_ROOM_MANAGEMENT) {
                this.fileMenu.add(this.miManage);
            }
            this.fileMenu.add(this.miUnsubscribe);
            this.fileMenu.addSeparator();
        }
        this.fileMenu.add(this.miExit);
    }

    private void populateBlockList() {
        this.updatePrivacyMenu();
    }

    private void populateMenuBar() {
        this.updateFileMenu(true);
        this.updateStatusMenu();
        this.toolsMenu.removeAll();
        if (Manager.ALLOW_CHAT) {
            this.toolsMenu.add(this.miChat);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.toolsMenu.add(this.miAlert);
        }
        if (Manager.ALLOW_POLLS) {
            this.toolsMenu.add(this.miPoll);
        }
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.toolsMenu.add(this.miRoom);
        }
        if (Manager.ALLOW_NEWS_ACCESS) {
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.miNews);
        }
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.miWatchUserStatus);
        }
        this.toolsMenu.add(this.miAuthorize_Again);
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.miViewOthers);
        }
        if (Manager.ALLOW_SETTINGS_CHANGES) {
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.miSettings);
        }
        this.helpMenu.removeAll();
        this.helpMenu.add(this.miHelp);
        this.helpMenu.add(this.miAbout);
    }

    public void setUserGroupMenu() {
        if (this.pnlBuddy.isContactSelected()) {
            this.userSelected(this.pnlBuddy.getSelectedContactID());
        } else if (this.pnlBuddy.isContactFolderSelected()) {
            this.groupSelected();
        } else if (this.pnlBuddy.isLDAPGroupSelected()) {
            this.ldapGroupSelected();
        } else if (this.pnlBuddy.isGatewaySelected()) {
            this.gatewaySelected();
        } else if (this.pnlBuddy.isServiceFolderSelected()) {
            this.servicesFolderSelected();
        }
    }

    public void setRoomListMenu() {
        if (pnlRooms == null) {
            return;
        }
        if (pnlRooms.isSelectionEmpty()) {
            return;
        }
        this.conferenceSelected();
    }

    public void setContactMenu() {
        this.updateFileMenu(true);
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.miNewGroup.setEnabled(true);
            this.miRenameGroup.setEnabled(false);
            this.miDelete.setEnabled(false);
            this.miAddUsers.setEnabled(true);
            this.miAddUsersById.setEnabled(true);
            this.miSave.setEnabled(true);
            this.miAuthorize_Again.setEnabled(false);
            this.miImport.setEnabled(true);
        }
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.miRoom.setEnabled(false);
            this.miAddConf.setEnabled(false);
            if (Manager.ALLOW_ROOM_MANAGEMENT) {
                this.miManage.setEnabled(false);
            }
            this.miUnsubscribe.setEnabled(false);
        }
        this.miOfflineOnly.setEnabled(true);
        this.miPending.setEnabled(true);
        if (Manager.ALLOW_CHAT) {
            this.miChat.setEnabled(true);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.miAlert.setEnabled(true);
        }
        if (Manager.ALLOW_POLLS) {
            this.miPoll.setEnabled(true);
        }
        this.setUserGroupMenu();
    }

    public void setRoomMenu() {
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.miWatchUserStatus.setEnabled(false);
        }
        this.updateFileMenu(false);
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.miNewGroup.setEnabled(false);
            this.miRenameGroup.setEnabled(false);
            this.miDelete.setEnabled(false);
            this.miAddUsers.setEnabled(false);
            this.miAddUsersById.setEnabled(false);
            this.miSave.setEnabled(false);
            this.miAuthorize_Again.setEnabled(false);
            this.miImport.setEnabled(false);
        }
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.miAddConf.setEnabled(true);
        }
        if (Manager.ALLOW_ROOM_MANAGEMENT) {
            this.miManage.setEnabled(true);
        }
        this.miOfflineOnly.setEnabled(false);
        this.miPending.setEnabled(false);
        if (Manager.ALLOW_CHAT) {
            this.miChat.setEnabled(false);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.miAlert.setEnabled(false);
        }
        if (Manager.ALLOW_POLLS) {
            // empty if block
        }
        this.setRoomListMenu();
    }

    public void groupSelected() {
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.miWatchUserStatus.setEnabled(false);
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.miRenameGroup.setEnabled(true);
            this.miDelete.setEnabled(true);
            this.miAddUsers.setEnabled(true);
            this.miAddUsersById.setEnabled(true);
            this.miAuthorize_Again.setEnabled(false);
        }
    }

    public void ldapGroupSelected() {
        this.miWatchUserStatus.setEnabled(false);
        this.miRenameGroup.setEnabled(false);
        this.miDelete.setEnabled(true);
        this.miAuthorize_Again.setEnabled(false);
    }

    public void gatewaySelected() {
        this.miWatchUserStatus.setEnabled(false);
        this.miRenameGroup.setEnabled(false);
        this.miAuthorize_Again.setEnabled(false);
        this.miDelete.setEnabled(false);
        PersonalGateway gtw = this.pnlBuddy.getSelectedGateway();
        if (gtw != null) {
            UserInfo ui = UserStatusManager.getUserInfoObject(gtw.getEntryId());
            boolean loggedout = false;
            if (ui == null || ui.isOffLine()) {
                loggedout = true;
            }
            this.miGtwLogin.setEnabled(loggedout);
            this.miGtwLogout.setEnabled(!loggedout);
        }
    }

    public void servicesFolderSelected() {
        this.miWatchUserStatus.setEnabled(false);
        this.miRenameGroup.setEnabled(false);
        this.miAuthorize_Again.setEnabled(false);
        this.miDelete.setEnabled(false);
    }

    public void userSelected(String id) {
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            if (UserStatusManager.isUserSetForAlertAny(id)) {
                this.miWatchUserStatus.setSelected(true);
            } else {
                this.miWatchUserStatus.setSelected(false);
            }
            this.miWatchUserStatus.setEnabled(true);
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.miRenameGroup.setEnabled(false);
            BaseTreeNode node = this.pnlBuddy.getSelectedNode();
            if (node.getParent() instanceof LDAPGroupTreeNode) {
                this.miDelete.setEnabled(false);
            } else {
                this.miDelete.setEnabled(true);
            }
            if (UserCache.isRegularUser(id)) {
                this.miAuthorize_Again.setEnabled(false);
            } else {
                this.miAuthorize_Again.setEnabled(true);
            }
            this.miAddUsers.setEnabled(true);
            this.miAddUsersById.setEnabled(true);
        }
    }

    public void conferenceSelected() {
        this.miRoom.setEnabled(true);
        this.miUnsubscribe.setEnabled(true);
        this.pnlButtons.getChatButton().setEnabled(true);
    }

    public void conferencedeSelected() {
        this.miRoom.setEnabled(false);
        this.pnlButtons.getChatButton().setEnabled(false);
        this.miUnsubscribe.setEnabled(false);
    }

    public void reLoad() {
        this.doInit();
        this.pnlBuddy.reload();
    }

    public void focusGained(FocusEvent e) {
        this.hidePopup();
    }

    public void focusLost(FocusEvent e) {
        this.hidePopup();
    }

    public void windowIconified(WindowEvent e) {
        if (PlatformUtil.isWin() && iIMPropsUtil.getShowTrayIcon(CurrentUserManager.getCurrentUserProperties()) && iIMPropsUtil.getHideWhenMinimizedStatus(CurrentUserManager.getCurrentUserProperties()) && iIM._buddylist != null && iIM._buddylist.isTrayIconPresent()) {
            this.saveBuddyListSettings();
            this.setVisible(false);
        }
    }

    public void windowDeiconified(WindowEvent e) {
        this.setVisible(true);
    }

    public void windowClosing(WindowEvent event) {
        this.close(true);
    }

    public void refresh() {
        this.pnlButtons.refresh();
        if (Manager.ALLOW_ROOM_ACCESS || Manager.ALLOW_ROOM_MANAGEMENT) {
            pnlRooms.refresh();
        }
        this.saveBuddyListSettings();
        this.pnlBuddy.refresh();
    }

    public static RoomListPanel getRoomListPanel() {
        return pnlRooms;
    }

    public void setEnabledWatchUserStatusMenu(boolean value) {
        this.miWatchUserStatus.setEnabled(value);
    }

    public void setEnabledDeleteMenu(boolean value) {
        this.miDelete.setEnabled(value);
    }

    private void showUserProperties(PersonalContact[] nu) {
        try {
            PersonalProfile pp = Manager._personalStoreSession.getProfile(UserCache.getPrincipal(nu[0].getEntryId()));
            Properties p = UserPropsManager.loadUserProperties(pp);
            StringBuffer buf = new StringBuffer("*** Properties for " + nu[0].getEntryId());
            Enumeration<Object> e = p.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                buf.append(key);
                buf.append("    =    ");
                buf.append(p.get(key));
                buf.append("\n");
            }
            EditorUtility.viewSource(buf.toString(), StringUtility.substitute((String)communicatorBundle.getString("Properties_For_"), (String)"__MACRO__", (String)nu[0].getDisplayName()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e);
        }
    }

    public void changeFont() {
        this.pnlBuddy.changeFont();
        if (pnlRooms != null) {
            pnlRooms.changeFont();
        }
    }

    public void chat() {
        if (this.tabbedPane.getSelectedIndex() == -1) {
            return;
        }
        if (Manager.ALLOW_PRESENCE_ACCESS && this.tabbedPane.getSelectedIndex() == 0) {
            this.pnlBuddy.handleListChat();
        } else if (Manager.ALLOW_ROOM_ACCESS) {
            pnlRooms.enterSelectedRoom();
        }
    }

    public void poll() {
        this.pnlBuddy.handleListPoll();
    }

    public void sendAlert() {
        this.pnlBuddy.handleListAlert();
    }

    public void setVisible(boolean b) {
        if (b) {
            super.setVisible(b);
            if (iIMPropsUtil.getBuddyOnTopStatus(CurrentUserManager.getCurrentUserProperties())) {
                JNILink.alwaysOnTop(this, true);
            }
        } else {
            super.setVisible(b);
        }
    }

    public void alertReply() {
        System.out.println("TODO");
        System.out.println("TODO");
        System.out.println("TODO");
    }

    public void addUserByID(String group) {
        AddContactByUID addByUID = new AddContactByUID((Frame)this, true, group);
        addByUID.setVisible(true);
        addByUID.setModal(true);
        String id = addByUID.getUID();
        group = addByUID.getGroup();
        if (id == null || id.length() == 0) {
            return;
        }
        this.searchAndAdd(group, id, 0);
        this.repaint();
    }

    private void searchAndAdd(String group, String id, int searchType) {
        CollaborationPrincipal[] res = null;
        try {
            res = UserCache.search(id, searchType);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            res = null;
        }
        if (res == null || res.length == 0) {
            String msg = searchType == 0 ? communicatorBundle.getString("No_User_with_that_ID_was_not_found") : communicatorBundle.getString("No_Group_with_that_ID_was_not_found");
            JOptionPane.showMessageDialog(this, msg);
        } else if (res.length > 1) {
            this.startSearch(id, res, group);
        } else {
            if (res[0] instanceof CollaborationGroup) {
                String[] tmp = new String[]{"g:" + res[0].getUID()};
                this.addElementsToBuddyListGroup(tmp, group);
            } else {
                String[] tmp = new String[res.length];
                for (int i = 0; i < res.length; ++i) {
                    tmp[i] = res[i].getUID();
                }
                this.addElementsToBuddyListGroup(tmp, group);
            }
            BuddyListManager.setBuddyListGroupExpanded(group);
            this.updateBuddylist(false);
        }
    }

    public int dragAndDrop(String group, String user, String server) {
        try {
            PersonalStoreEntry[] res = Manager._personalStoreSession.search(0, user, "contact");
            if (server == null) {
                server = CurrentUserManager.getCurrentUserServer();
            }
            if (res == null || res.length == 0) {
                Manager.Out("Communicator.dragAndDrop(): Searching by name for DnD");
                res = Manager._personalStoreSession.search(1, user, "group");
            }
            if (res == null || res.length == 0 || res.length > 1) {
                return 1;
            }
            if (res[0] instanceof CollaborationGroup) {
                String[] tmp = new String[]{"g:" + res[0].getEntryId()};
                this.addElementsToBuddyListGroup(tmp, group);
                return 0;
            }
            String[] tmp = new String[res.length];
            for (int i = 0; i < res.length; ++i) {
                tmp[i] = res[i].getEntryId();
            }
            Manager.Out("Communicator.dragAndDrop(): Adding user: " + tmp[0] + " to group: " + group);
            this.addElementsToBuddyListGroup(tmp, group);
            return 0;
        }
        catch (CollaborationException e) {
            System.err.println("Communicator.dragAndDrop(): CollaborationException thrown: " + (Object)((Object)e));
            return 1;
        }
    }

    public void validatePopup() {
        this.hidePopup();
    }

    public final void hidePopup() {
        if (this.popup == null) {
            return;
        }
        this.popup.setVisible(false);
    }

    public void showListPopup(Component c, Point clickPoint) {
        this.validatePopup();
        String id = this.pnlBuddy.getSelectedID();
        if (id == null) {
            if (Manager.ALLOW_PRESENCE_ACCESS && this.tabbedPane.getSelectedIndex() == 0) {
                String msg = communicatorBundle.getString("First_select_a_user_or_contact_group");
                JOptionPane.showMessageDialog(this, msg);
            }
            return;
        }
        if (this.pnlBuddy.isContactFolderSelected() || this.pnlBuddy.isServiceFolderSelected()) {
            if (this.pnlBuddy.getSelectionExpansionState()) {
                this.popup.add(this.miPopupCollapse);
            } else {
                this.popup.add(this.miPopupExpand);
            }
            if (Manager.ALLOW_CONTACT_MANAGEMENT) {
                this.popup.addSeparator();
                this.popup.add(this.miNewGroup);
                this.popup.add(this.miRenameGroup);
                this.popup.add(this.miDelete);
                this.popup.add(this.miAuthorize_Again);
                this.popup.addSeparator();
                this.popup.add(this.miAddUsers);
                this.popup.add(this.miAddUsersById);
                this.popup.addSeparator();
            }
            if (Manager.ALLOW_CHAT) {
                this.popup.add(this.miChat);
            }
            if (Manager.ALLOW_SEND_ALERTS) {
                this.popup.add(this.miAlert);
            }
        } else if (this.pnlBuddy.isContactSelected() || this.pnlBuddy.isLDAPGroupSelected()) {
            if (Manager.ALLOW_PRESENCE_ACCESS) {
                this.popup.add(this.miWatchUserStatus);
                this.popup.addSeparator();
            }
            if (iIMPropsUtil.getUserClickAction(CurrentUserManager.getCurrentUserProperties()) == 1) {
                if (Manager.ALLOW_CHAT) {
                    this.popup.add(this.miChat);
                }
                if (Manager.ALLOW_SEND_ALERTS) {
                    this.popup.add(this.miPopupAlert);
                }
            } else {
                if (Manager.ALLOW_CHAT) {
                    this.popup.add(this.miPopupChat);
                }
                if (Manager.ALLOW_SEND_ALERTS) {
                    this.popup.add(this.miAlert);
                    this.popup.addSeparator();
                }
            }
            this.popup.add(this.miDelete);
            this.popup.add(this.miAuthorize_Again);
            this.popup.add(this.miRename_Contact);
            if (this.pnlBuddy.isContactSelected()) {
                CollaborationPrincipal[] selectedUsers = this.pnlBuddy.getSelectedUsers();
                if ((CurrentUserManager.isCurrentUserID(id) || !CurrentUserManager.isCurrentUserID(id) && UserAccessControl.isAdmin()) && selectedUsers != null && selectedUsers.length == 1 && Manager.ALLOW_SETTINGS_CHANGES) {
                    this.popup.addSeparator();
                    this.popup.add(this.miSettings);
                }
            }
            if (Manager.debugEnabled() && UserAccessControl.isAdmin()) {
                this.popup.addSeparator();
                this.popup.add(this.miProps);
            }
        } else if (this.pnlBuddy.isGatewaySelected()) {
            this.popup.add(this.miGtwLogin);
            this.popup.add(this.miGtwLogout);
            this.popup.add(this.miGtwUnregister);
            this.gatewaySelected();
        }
        this.popup.show(this.pnlBuddy, clickPoint);
    }

    public void showStatusChangePopup(Point clickPoint) {
        this.validatePopup();
        this.popup.add(this.miStatusAway);
        this.popup.add(this.miStatusOnline);
        this.popup.add(this.miStatusBusy);
        this.popup.addSeparator();
        this.popup.add(this.miStatusAway1);
        this.popup.add(this.miStatusAway2);
        this.popup.add(this.miStatusAway3);
        this.popup.add(this.miStatusAway4);
        if (this.customStatusMenuItems.size() > 0) {
            this.popup.addSeparator();
            for (int i = 0; i < this.customStatusMenuItems.size(); ++i) {
                this.popup.add((JMenuItem)this.customStatusMenuItems.get(i));
            }
        }
        this.popup.addSeparator();
        this.popup.add(this.miStatusCustom);
        this.popup.addSeparator();
        this.popup.add(this.miStatusInvisible);
        this.popup.show(this.pnlStatus, clickPoint);
    }

    private void buildCustomStatusMenuItems() {
        int i;
        JRadioButtonMenuItem tmpMenuItem = null;
        String toDisplay = null;
        this.retrieveCustomStatus();
        boolean selected = false;
        if (this.customStatusMenuItems != null) {
            for (i = 0; i < this.customStatusMenuItems.size(); ++i) {
                this.bgrpStatusMenu.remove((AbstractButton)this.customStatusMenuItems.get(i));
                if (selected) continue;
                selected = ((AbstractButton)this.customStatusMenuItems.get(i)).isSelected();
            }
        }
        this.customStatusMenuItems = new ArrayList();
        for (i = 0; i < this.customStatusMessages.size(); ++i) {
            toDisplay = (String)this.customStatusMessages.get(i);
            if (toDisplay.length() > MAX_POPUP_ITEM_LENGTH) {
                toDisplay = toDisplay.substring(0, MAX_POPUP_ITEM_LENGTH);
                toDisplay = toDisplay + communicatorBundle.getString("toBeContinued_Suffix");
            }
            if (((String)this.customStatusTypes.get(i)).equals("OPEN")) {
                tmpMenuItem = new JRadioButtonMenuItem(toDisplay, SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_online.png", "/com/sun/im/desktop/default/presenceicons/cl_online.png", this));
            } else if (((String)this.customStatusTypes.get(i)).equals("AWAY")) {
                tmpMenuItem = new JRadioButtonMenuItem(toDisplay, SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", this));
            }
            if (tmpMenuItem != null) {
                tmpMenuItem.addActionListener(this);
            }
            this.bgrpStatusMenu.add(tmpMenuItem);
            this.customStatusMenuItems.add(tmpMenuItem);
        }
        if (selected && this.customStatusMenuItems.size() > 0) {
            ((AbstractButton)this.customStatusMenuItems.get(0)).setSelected(true);
        }
    }

    private void buildPrivacyProfileMenuItems() {
        try {
            JCheckBoxMenuItem menuItem = null;
            String listName = null;
            this.privacyArray = new ArrayList();
            Vector privacyList = UserAccessControl.initPrivacyLists();
            if (privacyList.size() > 0) {
                for (int i = 0; i < privacyList.size(); ++i) {
                    listName = (String)privacyList.get(i);
                    menuItem = new JCheckBoxMenuItem(listName);
                    if (menuItem != null) {
                        menuItem.addActionListener(this);
                    }
                    if (UserAccessControl.isActivePrivacyList(listName)) {
                        menuItem.setSelected(true);
                    }
                    this.privacyArray.add(menuItem);
                }
            }
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void changeTab() {
    }

    public void saveBuddyListSettings() {
        iIMPropsUtil.setBuddyWindowDim(CurrentUserManager.getCurrentUserProperties(), this.getSize());
        iIMPropsUtil.setBuddyWindowPoint(CurrentUserManager.getCurrentUserProperties(), this.getLocation());
    }

    public void close() {
        Manager.Out("Communicator / close()");
        if (Manager.ALLOW_SETTINGS_CHANGES) {
            UserPropsManager.saveUserSettingsNow(CurrentUserManager.getCurrentProfile(), CurrentUserManager.getCurrentUserProperties(), true);
        }
        this.killIdleCheckThread = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Communicator.this.dispose();
            }
        });
    }

    public void dispose() {
        this.setVisible(false);
        if (this.statusWin != null) {
            this.statusWin.close();
            this.statusWin = null;
        }
        this.tabbedPane.removeChangeListener(this);
        DefaultCommunicator._changeListenerAdded = false;
        this.pnlStatus.close();
        this.pnlBuddy.close();
        this.pnlButtons.close();
        if (pnlRooms != null) {
            pnlRooms.close();
        }
        this.removeAll();
        super.dispose();
    }

    public void close(boolean show_dlg) {
        this.saveBuddyListSettings();
        if (show_dlg && ApplicationManager.isLastActiveObject()) {
            if (iIM.canExit(this)) {
                iIM.exit(this);
            }
        } else {
            this.setVisible(false);
            ApplicationManager.removeActiveObject(this);
        }
    }

    private String getAlertMsg(String uid) {
        String msg = StringUtility.substitute((String)communicatorBundle.getString("_Status_is_now_"), (String)"__MACRO__", (String)UserCache.getDisplayName(uid));
        UserInfo ui = UserStatusManager.getUserInfoObject(uid);
        return StringUtility.substitute((String)msg, (String)"__MACRO1__", (String)ui.curMsg);
    }

    private void sendStatusChangeAlert(String uid) {
        try {
            Manager.Out("Communicator.sendStatusChangeAlert)(): Alert status change On" + uid);
            Message m = Manager._messageSession.createMessage();
            String subj = StringUtility.substitute((String)communicatorBundle.getString("m_subject"), (String)"__MACRO__", (String)UserCache.getDisplayName(uid));
            String msgType = "text/html";
            String content = this.getAlertMsg(uid);
            ClientMessageFactory.updateMessage(m, content, msgType, subj);
            m.addRecipient(CurrentUserManager.getCurrentUserID());
            Alert.handleAlertMsg(m);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private void addStatusChangeListener(ActionEvent event, int type) {
        PersonalContact nu = this.pnlBuddy.getCurrentSelectedUser();
        if (nu == null) {
            return;
        }
        if (!Manager.ALLOW_PRESENCE_ACCESS) {
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        if (type == 1) {
            UserStatusManager.setUserWatchedOn(nu.getEntryId());
        } else if (type == 2) {
            UserStatusManager.setUserWatchedOff(nu.getEntryId());
        } else if (type == 0) {
            UserStatusManager.setUserWatchedAny(nu.getEntryId());
        } else {
            UserStatusManager.clearStatusWatch(nu.getEntryId());
        }
        this.pnlBuddy.updateBuddyList();
    }

    private PersonalContact getCurrentSelectedUser() {
        return this.pnlBuddy.getCurrentSelectedUser();
    }

    private void handleStatusOff(String uid) {
        if (!UserStatusManager.isFirstUpdate(uid)) {
            Sound.play(1);
        }
        if (UserStatusManager.isUserSetForAlertOff(uid) || UserStatusManager.isUserSetForAlertAny(uid)) {
            this.sendStatusChangeAlert(uid);
        }
    }

    private void handleStatusOn(String uid) {
        if (!UserStatusManager.isFirstUpdate(uid)) {
            Sound.play(2);
        }
        if (UserStatusManager.isUserSetForAlertOn(uid) || UserStatusManager.isUserSetForAlertAny(uid)) {
            this.sendStatusChangeAlert(uid);
        }
    }

    private void handleStatusAway(String uid) {
        if (!UserStatusManager.isFirstUpdate(uid)) {
            Sound.play(5);
        }
        if (UserStatusManager.isUserSetForAlertAny(uid)) {
            this.sendStatusChangeAlert(uid);
        }
    }

    private void handleStatusBusy(String uid) {
        if (!UserStatusManager.isFirstUpdate(uid)) {
            Sound.play(8);
        }
        if (UserStatusManager.isUserSetForAlertAny(uid)) {
            this.sendStatusChangeAlert(uid);
        }
    }

    private void viewWatchers() {
        WatcherStatusDialog watcherStatusDialog = new WatcherStatusDialog(this, communicatorBundle.getString("view_others"), true);
        watcherStatusDialog.setLocationRelativeTo(this);
        watcherStatusDialog.setVisible(true);
    }

    private void handleStatusChat(String uid) {
        if (!UserStatusManager.isFirstUpdate(uid)) {
            Sound.play(7);
        }
        if (UserStatusManager.isUserSetForAlertAny(uid)) {
            this.sendStatusChangeAlert(uid);
        }
    }

    private void handleUnknownStatus(String reason) {
        Manager.Out("UNKNOWN STATUS");
        Manager.Out(reason);
    }

    private void showStatusWin(String title) {
        Point p = new Point(10, 5);
        long lng = JNILink.getActiveWindow();
        if (this.statusWin == null) {
            JComboBox<String> scroll = new JComboBox<String>();
            scroll.addItem(title);
            this.statusWin = new StatusWindow(this, scroll, p, Color.white);
        } else {
            this.statusLabel.setText(title);
            this.statusWin.showStatusScreen();
        }
        iIM.setActiveWindow(lng);
    }

    private void setTitle(String uid, String status, String reason) {
        Manager.Out("Communicator.setTitle(): user: " + uid);
        if (uid.equals(CurrentUserManager.getCurrentUserID())) {
            return;
        }
        StringBuffer buf = new StringBuffer(UserCache.getDisplayName(uid));
        buf.append("-");
        UserInfo ui = UserStatusManager.getUserInfoObject(uid);
        if (ui.curStatus == status) {
            return;
        }
        if (reason == null || reason.equals("")) {
            buf.append(status);
        } else {
            buf.append(reason);
        }
        this.setTitle(buf.toString());
        int show_stat_win = iIMPropsUtil.getShowUserStatusWin(CurrentUserManager.getCurrentUserProperties());
        if (!this.isVisible() && show_stat_win == 2) {
            this.showStatusWin(buf.toString());
        } else if (show_stat_win == 1) {
            this.showStatusWin(buf.toString());
        }
        buf = null;
    }

    public void handleUserStatusChange(String uid, String status, String reason) {
        UserInfo ui = UserStatusManager.getUserInfoObject(uid);
        if (ui.prevStatus == ui.curStatus && ui.prevMsg.equals(ui.curMsg)) {
            return;
        }
        this.setTitle(uid, status, reason);
        if (status.equals("OPEN")) {
            this.handleStatusOn(uid);
        } else if (status.equals("CLOSED")) {
            this.handleStatusOff(uid);
        } else if (status.equals("AWAY")) {
            this.handleStatusAway(uid);
        } else if (status.equals("BUSY")) {
            this.handleStatusBusy(uid);
        } else if (status.equals("CHAT")) {
            this.handleStatusChat(uid);
        } else {
            this.handleUnknownStatus(reason);
        }
        this.pnlBuddy.notifyContactInfoChanged(uid);
    }

    public void notifyContactInfoChanged(String uid) {
        this.pnlBuddy.notifyContactInfoChanged(uid);
    }

    public void handleOnSubscribeRequest(Presence p) {
        boolean approve = false;
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = null;
        if (o.length <= 0) {
            Manager.error("No PresenceTuples in Presence object");
            return;
        }
        pt = (PresenceTuple)o[0];
        if (iIMPropsUtil.isAutomaticAddContactEnabled(CurrentUserManager.getCurrentUserProperties())) {
            String grp = iIMPropsUtil.getAddContactFolder(CurrentUserManager.getCurrentUserProperties());
            iIM.addUsersToBuddyListGroup(new String[]{pt.getContact()}, grp);
            iIM.getBuddyList().update(true);
            approve = true;
        } else if (iIMPropsUtil.isAutomaticApproveRequestEnabled(CurrentUserManager.getCurrentUserProperties())) {
            approve = true;
        } else {
            boolean addContacts = false;
            try {
                PersonalStoreEntry pse = Manager._personalStoreSession.getEntry("contact", pt.getContact());
                addContacts = pse == null;
            }
            catch (CollaborationException e) {
                Manager.error("Error in fetching the conatct from roster");
                return;
            }
            AuthSubscription auth = new AuthSubscription((Frame)this, p, addContacts);
            auth.setModal(true);
            auth.setVisible(true);
            int status = auth.getStatus();
            switch (status) {
                case 2: {
                    return;
                }
                case 0: {
                    approve = true;
                    break;
                }
                case 1: {
                    approve = false;
                }
            }
        }
        try {
            if (approve) {
                Manager._presenceSession.authorize(pt.getContact());
            } else {
                Manager._presenceSession.cancel(pt.getContact());
            }
        }
        catch (CollaborationException e) {
            Manager.error("Error in sending subscribe/unsubscribe");
        }
    }

    public int getCurrentViewType() {
        switch (this.tabbedPane.getSelectedIndex()) {
            case 0: {
                if (Manager.ALLOW_PRESENCE_ACCESS) {
                    return 0;
                }
                return 1;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public void updateBuddylist(boolean b) {
        this.pnlBuddy.updateBuddyList(b);
    }

    public void updateUserStatus(String[] uids, boolean watch) {
    }

    private void startSearch(String searchFor, CollaborationPrincipal[] u, String grp) {
        AddContact ac = new AddContact((Frame)this, false);
        ac.setVisible(true);
        ac.setModal(true);
        ac.refresh(searchFor, u, grp);
    }

    public void startSearch() {
        if (this.startUserSearch) {
            this.startUserSearch = false;
            this.updateUserSearch = true;
            this.addContact = new AddContact((Frame)this, false);
        }
        this.addContact.setVisible(true);
        JTextField jt = this.addContact.getTxtSearchPattern();
        jt.requestFocus();
    }

    public void deleteSelectedItem(boolean dnd) {
        this.pnlBuddy.deleteSelectedItems();
        this.pnlBuddy.updateBuddyList(true);
    }

    public void startRoomSearch() {
        AddRoomDialog ar = new AddRoomDialog((Frame)this, false);
        Vector v = RoomManager.getFavorites();
        if (v.size() == 0) {
            pnlRooms.addDefaultText();
            pnlRooms.setListEnable(false);
        }
    }

    public String getCurrentBuddyListGroup() {
        return this.pnlBuddy.getCurrentBuddyListGroup();
    }

    public void createBuddyListGroup() {
        String msg = communicatorBundle.getString("Enter_new_contact_group_name");
        String s = JOptionPane.showInputDialog(this, msg, communicatorBundle.getString("Enter_new_contact_group_name_title"), 3);
        if (s == null || s.equals("")) {
            return;
        }
        this.pnlBuddy.createBuddyListGroup(s);
        if (this.addContact != null && this.updateUserSearch) {
            this.addContact.addGroup(s);
        }
    }

    private void renameBuddyListGroup() {
        String oldName = this.pnlBuddy.getSelectedID();
        if (!BuddyListManager.isBuddyListGroup(oldName)) {
            return;
        }
        String msg = communicatorBundle.getString("Rename_contact_group_to");
        String newName = JOptionPane.showInputDialog(this, (Object)msg);
        if (newName == null) {
            return;
        }
        this.pnlBuddy.renameBuddyListGroup(oldName, newName);
        this.pnlBuddy.updateBuddyList();
    }

    public void addElementsToBuddyListGroup(CollaborationPrincipal[] p, String groupName) {
        String[] tmp = new String[]{groupName};
        this.addElementsToBuddyListGroups(p, tmp);
    }

    public void addElementsToBuddyListGroups(CollaborationPrincipal[] p, String[] groupNames) {
        if (!Manager.ALLOW_PRESENCE_ACCESS) {
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        for (int n = 0; n < groupNames.length; ++n) {
            BuddyListManager.addBuddyListGroupMembers(groupNames[n], p);
        }
        this.pnlBuddy.updateBuddyListGroups(groupNames);
    }

    public void addElementsToBuddyListGroup(String[] ids, String groupName) {
        String[] tmp = new String[]{groupName};
        this.addElementsToBuddyListGroups(ids, tmp);
    }

    public void addElementsToBuddyListGroups(String[] ids, String[] groupNames) {
        if (!Manager.ALLOW_PRESENCE_ACCESS) {
            return;
        }
        this.tabbedPane.setSelectedIndex(0);
        for (int n = 0; n < groupNames.length; ++n) {
            BuddyListManager.addBuddyListGroupMembers(groupNames[n], ids);
        }
    }

    public final void saveContacts() {
        File file = null;
        try {
            file = StickyFileChooser.chooseSaveFile(this, null, ".iim", communicatorBundle.getString("ContactList_fileType"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            JOptionPane.showMessageDialog(this, communicatorBundle.getString("Error_while_opening_file"));
            return;
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            String[] uids = BuddyListManager.getAllGroupsAndUserIDs();
            for (int i = 0; i < uids.length; ++i) {
                Manager.Out(uids[i]);
                if (BuddyListManager.isBuddyListGroup(uids[i])) {
                    out.println(CONTACT_FILE_GROUP_SUFFIX + uids[i]);
                    continue;
                }
                out.println(uids[i]);
            }
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, communicatorBundle.getString("Error_while_writing_to_file"));
            return;
        }
    }

    public final void importContacts() {
        File file = null;
        try {
            file = StickyFileChooser.chooseFile(this, ".iim", communicatorBundle.getString("ContactList_fileType"), communicatorBundle.getString("ImportDialog_title"), communicatorBundle.getString("ImportDialog_btnTxt"), communicatorBundle.getString("ImportDialog_btnTxt_M"));
        }
        catch (Exception e) {
            System.err.println("Communicator.importContacts(): Exception occured while opening file: " + e.getMessage());
            e.printStackTrace();
        }
        if (file == null || !file.isFile()) {
            JOptionPane.showMessageDialog(this, communicatorBundle.getString("Error_while_opening_file"));
            return;
        }
        if (this._importContactsThread == null || !this._importContactsThread.isAlive()) {
            this._importContactsThread = new Thread((Runnable)new ImportContactsRunnable(this, file), "import-contacts-thread");
            this._importContactsThread.start();
        }
    }

    private void searchForImport(String group, String id, String server) {
        try {
            CollaborationPrincipal[] res = Manager._personalStoreSession.searchPrincipals(0, id);
            if (res == null || res.length == 0) {
                return;
            }
            if (res.length > 1) {
                this.startSearch(id, res, group);
            } else if (res[0] instanceof CollaborationGroup) {
                String[] tmp = new String[]{"g:" + res[0].getUID()};
                this.addElementsToBuddyListGroup(tmp, group);
            } else {
                String[] tmp = new String[res.length];
                for (int i = 0; i < res.length; ++i) {
                    tmp[i] = res[i].getUID();
                }
                this.addElementsToBuddyListGroup(tmp, group);
            }
        }
        catch (CollaborationException e) {
            System.err.println((Object)e);
        }
    }

    private void changeStatus() {
        Status ns = new Status((Frame)this, this.getStatus(), this.getStatusString());
        ns.setModal(true);
        ns.setLocationRelativeTo(this);
        ns.setVisible(true);
        Manager.Out("Communicator/changeStatus(): ns: " + ns.getMessage());
        if (!ns.OK) {
            return;
        }
        if (ns.STATUS.equals("OPEN")) {
            ImageIcon icon = UserStatusManager.getIcon("OPEN", this);
            this.setCurrentStatus("OPEN", ns.getMessage(), icon, false);
        } else if (ns.STATUS.equals("AWAY")) {
            ImageIcon icon = UserStatusManager.getIcon("AWAY", this);
            this.setCurrentStatus("AWAY", ns.getMessage(), icon, false);
        }
        this.saveCustomStatus(ns.STATUS, ns.getMessage());
        ((JRadioButtonMenuItem)this.customStatusMenuItems.get(0)).setSelected(true);
    }

    private void _onCustomStatusSelected(String statusType, String statusMsg) {
        Properties p = CurrentUserManager.getCurrentUserProperties();
        String statusToCmp = statusType + iIMPropsUtil.getCustomStatusSeparator() + statusMsg;
        String tmpStr = null;
        for (int i = 0; i < this.customStatusMessages.size(); ++i) {
            tmpStr = iIMPropsUtil.getCustomUserStatus(p, i);
            if (statusToCmp.compareTo(tmpStr) != 0) continue;
            for (int j = 0; j < i; ++j) {
                iIMPropsUtil.setCustomUserStatus(p, i - j, iIMPropsUtil.getCustomUserStatus(p, i - j - 1));
            }
            iIMPropsUtil.setCustomUserStatus(p, 0, statusToCmp);
            break;
        }
        this.buildCustomStatusMenuItems();
        this.updateStatusMenu();
    }

    private void saveCustomStatus(String statusType, String statusMsg) {
        Properties p = CurrentUserManager.getCurrentUserProperties();
        String statusToStore = statusType + iIMPropsUtil.getCustomStatusSeparator() + statusMsg;
        String tmpStr = null;
        int i = 0;
        boolean j = false;
        for (i = 0; i < this.customStatusMessages.size(); ++i) {
            tmpStr = iIMPropsUtil.getCustomUserStatus(p, i);
            if (statusToStore.compareTo(tmpStr) != 0) continue;
            this._onCustomStatusSelected(statusType, statusMsg);
            return;
        }
        for (i = iIMPropsUtil.getMaxCustomStatus() - 1; i > 0; --i) {
            iIMPropsUtil.setCustomUserStatus(p, i, iIMPropsUtil.getCustomUserStatus(p, i - 1));
        }
        iIMPropsUtil.setCustomUserStatus(p, 0, statusToStore);
        this.buildCustomStatusMenuItems();
        this.updateStatusMenu();
    }

    private void retrieveCustomStatus() {
        String tmpStr = null;
        this.customStatusTypes = new ArrayList();
        this.customStatusMessages = new ArrayList();
        for (int i = 0; i < iIMPropsUtil.getMaxCustomStatus(); ++i) {
            tmpStr = iIMPropsUtil.getCustomUserStatus(CurrentUserManager.getCurrentUserProperties(), i);
            if (tmpStr == null) continue;
            this.customStatusTypes.add(tmpStr.substring(0, tmpStr.indexOf(iIMPropsUtil.getCustomStatusSeparator())));
            this.customStatusMessages.add(tmpStr.substring(tmpStr.indexOf(iIMPropsUtil.getCustomStatusSeparator()) + 1));
        }
    }

    public String getStatus() {
        return iIM.getPresenceStatus();
    }

    public String getStatusString() {
        return iIM.getPresenceStatusString();
    }

    public void changeStatusReconnecting() {
        Manager.Out("\n\n\n\n.... Connection Lost at Communicator", true);
        this.pnlStatus.setReconnecting(communicatorBundle.getString("pnlStatus_Reconnecting"));
    }

    public void updateReconnectStatusLabel(String countStr) {
        this.pnlStatus.setLabel(StringUtility.substitute((String)communicatorBundle.getString("pnlStatus_Reconnecting_Count"), (String)"__MACRO__", (String)countStr));
    }

    public void setCurrentStatus(String type, String msg, ImageIcon icon, boolean invokeLater) {
        Manager.Out("Communicator/setCurrentStatus: " + type + " " + msg);
        iIM.setPresenceStatus(type);
        iIM.setPresenceStatusString(msg);
        if (!"Invisible".equals(type)) {
            UserStatusManager.setCurrentUserStatusToServerNow(CurrentUserManager.getCurrUsrUIDWithResource(), type, msg);
        } else {
            UserStatusManager.setCurrentUserStatus(type, msg);
        }
        this.pnlBuddy.notifyContactInfoChanged(CurrentUserManager.getCurrentUserID());
        this.pnlStatus.setCurrentStatus(msg, type, icon, invokeLater);
    }

    public void resetLocalStatus() {
        this.setCurrentStatus(iIM.getPresenceStatus(), iIM.getPresenceStatusString(), iIM.getPresenceIcon(), false);
        this.pnlStatus.repaint();
        this.pnlStatus.updateUI();
        this.repaint();
    }

    public void sendInitialOnlinePresence() {
        ImageIcon icon = UserStatusManager.getIcon("OPEN", this);
        this.setCurrentStatus("OPEN", communicatorBundle.getString("Online"), icon, false);
        try {
            Collection entries = Manager._personalStoreSession.getEntries("gateway");
            if (entries != null || entries.size() == 0) {
                String[] rcpt = new String[entries.size()];
                int i = 0;
                Iterator itr = entries.iterator();
                while (itr.hasNext()) {
                    rcpt[i++] = ((PersonalStoreEntry)itr.next()).getEntryId();
                }
                UserStatusManager.setCurrentUserStatusToServerNow(CurrentUserManager.getCurrentUserID(), "OPEN", communicatorBundle.getString("Online"), rcpt);
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public void menuSelected(MenuEvent e) {
        if (e.getSource() == this.fileMenu) {
            this.fileMenu.revalidate();
        } else if (e.getSource() == this.viewMenu) {
            this.reloadViewMenu();
            this.viewMenu.revalidate();
        } else if (e.getSource() == this.toolsMenu) {
            this.toolsMenu.revalidate();
        } else if (e.getSource() == this.helpMenu) {
            this.helpMenu.revalidate();
        } else if (e.getSource() == this.privacyProfileMenu) {
            this.updatePrivacyMenu();
        } else if (e.getSource() == this.registerMenu) {
            this.listGateways();
        }
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Object object = event.getSource();
        try {
            if (object == this.miStatusOnline) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                ImageIcon icon = UserStatusManager.getIcon("OPEN", this);
                this.setCurrentStatus("OPEN", communicatorBundle.getString("Online"), icon, false);
            } else if (object == this.miStatusBusy) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusBusy"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                ImageIcon icon = UserStatusManager.getIcon("BUSY", this);
                this.setCurrentStatus("BUSY", communicatorBundle.getString("Busy"), icon, false);
            } else if (object == this.miStatusAway) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                ImageIcon icon = UserStatusManager.getIcon("AWAY", this);
                this.setCurrentStatus("AWAY", communicatorBundle.getString("Away"), icon, false);
            } else if (object == this.miStatusCustom) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                this.changeStatus();
                this.hidePopup();
            } else if (object == this.miStatusAway1) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                ImageIcon icon = UserStatusManager.getIcon("AWAY", this);
                this.setCurrentStatus("AWAY", communicatorBundle.getString("mi_status_awayMenuItem1"), icon, false);
            } else if (object == this.miStatusAway2) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                ImageIcon icon = UserStatusManager.getIcon("AWAY", this);
                this.setCurrentStatus("AWAY", communicatorBundle.getString("mi_status_awayMenuItem2"), icon, false);
            } else if (object == this.miStatusAway3) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                ImageIcon icon = UserStatusManager.getIcon("AWAY", this);
                this.setCurrentStatus("AWAY", communicatorBundle.getString("mi_status_awayMenuItem3"), icon, false);
            } else if (object == this.miStatusAway4) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                ImageIcon icon = UserStatusManager.getIcon("AWAY", this);
                this.setCurrentStatus("AWAY", communicatorBundle.getString("mi_status_awayMenuItem4"), icon, false);
            } else if (object == this.miStatusInvisible) {
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                UserInfo ui = UserStatusManager.getUserInfoObject(CurrentUserManager.getCurrentUserID());
                UserInfo.ResourceInfo ri = ui.getResourceInfo(CurrentUserManager.getCurrUsrUIDWithResource());
                if (ri != null && ri.getStatus().equals("Invisible")) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                String activePrivList = UserAccessControl.getActivePrivacyList();
                if (this._showInfoDialog && activePrivList != null && !activePrivList.equals(UserAccessControl.localizedVisibleToAll) && !activePrivList.equals(UserAccessControl.localizedInvisibleToAll) && !this.showInvisibleInfoDialog(activePrivList)) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                PrivacySettingsPanel.activatePrivacyList(UserAccessControl.localizedInvisibleToAll);
            } else if (Manager.ALLOW_PRESENCE_ACCESS && object == this.miWatchUserStatus) {
                if (this.miWatchUserStatus.isSelected()) {
                    this.addStatusChangeListener(event, 0);
                } else {
                    this.addStatusChangeListener(event, -1);
                }
            } else if (object == this.miNewGroup) {
                this.createBuddyListGroup();
                this.hidePopup();
            } else if (object == this.miRenameGroup) {
                this.renameBuddyListGroup();
                this.hidePopup();
            } else if (object == this.miDelete) {
                this.pnlBuddy.deleteSelectedItems();
                this.pnlBuddy.updateBuddyList(true);
            } else if (Manager.ALLOW_SETTINGS_CHANGES && object == this.miSettings) {
                CollaborationPrincipal[] cp = this.pnlBuddy.getSelectedUsers();
                if (cp != null && cp.length > 0) {
                    CollaborationPrincipal u = this.pnlBuddy.getSelectedUsers()[0];
                    if (UserAccessControl.isAdmin() || CurrentUserManager.isCurrentUserID(u.getUID())) {
                        iIM.showSettings(u, null);
                    } else {
                        iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), null);
                    }
                } else {
                    iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), null);
                }
            } else if (object == this.miAddUsers) {
                this.startSearch();
            } else if (object == this.miAddUsersById) {
                this.addUserByID(this.pnlBuddy.getSelectedID());
            } else if (Manager.ALLOW_CHAT && (object == this.miChat || object == this.miPopupChat)) {
                this.chat();
            } else if (Manager.ALLOW_SEND_ALERTS && (object == this.miAlert || object == this.miPopupAlert)) {
                this.sendAlert();
            } else if (Manager.ALLOW_POLLS && object == this.miPoll) {
                this.poll();
            } else if (Manager.ALLOW_ROOM_ACCESS && object == this.miRoom) {
                this.chat();
            } else if (Manager.ALLOW_NEWS_ACCESS && object == this.miNews) {
                iIM.showTopicView();
            } else if (object == this.miPrivacyProfile) {
                this.showPrivacyList();
                this.populateBlockList();
            } else if (object == this.miprivacyVisible) {
                try {
                    UserAccessControl.declineActivePrivacyList();
                }
                catch (Exception e) {}
            } else if (object == this.miHelp) {
                HelpManager.showHelp("mainview");
            } else if (object == this.miSave) {
                this.saveContacts();
            } else if (object == this.miAbout) {
                AboutDialog aboutDialog = new AboutDialog(this);
                aboutDialog.setVisible(true);
            } else if (object == this.miImport) {
                this.importContacts();
            } else if (object == this.miAuthorize_Again) {
                this.subscribeContacts();
            } else if (object == this.miRename_Contact) {
                this.renameContacts();
            } else if (object == this.miAddConf) {
                this.startRoomSearch();
            } else if (object == this.miManage) {
                this.manageConference();
            } else if (object == this.miUnsubscribe) {
                pnlRooms.unsubscribeSelectedRoom();
            } else if (object == this.miViewOthers) {
                this.viewWatchers();
            } else if (object == this.miExit) {
                if (iIM.canExit(this)) {
                    this.close(false);
                    iIM.exit(this);
                }
            } else if (object == this.miToolBar) {
                boolean nextState = this.miToolBar.isSelected();
                iIMPropsUtil.setShowToolBar(CurrentUserManager.getCurrentUserProperties(), nextState);
                this.pnlButtons.setVisible(nextState);
                this.validate();
                this.miToolBar.setSelected(nextState);
            } else if (object == this.miStatusBar) {
                boolean nextState = this.miStatusBar.isSelected();
                iIMPropsUtil.setShowStatusBar(CurrentUserManager.getCurrentUserProperties(), nextState);
                this.pnlStatus.setVisible(nextState);
                this.validate();
            } else if (object == this.miOfflineOnly) {
                boolean nextState;
                Manager.SHOW_ONLY_OFFLINE = nextState = this.miOfflineOnly.isSelected();
                iIMPropsUtil.setShowOnlyOfflineContacts(CurrentUserManager.getCurrentUserProperties(), nextState);
                this.pnlBuddy.updateBuddyList(true);
            } else if (object == this.miPending) {
                boolean nextState;
                Manager.SHOW_PENDING_CONTACTS = nextState = this.miPending.isSelected();
                iIMPropsUtil.setShowPendingContacts(CurrentUserManager.getCurrentUserProperties(), nextState);
                this.pnlBuddy.updateBuddyList(true);
            } else if (object == this.miProps) {
                this.showUserProperties((PersonalContact[])this.pnlBuddy.getSelectedUsers());
            } else if (object == this.miPopupExpand) {
                this.pnlBuddy.setSelectedGroupExpansion(true);
            } else if (object == this.miPopupCollapse) {
                this.pnlBuddy.setSelectedGroupExpansion(false);
            } else if (object == this.miGtwLogin) {
                PersonalGateway gtw = this.pnlBuddy.getSelectedGateway();
                UserStatusManager.setCurrentUserStatusToServerNow(CurrentUserManager.getCurrentUserID(), "OPEN", communicatorBundle.getString("Online"), new String[]{gtw.getEntryId()});
            } else if (object == this.miGtwLogout) {
                PersonalGateway gtw = this.pnlBuddy.getSelectedGateway();
                UserStatusManager.setCurrentUserStatusToServerNow(CurrentUserManager.getCurrentUserID(), "CLOSED", communicatorBundle.getString("Offline"), new String[]{gtw.getEntryId()});
            } else if (object == this.miGtwUnregister) {
                PersonalGateway gtw = this.pnlBuddy.getSelectedGateway();
                gtw.unregister((RegistrationListener)new ServiceRegistration(this, gtw.getEntryId()));
                gtw.remove();
                gtw.save();
            }
            Iterator i = this.privacyArray.iterator();
            while (i.hasNext()) {
                JCheckBoxMenuItem tmpMenuItem = (JCheckBoxMenuItem)i.next();
                if (object != tmpMenuItem) continue;
                String privListName = tmpMenuItem.getText();
                PrivacySettingsPanel.activatePrivacyList(privListName);
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (this._services != null) {
                Enumeration enumeration = this._services.keys();
                while (enumeration.hasMoreElements()) {
                    String uid = (String)enumeration.nextElement();
                    JCheckBoxMenuItem serviceMenuItem = (JCheckBoxMenuItem)this._services.get(uid);
                    if (object != serviceMenuItem) continue;
                    this.registerService(uid);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            for (int i2 = 0; i2 < this.customStatusMenuItems.size(); ++i2) {
                ImageIcon icon;
                if (object != this.customStatusMenuItems.get(i2)) continue;
                if (!Manager.isConnected()) {
                    JOptionPane.showMessageDialog(this, communicatorBundle.getString("pnlStatus_currentStatusAway"));
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                if (UserStatusManager.isStatusInvisible()) {
                    UserAccessControl.setPrevActiveProfileActive();
                }
                if (this.customStatusTypes.get(i2).equals("OPEN")) {
                    icon = UserStatusManager.getIcon("OPEN", this);
                    this.setCurrentStatus("OPEN", (String)this.customStatusMessages.get(i2), icon, false);
                } else if (this.customStatusTypes.get(i2).equals("AWAY")) {
                    icon = UserStatusManager.getIcon("AWAY", this);
                    this.setCurrentStatus("AWAY", (String)this.customStatusMessages.get(i2), icon, false);
                }
                this._onCustomStatusSelected((String)this.customStatusTypes.get(i2), (String)this.customStatusMessages.get(i2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void manageConference() {
        pnlRooms.manageDestination();
    }

    public void tellUserToSubscribe(Component parent) {
        String lines = communicatorBundle.getString("Empty_Conferences_1") + communicatorBundle.getString("Empty_Conferences_2") + communicatorBundle.getString("Empty_Conferences_3");
        String l5 = communicatorBundle.getString("Empty_Conferences_5");
        if (l5 != null) {
            lines = lines + l5;
        }
        JOptionPane.showMessageDialog(parent, lines);
    }

    public void stateChanged(ChangeEvent event) {
        Object o = event.getSource();
        if (o == this.tabbedPane) {
            Manager.Out("Communicator.stateChanged(): TabbedPane has changed state");
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.tabbedPane.getSelectedIndex() == 0 && Manager.ALLOW_PRESENCE_ACCESS) {
                if (this.miToolBar.isSelected()) {
                    this.pnlButtons.setVisible(true);
                    this.pnlButtons.setView(0);
                    this.setContactMenu();
                }
                this.pnlBuddy.refresh();
            } else if (Manager.ALLOW_ROOM_ACCESS || Manager.ALLOW_ROOM_MANAGEMENT) {
                pnlRooms.refresh();
                if (this.miToolBar.isSelected()) {
                    this.pnlButtons.setVisible(true);
                    this.pnlButtons.setView(1);
                }
                this.setRoomMenu();
                Vector v = RoomManager.getFavorites();
                if (v.size() == 0) {
                    pnlRooms.addDefaultText();
                    pnlRooms.setListEnable(false);
                } else if (v.size() > 0) {
                    pnlRooms.setListEnable(true);
                    pnlRooms.getlstRooms().setSelectionInterval(pnlRooms.getlstRooms().getSelectedIndex(), pnlRooms.getlstRooms().getSelectedIndex());
                } else {
                    pnlRooms.setListEnable(true);
                    pnlRooms.getlstRooms().setSelectionInterval(0, 0);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Communicator.this.requestDefaultFocus();
                }
            });
        }
    }

    public final void subscribeContacts() {
        try {
            CollaborationPrincipal[] cp = this.pnlBuddy.getSelectedUsers();
            for (int i = 0; i < cp.length; ++i) {
                if (Manager._personalStoreSession.getEntry("contact", cp[i].getUID()) == null) {
                    BuddyListManager.addBuddyListGroupMember("Server Group Members", cp[i]);
                    continue;
                }
                Manager._presenceSession.subscribe(cp[i].getUID());
            }
        }
        catch (CollaborationException coe) {
            coe.printStackTrace();
        }
    }

    private final void renameContacts() {
        CollaborationPrincipal p = this.pnlBuddy.getSelectedPrincipal();
        if (p == null) {
            return;
        }
        String msg = communicatorBundle.getString("Rename_contact_to");
        String newName = JOptionPane.showInputDialog(this, msg, p.getDisplayName());
        if (newName == null) {
            return;
        }
        try {
            BaseTreeNode node = this.pnlBuddy.getSelectedNode();
            if (node instanceof ContactTreeNode && Manager._personalStoreSession.getEntry("contact", p.getUID()) == null && node.getParent() instanceof LDAPGroupTreeNode) {
                BuddyListManager.addBuddyListGroupMember("Server Group Members", p, false);
            }
        }
        catch (CollaborationException e) {
            Manager.warning("Error when renaming contact " + (Object)((Object)e));
        }
        BuddyListManager.renameBuddyListElement(p, newName);
        this.pnlBuddy.updateBuddyList();
    }

    private final void displayStatusPanelAtPostion(String position) {
        this.getContentPane().remove(this.pnlStatus);
        this.pnlStatus.remove(this.pnlStatus.separator);
        if (!position.equals("North")) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            this.pnlStatus.add((Component)this.pnlStatus.separator, gridBagConstraints);
        }
        this.getContentPane().add((Component)this.pnlStatus, position);
        this.validate();
    }

    public boolean requestDefaultFocus() {
        switch (this.getCurrentViewType()) {
            case 0: {
                return this.pnlBuddy.requestDefaultFocus();
            }
            case 1: {
                return pnlRooms != null ? pnlRooms.requestDefaultFocus() : false;
            }
        }
        return this.pnlBuddy.requestDefaultFocus();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.popup.removeAll();
        this.populateMenuBar();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    private void showPrivacyList() {
        String privacy = Settings.getSettingsBundle().getString("Privacy");
        if (Manager.ALLOW_PRESENCE_ACCESS && this.pnlBuddy.getSelectedUsers().length > 0) {
            CollaborationPrincipal u = this.pnlBuddy.getSelectedUsers()[0];
            if (UserAccessControl.isAdmin() || CurrentUserManager.isCurrentUserID(u.getUID())) {
                iIM.showSettings(u, privacy);
            } else {
                Settings.displayNonAdminDialog();
                iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), privacy);
            }
        } else {
            iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), privacy);
        }
    }

    private void registerService(String jid) {
        try {
            PersonalStoreEntry[] pse = Manager._personalStoreSession.search(0, jid, "gateway");
            if (pse == null) {
                Manager.warning("The service entry is not found");
                return;
            }
            ((PersonalGateway)pse[0]).register((RegistrationListener)new ServiceRegistration(this, pse[0].getDisplayName()));
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public void showAccessDenied(String uid) {
        String msg = StringUtility.substitute((String)communicatorBundle.getString("access_denied"), (String)"__MACRO__", (String)UserCache.getDisplayName(uid));
        String title = communicatorBundle.getString("access_denied_title");
        Object[] options = new Object[]{communicatorBundle.getString("access_denied_close")};
        AlertDialog d = new AlertDialog(this, title, title, msg, null, SwingImageManager.getIcon("/com/iplanet/im/client/images/information.gif", (Object)this));
        d.setLocationRelativeTo(this);
        d.setVisible(true);
    }

    public boolean showInvisibleInfoDialog(String activePrivList) {
        String info = communicatorBundle.getString("privacy_active_invisible_information");
        String msg = StringUtility.substitute((String)info, (String)"__MACRO__", (String)activePrivList);
        Object[] message = new Object[2];
        message[0] = new JLabel("<html><body>" + msg + "</body></html>");
        ((JLabel)message[0]).setPreferredSize(new Dimension(300, 200));
        JCheckBox cb = new JCheckBox(communicatorBundle.getString("do_not_show_checkbox"));
        message[1] = cb;
        int result = JOptionPane.showOptionDialog(this, message, communicatorBundle.getString("privacy_active_invisible_info_title"), 2, 1, SwingImageManager.getIcon("/com/iplanet/im/client/images/warning.png", (Object)this), null, null);
        if (result != 0) {
            return false;
        }
        if (cb.isSelected()) {
            this._showInfoDialog = false;
            iIMPropsUtil.setShowInvisibleInfoDialog(Manager.NetLertProperties, StringUtility.getBooleanString((boolean)this._showInfoDialog));
            iIMPropsUtil.saveNetLertProperties(Manager.NetLertProperties, Manager._propFileName, Manager._auto_logon, true);
        }
        return true;
    }

    static {
        try {
            brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MAX_POPUP_ITEM_LENGTH = 50;
    }

    class idleCheckThread
    extends Thread {
        idleCheckThread() {
        }

        public void run() {
            Manager.Out("Started idleCheckThread");
            while (!Communicator.this.killIdleCheckThread) {
                if (iIMPropsUtil.getIdleTime(CurrentUserManager.getCurrentUserProperties()) == 0) {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (Throwable e) {}
                    continue;
                }
                Manager.Out("STATUS BEFORE isIdle: " + Communicator.this.getStatusString());
                Manager.Out("\n******************  CHECK IDLE: " + 60 * iIMPropsUtil.getIdleTime(CurrentUserManager.getCurrentUserProperties()) + " seconds");
                if (!JNILink.isIdle(60 * iIMPropsUtil.getIdleTime(CurrentUserManager.getCurrentUserProperties()))) {
                    Manager.Out("\n******** GOT BREAK ******");
                    break;
                }
                Manager.Out("STATUS just after isIdle: " + Communicator.this.getStatus() + " / " + Communicator.this.getStatusString());
                if (!Communicator.this.killIdleCheckThread && Communicator.this.getStatus().equals("OPEN")) {
                    Manager.Out("Reverting to Idle state...");
                    ImageIcon icon = UserStatusManager.getIcon("IDLE", this);
                    Communicator.this.setCurrentStatus("IDLE", communicatorBundle.getString("Idle"), icon, false);
                    Manager.Out("Finished reverting to Idle state...");
                }
                Manager.Out("\n******************  CHECK ACTIVE");
                if (!JNILink.isActive()) break;
                String str = iIM.getPreviousStatusString();
                Manager.Out("Last non-idle status AFTER isActive(): " + str);
                if (Communicator.this.killIdleCheckThread || !Communicator.this.getStatus().equals("IDLE")) continue;
                Manager.Out("Setting online label to: " + str);
                ImageIcon icon = UserStatusManager.getIcon("OPEN", this);
                Communicator.this.setCurrentStatus("OPEN", str, icon, false);
            }
            Manager.Out("Obsolete dead IdleCheckThread now terminating");
        }
    }

    class ImportContactsRunnable
    implements Runnable {
        private File _file = null;
        private Component _parentComponent = null;

        public ImportContactsRunnable(Component parentComponent, File file) {
            this._file = file;
            this._parentComponent = parentComponent;
        }

        public void run() {
            BufferedReader in;
            Manager.Out("Communicator.ImportContactsRunnable.run(): Thread starting");
            Communicator.this.miImport.setEnabled(false);
            Communicator.this.miSave.setEnabled(false);
            if (this._file == null) {
                System.err.print("Communicator.ImportContactsRunnable.run(): file is null!! Terminating thread.");
                return;
            }
            int nbLines = -1;
            try {
                in = new BufferedReader(new FileReader(this._file));
                while (in.readLine() != null) {
                    ++nbLines;
                }
            }
            catch (Exception e) {
                System.err.println("Communicator.ImportContactsRunnable.run(): Exception occured while counting number of entry: " + e.getMessage());
                e.printStackTrace();
                return;
            }
            switch (nbLines) {
                case -1: {
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    try {
                        String uid;
                        String group = BuddyListManager.ID_MY_CONTACTS;
                        int curLine = 1;
                        HashMap<String, String> htProgress = new HashMap<String, String>();
                        htProgress.put("nbEntries", String.valueOf(nbLines));
                        ProgressMonitor progressMon = new ProgressMonitor(this._parentComponent, communicatorBundle.getString("Import_contacts_progress_title"), "", 0, nbLines);
                        in = new BufferedReader(new FileReader(this._file));
                        while ((uid = in.readLine()) != null && !progressMon.isCanceled()) {
                            progressMon.setProgress(curLine);
                            htProgress.put("curEntry", String.valueOf(curLine));
                            progressMon.setNote(StringUtility.substituteMacros((String)communicatorBundle.getString("Import_contacts_progress_note"), htProgress, (String)"${attr:", (String)"}"));
                            if (uid.startsWith(Communicator.CONTACT_FILE_GROUP_SUFFIX)) {
                                group = uid.substring(3);
                                if (!BuddyListManager.isBuddyListGroup(group)) {
                                    Communicator.this.pnlBuddy.createBuddyListGroup(group, true, false);
                                }
                            } else {
                                String user = StringUtility.getLocalPartFromAddress((String)uid);
                                String server = StringUtility.getDomainFromAddress((String)uid, null);
                                Communicator.this.searchForImport(group, user, server);
                            }
                            ++curLine;
                        }
                        in.close();
                        break;
                    }
                    catch (Exception e) {
                        System.err.println("Communicator.ImportContactsRunnable.run(): Exception occured while reading file: " + e.getMessage());
                        return;
                    }
                }
            }
            Communicator.this.miImport.setEnabled(true);
            Communicator.this.miSave.setEnabled(true);
            Manager.Out("Communicator.ImportContactsRunnable.run(): Thread terminating");
        }
    }
}

