/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.ContactFolderTreeNode;
import com.iplanet.im.client.swing.communicator.ContactTreeNode;
import com.iplanet.im.client.swing.communicator.LDAPGroupTreeNode;
import com.iplanet.im.client.swing.communicator.TreeNodeVisitor;
import com.sun.im.service.CollaborationPrincipal;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ChatTreeNodeVisitor
extends TreeNodeVisitor {
    private ArrayList _principals;
    private JTree _tree;
    private boolean _ldapGroupExpanded;

    public ChatTreeNodeVisitor(JTree tree) {
        this._tree = tree;
        this.reset();
    }

    public void traverse(boolean ldapGroupExpanded) {
        if (!this._tree.isSelectionEmpty()) {
            this._ldapGroupExpanded = ldapGroupExpanded;
            TreePath[] paths = this._tree.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                ((BaseTreeNode)paths[i].getLastPathComponent()).accept(this);
            }
        }
    }

    public void visit(ContactTreeNode node) {
        if (!this._principals.contains(node.getPrincipal())) {
            this._principals.add(node.getPrincipal());
        }
    }

    public void visit(ContactFolderTreeNode node) {
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            ((BaseTreeNode)node.getChildAt(i)).accept(this);
        }
    }

    public void visit(LDAPGroupTreeNode node) {
        if (this._ldapGroupExpanded) {
            if (!node.isLoaded()) {
                node.load();
            }
            if (node.isLoaded()) {
                int count = node.getChildCount();
                for (int i = 0; i < count; ++i) {
                    ContactTreeNode n = (ContactTreeNode)node.getChildAt(i);
                    if (this._principals.contains(n.getPrincipal())) continue;
                    this._principals.add(n.getPrincipal());
                }
            }
        } else if (!this._principals.contains(node.getPrincipal())) {
            this._principals.add(node.getPrincipal());
        }
    }

    public CollaborationPrincipal[] getCollaborationPrincipals() {
        return this._principals.toArray(new CollaborationPrincipal[this._principals.size()]);
    }

    public void reset() {
        this._principals = new ArrayList();
        this._ldapGroupExpanded = true;
    }
}

