/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.util.AutoOrientationJPanel;
import com.iplanet.im.client.util.Orientation;
import com.iplanet.im.client.util.SafeResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class BuddyStatusPanel
extends AutoOrientationJPanel
implements MouseListener,
ActionListener {
    Communicator parent;
    private JButton btnStatus;
    private JLabel lblSecure;
    private JLabel lblArchive;
    private JButton btnMsg;
    public JSeparator separator;
    private Point _mousePos = null;
    private Point _menuPos = null;
    static SafeResourceBundle buddyStatusPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");

    public BuddyStatusPanel(Communicator c) {
        this.parent = c;
        this.initComponents();
        this.addMouseListener(this);
    }

    private void initComponents() {
        this.separator = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.btnStatus = new JButton();
        this.btnMsg = new JButton();
        this.btnStatus.setFocusable(false);
        this.btnMsg.setFocusPainted(false);
        this.btnMsg.setHorizontalTextPosition(2);
        this.btnMsg.setModel(this.btnStatus.getModel());
        this.btnMsg.setMargin(new Insets(2, 2, 2, 2));
        this.btnStatus.setMargin(new Insets(2, 2, 2, 2));
        this.btnStatus.setIconTextGap(10);
        this.btnStatus.setBorderPainted(false);
        this.btnStatus.setOpaque(false);
        this.btnMsg.setBorderPainted(false);
        this.btnMsg.setOpaque(false);
        this.btnStatus.setHorizontalTextPosition(10);
        this.setStatusIcon(SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_online.png", "/com/sun/im/desktop/default/presenceicons/sb_online.png", this));
        this.btnStatus.setText(buddyStatusPanelBundle.getString("btnStatus_text"));
        this.setStatusDownArrowIcon("/com/iplanet/im/client/images/d_arrow.gif");
        if (Orientation.isLeftToRight()) {
            this.add((Component)this.btnMsg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.add((Component)this.btnStatus, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add(this.btnMsg);
            this.add(this.btnStatus);
        }
        if (Manager.SERVER_ARCHIVE_ENABLED) {
            this.lblArchive = new JLabel();
            this.lblArchive.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/sb_archive.png", (Object)this));
            this.lblArchive.setToolTipText(buddyStatusPanelBundle.getString("iconArchive_toolTipText"));
            if (Orientation.isLeftToRight()) {
                this.add((Component)this.lblArchive, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 10), 0, 0));
            } else {
                this.add((Component)this.lblArchive, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 4), 0, 0));
            }
        }
        if (Manager._use_ssl || Manager.gateway_url != null) {
            this.lblSecure = new JLabel();
            this.lblSecure.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/sb_secure.png", (Object)this));
            this.lblSecure.setToolTipText(buddyStatusPanelBundle.getString("Secure_tool_tip"));
            if (Orientation.isLeftToRight()) {
                this.add((Component)this.lblSecure, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            } else {
                this.add((Component)this.lblSecure, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 4), 0, 0));
            }
        }
        this.btnStatus.addMouseListener(this);
        this.btnStatus.addActionListener(this);
        this.btnMsg.addMouseListener(this);
        this.btnMsg.addActionListener(this);
    }

    public void setCurrentStatus(final String msg, String status, final ImageIcon icon, boolean paintLater) {
        if (paintLater) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BuddyStatusPanel.this.updateStatusInUI(icon, msg);
                }
            });
        } else {
            this.updateStatusInUI(icon, msg);
        }
    }

    private void updateStatusInUI(ImageIcon icon, String msg) {
        this.setStatusIcon(icon);
        this.btnStatus.setText(msg);
        this.btnStatus.setToolTipText(msg);
    }

    public void setLabel(String msg) {
        this.btnStatus.setText(msg);
        this.btnStatus.setToolTipText(msg);
    }

    private void setStatusIcon(String iconStr) {
        this.btnMsg.setIcon(SwingImageManager.getIcon(iconStr, (Object)this));
    }

    private void setStatusDownArrowIcon(String iconStr) {
        this.btnStatus.setIcon(SwingImageManager.getIcon(iconStr, (Object)this));
    }

    private void setStatusIcon(ImageIcon icon) {
        this.btnMsg.setIcon(icon);
    }

    public void setReconnecting(String msg) {
        this.btnMsg.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_offline.png", "/com/sun/im/desktop/default/presenceicons/sb_offline.png", this));
        this.setLabel(msg);
    }

    public void setCurrentStatusAway(String msg) {
        iIM.setPresenceStatus("AWAY");
        iIM.setPresenceStatusString(msg);
        ImageIcon icon = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_away.png", "/com/sun/im/desktop/default/presenceicons/sb_away.png", this);
        this.setStatusIcon(icon);
        iIM.setPresenceIcon(icon);
        this.btnStatus.setText(msg);
        this.setStatusIcon(icon);
        this.btnStatus.setToolTipText(msg);
    }

    public void setCurrentStatusBusy(String msg) {
        iIM.setPresenceStatus("BUSY");
        iIM.setPresenceStatusString(msg);
        ImageIcon icon = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_dnd.png", "/com/sun/im/desktop/default/presenceicons/sb_dnd.png", this);
        this.setStatusIcon(icon);
        iIM.setPresenceIcon(icon);
        this.btnStatus.setText(msg);
        this.setStatusIcon(icon);
        this.btnStatus.setToolTipText(msg);
    }

    public void setCurrentStatusChat(String msg) {
        iIM.setPresenceStatus("CHAT");
        iIM.setPresenceStatusString(msg);
        ImageIcon icon = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_online.png", "/com/sun/im/desktop/default/presenceicons/sb_online.png", this);
        this.setStatusIcon(icon);
        iIM.setPresenceIcon(icon);
        this.btnStatus.setText(msg);
        this.setStatusIcon(icon);
        this.btnStatus.setToolTipText(msg);
    }

    public void setCurrentStatusIdle(String msg) {
        iIM.setPresenceStatus("IDLE");
        iIM.setPresenceStatusString(msg);
        ImageIcon icon = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_away.png", "/com/sun/im/desktop/default/presenceicons/sb_away.png", this);
        this.setStatusIcon(icon);
        iIM.setPresenceIcon(icon);
        this.btnStatus.setText(msg);
        this.setStatusIcon(icon);
        this.btnStatus.setToolTipText(msg);
    }

    public void setCurrentStatusOff(String msg) {
        iIM.setPresenceStatus("CLOSED");
        iIM.setPresenceStatusString(msg);
        ImageIcon icon = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_offline.png", "/com/sun/im/desktop/default/presenceicons/sb_offline.png", this);
        this.setStatusIcon(icon);
        iIM.setPresenceIcon(icon);
        this.btnStatus.setText(msg);
        this.setStatusIcon(icon);
        this.btnStatus.setToolTipText(msg);
    }

    public void setCurrentStatusOn(String msg) {
        iIM.setPresenceStatus("OPEN");
        iIM.setPresenceStatusString(msg);
        Manager.Out("SETCURRENTSTATUSON called with msg: " + msg);
        ImageIcon icon = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/sb_online.png", "/com/sun/im/desktop/default/presenceicons/sb_online.png", this);
        this.setStatusIcon(icon);
        iIM.setPresenceIcon(icon);
        this.btnStatus.setText(msg);
        this.btnStatus.setToolTipText(msg);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        Object src = e.getSource();
        if (Manager.ALLOW_PRESENCE_PUBLISH && src == this.btnStatus && SwingUtilities.isLeftMouseButton(e)) {
            this.btnStatus.setForeground(Color.black);
        }
    }

    public void mouseEntered(MouseEvent e) {
        Object src = e.getSource();
        if (src == this.btnStatus) {
            this.btnStatus.setForeground(Color.blue);
        }
    }

    public void mouseExited(MouseEvent e) {
        Object src = e.getSource();
        if (src == this.btnStatus) {
            this.btnStatus.setForeground(Color.black);
            this.repaint();
        }
    }

    public void close() {
        this.removeMouseListener(this);
        this.btnStatus.removeMouseListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (Manager.ALLOW_PRESENCE_CHANGES) {
            this.setCursor(new Cursor(3));
            Object object = event.getSource();
            if (object == this.btnStatus || object == this.btnMsg) {
                this.parent.showStatusChangePopup(new Point(this.btnStatus.getWidth() + 30, 8));
            }
            this.setCursor(new Cursor(0));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }
}

