/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserStatusManager;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class BuddyListTreeNode
implements MutableTreeNode {
    public static final int ID_TYPE_FOLDER = 1;
    public static final int ID_TYPE_SERVER_GROUP = 2;
    public static final int ID_TYPE_SERVER_USER = 4;
    public static final int ID_TYPE_SERVER_ELEMENT = 6;
    private Vector _children = new Vector();
    private MutableTreeNode _parentNode;
    private int _type;
    private String _label;
    private String _uid = null;
    private boolean _isExpanded;
    private CollaborationPrincipal _principal = null;
    private UserInfo _userInfo = null;

    public BuddyListTreeNode(Object o) {
        if (o instanceof String) {
            this._type = 1;
            this._label = (String)o;
            this._uid = (String)o;
            CollaborationPrincipal[] folderContent = BuddyListManager.getBuddyListGroupElements(this._label);
            if (folderContent != null) {
                int i = 0;
                for (i = 0; i < folderContent.length; ++i) {
                    this.add(folderContent[i]);
                }
                Manager.Out("BuddyListTreeNode.<init>: added: " + this._children.size() + " children to: " + this._label);
            }
        } else if (o instanceof CollaborationPrincipal) {
            if (o instanceof CollaborationGroup) {
                this._type = 2;
                Manager.Out("Type is group");
            } else {
                this._type = 4;
                Manager.Out("Type is user");
            }
            this._uid = ((CollaborationPrincipal)o).getUID();
            this._label = ((CollaborationPrincipal)o).getDisplayName();
        }
    }

    public BuddyListTreeNode(MutableTreeNode parentNode, Object o) {
        this(o);
        this._parentNode = parentNode;
        this._parentNode.insert(this, parentNode.getChildCount());
    }

    public Enumeration children() {
        return this._children.elements();
    }

    public void add(Object o) {
        new BuddyListTreeNode(this, o);
    }

    public boolean add(BuddyListTreeNode buddyListTreeNode) {
        if (this._children.contains(buddyListTreeNode)) {
            return false;
        }
        this.insert(buddyListTreeNode, this._children.size());
        return true;
    }

    public boolean getAllowsChildren() {
        return this._type == 1 || this._type == 2;
    }

    public TreeNode getChildAt(int param) {
        if (param >= this._children.size()) {
            return null;
        }
        return (BuddyListTreeNode)this._children.get(param);
    }

    public int getChildCount() {
        return this._children != null ? this._children.size() : 0;
    }

    public int getIndex(TreeNode treeNode) {
        if (!this._children.contains(treeNode)) {
            return -1;
        }
        return this._children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this._parentNode;
    }

    public boolean isLeaf() {
        boolean isLeaf = true;
        switch (this._type) {
            case 1: 
            case 2: {
                isLeaf = false;
            }
        }
        return isLeaf;
    }

    public String getUID() {
        return this._uid;
    }

    public void renameTo(String name) {
        if (this._type == 1) {
            this._uid = name;
            this._label = name;
            this._principal = null;
            this._userInfo = null;
        }
    }

    public CollaborationPrincipal getPrincipal() {
        if ((this._type & 6) == 0) {
            return null;
        }
        if (this._principal == null) {
            switch (this._type) {
                case 2: 
                case 4: {
                    this._principal = UserCache.getPrincipal(this._uid);
                }
            }
        }
        return this._principal;
    }

    public UserInfo getUserInfo() {
        if ((this._type & 6) == 0) {
            return null;
        }
        switch (this._type) {
            case 4: {
                this._userInfo = UserStatusManager.getUserInfoObject(this._uid);
            }
        }
        return this._userInfo;
    }

    public CollaborationPrincipal[] getPrincipals() {
        if ((this._type & 1) == 0) {
            return null;
        }
        return BuddyListManager.getBuddyListGroupElements(this._uid);
    }

    public int getNodeType() {
        return this._type;
    }

    public boolean isNodeType(int type) {
        return (type & this._type) != 0;
    }

    public String toString() {
        return this._label;
    }

    public void insert(MutableTreeNode mutableTreeNode, int param) {
        if (this._children.contains(mutableTreeNode)) {
            return;
        }
        this._children.insertElementAt(mutableTreeNode, param);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        int index = -1;
        index = this._children.indexOf(mutableTreeNode);
        if (index > -1) {
            this._children.remove(index);
        }
    }

    public void remove(int param) {
        MutableTreeNode child = (MutableTreeNode)this._children.get(param);
        if (child != null) {
            this._children.remove(child);
        }
        if (child instanceof BuddyListTreeNode) {
            BuddyListTreeNode buddyListTreeNode = (BuddyListTreeNode)child;
            switch (buddyListTreeNode.getNodeType()) {
                case 1: {
                    BuddyListManager.removeBuddyListGroup(buddyListTreeNode.toString());
                    break;
                }
                case 2: 
                case 4: {
                    BuddyListManager.removeBuddyListGroupMember(buddyListTreeNode.getUID(), this.toString());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void removeAllChildren() {
        this._children.clear();
        this._children.trimToSize();
    }

    public void removeFromParent() {
        if (this._parentNode == null) {
            return;
        }
        this._parentNode.remove(this);
        this._parentNode = null;
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
        this._parentNode = mutableTreeNode;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        if (this._type != 2) {
            return;
        }
        this._isExpanded = isExpanded;
    }

    public void setUserObject(Object obj) {
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        boolean equal = false;
        if (o instanceof BuddyListTreeNode) {
            BuddyListTreeNode buddyListTreeNode = (BuddyListTreeNode)o;
            equal = buddyListTreeNode.getNodeType() == this._type && buddyListTreeNode.getUID().equals(this._uid);
        }
        return equal;
    }
}

