/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.BuddyListTreeNode;
import com.iplanet.im.client.swing.communicator.ContactFolderTreeNode;
import com.iplanet.im.client.swing.model.BuddyListTreeModel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class BuddyListTree
extends JTree
implements TreeSelectionListener,
TreeExpansionListener {
    private static SafeResourceBundle bundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");
    private JScrollPane _scrollPane;
    private LinkedList _selectedUsers;
    private boolean _dnd;
    private static final int INITIAL_DELAY = 800;
    private static final int RESET_DELAY = 1000;

    public BuddyListTree(BuddyListTreeModel model) {
        super(model);
        this.setRootVisible(false);
        for (int i = this.treeModel.getChildCount(this.treeModel.getRoot()) - 1; i > -1; --i) {
            if (!BuddyListManager.isGroupExpanded(this.treeModel.getChild(this.treeModel.getRoot(), i).toString())) continue;
            Manager.Out("BuddyListTree.<init>: expanding row " + i + " of the tree");
            this.expandRow(i);
        }
        this.addTreeWillExpandListener(model);
        this.addTreeExpansionListener(this);
        this.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(true);
        ToolTipManager.sharedInstance().setInitialDelay(800);
        ToolTipManager.sharedInstance().setReshowDelay(1000);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public Object[] getSelectedElements() {
        if (this.getSelectionCount() <= 0) {
            return null;
        }
        TreePath[] selectedPaths = this.getSelectionPaths();
        Object lastPathComponent = null;
        LinkedList<CollaborationPrincipal> selectedElementsList = new LinkedList<CollaborationPrincipal>();
        for (int i = 0; i < selectedPaths.length; ++i) {
            BuddyListTreeNode buddyListTreeNode;
            lastPathComponent = selectedPaths[i].getLastPathComponent();
            if (!(lastPathComponent instanceof BuddyListTreeNode) || !(buddyListTreeNode = (BuddyListTreeNode)lastPathComponent).isNodeType(6)) continue;
            selectedElementsList.add(((BuddyListTreeNode)lastPathComponent).getPrincipal());
        }
        if (selectedElementsList.size() == 0) {
            return null;
        }
        Object[] selectedElements = new CollaborationPrincipal[selectedElementsList.size()];
        selectedElements = selectedElementsList.toArray(selectedElements);
        return selectedElements;
    }

    public CollaborationPrincipal getSelectedElement() {
        BuddyListTreeNode buddyListTreeNode;
        if (this.getSelectionCount() <= 0) {
            return null;
        }
        Object lastPathComponent = this.getSelectionPath().getLastPathComponent();
        if (lastPathComponent instanceof BuddyListTreeNode && (buddyListTreeNode = (BuddyListTreeNode)lastPathComponent).isNodeType(6)) {
            return ((BuddyListTreeNode)lastPathComponent).getPrincipal();
        }
        return null;
    }

    public CollaborationPrincipal[] getImplicitlySelectedUsers() {
        if (this.getSelectionCount() <= 0) {
            return null;
        }
        TreePath[] selectedPaths = this.getSelectionPaths();
        this._selectedUsers = new LinkedList();
        for (int i = 0; i < selectedPaths.length; ++i) {
            CollaborationPrincipal[] folderContent;
            this.removeDescendantSelectedPaths(selectedPaths[i], false);
            Object lastPathComponent = selectedPaths[i].getLastPathComponent();
            if (!(lastPathComponent instanceof BuddyListTreeNode)) continue;
            BuddyListTreeNode buddyListTreeNode = (BuddyListTreeNode)lastPathComponent;
            if (buddyListTreeNode.isNodeType(6)) {
                this.addToSelectedUsers(buddyListTreeNode.getPrincipal());
                continue;
            }
            if (!buddyListTreeNode.isNodeType(1) || (folderContent = buddyListTreeNode.getPrincipals()) == null) continue;
            for (int j = 0; j < folderContent.length; ++j) {
                this.addToSelectedUsers(folderContent[j]);
            }
        }
        CollaborationPrincipal[] selectedUsers = new CollaborationPrincipal[this._selectedUsers.size()];
        this._selectedUsers.toArray(selectedUsers);
        return selectedUsers;
    }

    private void addToSelectedUsers(CollaborationPrincipal element) {
        if (element instanceof CollaborationGroup) {
            CollaborationPrincipal[] usersInGroup = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(element.getUID());
            if (usersInGroup != null && usersInGroup.length > 0) {
                for (int i = 0; i < usersInGroup.length; ++i) {
                    if (this._selectedUsers.contains(usersInGroup[i])) continue;
                    this._selectedUsers.add(usersInGroup[i]);
                }
            }
        } else if (!this._selectedUsers.contains(element)) {
            this._selectedUsers.add(element);
        }
    }

    public String getSelectedID() {
        if (this.getSelectionCount() <= 0) {
            return null;
        }
        String id = null;
        Object lastPathComponent = this.getSelectionPath().getLastPathComponent();
        if (lastPathComponent instanceof BaseTreeNode) {
            id = ((BaseTreeNode)lastPathComponent).getName();
        }
        return id;
    }

    public String[] getSelectedIDs() {
        if (this.getSelectionCount() <= 0) {
            return null;
        }
        TreePath[] selectedPaths = this.getSelectionPaths();
        String[] selectedIDs = new String[selectedPaths.length];
        for (int i = 0; i < selectedPaths.length; ++i) {
            Object lastPathComponent = selectedPaths[i].getLastPathComponent();
            selectedIDs[i] = lastPathComponent instanceof BuddyListTreeNode ? ((BuddyListTreeNode)lastPathComponent).getUID() : null;
        }
        return selectedIDs;
    }

    public String[] getSelectedPrincipalIDs() {
        if (this.getSelectionCount() <= 0) {
            return null;
        }
        TreePath[] selectedPaths = this.getSelectionPaths();
        LinkedList<String> l = new LinkedList<String>();
        for (int i = 0; i < selectedPaths.length; ++i) {
            Object lastPathComponent = selectedPaths[i].getLastPathComponent();
            if (!(lastPathComponent instanceof BuddyListTreeNode)) continue;
            BuddyListTreeNode node = (BuddyListTreeNode)lastPathComponent;
            if (node.getNodeType() == 1) {
                CollaborationPrincipal[] folderContent = node.getPrincipals();
                if (folderContent == null) continue;
                for (int j = 0; j < folderContent.length; ++j) {
                    l.add(folderContent[j].getUID());
                }
                continue;
            }
            l.add(node.getPrincipal().getUID());
        }
        if (l.size() > 0) {
            String[] selectedIDs = new String[l.size()];
            selectedIDs = l.toArray(selectedIDs);
            return selectedIDs;
        }
        return null;
    }

    public String getElementIDAt(int index) {
        String id = null;
        Object lastPathComponent = this.getPathForRow(index).getLastPathComponent();
        if (lastPathComponent instanceof BuddyListTreeNode) {
            ((BuddyListTreeNode)lastPathComponent).getUID();
        }
        return id;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void deleteSelectedItems() {
        Manager.Out("DEBUG BuddyListTree.deleteSelectedItems()");
        if (this.isSelectionEmpty()) {
            return;
        }
        TreePath[] selectedPaths = this.getSelectionPaths();
        boolean isSelectionDeletable = true;
        int nFoldersToDelete = 0;
        for (int i = 0; i < selectedPaths.length; ++i) {
            MutableTreeNode parentMutableTreeNode;
            TreePath parentTreePath = selectedPaths[i].getParentPath();
            if (parentTreePath != null && parentTreePath.getLastPathComponent() != this.treeModel.getRoot() && ((BuddyListTreeNode)(parentMutableTreeNode = (MutableTreeNode)parentTreePath.getLastPathComponent())).isNodeType(2)) {
                return;
            }
            Object o = selectedPaths[i].getLastPathComponent();
            if (!(o instanceof BuddyListTreeNode) || ((BuddyListTreeNode)o).getNodeType() != 1) continue;
            ++nFoldersToDelete;
        }
        if (!isSelectionDeletable) {
            JOptionPane.showMessageDialog(this, bundle.getString("BuddyListPanel_Selection_contains_a_server_group_member"));
            return;
        }
        if (nFoldersToDelete >= BuddyListManager.getBuddyListGroups().length) {
            JOptionPane.showMessageDialog(this, bundle.getString("BuddyListPanel_You_need_at_least_one_group"));
            return;
        }
        int n = 0;
        while (true) {
            block13: {
                MutableTreeNode mutableTreeNode;
                block12: {
                    if (n >= selectedPaths.length) {
                        return;
                    }
                    Manager.Out("BuddyListPanel.deleteSelectedItems(): selectedPaths[n].getLastPathComponent().getClass(): " + selectedPaths[n].getLastPathComponent().getClass().getName());
                    mutableTreeNode = (MutableTreeNode)selectedPaths[n].getLastPathComponent();
                    if (!(mutableTreeNode instanceof BuddyListTreeNode)) break block12;
                    BuddyListTreeNode buddyListTreeNode = (BuddyListTreeNode)mutableTreeNode;
                    switch (buddyListTreeNode.getNodeType()) {
                        case 1: {
                            String msg = StringUtility.substitute((String)bundle.getString("BuddyListPanel_Confirm_BuddyListGroup_deletion"), (String)"__MACRO__", (String)buddyListTreeNode.toString());
                            String title = bundle.getString("Confirm_Delete");
                            int confirm = JOptionPane.showConfirmDialog(this, msg, title, 0);
                            if (confirm == 0) {
                                BuddyListManager.removeBuddyListGroup(buddyListTreeNode.getUID());
                                break;
                            }
                            break block13;
                        }
                        case 4: {
                            String userdeletemsg = StringUtility.substitute((String)bundle.getString("delete_user_list_message"), (String)"__MACRO__", (String)buddyListTreeNode.toString());
                            String titledelete = bundle.getString("Confirm_Delete");
                            int confirmdelete = JOptionPane.showConfirmDialog(this, userdeletemsg, titledelete, 0);
                            if (confirmdelete != 0) break block13;
                        }
                    }
                }
                this.removeDescendantSelectedPaths(selectedPaths[n], true);
                ((DefaultTreeModel)this.treeModel).removeNodeFromParent(mutableTreeNode);
            }
            ++n;
        }
    }

    public void expandGroups() {
        MutableTreeNode rootNode = (MutableTreeNode)((DefaultTreeModel)this.treeModel).getRoot();
        for (int i = this.treeModel.getChildCount(rootNode) - 1; i > -1; --i) {
            BaseTreeNode node = (BaseTreeNode)rootNode.getChildAt(i);
            if (!BuddyListManager.isGroupExpanded(node.getName())) continue;
            this.expandRow(i);
        }
    }

    public void reloadBuddyListGroup(String groupName) {
        MutableTreeNode rootNode = (MutableTreeNode)((DefaultTreeModel)this.treeModel).getRoot();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            ContactFolderTreeNode buddyListTreeNode;
            if (!(rootNode.getChildAt(i) instanceof ContactFolderTreeNode) || !(buddyListTreeNode = (ContactFolderTreeNode)rootNode.getChildAt(i)).getName().equals(groupName)) continue;
            buddyListTreeNode.reload();
            ((DefaultTreeModel)this.treeModel).nodeStructureChanged(buddyListTreeNode);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.isSelectionEmpty()) {
            iIM._buddylist.getCommunicator().setEnabledWatchUserStatusMenu(false);
            iIM._buddylist.getCommunicator().setEnabledDeleteMenu(false);
        } else {
            iIM._buddylist.getCommunicator().setEnabledWatchUserStatusMenu(true);
            iIM._buddylist.getCommunicator().setEnabledDeleteMenu(true);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath path = treeExpansionEvent.getPath();
        if (path.getLastPathComponent() instanceof ContactFolderTreeNode) {
            ContactFolderTreeNode buddyListTreeNode = (ContactFolderTreeNode)path.getLastPathComponent();
            BuddyListManager.setBuddyListGroupExpansion(buddyListTreeNode.getName(), false);
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath path = treeExpansionEvent.getPath();
        if (path.getLastPathComponent() instanceof ContactFolderTreeNode) {
            ContactFolderTreeNode buddyListTreeNode = (ContactFolderTreeNode)path.getLastPathComponent();
            BuddyListManager.setBuddyListGroupExpansion(buddyListTreeNode.getName(), true);
        }
    }

    public void setModel(BuddyListTreeModel model) {
        TreeWillExpandListener[] t = this.getTreeWillExpandListeners();
        for (int i = 0; i < t.length; ++i) {
            this.removeTreeWillExpandListener(t[i]);
        }
        this.addTreeWillExpandListener(model);
        super.setModel(model);
    }
}

