/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.BaseTreeNode;
import com.iplanet.im.client.swing.communicator.BuddyButtonPanel;
import com.iplanet.im.client.swing.communicator.BuddyListTree;
import com.iplanet.im.client.swing.communicator.BuddyListTreeCellRenderer;
import com.iplanet.im.client.swing.communicator.ChatTreeNodeVisitor;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.communicator.ContactFolderTreeNode;
import com.iplanet.im.client.swing.communicator.ContactTreeNode;
import com.iplanet.im.client.swing.communicator.CopyTreeNodeVisitor;
import com.iplanet.im.client.swing.communicator.DeleteTreeNodeVisitor;
import com.iplanet.im.client.swing.communicator.DragTreeNodeVisitor;
import com.iplanet.im.client.swing.communicator.DropTreeNodeVisitor;
import com.iplanet.im.client.swing.communicator.GatewayTreeNode;
import com.iplanet.im.client.swing.communicator.LDAPGroupTreeNode;
import com.iplanet.im.client.swing.communicator.MoveTreeNodeVisitor;
import com.iplanet.im.client.swing.communicator.RootTreeNode;
import com.iplanet.im.client.swing.communicator.ServicesFolderTreeNode;
import com.iplanet.im.client.swing.model.BuddyListTreeModel;
import com.iplanet.im.client.util.AutoOrientationJPanel;
import com.iplanet.im.client.util.ImagePaintingViewport;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BuddyListPanel
extends AutoOrientationJPanel
implements ActionListener,
MouseListener,
DragSourceListener,
DragGestureListener,
DropTargetListener,
KeyListener,
PropertyChangeListener {
    static SafeResourceBundle buddyListPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");
    private Communicator parent;
    private BuddyButtonPanel buttonPanel;
    private Object[] _draggedValues;
    private int ACTION_MOVE_COPY = 0;
    private MouseEvent firstMouseEvent = null;
    private ChatTreeNodeVisitor _chatTreeNodeVisitor;
    TreeNode dragTarget;
    DropTargetDragEvent dropTarget;
    private JScrollPane buddyScroll = new JScrollPane();
    private ImagePaintingViewport imagePaintingVP;
    private BuddyListTree tree;
    private BuddyListTreeCellRenderer treeCellRenderer = null;

    public BuddyListPanel(Communicator parent, BuddyButtonPanel p) {
        Manager.Out("DEBUG: BuddyListPanel.<init>");
        this.parent = parent;
        this.buttonPanel = p;
        this.initComponents();
        if (!PlatformUtil.isMac() || !PlatformUtil.isJDK1_3()) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this.tree, 3, this);
            DropTarget treeDropTarget = new DropTarget(this.tree, this);
        }
    }

    private void setupRendererFont(BuddyListTreeCellRenderer tcr) {
        Font f;
        if (tcr.getFont() == null) {
            Manager.Out("treeCellRenderer.getFont() was null");
            f = new Font("Dialog", 0, 10);
            Manager.Out("treeCellRenderer.getFont() 1: " + this.treeCellRenderer.getFont());
        } else {
            f = tcr.getFont();
        }
        Properties p = CurrentUserManager.getCurrentUserProperties();
        Integer i = new Integer(iIMPropsUtil.getCommunicatorFontSize(p));
        f = f.deriveFont(0, i.floatValue());
        Color col = iIMPropsUtil.getCommunicatorFontColor(p);
        tcr.setTextSelectionColor(col);
        tcr.setTextNonSelectionColor(col);
        tcr.setFont(f);
    }

    private void initComponents() {
        this.tree = new BuddyListTree(new BuddyListTreeModel());
        this._chatTreeNodeVisitor = new ChatTreeNodeVisitor(this.tree);
        this.tree.setModel(this._createTreeModel(this.tree));
        this.tree.addKeyListener(this);
        this._addTreeWillExpandListener();
        this.treeCellRenderer = new BuddyListTreeCellRenderer();
        this.setupRendererFont(this.treeCellRenderer);
        this.setLayout(new GridBagLayout());
        Insets ins = new Insets(0, 2, 0, 2);
        this.imagePaintingVP = new ImagePaintingViewport();
        this.buddyScroll.setViewport(this.imagePaintingVP);
        this._loadBgTexIcon();
        UserPropsManager.addPropertyChangeListener(this);
        this.buddyScroll.setOpaque(true);
        this.add((Component)this.buddyScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.tree.setCellRenderer(this.treeCellRenderer);
        this.buddyScroll.setViewportView(this.tree);
        this.tree.addMouseListener(this);
        this.buddyScroll.getVerticalScrollBar().addMouseListener(this);
    }

    private void _addTreeWillExpandListener() {
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                LDAPGroupTreeNode node;
                TreePath path = event.getPath();
                Object o = path.getLastPathComponent();
                if (o instanceof LDAPGroupTreeNode && !(node = (LDAPGroupTreeNode)o).isLoaded()) {
                    node.load();
                    ((DefaultTreeModel)BuddyListPanel.this.tree.getModel()).nodeStructureChanged(node);
                }
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
    }

    private DefaultTreeModel _createTreeModel(JTree tree) {
        DefaultTreeModel model = new DefaultTreeModel(new RootTreeNode(tree));
        return model;
    }

    private void _reload() {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        BaseTreeNode root = (BaseTreeNode)model.getRoot();
        root.reload();
        model.nodeStructureChanged(root);
    }

    public void close() {
        this.tree.removeKeyListener(this);
        UserPropsManager.removePropertyChangeListener(this);
    }

    public void reload() {
        this.clear();
        BuddyListManager.reload(true);
    }

    public void clear() {
        if (this.tree != null) {
            this.tree.clearSelection();
            this.tree.setModel(this._createTreeModel(this.tree));
        }
    }

    public void refresh() {
    }

    public void changeFont() {
        Manager.Out("BuddyListPanel.changeFont(): iIMPropsUtil.getCommunicatorFontSize(CurrentUserManager.getCurrentUserProperties()): " + iIMPropsUtil.getCommunicatorFontSize(CurrentUserManager.getCurrentUserProperties()));
        Manager.Out("BuddyListPanel.changeFont(): iIMPropsUtil.getCommunicatorFontColor(CurrentUserManager.getCurrentUserProperties()): " + iIMPropsUtil.getCommunicatorFontColor(CurrentUserManager.getCurrentUserProperties()).toString());
        this.setupRendererFont(this.treeCellRenderer);
        this.updateBuddyList(false);
    }

    public CollaborationPrincipal[] getAllElements() {
        return (CollaborationPrincipal[])StringUtility.sort((Object[])BuddyListManager.getAllElements());
    }

    public String getSelectedID() {
        if (this.tree != null) {
            return this.tree.getSelectedID();
        }
        return null;
    }

    public BaseTreeNode getSelectedNode() {
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getSelectionPath();
            return (BaseTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    public String getSelectedContactID() {
        TreePath path;
        Object o;
        if (!this.tree.isSelectionEmpty() && (o = (path = this.tree.getSelectionPath()).getLastPathComponent()) instanceof ContactTreeNode) {
            return ((ContactTreeNode)o).getPrincipal().getUID();
        }
        return null;
    }

    public CollaborationPrincipal getSelectedPrincipal() {
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getSelectionPath();
            Object o = path.getLastPathComponent();
            if (o instanceof ContactTreeNode) {
                return ((ContactTreeNode)o).getPrincipal();
            }
            if (o instanceof LDAPGroupTreeNode) {
                return ((LDAPGroupTreeNode)o).getPrincipal();
            }
        }
        return null;
    }

    public boolean isContactSelected() {
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getSelectionPath();
            return path.getLastPathComponent() instanceof ContactTreeNode;
        }
        return false;
    }

    public boolean isContactFolderSelected() {
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getSelectionPath();
            return path.getLastPathComponent().getClass() == ContactFolderTreeNode.class;
        }
        return false;
    }

    public boolean isLDAPGroupSelected() {
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getSelectionPath();
            return path.getLastPathComponent() instanceof LDAPGroupTreeNode;
        }
        return false;
    }

    public boolean isServiceFolderSelected() {
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getSelectionPath();
            return path.getLastPathComponent() instanceof ServicesFolderTreeNode;
        }
        return false;
    }

    public boolean isGatewaySelected() {
        if (!this.tree.isSelectionEmpty()) {
            TreePath path = this.tree.getSelectionPath();
            return path.getLastPathComponent() instanceof GatewayTreeNode;
        }
        return false;
    }

    public PersonalGateway getSelectedGateway() {
        TreePath path;
        if (!this.tree.isSelectionEmpty() && (path = this.tree.getSelectionPath()).getLastPathComponent() instanceof GatewayTreeNode) {
            GatewayTreeNode node = (GatewayTreeNode)path.getLastPathComponent();
            return node.getGateway();
        }
        return null;
    }

    public boolean getSelectionExpansionState() {
        if (this.tree != null && this.tree.getSelectionPath() != null) {
            return this.tree.isExpanded(this.tree.getSelectionPath());
        }
        return false;
    }

    public void setSelectedGroupExpansion(boolean expand) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            if (expand) {
                this.tree.expandPath(path);
            } else {
                this.tree.collapsePath(path);
            }
        }
    }

    public void handleListChat() {
        Manager.Out("BuddyListPanel.handleListChat(): Starting new chat");
        this._chatTreeNodeVisitor.reset();
        this._chatTreeNodeVisitor.traverse(true);
        iIM.startNewChat(this._chatTreeNodeVisitor.getCollaborationPrincipals());
    }

    public void handleListAlert() {
        Manager.Out("DEBUG BuddyListPanel.handleListAlert()");
        this._chatTreeNodeVisitor.reset();
        this._chatTreeNodeVisitor.traverse(true);
        CollaborationPrincipal[] nu = this._chatTreeNodeVisitor.getCollaborationPrincipals();
        CollaborationPrincipal[] au = this.getAllElements();
        iIM.AddMsg(nu, au, 1);
    }

    public void handleListPoll() {
        CollaborationPrincipal[] au = this.getAllElements();
        Vector<CollaborationPrincipal> v = null;
        Vector<CollaborationPrincipal> a = null;
        this._chatTreeNodeVisitor.reset();
        this._chatTreeNodeVisitor.traverse(true);
        CollaborationPrincipal[] nu = this._chatTreeNodeVisitor.getCollaborationPrincipals();
        if (nu.length > 0) {
            v = new Vector<CollaborationPrincipal>(nu.length);
            for (int n = 0; n < nu.length; ++n) {
                v.addElement(nu[n]);
            }
        }
        if (au != null) {
            a = new Vector<CollaborationPrincipal>(au.length);
            for (int m = 0; m < au.length; ++m) {
                a.addElement(au[m]);
            }
        }
        iIM.Poll(this.parent, a, v);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 127 || code == 8) {
            this.deleteSelectedItems();
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        this.tree.requestDefaultFocus();
        this.tree.requestFocus();
        if (o instanceof JScrollBar) {
            return;
        }
        if (o == this.tree) {
            TreePath treePath;
            if (this.tree.isSelectionEmpty()) {
                return;
            }
            this.parent.setUserGroupMenu();
            this.tree.requestDefaultFocus();
            this.tree.requestFocus();
            if (e.getClickCount() > 1 && (treePath = this.tree.getLeadSelectionPath()).getLastPathComponent() instanceof ContactTreeNode) {
                if (iIMPropsUtil.getUserClickAction(CurrentUserManager.getCurrentUserProperties()) == 1) {
                    this.handleListAlert();
                } else {
                    this.handleListChat();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        Object o = e.getSource();
        this.firstMouseEvent = e;
        if (o instanceof JScrollBar) {
            this.repaint();
            return;
        }
        if ((SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) && o == this.tree) {
            int x = e.getX();
            int y = e.getY();
            if (this.tree.isSelectionEmpty()) {
                this.tree.setSelectionPath(this.tree.getPathForLocation(x, y));
            }
            Point p = SwingUtilities.convertPoint(this.tree, e.getPoint(), this);
            this.parent.showListPopup(this.tree, p);
            return;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void updateBuddyList() {
        this.updateBuddyList(false);
    }

    private void loadBuddyGroups(String uid) {
        String[] groups = BuddyListManager.getBuddyListGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (!BuddyListManager.isElementInGroup(uid, groups[i])) continue;
            this.updateBuddyListGroup(groups[i]);
        }
    }

    public void notifyContactInfoChanged(final String uid) {
        UserInfo ui;
        Properties p = CurrentUserManager.getCurrentUserProperties();
        boolean showOffline = iIMPropsUtil.getShowOnlyOfflineContacts(p);
        boolean showPending = iIMPropsUtil.getShowPendingContacts(p);
        boolean load = false;
        if (!(showOffline && showPending || (ui = UserStatusManager.getUserInfoObject(uid)) == null)) {
            String prevStatus = ui.getPrevStatus();
            String curStatus = ui.getCurrentStatus();
            if (!showOffline && ("CLOSED".equals(prevStatus) || "Invisible".equals(prevStatus) || "CLOSED".equals(curStatus) || "Invisible".equals(curStatus))) {
                load = true;
            }
            if (!load && !showPending && ("PENDING".equals(prevStatus) || "PENDING".equals(curStatus))) {
                load = true;
            }
            if (load) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BuddyListPanel.this.loadBuddyGroups(uid);
                    }
                });
            }
        }
        final boolean tmpLoad = load;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)BuddyListPanel.this.tree.getModel().getRoot();
                int count = node.getChildCount();
                if (!tmpLoad) {
                    for (int i = 0; i < count; ++i) {
                        BuddyListPanel.this.updateTreeNode((DefaultMutableTreeNode)node.getChildAt(i), uid);
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        BaseTreeNode child = (BaseTreeNode)node.getChildAt(i);
                        if (!(child instanceof ServicesFolderTreeNode)) continue;
                        BuddyListPanel.this.updateTreeNode(child, uid);
                    }
                }
            }
        });
    }

    private void updateTreeNode(DefaultMutableTreeNode node, String uid) {
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            GatewayTreeNode gtwNode;
            TreeNode o = node.getChildAt(i);
            if (o instanceof ContactTreeNode) {
                ContactTreeNode contact = (ContactTreeNode)o;
                if (!uid.equals(contact.getPrincipal().getUID())) continue;
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(contact);
                continue;
            }
            if (!(o instanceof GatewayTreeNode) || !(gtwNode = (GatewayTreeNode)o).getGateway().getEntryId().equals(uid)) continue;
            ((DefaultTreeModel)this.tree.getModel()).nodeChanged(gtwNode);
        }
    }

    public void updateBuddyListGroup(String groupName) {
        this.tree.reloadBuddyListGroup(groupName);
    }

    public void updateBuddyListGroups(String[] groupNames) {
        for (int i = 0; i < groupNames.length; ++i) {
            this.updateBuddyListGroup(groupNames[i]);
        }
        Manager.saveAllPropertiesToServer(true, false);
    }

    public void updateBuddyList(boolean save) {
        if (!Manager.ALLOW_PRESENCE_ACCESS) {
            return;
        }
        this._reload();
        this.tree.expandGroups();
        if (save) {
            Manager.saveAllPropertiesToServer(true, false);
        }
    }

    public void updateElement(PersonalStoreEntry element) {
    }

    public CollaborationPrincipal[] getSelectedUsers() {
        ChatTreeNodeVisitor v = new ChatTreeNodeVisitor(this.tree);
        v.traverse(true);
        return v.getCollaborationPrincipals();
    }

    public void deleteSelectedItems() {
        DeleteTreeNodeVisitor v = new DeleteTreeNodeVisitor(this.tree);
        v.deleteSelectedItems(this);
    }

    public void expandGroups() {
        this.tree.expandGroups();
    }

    public boolean createBuddyListGroup(String buddyListGroupName) {
        return this.createBuddyListGroup(buddyListGroupName, false, true);
    }

    public boolean createBuddyListGroup(String buddyListGroupName, boolean quiet, boolean saveImmediately) {
        if (BuddyListManager.isBuddyListGroup(buddyListGroupName)) {
            if (quiet) {
                return false;
            }
            String msg = buddyListPanelBundle.getString("A_contact_group_with_that_name_already");
            JOptionPane.showMessageDialog(this, msg);
            return false;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        BuddyListManager.addBuddyListGroup(buddyListGroupName);
        ContactFolderTreeNode node = new ContactFolderTreeNode(buddyListGroupName);
        TreeNode root = (TreeNode)treeModel.getRoot();
        int childCount = root.getChildCount();
        Vector<TreeNode> nodes = new Vector<TreeNode>(childCount + 1);
        for (int i = 0; i < childCount; ++i) {
            nodes.add(root.getChildAt(i));
        }
        nodes.add(node);
        StringUtility.sort(nodes);
        treeModel.insertNodeInto(node, (MutableTreeNode)treeModel.getRoot(), nodes.indexOf(node));
        if (saveImmediately) {
            Manager.saveAllPropertiesToServer(true, false);
        }
        return true;
    }

    public boolean renameBuddyListGroup(String oldName, String newName) {
        if (BuddyListManager.isBuddyListGroup(newName)) {
            String msg2 = buddyListPanelBundle.getString("A_contact_group_with_that_name_already_1");
            JOptionPane.showMessageDialog(this, msg2);
            return false;
        }
        BuddyListManager.renameBuddyListGroup(oldName, newName);
        Object o = this.tree.getSelectionPath().getLastPathComponent();
        Manager.saveAllPropertiesToServer(true, false);
        return true;
    }

    public String getCurrentBuddyListGroup() {
        Object lastSelectedPathComponent = this.tree.getLastSelectedPathComponent();
        if (lastSelectedPathComponent instanceof ContactFolderTreeNode) {
            ContactFolderTreeNode buddyListTreeNode = (ContactFolderTreeNode)lastSelectedPathComponent;
            return buddyListTreeNode.getName();
        }
        return null;
    }

    public PersonalContact getCurrentSelectedUser() {
        try {
            String id = this.getSelectedContactID();
            if (id == null) {
                return null;
            }
            return (PersonalContact)Manager._personalStoreSession.getEntry("contact", id);
        }
        catch (CollaborationException e) {
            Manager.Out((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point nodeLocation = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.tree.getPathForLocation(nodeLocation.x, nodeLocation.y);
        TreeNode treeNode = null;
        if (treePath != null) {
            treeNode = (TreeNode)treePath.getLastPathComponent();
        }
        DragTreeNodeVisitor v = new DragTreeNodeVisitor(this.tree);
        v.traverse();
        this._draggedValues = v.getCollaborationPrincipals();
        if (this._draggedValues == null || this._draggedValues.length == 0) {
            return;
        }
        if (treeNode != null && this.isDragableNode(treeNode, dragGestureEvent.getDragAction())) {
            BuddyListTransferable transferable = new BuddyListTransferable(this._draggedValues);
            dragGestureEvent.startDrag(null, transferable, this);
        }
    }

    public Vector getDontMoveComponents(DropTargetDragEvent dropTargetDragEvent) {
        boolean value = true;
        Vector elements = new Vector();
        DropTreeNodeVisitor v = new DropTreeNodeVisitor(this.tree);
        Point point = dropTargetDragEvent.getLocation();
        TreePath tp = this.tree.getClosestPathForLocation((int)point.getX(), (int)point.getY());
        BaseTreeNode[] nodes = v.getDropableNodes((BaseTreeNode)tp.getLastPathComponent());
        if (nodes.length == 0) {
            dropTargetDragEvent.rejectDrag();
        } else if (this.ACTION_MOVE_COPY == 1) {
            dropTargetDragEvent.acceptDrag(1);
        } else if (this.ACTION_MOVE_COPY == 2) {
            dropTargetDragEvent.acceptDrag(2);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
        return elements;
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Object source = dropTargetDragEvent.getSource();
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.ACTION_MOVE_COPY = dropTargetDragEvent.getDropAction();
        this.dropTarget = dropTargetDragEvent;
        this.getDontMoveComponents(dropTargetDragEvent);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Object source = dropTargetDropEvent.getSource();
        String contact_error_msg = buddyListPanelBundle.getString("contact_list_featching_error");
        Manager.Out("BuddyListPanel.drop(): dropTargetDropEvent.getSource().getClass(): " + source.getClass().getName());
        if (source instanceof DropTarget) {
            Component dropTargetComponent = ((DropTarget)source).getComponent();
            if (dropTargetComponent == this.tree) {
                Point point = dropTargetDropEvent.getLocation();
                TreePath path = this.tree.getClosestPathForLocation((int)point.getX(), (int)point.getY());
                BaseTreeNode target = (BaseTreeNode)path.getLastPathComponent();
                DropTreeNodeVisitor v = new DropTreeNodeVisitor(this.tree);
                BaseTreeNode[] nodes = v.getDropableNodes(target);
                if (this.ACTION_MOVE_COPY == 2) {
                    MoveTreeNodeVisitor mv = new MoveTreeNodeVisitor(target, nodes);
                    mv.move();
                    dropTargetDropEvent.dropComplete(true);
                } else if (this.ACTION_MOVE_COPY == 1) {
                    CopyTreeNodeVisitor cv = new CopyTreeNodeVisitor(target, nodes);
                    cv.copy();
                    dropTargetDropEvent.dropComplete(true);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public boolean isDragAcceptable(DropTargetEvent dropTargetEvent) {
        Object source = dropTargetEvent.getSource();
        if (source instanceof DropTarget) {
            Component dropTargetComponent = ((DropTarget)source).getComponent();
            if (dropTargetComponent == this.tree) {
                return true;
            }
            if (dropTargetComponent == this.tree) {
                return true;
            }
        }
        return false;
    }

    protected boolean isDragableNode(TreeNode node, int dragAction) {
        return true;
    }

    public boolean isDropAcceptable(DropTargetEvent dropTargetEvent) {
        Component dropTargetComponent;
        Object source = dropTargetEvent.getSource();
        return source instanceof DropTarget && (dropTargetComponent = ((DropTarget)source).getComponent()) == this.tree;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._loadBgTexIcon();
    }

    private void _loadBgTexIcon() {
        String name = iIMPropsUtil.getBackgroundTexture(UserPropsManager.loadUserProperties(CurrentUserManager.getCurrentProfile()));
        ImageIcon icon = SwingImageManager.getBgPatternIcon(name);
        this.imagePaintingVP.setIcon(icon);
        this.tree.setOpaque(icon == null);
    }

    class BuddyListTransferable
    implements Transferable {
        private DataFlavor[] _flavors = new DataFlavor[0];
        private LinkedList _elements = new LinkedList();
        private LinkedList _buddyListGroups = new LinkedList();

        public BuddyListTransferable(Object[] objects) {
            if (objects == null) {
                return;
            }
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] instanceof PersonalStoreEntry) {
                    this._elements.add(objects[i]);
                    continue;
                }
                if (!(objects[i] instanceof String)) continue;
                this._buddyListGroups.add(objects[i]);
            }
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this._flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(this._flavors).contains(flavor);
        }

        public synchronized Object getTransferData(DataFlavor flavor) {
            return null;
        }
    }
}

