/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.communicator;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.util.AutoOrientationJPanel;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.sun.im.desktop.MessengerAppContext;
import com.sun.im.desktop.MessengerContainer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public class BuddyButtonPanel
extends AutoOrientationJPanel
implements MouseListener,
ActionListener,
MessengerContainer {
    Communicator parent;
    public JButton btnChat;
    public JButton btnAlert;
    private JToolBar toolBar = new JToolBar();
    private JButton btnAddUser = new JButton();
    private JButton btnSubscribeConf = new JButton();
    static SafeResourceBundle buddyButtonPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");

    public BuddyButtonPanel(Communicator c) {
        this.parent = c;
        this.initComponents();
        if (Manager.ALLOW_PRESENCE_ACCESS) {
            this.setListView();
        } else {
            this.setRoomView();
        }
    }

    private JButton setupButton(String resLabel, String resActionCommand, String resToolTipText, String mnemonic, ImageIcon icon) {
        Insets ins = new Insets(2, 2, 2, 2);
        JButton item = new JButton();
        SwingUtils.setupButton(item, buddyButtonPanelBundle, resLabel, mnemonic, resActionCommand, resToolTipText);
        item.setIcon(icon);
        item.setHorizontalTextPosition(0);
        item.setVerticalTextPosition(3);
        item.setVerticalAlignment(3);
        return item;
    }

    private void initComponents() {
        String mnemonicStr;
        this.setToolTipText(buddyButtonPanelBundle.getString("BuddyButtonPanel_toolTipText").length() != 0 ? buddyButtonPanelBundle.getString("BuddyButtonPanel_toolTipText") : null);
        this.setLayout(new GridBagLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setLayout(new GridBagLayout());
        this.toolBar.setOrientation(0);
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.btnChat = this.setupButton(null, "btnChat_actionCommand", "btnChat_toolTipText", "btnChat_text_M", SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_chat.png", "/com/sun/im/desktop/default/brand/tb_chat.png", this));
        if (Manager.ALLOW_CHAT && Manager.ALLOW_PRESENCE_ACCESS || Manager.ALLOW_ROOM_ACCESS) {
            this.toolBar.add((Component)this.btnChat, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnChat.setBorderPainted(false);
            this.btnChat.setFocusPainted(false);
        } else {
            this.btnChat.setVisible(false);
            this.btnChat.setEnabled(false);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.btnAlert = this.setupButton(null, "btnAlert_actionCommand", "btnAlert_toolTipText", "btnAlert_text_M", SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_alert.png", "/com/sun/im/desktop/default/brand/tb_alert.png", this));
            this.btnAlert.setOpaque(false);
            this.toolBar.add((Component)this.btnAlert, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.btnAlert.setBorderPainted(false);
            this.btnAlert.setFocusPainted(false);
        }
        boolean addUserButtonAdded = false;
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.btnAddUser.setHorizontalTextPosition(0);
            this.btnAddUser.setVerticalTextPosition(3);
            this.btnAddUser.setVerticalAlignment(3);
            mnemonicStr = buddyButtonPanelBundle.getString("lstBuddy_add_user_M");
            if (mnemonicStr != null && mnemonicStr.length() > 0) {
                this.btnAddUser.setMnemonic(mnemonicStr.charAt(0));
            }
            this.btnAddUser.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_addcontacts.png", "/com/sun/im/desktop/default/brand/tb_addcontacts.png", this));
            this.btnAddUser.setBorderPainted(false);
            this.btnAddUser.setFocusPainted(false);
            this.toolBar.add((Component)this.btnAddUser, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            addUserButtonAdded = true;
            this.btnAddUser.setRolloverEnabled(true);
            this.btnAddUser.addMouseListener(this);
            this.btnAddUser.addActionListener(this);
        }
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.btnSubscribeConf.setHorizontalTextPosition(0);
            this.btnSubscribeConf.setVerticalTextPosition(3);
            this.btnSubscribeConf.setVerticalAlignment(3);
            mnemonicStr = buddyButtonPanelBundle.getString("btnSubscribe_text_M");
            if (mnemonicStr != null && mnemonicStr.length() > 0) {
                this.btnSubscribeConf.setMnemonic(mnemonicStr.charAt(0));
            }
            this.btnSubscribeConf.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_conf.png", "/com/sun/im/desktop/default/brand/tb_conf.png", this));
            this.btnSubscribeConf.setBorderPainted(false);
            this.btnSubscribeConf.setFocusPainted(false);
            int gridX = 2;
            if (addUserButtonAdded) {
                gridX = 3;
            }
            this.toolBar.add((Component)this.btnSubscribeConf, new GridBagConstraints(gridX, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.btnSubscribeConf.setRolloverEnabled(true);
            this.btnSubscribeConf.addMouseListener(this);
            this.btnSubscribeConf.addActionListener(this);
        }
        if (Manager.ALLOW_CHAT || Manager.ALLOW_ROOM_ACCESS) {
            this.btnChat.addActionListener(this);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.btnAlert.addActionListener(this);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.btnAlert.addMouseListener(this);
        }
        if (Manager.ALLOW_CHAT || Manager.ALLOW_ROOM_ACCESS) {
            this.btnChat.addMouseListener(this);
        }
    }

    public void setBarVisible(boolean b) {
        this.toolBar.setVisible(b);
    }

    public void close() {
        this.removeMouseListener(this);
        if (Manager.ALLOW_SEND_ALERTS) {
            this.btnAlert.removeActionListener(this);
        }
        if (Manager.ALLOW_CHAT || Manager.ALLOW_ROOM_ACCESS) {
            this.btnChat.removeActionListener(this);
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.btnAddUser.removeMouseListener(this);
            this.btnSubscribeConf.removeMouseListener(this);
            this.btnAddUser.removeActionListener(this);
            this.btnSubscribeConf.removeActionListener(this);
        }
    }

    public void refresh() {
        this.initButtons();
        this.setView(this.parent.getCurrentViewType());
    }

    public JButton getChatButton() {
        return this.btnChat;
    }

    private void initButtons() {
        this.btnChat.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_chat.png", "/com/sun/im/desktop/default/brand/tb_chat.png", this));
        if (Manager.ALLOW_SEND_ALERTS) {
            this.btnAlert.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_alert.png", "/com/sun/im/desktop/default/brand/tb_alert.png", this));
        }
    }

    private void onButtonOver(ComponentEvent e) {
        if ((Manager.ALLOW_CHAT || Manager.ALLOW_ROOM_ACCESS) && e.getSource() == this.btnChat && this.btnChat.isEnabled()) {
            this.btnChat.setBorderPainted(true);
        } else if (Manager.ALLOW_SEND_ALERTS && e.getSource() == this.btnAlert && this.btnAlert.isEnabled()) {
            this.btnAlert.setBorderPainted(true);
        } else if (Manager.ALLOW_CONTACT_MANAGEMENT && e.getSource() == this.btnAddUser && this.btnAddUser.isEnabled()) {
            this.btnAddUser.setToolTipText(buddyButtonPanelBundle.getString("lstBuddy_add_user"));
            this.btnAddUser.setBorderPainted(true);
        } else if (Manager.ALLOW_CONTACT_MANAGEMENT && e.getSource() == this.btnSubscribeConf && this.btnSubscribeConf.isEnabled()) {
            this.btnSubscribeConf.setToolTipText(buddyButtonPanelBundle.getString("btnSubscribe_toolTipText"));
            this.btnSubscribeConf.setBorderPainted(true);
        }
    }

    private void onButtonLeave(ComponentEvent e) {
        if ((Manager.ALLOW_CHAT || Manager.ALLOW_ROOM_ACCESS) && e.getSource() == this.btnChat) {
            this.btnChat.setBorderPainted(false);
        } else if (Manager.ALLOW_SEND_ALERTS && e.getSource() == this.btnAlert) {
            this.btnAlert.setBorderPainted(false);
        } else if (Manager.ALLOW_CONTACT_MANAGEMENT && e.getSource() == this.btnAddUser) {
            this.btnAddUser.setBorderPainted(false);
        } else if (Manager.ALLOW_CONTACT_MANAGEMENT && e.getSource() == this.btnSubscribeConf) {
            this.btnSubscribeConf.setBorderPainted(false);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.onButtonOver(e);
    }

    public void mouseExited(MouseEvent e) {
        this.onButtonLeave(e);
        this.repaint();
    }

    public void setView(int type) {
        switch (type) {
            case 0: {
                this.setListView();
                break;
            }
            case 1: {
                this.setRoomView();
            }
        }
    }

    private void setListView() {
        this.btnAddUser.setEnabled(true);
        this.btnSubscribeConf.setEnabled(false);
        if (Manager.ALLOW_CHAT) {
            this.btnChat.setVisible(true);
            this.btnChat.setEnabled(true);
            SwingUtils.setupButton(this.btnChat, buddyButtonPanelBundle, null, "btnChat_text_M", null, "btnChat_toolTipText");
            this.btnChat.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_chat.png", "/com/sun/im/desktop/default/brand/tb_chat.png", this));
        } else {
            this.btnChat.setVisible(false);
            this.btnChat.setEnabled(false);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.btnAlert.setEnabled(true);
            this.btnAlert.setVisible(true);
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.btnAddUser.setVisible(true);
        }
    }

    private void setRoomView() {
        Manager.Out("In setRoomView()");
        if (Manager.ALLOW_SEND_ALERTS) {
            this.btnAlert.setEnabled(false);
        }
        this.btnAddUser.setEnabled(false);
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.btnChat.setVisible(true);
            this.btnChat.setEnabled(true);
            SwingUtils.setupButton(this.btnChat, buddyButtonPanelBundle, null, "btnChat_enter_M", null, "btnEnter_toolTipText");
            this.btnChat.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_chat.png", "/com/sun/im/desktop/default/brand/tb_chat.png", this));
        } else {
            this.btnChat.setEnabled(false);
        }
        if (RoomManager.getFavorites().size() == 0) {
            this.btnChat.setEnabled(false);
        } else {
            this.btnChat.setEnabled(true);
        }
        if (Manager.ALLOW_ROOM_ACCESS) {
            this.btnSubscribeConf.setVisible(true);
            this.btnSubscribeConf.setEnabled(true);
            SwingUtils.setupButton(this.btnSubscribeConf, buddyButtonPanelBundle, null, "btnSubscribe_text_M", null, "btnSubscribe_toolTipText");
            this.btnSubscribeConf.setIcon(SwingImageManager.getIcon("/com/sun/im/desktop/brand/tb_conf.png", "/com/sun/im/desktop/default/brand/tb_conf.png", this));
        } else {
            this.btnSubscribeConf.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.setCursor(new Cursor(3));
        Object object = event.getSource();
        if (Manager.ALLOW_SEND_ALERTS && object == this.btnAlert) {
            this.parent.sendAlert();
        } else if ((Manager.ALLOW_CHAT || Manager.ALLOW_ROOM_ACCESS) && object == this.btnChat) {
            Manager.Out("DEBUG: BuddyButtonPanel: calling parent.chat()");
            this.parent.chat();
        } else if (Manager.ALLOW_ROOM_ACCESS && object == this.btnSubscribeConf) {
            this.parent.startRoomSearch();
        } else if (Manager.ALLOW_CONTACT_MANAGEMENT && object == this.btnAddUser) {
            this.parent.startSearch();
        }
        this.setCursor(new Cursor(0));
    }

    public MessengerAppContext getAppContext() {
        return iIM._client;
    }

    public Component getComponent() {
        return this;
    }

    public void outputError(String errorText) {
        JOptionPane.showMessageDialog(this, errorText);
    }

    public void setServerArchive(boolean b) {
    }
}

