/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.AddMsg;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.chat.bean.RoomFrame;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.swing.chat.bean.RoomViewUIEvent;
import com.iplanet.im.client.swing.chat.bean.RoomViewUIListener;
import com.iplanet.im.client.swing.dialogs.MessageBox;
import com.iplanet.im.client.swing.dialogs.MessageBoxListener;
import com.iplanet.im.client.util.BlinkableJTabbedPane;
import com.iplanet.im.client.util.Orientation;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.StickyFileChooser;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.StringUtility;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoomViewContainer
extends JPanel
implements RoomViewUIListener,
ChangeListener,
ActionListener {
    static SafeResourceBundle chatPanelBundle = Chat.chatPanelBundle;
    private Vector views = new Vector(5);
    private Vector room_ids = new Vector(5);
    private JFrame _parentFrame;
    private RoomFrame _roomFrame;
    private final int NUM_TITLE = 3;
    public Vector msgQueue = new Vector(2);
    public boolean MESSAGE_OPEN = false;
    BlinkableJTabbedPane tabs;

    public RoomViewContainer(JFrame _parentFrame) {
        this._parentFrame = _parentFrame;
        this._roomFrame = (RoomFrame)_parentFrame;
        this.initComponents();
    }

    private void initComponents() {
        this.tabs = new BlinkableJTabbedPane();
        this.tabs.getAccessibleContext().setAccessibleDescription(chatPanelBundle.getString("Tabs_labelled_With_Room_Names"));
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(405, 270);
        this.add("Center", this.tabs);
        this.tabs.addChangeListener(this);
        Orientation.apply(this);
    }

    public RoomFrame getRoomFrame() {
        return this._roomFrame;
    }

    public void setInviteList(CollaborationPrincipal[] inv, String roomid) {
        int n = this.room_ids.indexOf(roomid);
        if (n < 0) {
            return;
        }
        RoomView v = (RoomView)this.views.elementAt(n);
        v.setInviteList(inv);
        this.updateTabAt(n);
    }

    public void showInviteMsg(String rid, Message m) throws CollaborationException {
        RoomView v = this.getRoomViewFromConfID(rid);
        v.showInviteMsg(m);
    }

    private RoomView getRoomViewFromConfID(String confAddress) {
        int n = this.room_ids.indexOf(confAddress);
        if (n < 0) {
            return null;
        }
        return (RoomView)this.views.elementAt(n);
    }

    private RoomView getSelectedRoomView() {
        int sel = this.tabs.getSelectedIndex();
        if (sel < 0) {
            return null;
        }
        RoomView pnl = (RoomView)this.views.elementAt(sel);
        return pnl;
    }

    private void setRoomFrameTitle(String title) {
        this._parentFrame.setTitle(title);
        this._parentFrame.getAccessibleContext().setAccessibleDescription(title);
        this.getAccessibleContext().setAccessibleDescription(title);
    }

    public void addNewRoom(Conference conf, boolean is_conf, Message inviteMsg) throws CollaborationException {
        Manager.Out("RoomViewContainer.addNewRoom() called: " + conf.getDestination());
        RoomView rv = new RoomView(this._parentFrame, this, conf, is_conf, inviteMsg);
        rv.addRoomViewUIListener(this);
        String title = rv.getRoomTitle();
        this.views.addElement(rv);
        this.room_ids.addElement(conf.getDestination());
        this.tabs.addTab(title, rv);
        this.setRoomFrameTitle(title);
        this.setVisible(true);
        this._parentFrame.setVisible(true);
        rv.init();
    }

    public void addNewRoom(Conference conf, boolean is_conf) throws CollaborationException {
        this.addNewRoom(conf, is_conf, null);
    }

    public Conference addNewChatRoom(String server, boolean is_conf) throws CollaborationException {
        RoomView rv = new RoomView(this._parentFrame, this, null, is_conf, null);
        rv.addRoomViewUIListener(this);
        Conference conf = rv.getConference();
        String title = rv.getRoomTitle();
        this.views.addElement(rv);
        this.room_ids.addElement(conf.getDestination());
        this.tabs.addTab(title, rv);
        this.setVisible(true);
        this._parentFrame.setVisible(true);
        rv.init();
        return conf;
    }

    public Vector getRoomViews() {
        return this.views;
    }

    public RoomView getActiveRoomView() {
        if (this.tabs.getSelectedIndex() > -1) {
            return (RoomView)this.views.get(this.tabs.getSelectedIndex());
        }
        return null;
    }

    public void localStatusMessage(String msg) {
        for (int i = 0; i < this.views.size(); ++i) {
            RoomView pnl = (RoomView)this.views.elementAt(i);
            pnl.displayMessage(msg);
        }
    }

    public void setRoomFocus(String id) {
        int n = this.room_ids.indexOf(id);
        if (n < 0) {
            return;
        }
        this.tabs.setSelectedIndex(n);
    }

    public void setblinkActiveView(boolean blink) {
        if (this.tabs.getSelectedIndex() > -1) {
            ((RoomView)this.tabs.getComponentAt(this.tabs.getSelectedIndex())).setBlink(blink);
        }
    }

    public boolean removeTab(RoomView pnl) {
        int n;
        int index = this.views.indexOf(pnl);
        Manager.Out("RoomViewContainer.removeTab(): About to remove tab: " + index);
        if (index < 0) {
            return true;
        }
        if (pnl.isSomeoneElseThanMeTyping() && (n = JOptionPane.showConfirmDialog(this, chatPanelBundle.getString("A_user_may_still_be_typing"), chatPanelBundle.getString("User_Still_Typing"), 0, 1)) == 1) {
            Manager.Out("RoomViewContainer: NO_OPTION chosen");
            return false;
        }
        pnl.close();
        this.tabs.removeTabAt(index);
        this.views.removeElementAt(index);
        this.room_ids.removeElementAt(index);
        if (this.views.size() < 1) {
            this.close(false);
        }
        if (this.tabs.getSelectedComponent() instanceof RoomView) {
            RoomView rv = (RoomView)this.tabs.getSelectedComponent();
            this._parentFrame.getRootPane().setDefaultButton(rv.getRoomEditorViewContainer().getDefaultButton());
        }
        return true;
    }

    private final void updateSelectedTab() {
        int index = this.tabs.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.updateTabAt(index);
    }

    private final void updateTabAt(int index) {
        try {
            if (!this.isVisible()) {
                return;
            }
            if (index < 0) {
                return;
            }
            RoomView pnl = null;
            if (index < this.views.size()) {
                pnl = (RoomView)this.views.elementAt(index);
            }
            if (pnl == null) {
                return;
            }
            String title = pnl.getRoomTitle();
            this.tabs.setTitleAt(index, title);
            this.setRoomFrameTitle(title);
        }
        catch (Exception e) {
            Manager.Out("Exception e:" + e);
        }
    }

    public final void changeModeratedTabTitleOn(RoomView rv) {
        int index = this.views.indexOf(rv);
        StringBuffer title = new StringBuffer(this._parentFrame.getTitle());
        StringBuffer tabTitle = new StringBuffer(this.tabs.getTitleAt(index));
        title.append(chatPanelBundle.getString("ChatFrame_Moderated"));
        tabTitle.append(chatPanelBundle.getString("ChatFrame_Moderated"));
        if (iIMPropsUtil.getChatTab(CurrentUserManager.getCurrentUserProperties())) {
            this.tabs.setTitleAt(index, tabTitle.toString());
        }
        if (index == this.tabs.getSelectedIndex()) {
            this.setRoomFrameTitle(title.toString());
        }
    }

    public final void changeModeratedTabTitleOff(Conference r, RoomView rv) {
        int index = this.views.indexOf(rv);
        String title = r.getDestination();
        String tabTitle = r.getDestination();
        if (iIMPropsUtil.getChatTab(CurrentUserManager.getCurrentUserProperties())) {
            this.tabs.setTitleAt(index, tabTitle);
        }
        if (index == this.tabs.getSelectedIndex()) {
            this.setRoomFrameTitle(title);
        }
    }

    public synchronized boolean close(boolean validate) {
        Manager.Out("   DEBUG CHAT: Closing Chat Frame", true);
        if (validate && this.views.size() > 1) {
            String title;
            String msg = chatPanelBundle.getString("Are_you_sure_you_want_to_close_all_chat");
            int op = JOptionPane.showConfirmDialog(this, msg, title = chatPanelBundle.getString("Close_All_Sessions"), 0);
            if (op != 0) {
                return false;
            }
            validate = false;
        }
        if (this.views.size() >= 1) {
            Object[] tmp = new RoomView[this.views.size()];
            this.views.copyInto(tmp);
            for (int n = 0; n < tmp.length; ++n) {
                Object p = tmp[n];
                this.removeTab((RoomView)p);
            }
            tmp = null;
            this.views.removeAllElements();
            this.room_ids.removeAllElements();
        }
        this.setVisible(false);
        this._parentFrame.setVisible(false);
        ApplicationManager.removeActiveObject(this._parentFrame);
        if (!iIMPropsUtil.getChatTab(CurrentUserManager.getCurrentUserProperties())) {
            this._roomFrame.close();
        }
        return true;
    }

    private final void handleChat(String[] uids) {
        try {
            CollaborationPrincipal[] nu = UserCache.getPrincipal(uids);
            if (nu == null) {
                return;
            }
            iIM._chat.startNewChat(nu);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            Manager.Out("Exception e:" + (Object)((Object)e));
        }
    }

    private final void handleAlert(String[] uids) {
        Object[] nu = UserCache.getPrincipal(uids);
        if (nu == null) {
            return;
        }
        Object[] allUsers = UserCache.getPrincipal(BuddyListManager.getAllElementsIDs());
        new AddMsg(Manager.getVectorFromArray(nu), Manager.getVectorFromArray(allUsers), 1);
    }

    public void actionPerformed(ActionEvent ev) {
        String actionCommand = ev.getActionCommand();
        if (actionCommand == "cancel") {
            this.close(true);
        } else if (actionCommand == "help") {
            HelpManager.showHelp("chat");
        }
    }

    public void sendMessage() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.sendMessage();
        }
    }

    public void inviteOthers() {
        try {
            RoomView pnl = this.getSelectedRoomView();
            if (pnl != null) {
                pnl.showInviteDialog();
            }
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e:" + (Object)((Object)e));
        }
    }

    public void save() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.save();
        }
    }

    public void print() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.print();
        }
    }

    public void viewSource() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.viewSource();
        }
    }

    public void sideChat() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.handleChat();
        }
    }

    public void alert() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.handleAlert();
        }
    }

    public boolean hasWriteAccess() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            return pnl.hasWriteAccess();
        }
        return false;
    }

    public boolean isModetared() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            return pnl.isModetared();
        }
        return false;
    }

    public boolean removeTab() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            return this.removeTab(pnl);
        }
        return false;
    }

    public boolean isToolBarVisible() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            return pnl.isToolBarVisible();
        }
        return false;
    }

    public boolean isModerateEnabled() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            return pnl.isModerateEnabled();
        }
        return false;
    }

    public String getModerateText() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            return pnl.getModeratedText();
        }
        return null;
    }

    public void showToolBar(boolean b) {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.showToolBar(b);
        }
    }

    public void showParticipantList(boolean b) {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.showParticipantList(b);
        }
    }

    public void moderate() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.moderate();
        }
    }

    public void clearText() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.clearText();
        }
    }

    public boolean isSelected() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            return pnl.isSelected();
        }
        return false;
    }

    public void addContacts() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.addContacts();
        }
    }

    public void attach() {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.attach();
        }
    }

    public void setShowTimeStamp(boolean b) {
        RoomView pnl = this.getSelectedRoomView();
        if (pnl != null) {
            pnl.setShowTimeStamp(b);
        }
    }

    public void stateChanged(ChangeEvent event) {
        this.updateSelectedTab();
        boolean enable = this.isSelected();
        this._roomFrame.setToolsMenu(enable);
        this._roomFrame.setEditItemsEnabled(false);
        if (this.tabs.getSelectedComponent() instanceof JComponent) {
            ((JComponent)this.tabs.getSelectedComponent()).requestDefaultFocus();
            if (this.tabs.getSelectedComponent() instanceof RoomView) {
                RoomView rv = (RoomView)this.tabs.getSelectedComponent();
                this._parentFrame.getRootPane().setDefaultButton(rv.getRoomEditorViewContainer().getDefaultButton());
                this._roomFrame.setModeratedMenuItemEnabled(this.isModerateEnabled());
                this._roomFrame.setModeratedMenuItemText(this.getModerateText());
            }
        }
    }

    public void newRoomViewEvent(RoomViewUIEvent ev) {
        switch (ev.getType()) {
            case 1: {
                this.tabs.setAlertAt(this.tabs.indexOfComponent((RoomView)ev.getSource()), true);
                this._roomFrame.flashOnce();
                break;
            }
            case 0: {
                this.tabs.setAlertAt(this.tabs.indexOfComponent((RoomView)ev.getSource()), false);
                break;
            }
            case 2: {
                this.removeTab((RoomView)ev.getSource());
                break;
            }
            case 3: {
                int n = this.room_ids.indexOf(ev.getRoomId());
                if (n < 0) {
                    return;
                }
                this.updateTabAt(n);
                break;
            }
            case 5: {
                this.handleChat(ev.getUserList());
                break;
            }
            case 6: {
                this.handleAlert(ev.getUserList());
                break;
            }
            case 7: {
                if (!Manager.ALLOW_ATTACHMENTS) break;
                this.handleAttachment((Message)ev.getMsgObject());
                break;
            }
        }
    }

    private final synchronized void handleAttachment(Message m) {
        try {
            MessagePart[] mp = m.getParts();
            if (mp.length > 1 && !CurrentUserManager.isCurrentUserID(m.getOriginator())) {
                Manager.Out("   DEBUG CHAT: handleAttachment ", true);
                if (this.MESSAGE_OPEN) {
                    this.msgQueue.addElement(m);
                } else {
                    this.MESSAGE_OPEN = true;
                    this.queueEmbeddedFile(m);
                    this.MESSAGE_OPEN = false;
                }
            }
        }
        catch (Exception e) {
            Manager.Out("Exception e:" + e);
        }
    }

    public final void queueEmbeddedFile(Message m) throws Exception {
    }

    public final synchronized void checkMessageQueue() {
        try {
            if (this.msgQueue.size() == 0) {
                return;
            }
            Message m = (Message)this.msgQueue.firstElement();
            this.msgQueue.removeElementAt(0);
            this.queueEmbeddedFile(m);
        }
        catch (Exception e) {
            Manager.Out("Exception e:" + e);
        }
    }

    public final void handleEmbeddedFile(String s, byte[] b, CollaborationPrincipal cp) {
        Manager.Out("   DEBUG CHAT: handleEmbeddedFile ");
        String msg = StringUtility.substitute((String)chatPanelBundle.getString("You_have_been_sent_the_file"), (String)"__MACRO__", (String)cp.getDisplayName());
        String title = StringUtility.substitute((String)chatPanelBundle.getString("Received_a_file_from_"), (String)"__MACRO__", (String)cp.getDisplayName());
        String save = chatPanelBundle.getString("Save");
        String ignore = chatPanelBundle.getString("Ignore");
        String open = chatPanelBundle.getString("Open");
        MessageBox mb = null;
        this._parentFrame.toFront();
        Point p = this.getLocation();
        MessageBoxListenerImpl msgBoxListener = new MessageBoxListenerImpl(s, b);
        mb = Manager.isFileLaunchable(s) ? new MessageBox((Frame)this._parentFrame, p, title, StringUtility.substitute((String)msg, (String)"__MACRO1__", (String)s), open, save, ignore, true, msgBoxListener) : new MessageBox((Frame)this._parentFrame, p, title, StringUtility.substitute((String)msg, (String)"__MACRO1__", (String)s), null, save, ignore, true, msgBoxListener);
    }

    public final boolean saveEmbeddedFile(String s, byte[] b) {
        Manager.Out("   DEBUG CHAT: save Embedded file");
        File f = StickyFileChooser.chooseSaveFile(this._parentFrame, s, null, null);
        if (f == null) {
            return false;
        }
        FileUtility.save((File)f, (byte[])b);
        return true;
    }

    class MessageBoxListenerImpl
    implements MessageBoxListener {
        String file;
        byte[] content;

        public MessageBoxListenerImpl(String file, byte[] content) {
            this.file = file;
            this.content = content;
        }

        public boolean actionPerformed(int button) {
            if (button == 0) {
                try {
                    Manager.launchFile(this.file, this.content);
                    return true;
                }
                catch (Exception x) {
                    JOptionPane.showMessageDialog(RoomViewContainer.this._parentFrame, chatPanelBundle.getString("Could_not_open_attachment"));
                    Manager.Out(x.getMessage());
                    return RoomViewContainer.this.saveEmbeddedFile(this.file, this.content);
                }
            }
            if (button == 1) {
                return RoomViewContainer.this.saveEmbeddedFile(this.file, this.content);
            }
            return true;
        }
    }
}

