/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.MBeanManager;
import com.iplanet.im.client.manager.MBeanRecord;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.chat.bean.RoomEditorUIEvent;
import com.iplanet.im.client.swing.chat.bean.RoomEditorUIListener;
import com.iplanet.im.client.swing.chat.bean.RoomEditorViewContainer;
import com.iplanet.im.client.swing.chat.bean.RoomFrame;
import com.iplanet.im.client.swing.chat.bean.RoomModeratedContainer;
import com.iplanet.im.client.swing.chat.bean.RoomMsgUIEvent;
import com.iplanet.im.client.swing.chat.bean.RoomMsgUIListener;
import com.iplanet.im.client.swing.chat.bean.RoomMsgViewContainer;
import com.iplanet.im.client.swing.chat.bean.RoomUserListContainer;
import com.iplanet.im.client.swing.chat.bean.RoomViewBean;
import com.iplanet.im.client.swing.chat.bean.RoomViewContainer;
import com.iplanet.im.client.swing.chat.bean.RoomViewUIEvent;
import com.iplanet.im.client.swing.chat.bean.RoomViewUIListener;
import com.iplanet.im.client.swing.dialogs.AddContact;
import com.iplanet.im.client.swing.dialogs.InviteUsers;
import com.iplanet.im.client.util.AutoOrientationJPanel;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.Orientation;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.desktop.MessengerActionListener;
import com.sun.im.desktop.MessengerAppContext;
import com.sun.im.desktop.MessengerBeanFactory;
import com.sun.im.desktop.MessengerConferenceContainer;
import com.sun.im.desktop.MessengerConferenceListener;
import com.sun.im.desktop.MessengerContainer;
import com.sun.im.desktop.MessengerEventListener;
import com.sun.im.desktop.MessengerException;
import com.sun.im.desktop.MessengerItemListener;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class RoomView
extends AutoOrientationJPanel
implements ConferenceListener,
RoomEditorUIListener,
RoomMsgUIListener,
MouseListener,
MessengerConferenceContainer,
InviteMessageStatusListener {
    static SafeResourceBundle chatPanelBundle = Chat.chatPanelBundle;
    private RoomViewContainer _roomViewContainer;
    private RoomUserListContainer userContainer;
    private RoomMsgViewContainer msgContainer;
    private RoomEditorViewContainer editContainer;
    private RoomModeratedContainer modContainer;
    private SmartJPopupMenu popup;
    private JMenuItem sidechat;
    private JMenuItem alert;
    private JFrame _parentFrame;
    private SymAction lSymAction = new SymAction();
    public static int USER_TITLE_LENGTH = 3;
    private boolean _isConferenceRoom = false;
    private boolean pListVisible = false;
    private List _initialChatMsgs;
    private LinkedList roomListeners = new LinkedList();
    private CollaborationPrincipal[] _invitees;
    private LinkedList _inviteList = null;
    private boolean isModerated = false;
    private boolean moderate = false;
    JLabel label = new JLabel();
    private boolean firstTime = true;
    private boolean canSpeak = false;
    private boolean userHasReadAccess = false;
    private Vector moderators = new Vector(1);
    private boolean _showUserList = true;
    private boolean showPopup = true;
    private Conference conf;
    private String typingUserID = null;
    private RoomViewBean _activeRoomBean = null;
    JPanel test = new JPanel();
    JPanel pnlEdit = new JPanel();
    JPanel pnlOptions = new JPanel();
    JButton btnOptions = new JButton();
    JButton btnModerate = new JButton();
    JSplitPane horSplitPane;
    JSplitPane verSplitPane;
    JSplitPane modSplitPane;
    private boolean isInitialized = false;
    private LinkedList _listeners;

    public RoomView(JFrame parentFrame, RoomViewContainer rv, Conference conf, boolean is_conf, Message inviteMsg) throws CollaborationException {
        this._isConferenceRoom = is_conf;
        this._parentFrame = parentFrame;
        if (inviteMsg != null) {
            if (this._initialChatMsgs == null) {
                this._initialChatMsgs = new ArrayList();
            }
            this._initialChatMsgs.add(inviteMsg);
        }
        if (conf == null) {
            conf = RoomManager.createPrivateRoom(this);
        }
        this.conf = conf;
        this._roomViewContainer = rv;
        this.msgContainer = new RoomMsgViewContainer(parentFrame);
        this.msgContainer.addRoomMsgUIListener(this);
        this.userContainer = new RoomUserListContainer(this);
        this.userContainer.addRoomUser(CurrentUserManager.getCurrentUserID(), CurrentUserManager.getCurrentUserDisplayName());
        this.editContainer = new RoomEditorViewContainer(this._parentFrame, this);
        this.editContainer.addRoomEditorUIListener(this);
        this.setLayout(new GridBagLayout());
        Manager.Out("Trying to join the conference Room ");
        conf.join((ConferenceListener)this);
        Conference updatedRoom = RoomManager.getRoom(conf.getDestination());
        if (updatedRoom != null) {
            conf = updatedRoom;
            this._showUserList = true;
        }
        this.pnlEdit.setLayout(new GridBagLayout());
        this.test.setLayout(new FlowLayout(0));
        this.horSplitPane = new JSplitPane(0, this.msgContainer, this.pnlEdit);
        this.horSplitPane.setResizeWeight(1.0);
        this.userContainer.setMinimumSize(new Dimension(0, 0));
        this.verSplitPane = Orientation.isLeftToRight() ? new JSplitPane(1, this.horSplitPane, this.userContainer) : new JSplitPane(1, this.userContainer, this.horSplitPane);
        this.verSplitPane.setResizeWeight(0.5);
        this.verSplitPane.setOneTouchExpandable(true);
        this.verSplitPane.setDividerSize(10);
        if (this._showUserList) {
            this.add((Component)this.verSplitPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)this.horSplitPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.pnlEdit.add((Component)this.editContainer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.2, 10, 1, new Insets(0, 0, 0, 0), 0, 12));
        this.pnlOptions.setLayout(new FlowLayout(0, 0, 0));
        this.pnlOptions.add(this.label);
        this.label.setVisible(true);
        this.label.setText(" ");
        this.add((Component)this.pnlOptions, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.btnModerate.setText(chatPanelBundle.getString("ChatPanel_moderate"));
        this.btnModerate.setMnemonic(chatPanelBundle.getString("ChatPanel_moderate_M").charAt(0));
        List l = MBeanManager.getBeans(is_conf ? "mbean.conference" : "mbean.chat");
        int xOptions = 4;
        boolean xEditorView = false;
        if (l != null) {
            Manager.Out("RoomView.Constructor: loading beans: " + l.size());
            Iterator i = l.iterator();
            while (i.hasNext()) {
                MBeanRecord rec;
                AbstractButton btn;
                MessengerBeanFactory f = (MessengerBeanFactory)i.next();
                MessengerEventListener eventListener = f.getEventListener((MessengerContainer)this);
                if (eventListener == null) continue;
                if (eventListener instanceof MessengerActionListener) {
                    Manager.Out("RoomView.Constructor: Adding button");
                    btn = new JButton();
                    rec = MBeanManager.addComponent((MessengerContainer)this, f, btn);
                    btn.setText(rec.getLabel());
                    btn.setIcon(rec.getIcon());
                    this.pnlOptions.add((Component)btn, new GridBagConstraints(xOptions++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
                    continue;
                }
                if (!(eventListener instanceof MessengerItemListener)) continue;
                Manager.Out("RoomView.Constructor: Adding ToggleButton in Chat Panel");
                btn = new JToggleButton();
                rec = MBeanManager.addComponent((MessengerContainer)this, f, btn);
                btn.setSelected(((MessengerItemListener)eventListener).isSelected());
                btn.setIcon(rec.getIcon());
                btn.setPreferredSize(new Dimension(25, 25));
                this.editContainer.pnlBeans.add(btn);
            }
        }
        if (this._isConferenceRoom) {
            this.showCompose(false);
        }
        this.roomStarted();
        this.btnOptions.addActionListener(this.lSymAction);
        this.btnModerate.addActionListener(this.lSymAction);
        MBeanManager.startActionListeners(this);
        ((RoomFrame)this._parentFrame).setModeratedMenuItemEnabled(this.isModerateEnabled());
    }

    public void roomStarted() {
        Manager.Out("roomStarted called");
        this.editContainer.setAttachmentEnabled(false);
        if (!RoomManager.isLikelyPrivate(this.conf)) {
            this.userHasReadAccess = UserAccessControl.hasPrivilege(this.conf, 2);
            Manager.Out("**** userHasReadAccess: " + this.userHasReadAccess);
        }
        if (this._isConferenceRoom && Manager.ALLOW_MODERATE && (UserAccessControl.isAdmin() || UserAccessControl.hasPrivilege(this.conf, 30))) {
            this.editContainer.setAttachmentEnabled(true);
            this.btnModerate.setVisible(true);
        }
        Manager.Out("roomStarted: at 2");
        if (!this._isConferenceRoom || UserAccessControl.hasPrivilege(this.conf, 4)) {
            this.editContainer.setAttachmentEnabled(true);
            Manager.Out("RoomView.java: canSpeak: true");
            this.canSpeak = true;
        }
        if (!RoomManager.isLikelyPrivate(this.conf)) {
            if (!this.canSpeak && !this.isModerated) {
                this.showCompose(false);
                this.displayMessage(chatPanelBundle.getString("ChatPanel_readonlymsg"));
            } else if (UserAccessControl.hasPrivilege(this.conf, 4) || this.userHasReadAccess && this.isModerated) {
                this.editContainer.setAttachmentEnabled(true);
                this.showCompose(true);
            }
        }
    }

    private void showCompose(boolean bShow) {
        this.pnlEdit.setVisible(bShow);
        Manager.Out("in showCompose(): " + bShow);
        this._roomViewContainer.getRoomFrame().setSendMenu(bShow);
        this.showPopup = bShow;
        if (!bShow) {
            this._parentFrame.getRootPane().setDefaultButton(null);
            this.horSplitPane.revalidate();
        } else {
            this.horSplitPane.setBottomComponent(this.pnlEdit);
            this._parentFrame.getRootPane().setDefaultButton(this.editContainer.getDefaultButton());
            this.horSplitPane.setResizeWeight(0.75);
            this.horSplitPane.resetToPreferredSizes();
            this.horSplitPane.repaint();
            this.pnlEdit.repaint();
            this.repaint();
        }
        this.requestDefaultFocus();
    }

    public void startModerating() {
        this.moderate = true;
        JSplitPane displayedPane = this._showUserList ? this.verSplitPane : this.horSplitPane;
        displayedPane.setVisible(false);
        this.remove(displayedPane);
        this._parentFrame.getRootPane().setDefaultButton(this.editContainer.getDefaultButton());
        Dimension psize = this._parentFrame.getSize();
        if (psize.height < 500) {
            Dimension nsize = new Dimension(psize.width, 500);
            this._parentFrame.setSize(nsize);
        }
        if (this.modContainer == null) {
            this.modContainer = new RoomModeratedContainer(this, this._parentFrame);
        }
        if (this.modSplitPane == null) {
            this.modSplitPane = new JSplitPane(0);
        }
        this.modSplitPane.setTopComponent(this.modContainer);
        displayedPane.setVisible(true);
        this.modSplitPane.setBottomComponent(displayedPane);
        this.modSplitPane.setDividerLocation(0.3);
        this.modSplitPane.setResizeWeight(0.3);
        this.add((Component)this.modSplitPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ((RoomFrame)this._parentFrame).setModeratedMenuItemText(this.getModeratedText());
        this.modContainer.setVisible(true);
        displayedPane.setVisible(true);
        this.modSplitPane.setVisible(true);
        this.requestDefaultFocus();
        Manager.Out("  DEBUG: RoomView.startModerating(): Starting moderated connection");
    }

    public void stopModerating() {
        this.moderate = false;
        this.modSplitPane.setVisible(false);
        this.remove(this.modSplitPane);
        this._parentFrame.getRootPane().setDefaultButton(this.editContainer.getDefaultButton());
        JSplitPane displayedPane = this._showUserList ? this.verSplitPane : this.horSplitPane;
        this.add((Component)displayedPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        displayedPane.setVisible(true);
        ((RoomFrame)this._parentFrame).setModeratedMenuItemText(this.getModeratedText());
        this.requestDefaultFocus();
        Manager.Out("  DEBUG: RoomView.startModerating(): Start unmoderated connection");
    }

    public String getModeratedText() {
        if (this.moderate) {
            return chatPanelBundle.getString("ChatPanel_unmoderate");
        }
        return chatPanelBundle.getString("ChatPanel_moderate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        boolean bParticipant = iIMPropsUtil.getParticipantList(CurrentUserManager.getCurrentUserProperties());
        boolean bToolbar = iIMPropsUtil.getToolBarVisible(CurrentUserManager.getCurrentUserProperties());
        boolean bTimeStamp = iIMPropsUtil.getTimeStampVisible(CurrentUserManager.getCurrentUserProperties());
        this.editContainer.showToolBar(bToolbar);
        this.horSplitPane.resetToPreferredSizes();
        this.showParticipantList(bParticipant);
        this.setShowTimeStamp(bTimeStamp);
        RoomView roomView = this;
        synchronized (roomView) {
            this.isInitialized = true;
            if (this._initialChatMsgs != null) {
                Iterator i = this._initialChatMsgs.iterator();
                while (i.hasNext()) {
                    Message m = (Message)i.next();
                    this.handleNewMsg(m);
                }
                this._initialChatMsgs = null;
            }
        }
    }

    public void showToolBar(boolean b) {
        int height = this.editContainer.getToolBarHeight();
        int divLoc = this.horSplitPane.getDividerLocation();
        this.editContainer.showToolBar(b);
        if (b && this.editContainer.isVisible()) {
            this.horSplitPane.setDividerLocation(divLoc - height);
        } else {
            this.horSplitPane.setDividerLocation(divLoc + height);
        }
    }

    public void showParticipantList(boolean b) {
        if (b) {
            this.verSplitPane.resetToPreferredSizes();
        } else {
            this.verSplitPane.setDividerLocation(this.verSplitPane.getMaximumDividerLocation());
        }
    }

    public boolean isToolBarVisible() {
        return this.editContainer.isToolBarVisible();
    }

    public boolean isModerateEnabled() {
        return !RoomManager.isLikelyPrivate(this.conf) && (UserAccessControl.isAdmin() || UserAccessControl.hasPrivilege(this.conf, 30));
    }

    public RoomEditorViewContainer getRoomEditorViewContainer() {
        return this.editContainer;
    }

    public boolean isConference() {
        return this._isConferenceRoom;
    }

    public void clearText() {
        this.msgContainer.getBean().clearText();
    }

    public void sendMessage() {
        this.editContainer.getBean().sendMessage();
    }

    public void save() {
        this.msgContainer.getBean().saveChat2File();
    }

    public void print() {
        this._activeRoomBean.print();
    }

    public void viewSource() {
        this._activeRoomBean.viewSource();
    }

    public void attach() {
        this.editContainer.attachFile();
    }

    public boolean hasWriteAccess() {
        return this.canSpeak;
    }

    public boolean isModetared() {
        return this.isModerated;
    }

    public void setShowTimeStamp(boolean b) {
        this.msgContainer.getBean().setShowTimeStamp(b);
    }

    private final void displayModeratedOn() {
        this.displayMessage(chatPanelBundle.getString("ChatPanel_roomhasbeenModerated"));
    }

    private final void displayModeratedOff() {
        this.displayMessage(chatPanelBundle.getString("ChatPanel_roomnotModerated"));
    }

    public final void displayMessage(String body) {
        this.msgContainer.getBean().displayMessage(body);
    }

    public final void displayMessage(boolean is_me, String body, String name) {
        this.msgContainer.getBean().displayMessage(is_me, body, name);
    }

    public void showInviteMsg(Message message) throws CollaborationException {
        String inviteMsg = ClientMessageFactory.getHTMLContent(message.getParts()[0]);
        String originator = StringUtility.removeResource((String)message.getOriginator());
        this.msgContainer.getBean().displayMessage(false, inviteMsg, UserCache.getDisplayName(originator));
        if (!CurrentUserManager.isCurrentUserID(originator)) {
            this.setBlink(true);
            Sound.play(4);
        }
        this.fireRoomViewUIListeners(this, 7, this.conf.getDestination(), null, message);
    }

    public void setInviteList(CollaborationPrincipal[] invitees) {
        if (invitees != null) {
            int i;
            if (this._inviteList == null) {
                this._inviteList = new LinkedList();
            }
            for (i = 0; i < invitees.length; ++i) {
                if (invitees[i] == null) continue;
                if (invitees[i] instanceof CollaborationGroup) {
                    CollaborationPrincipal[] usersInGroup = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(invitees[i].getUID());
                    if (usersInGroup == null) continue;
                    this.setInviteList(usersInGroup);
                    continue;
                }
                if (!(invitees[i] instanceof CollaborationPrincipal)) continue;
                this._inviteList.add(invitees[i]);
                this.userContainer.getBean().addRoomUserNotEntered(invitees[i].getUID(), invitees[i].getDisplayName());
            }
            this._invitees = new CollaborationPrincipal[this._inviteList.size()];
            i = 0;
            Iterator iter = this._inviteList.iterator();
            while (iter.hasNext()) {
                this._invitees[i++] = (CollaborationPrincipal)iter.next();
            }
        }
    }

    public String getRoomTitle() throws CollaborationException {
        String[] uids = this.userContainer.getBean().getUserList();
        CollaborationPrincipal[] users = UserCache.getPrincipal(uids);
        int userLength = users.length;
        int f = 0;
        if (RoomManager.isLikelyPrivate(this.conf)) {
            Manager.Out("Room is private");
        } else {
            Manager.Out("Room is public");
        }
        if (this.conf != null && !RoomManager.isLikelyPrivate(this.conf)) {
            return this.conf.getDestination();
        }
        if (uids.length <= 1) {
            return chatPanelBundle.getString("ChatFrame_None");
        }
        StringBuffer title = new StringBuffer();
        for (int d = 0; d < users.length; ++d) {
            if (CurrentUserManager.isCurrentUserID(users[d].getUID())) {
                --userLength;
                continue;
            }
            String displayName = users[d].getDisplayName();
            int fn = displayName.indexOf(" ");
            if (fn > 0) {
                displayName = displayName.substring(0, fn).trim();
            }
            if (f++ > 0) {
                title.append(", ");
            }
            title.append(displayName);
            if (f <= USER_TITLE_LENGTH || userLength - d <= 0) continue;
            title.append(" (+");
            title.append(userLength - d);
            title.append(")");
            break;
        }
        return title.toString();
    }

    public void close() {
        this.removeMenu();
        this.editContainer.close();
        this.userContainer.close();
        this.msgContainer.close();
        this.editContainer.removeRoomEditorUIListener(this);
        this.msgContainer.removeRoomMsgUIListener(this);
        this.conf.leave();
    }

    public final void validatePopup() {
        if (this.popup == null) {
            return;
        }
        this.popup.setVisible(false);
        this.popup.removeAll();
        this.popup.invalidate();
        this.popup.validate();
    }

    private void createMenu() {
        this.popup = new SmartJPopupMenu();
        this.sidechat = new JMenuItem(chatPanelBundle.getString("ChatPanel_sidechat___new_JMenuItem"));
        this.sidechat.addActionListener(this.lSymAction);
        if (UserAccessControl.canSendAlerts()) {
            this.alert = new JMenuItem(chatPanelBundle.getString("ChatPanel_alert___new_JMenuItem"));
            this.alert.addActionListener(this.lSymAction);
        }
    }

    private final void showPopup(Component c) {
        if (this.popup == null) {
            this.createMenu();
        } else {
            this.validatePopup();
        }
        if (c == this.btnOptions) {
            this.popup.add(this.sidechat);
            if (this.alert != null) {
                this.popup.add(this.alert);
            }
            this.popup.show(this.btnOptions, -100, -50);
        }
    }

    private void removeMenu() {
        if (this.popup != null) {
            this.sidechat.removeActionListener(this.lSymAction);
            if (this.alert != null) {
                this.alert.removeActionListener(this.lSymAction);
            }
        }
    }

    public final void showInviteDialog() throws CollaborationException {
        Object[] nu = new CollaborationPrincipal[]{};
        InviteUsers us = new InviteUsers((Frame)this._parentFrame, Manager.getVectorFromArray(nu), UserCache.getPrincipalVectorFromUids(UserStatusManager.getOnlineWatchedUsers()), true);
        us.setTitle(chatPanelBundle.getString("ChatPanel_usTitle"));
        us.setModal(true);
        us.setVisible(true);
        nu = us.getUserSelectionList();
        if (nu == null || nu.length == 0) {
            return;
        }
        String msg = JOptionPane.showInputDialog(this, (Object)chatPanelBundle.getString("Enter_Invite_Msg_2"));
        if (msg == null) {
            return;
        }
        Vector<Object> users = new Vector<Object>();
        for (int i = 0; i < nu.length; ++i) {
            if (!this.userContainer.getBean().isRoomUser(nu[i].getUID())) {
                this.userContainer.getBean().addRoomUserNotEntered(nu[i].getUID(), nu[i].getDisplayName());
                users.addElement(nu[i]);
            }
            if (nu[i] instanceof CollaborationGroup) {
                CollaborationPrincipal[] tmp = ServerGroupManager.getCollaborationPrincipalsInGroupFromServer(nu[i].getUID());
                if (tmp == null) continue;
                for (int n = 0; n < tmp.length; ++n) {
                    if (this.userContainer.getBean().isRoomUser(nu[i].getUID())) continue;
                    this.userContainer.getBean().addRoomUserNotEntered(nu[i].getUID(), nu[i].getDisplayName());
                    users.addElement(tmp[n]);
                }
                continue;
            }
            if (this.userContainer.getBean().isRoomUser(nu[i].getUID())) continue;
            this.userContainer.getBean().addRoomUserNotEntered(nu[i].getUID(), nu[i].getDisplayName());
            users.addElement(nu[i]);
        }
        if (users.size() == 0) {
            return;
        }
        users.copyInto(nu);
        this._invitees = nu;
        this.sendConferenceInvite(msg);
    }

    public final boolean isSelected() {
        return this.userContainer.getBean().usersHaveBeenSelected();
    }

    public void addStatus(String uid) {
        try {
            String roomTitle = this.getRoomTitle().toString();
            String msg = StringUtility.substitute((String)chatPanelBundle.getString("Chat_Composing"), (String)"__MACRO__", (String)UserCache.getDisplayName(uid));
            this.label.setText(msg);
            this.pnlOptions.updateUI();
            this.pnlOptions.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeStatus() {
        this.label.setText(" ");
    }

    public final void addContacts() {
        String[] uids = this.userContainer.getBean().getSelectedUIDs();
        if (uids == null || uids.length < 1) {
            return;
        }
        Object[] users = UserCache.getPrincipal(uids);
        Vector uv = Manager.getVectorFromArray(users);
        AddContact ac = new AddContact((Frame)this._parentFrame, uv, false);
        ac.setModal(true);
        ac.setVisible(true);
    }

    public final void handleChat() {
        String[] uids = this.userContainer.getBean().getSelectedUIDs();
        if (uids == null || uids.length < 1) {
            return;
        }
        this.fireRoomViewUIListeners(this, 5, this.conf.getDestination(), uids, null);
    }

    public final void handleAlert() {
        this.fireRoomViewUIListeners(this, 6, this.conf.getDestination(), this.userContainer.getBean().getSelectedUIDs(), null);
    }

    private void sendAckMessage(Message message, boolean accept) {
        if (accept) {
            String text = chatPanelBundle.getString("ChatPanel_ackBody");
            ClientMessageFactory.sendModeratedConferenceMsg(message, this.conf, 34, text);
        } else {
            String text = chatPanelBundle.getString("ChatPanel_nackBody");
            ClientMessageFactory.sendModeratedConferenceMsg(message, this.conf, 40, text);
        }
    }

    private final void newModeratedMessageAdded(Message m) {
        ClientMessageFactory.printMessage(m);
        String uid = StringUtility.removeResource((String)m.getOriginator());
        Manager.Out("Message Originator = " + uid);
        CollaborationPrincipal cp = UserCache.getPrincipal(uid);
        boolean is_me = CurrentUserManager.isCurrentUserID(uid);
        this.userContainer.setUserStatusChatting(uid);
        Manager.Out("RoomView.java: newModeratedMessageAdded(), moderate: " + this.moderate);
        if (!this.moderate) {
            MessagePart[] parts = m.getParts();
            String msg = ClientMessageFactory.getHTMLContent(parts[0]);
            if (msg == null) {
                return;
            }
            this.msgContainer.getBean().displayMessage(is_me, msg, null);
        } else if (this.modContainer.getBean().getMessageQueueSize() >= Manager.MAX_MODERATED_TABLE_ITEMS) {
            this.sendAckMessage(m, false);
        } else {
            this.sendAckMessage(m, true);
            this.modContainer.getBean().addQuestion(cp, m);
        }
        if (!is_me) {
            this.setBlink(true);
            Sound.play(4);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewMsg(Message m) {
        try {
            String type;
            ClientMessageFactory.printMessage(m);
            RoomView roomView = this;
            synchronized (roomView) {
                if (!this.isInitialized) {
                    if (this._initialChatMsgs == null) {
                        this._initialChatMsgs = new ArrayList();
                    }
                    this._initialChatMsgs.add(m);
                    return;
                }
            }
            String uid = StringUtility.removeResource((String)m.getOriginator());
            Manager.Out("Message Originator = " + uid);
            CollaborationPrincipal cp = UserCache.getPrincipal(uid);
            boolean is_me = CurrentUserManager.isCurrentUserID(uid);
            if (this.typingUserID == uid) {
                this.typingUserID = null;
            }
            if ("text/plain".equals(type = m.getContentType()) || "text/html".equals(type)) {
                this.userContainer.setUserStatusChatting(uid);
                MessagePart[] parts = m.getParts();
                if (parts.length == 1) {
                    Manager.Out(" Message content is " + ClientMessageFactory.getHTMLContent(parts[0]));
                    this.msgContainer.displayMessage(is_me, ClientMessageFactory.getHTMLContent(parts[0]), cp.getDisplayName());
                    if (!is_me) {
                        this.setBlink(true);
                        Sound.play(4);
                    }
                } else if (!CurrentUserManager.isCurrentUserID(cp.getUID())) {
                    String msg = StringUtility.substitute((String)chatPanelBundle.getString("Attachment_received_from_"), (String)"__MACRO__", (String)cp.getDisplayName());
                    this.msgContainer.displayMessage(msg);
                    this.fireRoomViewUIListeners(this, 7, this.conf.getDestination(), null, m);
                    if (!is_me) {
                        this.setBlink(true);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent e) {
        boolean enable = this.isSelected();
        this._roomViewContainer.getRoomFrame().setToolsMenu(enable);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void exit() {
        this.fireRoomViewUIListeners(this, 2, this.conf.getDestination());
    }

    void btnOptions_actionPerformed(ActionEvent event) {
        this.showPopup(this.btnOptions);
    }

    void btnModerate_actionPerformed(ActionEvent event) {
    }

    public void moderate() {
        try {
            this.conf.moderate(!this.moderate);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public void setBlink(boolean b) {
        if (b) {
            this.fireRoomViewUIListeners(this, 1, this.conf.getDestination());
        } else {
            this.fireRoomViewUIListeners(this, 0, this.conf.getDestination());
        }
    }

    public void sendConferenceMsg(String msg) throws Exception {
        Manager.Out("RoomView.java / sendRoomMsg");
        Manager.Out("RoomView.java: canSpeak: " + this.canSpeak);
        Manager.Out("RoomView.java: isModerated: " + this.isModerated);
        if (this.editContainer.attach_file != null) {
            this.sendAttachment();
        }
        if (msg == null || msg.equals("")) {
            return;
        }
        Message m = ClientMessageFactory.createRoomMsg("text/html", msg, this.conf);
        if (this.canSpeak) {
            ClientMessageFactory.sendConferenceMsg(m, this.conf);
        } else if (this.isModerated && this.userHasReadAccess) {
            ClientMessageFactory.sendModeratedConferenceMsg(m, this.conf, 32, null);
        }
    }

    private void sendAttachment() {
        if (this.editContainer.attach_file != null) {
            ArrayList<File> files = new ArrayList<File>(1);
            files.add(this.editContainer.attach_file);
            ClientMessageFactory.sendAttachments(this.userContainer.getBean().getUserList(), files, true);
        }
    }

    public void sendConferenceInvite(String msg) {
        boolean removeMe = true;
        try {
            if (this.editContainer.attach_file != null) {
                this.sendAttachment();
            }
            if (msg == null || msg.equals("")) {
                msg = " ";
            }
            ClientMessageFactory.sendInviteMsg(this._invitees, msg, this.conf, removeMe, this);
            this._invitees = null;
        }
        catch (CollaborationException e) {
            Manager.Out("Unable to send Invite Msg to the invitees " + e.toString());
        }
    }

    public void sendConferenceTypingMsg(boolean on) {
        System.out.println("Send Room TYPING " + on);
        ClientMessageFactory.sendTypingMsg(this.conf, on);
    }

    public void newRoomEditorEvent(RoomEditorUIEvent evt) {
        try {
            RoomFrame rf = this._roomViewContainer.getRoomFrame();
            switch (evt.getType()) {
                case 0: {
                    if (this._invitees != null) {
                        Manager.Out("Sending an invite message");
                        this.sendConferenceInvite(evt.getMessageText());
                        this.msgContainer.displayMessage(true, evt.getMessageText(), CurrentUserManager.getCurrentUserDisplayName());
                        this.setBlink(false);
                        this.editContainer.validateView();
                        break;
                    }
                    Manager.Out("Invitee list is null");
                    this.sendConferenceMsg(evt.getMessageText());
                    this.setBlink(false);
                    this.editContainer.validateView();
                    break;
                }
                case 1: {
                    System.out.println(" New RoomEditorUIEvent:   EV_TYPING_OFF " + evt.getType());
                    this.sendConferenceTypingMsg(false);
                    break;
                }
                case 2: {
                    Manager.Out("RoomView.newRoomEditorEvent: received: RoomEditorUIEvent.EV_TYPING_ON");
                    this.setBlink(false);
                    if (this._invitees == null || this._invitees.length == 0) {
                        this.sendConferenceTypingMsg(true);
                    }
                    break;
                }
                case 3: {
                    System.out.println(" New RoomEditorUIEvent:   EV_FORMAT_CHANGE " + evt.getType());
                    break;
                }
                case 4: {
                    this.setBlink(false);
                    this._activeRoomBean = this.editContainer.getBean();
                    rf.setEditItemsEnabled(true);
                    rf.validate();
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            Manager.Out("Exception e:" + e);
        }
    }

    public void newRoomMsgEvent(RoomMsgUIEvent evt) {
        RoomFrame rf = this._roomViewContainer.getRoomFrame();
        switch (evt.getType()) {
            case 1: {
                this._activeRoomBean = this.msgContainer.getBean();
                rf.setEditItemsEnabled(false);
                rf.validate();
                break;
            }
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
    }

    public final void addRoomViewUIListener(RoomViewUIListener l) {
        if (!this.roomListeners.contains(l)) {
            this.roomListeners.add(l);
        }
    }

    public final void removeRoomViewUIListener(RoomViewUIListener l) {
        this.roomListeners.remove(l);
    }

    public final void fireRoomViewUIListeners(Object src, int type, String room_id) {
        this.fireRoomViewUIListeners(src, type, room_id, null, null);
    }

    public final void fireRoomViewUIListeners(Object src, int type, String room_id, String[] uids, Object msg_obj) {
        RoomViewUIEvent event = new RoomViewUIEvent(src, type, room_id, uids, msg_obj);
        Iterator i = this.roomListeners.iterator();
        while (i.hasNext()) {
            RoomViewUIListener listener = (RoomViewUIListener)i.next();
            listener.newRoomViewEvent(event);
        }
    }

    public void addTextMessage(String text) throws MessengerException {
        try {
            this.sendConferenceMsg(text);
        }
        catch (Exception e) {
            Manager.Out("Exception e:" + e);
        }
    }

    public synchronized void addConferenceListener(MessengerConferenceListener listener) {
        if (this._listeners == null) {
            this._listeners = new LinkedList();
        }
        this._listeners.add(listener);
    }

    public synchronized void removeConferenceListener(MessengerConferenceListener listener) {
        this._listeners.remove(listener);
    }

    public Component getComponent() {
        return this;
    }

    public MessengerAppContext getAppContext() {
        return iIM._client;
    }

    public void outputError(String errorText) {
        JOptionPane.showMessageDialog(this, errorText);
    }

    public void setServerArchive(boolean b) {
    }

    public boolean isSomeoneTyping(boolean includingMe) {
        Manager.Out("RoomView.isSomeoneTyping(): typingUserID: " + this.typingUserID);
        if (includingMe) {
            return this.typingUserID != null;
        }
        return this.typingUserID != null && this.typingUserID != CurrentUserManager.getCurrentUserID();
    }

    public boolean isSomeoneElseThanMeTyping() {
        return this.isSomeoneTyping(false);
    }

    public boolean requestDefaultFocus() {
        if (this.pnlEdit.isVisible()) {
            return this.editContainer.requestDefaultFocus();
        }
        return super.requestDefaultFocus();
    }

    public void onError(CollaborationException e) {
        Manager.Out("Implement the onError listener method in the RoomView class later");
    }

    public void onEvent(String event) {
        SwingUtilities.invokeLater(new UserStatusChangeThread(event, this));
    }

    public void onMessageAdded(Message message) {
        Manager.Out("OnMessage added called");
        SwingUtilities.invokeLater(new NewRoomMessageRunnable(message));
    }

    public void onRsvp(String destination, Message message, boolean accepted) {
        Manager.Out("onRSvp is called");
        ClientMessageFactory.printMessage(message);
    }

    public void onRsvp(String destination, boolean accepted) {
        Manager.Out("onRSVP called, accepted = " + accepted);
    }

    public Conference getConference() {
        return this.conf;
    }

    public void onModeratedMessageAdded(Message message) {
        Manager.Out("OnMessage added called");
        SwingUtilities.invokeLater(new NewRoomMessageRunnable(message));
    }

    public void onModeratedMessageStatus(Message message, int status, String reason) {
        if (status == 32) {
            this.newModeratedMessageAdded(message);
        } else {
            MessagePart[] parts = message.getParts();
            String format = null;
            if (status == 36) {
                format = chatPanelBundle.getString("moderated_message_approved");
            } else if (status == 38) {
                format = chatPanelBundle.getString("moderated_message_modified");
            } else if (status == 40) {
                format = chatPanelBundle.getString("moderated_message_rejected");
            } else if (status == 34) {
                format = chatPanelBundle.getString("moderated_message_pending");
            } else {
                Manager.debug("Unknown status");
                return;
            }
            format = StringUtility.substitute((String)format, (String)"__MACRO1__", (String)reason);
            this.msgContainer.displayMessage(ClientMessageFactory.getHTMLContent(parts[0]), format);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RoomView.this.btnModerate) {
                RoomView.this.btnModerate_actionPerformed(event);
            } else if (object == RoomView.this.btnOptions) {
                RoomView.this.btnOptions_actionPerformed(event);
            } else if (object == RoomView.this.alert) {
                RoomView.this.validatePopup();
                RoomView.this.handleAlert();
            } else if (object == RoomView.this.sidechat) {
                RoomView.this.validatePopup();
                RoomView.this.handleChat();
            }
        }
    }

    private class NewRoomMessageRunnable
    implements Runnable {
        private Message message;

        public NewRoomMessageRunnable(Message message) {
            this.message = message;
        }

        public void run() {
            try {
                RoomView.this.handleNewMsg(this.message);
            }
            catch (Exception e) {
                e.printStackTrace();
                Manager.Out("Could not post the new Chat Message " + e.toString());
            }
        }
    }

    private class UserStatusChangeThread
    implements Runnable {
        private String event;
        private RoomView rv;

        public UserStatusChangeThread(String event, RoomView rv) {
            this.event = event;
            this.rv = rv;
        }

        public void run() {
            try {
                for (int attempt = 0; !this.rv.isInitialized() && attempt < 4; ++attempt) {
                    try {
                        Manager.Out("Waiting for RoomView to get intialized. Attempt - " + attempt);
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                if (!this.rv.isInitialized()) {
                    Manager.Out("Room View is not intialized so cannot process the conference event");
                    return;
                }
                ConferenceEventHelper ch = new ConferenceEventHelper(this.event);
                ArrayList tuples = (ArrayList)ch.getTuples();
                int status = -1;
                String uid = null;
                Iterator i = tuples.iterator();
                while (i.hasNext()) {
                    ConferenceEventTuple tuple = (ConferenceEventTuple)i.next();
                    status = Integer.parseInt(tuple.status);
                    uid = tuple.destination;
                }
                CollaborationPrincipal nu = UserCache.getPrincipal(uid);
                if (nu == null) {
                    return;
                }
                Object note = null;
                Manager.Out("In UserStatusChangeThread get the Accesslevel later on from the ConferenceEvent Tuple");
                Manager.Out("This is crucial for the working of the Moderated feature properly");
                if (RoomManager.isLikelyPrivate(this.rv.getConference()) || UserAccessControl.hasPrivilege(this.rv.getConference(), 30)) {
                    RoomView.this.canSpeak = true;
                }
                if (status == 32) {
                    Manager.Out("RoomView.UserStatusChangeThread.run(): moderation is ON");
                    if (CurrentUserManager.isCurrentUserID(uid)) {
                        RoomView.this.startModerating();
                    }
                    if (!RoomView.this.isModerated) {
                        this.rv.displayModeratedOn();
                        RoomView.this._roomViewContainer.changeModeratedTabTitleOn(this.rv);
                    }
                    RoomView.this.isModerated = true;
                    RoomView.this.moderators.add(UserCache.getPrincipal(uid));
                    if (!RoomView.this.canSpeak) {
                        RoomView.this.showCompose(true);
                    }
                } else if (status == 33) {
                    Manager.Out("RoomView.UserStatusChangeThread.run(): moderation is OFF");
                    if (CurrentUserManager.isCurrentUserID(uid)) {
                        RoomView.this.stopModerating();
                    }
                    for (int i2 = 0; i2 < RoomView.this.moderators.size(); ++i2) {
                        CollaborationPrincipal u = (CollaborationPrincipal)RoomView.this.moderators.elementAt(i2);
                        if (!uid.equals(u.getUID())) continue;
                        RoomView.this.moderators.remove(i2);
                        break;
                    }
                    if (RoomView.this.moderators.size() == 0) {
                        RoomView.this.isModerated = false;
                        RoomView.this._roomViewContainer.changeModeratedTabTitleOff(RoomView.this.conf, this.rv);
                        if (!RoomView.this.canSpeak) {
                            RoomView.this.showCompose(false);
                        }
                        this.rv.displayModeratedOff();
                    }
                } else if (status == 12) {
                    if (RoomView.this.userContainer.getBean().getModel().getUserStatus(nu.getUID()) != 2) {
                        String[] userList;
                        RoomView.this.userContainer.addRoomUser(nu.getUID(), nu.getDisplayName());
                        if (!(!RoomView.this.canSpeak && RoomView.this._isConferenceRoom || CurrentUserManager.isCurrentUserID(nu.getUID()) || (userList = RoomView.this.userContainer.getBean().getUserList()).length <= 2)) {
                            RoomView.this.msgContainer.displayUserJoinedMsg(nu.getDisplayName());
                        }
                        if (RoomManager.isLikelyPrivate(RoomView.this.conf)) {
                            RoomView.this.fireRoomViewUIListeners(this, 3, RoomView.this.conf.getDestination());
                        }
                    }
                } else if (status == 99) {
                    RoomView.this.userContainer.addRoomUser(nu.getUID(), nu.getDisplayName());
                } else if (status == 11) {
                    RoomView.this.userContainer.addRoomUserNotEntered(nu.getUID(), nu.getDisplayName());
                    RoomView.this.userContainer.getBean().removeRoomUser(nu.getUID(), false);
                    RoomView.this.msgContainer.displayUserLeftMsg(nu.getDisplayName());
                    if (RoomManager.isLikelyPrivate(RoomView.this.conf)) {
                        RoomView.this.fireRoomViewUIListeners(this, 3, RoomView.this.conf.getDestination());
                    }
                } else if (status == 9) {
                    Manager.Out("RoomView.UserStatusChange(): Received event user input started for uid: " + nu.getUID());
                    RoomView.this.userContainer.setUserStatusTypingOn(nu.getUID());
                    RoomView.this.typingUserID = nu.getUID();
                    if (!CurrentUserManager.isCurrentUserID(RoomView.this.typingUserID)) {
                        RoomView.this.addStatus(RoomView.this.typingUserID);
                    }
                } else if (status == 10) {
                    Manager.Out("RoomView.UserStatusChange(): Received event user input stoped for uid: " + nu.getUID());
                    RoomView.this.userContainer.setUserStatusTypingOff(nu.getUID());
                    RoomView.this.typingUserID = null;
                    RoomView.this.removeStatus();
                } else {
                    Manager.Out(".... UNKNOWN USER STATUS!" + status, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Manager.Out("Exception e:" + e);
            }
        }
    }
}

