/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.SwingImageManager;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JList;

public class RoomUserListModel
extends AbstractListModel {
    private JList theList;
    private Vector idList = new Vector(5);
    private Vector displayList = new Vector(5);
    private Hashtable userStatus = new Hashtable(4);
    public static final int EV_USER_AWAY = 0;
    public static final int EV_USER_LEFT = 1;
    public static final int EV_USER_ENTERED = 2;
    public static final int EV_USER_OFFLINE = 3;
    public static final int EV_USER_CHATTING = 4;
    public static final int EV_USER_TYPING_ON = 10;
    public static final int EV_USER_TYPING_OFF = 11;
    public static final int EV_USER_SEND_FILE = 12;
    public static final int EV_USER_RECEIVE_FILE = 13;

    public RoomUserListModel(JList l) {
        this.theList = l;
    }

    public final String getUserDisplayAt(int index) {
        return UserCache.getDisplayName((String)this.idList.elementAt(index));
    }

    public final void addUser(String id, String display, int status) {
        if (!this.idList.contains(id)) {
            this.idList.addElement(id);
            this.displayList.addElement(display);
            this.userStatus.put(id, new Integer(status));
        }
    }

    public final boolean containsUser(String id) {
        return this.idList.contains(id);
    }

    public void setUserStatus(String uid, int stat) {
        this.userStatus.put(uid, new Integer(stat));
    }

    public void removeUser(String uid, boolean hide) {
        int n = this.idList.indexOf(uid);
        if (n < 0) {
            return;
        }
        this.displayList.removeElementAt(n);
        this.idList.removeElementAt(n);
        this.userStatus.remove(uid);
        this.fireIntervalRemoved(this.theList, n, n);
    }

    public int getSize() {
        return this.idList.size();
    }

    public Object getElementAt(int index) {
        return this.displayList.elementAt(index);
    }

    public String getUserIDAt(int n) {
        return (String)this.idList.elementAt(n);
    }

    public String[] getUserList() {
        Object[] ret = new String[this.idList.size()];
        this.idList.copyInto(ret);
        return ret;
    }

    public int getUserStatusAt(int n) {
        return this.getUserStatus((String)this.idList.elementAt(n));
    }

    public int getUserStatus(String id) {
        Integer i = (Integer)this.userStatus.get(id);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public String getName(int index) {
        return this.getUserDisplayAt(index);
    }

    public final Icon getIcon(int index) {
        switch (this.getUserStatusAt(index)) {
            case 4: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/cp_active.png", (Object)this);
            }
            case 2: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/cp_active.png", (Object)this);
            }
            case 0: {
                return SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", this);
            }
            case 1: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/blankicon.gif", (Object)this);
            }
            case 3: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/blankicon.gif", (Object)this);
            }
            case 10: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/cp_typing.png", (Object)this);
            }
            case 11: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/cp_active.png", (Object)this);
            }
            case 12: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/cp_typing.png", (Object)this);
            }
            case 13: {
                return SwingImageManager.getIcon("/com/iplanet/im/client/images/cp_active.png", (Object)this);
            }
        }
        return SwingImageManager.getIcon("/com/iplanet/im/client/images/blankicon.gif", (Object)this);
    }

    public final void changed() {
        this.fireContentsChanged(this.theList, 0, this.getSize());
    }
}

