/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.chat.bean.RoomUserListModel;
import com.iplanet.im.client.swing.chat.bean.RoomUserListRenderer;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.util.AutoOrientationJPanel;
import com.iplanet.im.client.util.ImagePaintingViewport;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.iIMPropsUtil;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class RoomUserListBean
extends AutoOrientationJPanel
implements ActionListener,
MouseListener,
PropertyChangeListener {
    static SafeResourceBundle chatBundle = Chat.chatPanelBundle;
    private JList lstUsers;
    private RoomUserListModel model;
    private RoomView roomView;
    private SmartJPopupMenu popup;
    private JMenuItem chat;
    private JMenuItem alert;
    private JMenuItem add;
    JScrollPane scrollUsers = new JScrollPane();
    ImagePaintingViewport imagePaintingVP;

    public RoomUserListBean(RoomView rv) {
        this.initComponents(rv);
        this.roomView = rv;
        this.lstUsers.addMouseListener(this);
    }

    private void initComponents(RoomView rv) {
        this.lstUsers = new JList();
        this.imagePaintingVP = new ImagePaintingViewport();
        this._loadBgTexIcon();
        UserPropsManager.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout());
        this.scrollUsers.setViewport(this.imagePaintingVP);
        this.scrollUsers.setVerticalScrollBarPolicy(20);
        this.scrollUsers.setHorizontalScrollBarPolicy(30);
        this.scrollUsers.setOpaque(true);
        this.add("Center", this.scrollUsers);
        this.scrollUsers.setViewportView(this.lstUsers);
        this.popup = new SmartJPopupMenu();
        if (Manager.ALLOW_CHAT) {
            this.chat = new JMenuItem(chatBundle.getString("Side_Chat"));
            this.popup.add(this.chat);
            this.chat.addActionListener(this);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.alert = new JMenuItem(chatBundle.getString("Send_Alert"));
            this.popup.add(this.alert);
            this.alert.addActionListener(this);
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.add = new JMenuItem(chatBundle.getString("Add_to_Contact_List"));
            this.popup.add(this.add);
            this.add.addActionListener(this);
        }
        this.model = new RoomUserListModel(this.lstUsers);
        this.lstUsers.setModel(this.model);
        this.lstUsers.addMouseListener(rv);
        RoomUserListRenderer renderer = new RoomUserListRenderer(this.model);
        this.lstUsers.setCellRenderer(renderer);
        this.model.changed();
    }

    public boolean usersHaveBeenSelected() {
        return this.lstUsers.getSelectedIndex() != -1;
    }

    public void close() {
        UserPropsManager.removePropertyChangeListener(this);
    }

    public void handleUserStatusChange(RoomUserListModel evt) {
    }

    public RoomUserListModel getModel() {
        return this.model;
    }

    public boolean isRoomUser(String uid) {
        return this.model.containsUser(uid);
    }

    public void addRoomUserEntered(String uid, String display) {
        this.addRoomUser(uid, display, 2);
    }

    public void addRoomUserNotEntered(String uid, String display) {
        this.addRoomUser(uid, display, 3);
    }

    public void addRoomUser(String uid, String display, int status) {
        this.model.addUser(uid, display, status);
        this.setUserStatus(uid, status);
    }

    public void removeRoomUser(String uid, boolean hide) {
        this.model.removeUser(uid, hide);
    }

    public void setUserStatus(String uid, int status) {
        this.model.setUserStatus(uid, status);
        this.model.changed();
    }

    public void showParticipantList(boolean b) {
        this.setVisible(b);
    }

    public boolean isPListVisible() {
        return this.isVisible();
    }

    public String[] getSelectedUIDs() {
        int[] sel = this.lstUsers.getSelectedIndices();
        String[] ret = new String[sel.length];
        for (int n = 0; n < sel.length; ++n) {
            ret[n] = this.model.getUserIDAt(sel[n]);
        }
        return ret;
    }

    public String[] getUserList() {
        return this.model.getUserList();
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            this.roomView.handleChat();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if ((SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) && (Manager.ALLOW_CHAT || Manager.ALLOW_SEND_ALERTS || Manager.ALLOW_CONTACT_MANAGEMENT)) {
            this.popup.show(e.getComponent(), new Point(e.getX(), e.getY()));
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.chat) {
            this.roomView.handleChat();
        } else if (object == this.alert) {
            this.roomView.handleAlert();
        } else if (object == this.add) {
            this.roomView.addContacts();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._loadBgTexIcon();
    }

    private void _loadBgTexIcon() {
        String name = iIMPropsUtil.getBackgroundTexture(UserPropsManager.loadUserProperties(CurrentUserManager.getCurrentProfile()));
        ImageIcon icon = SwingImageManager.getBgPatternIcon(name);
        this.imagePaintingVP.setIcon(icon);
        this.lstUsers.setOpaque(icon == null);
    }
}

