/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.EmoticonsManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserPropsManager;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.chat.bean.RoomMsgUIEvent;
import com.iplanet.im.client.swing.chat.bean.RoomMsgUIListener;
import com.iplanet.im.client.swing.chat.bean.RoomViewBean;
import com.iplanet.im.client.swing.models.iIMLinkListener;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.IMHTMLEditorKit;
import com.iplanet.im.client.util.ImagePaintingViewport;
import com.iplanet.im.client.util.Orientation;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.StickyFileChooser;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.util.HtmlUtility;
import com.sun.im.service.util.StringUtility;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTML;

public class RoomMsgViewBean
extends JPanel
implements RoomViewBean,
PropertyChangeListener {
    static SafeResourceBundle chatPanelBundle = Chat.chatPanelBundle;
    static SafeResourceBundle brandBundle = null;
    private boolean _showTimeStamp = true;
    private SymAction lSymAction = new SymAction();
    private SymMouse aSymMouse = new SymMouse();
    private LinkedList chatListeners = new LinkedList();
    private SmartJPopupMenu popup;
    private JMenuItem source;
    private JMenuItem print;
    private JMenuItem save;
    private JFrame _parentFrame;
    IMHTMLEditorKit aEditorKit = new IMHTMLEditorKit();
    private Object lock = new Object();
    private boolean queueMessages = false;
    private Vector messageFlags = new Vector();
    private Vector messageBodies = new Vector();
    private Vector messageNames = new Vector();
    private Object displayLock = new Object();
    private iIMLinkListener chatLinkListener;
    private Hashtable _commands = null;
    private JScrollPane scrollPane;
    private JEditorPane txtView;
    private ImagePaintingViewport imagePaintingVP;
    private JPanel pnlView;

    public RoomMsgViewBean(JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.initComponents();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.imagePaintingVP = new ImagePaintingViewport();
        this.scrollPane.setViewport(this.imagePaintingVP);
        this.txtView = new JEditorPane();
        this._loadBgTexIcon();
        UserPropsManager.addPropertyChangeListener(this);
        this.pnlView = new JPanel();
        this.setLayout(new BorderLayout(0, 0));
        this.scrollPane.setAutoscrolls(true);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setOpaque(true);
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mousePressed(MouseEvent e) {
                Object object = RoomMsgViewBean.this.lock;
                synchronized (object) {
                    RoomMsgViewBean.this.queueMessages = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseReleased(MouseEvent e) {
                Object object = RoomMsgViewBean.this.lock;
                synchronized (object) {
                    Object object2 = RoomMsgViewBean.this.displayLock;
                    synchronized (object2) {
                        RoomMsgViewBean.this.queueMessages = false;
                        RoomMsgViewBean.this.updateMessages();
                    }
                }
            }
        });
        this.add("Center", this.scrollPane);
        this.txtView.setContentType("text/html");
        this.txtView.setEditable(false);
        this.scrollPane.setViewportView(this.txtView);
        this.txtView.setEditorKit(this.aEditorKit);
        this.txtView.addMouseListener(this.aSymMouse);
        this.txtView.addFocusListener(new FocusListener(){

            public final void focusGained(FocusEvent e) {
                RoomMsgViewBean.this.fireRoomMsgUIListeners(RoomMsgViewBean.this.txtView, 1);
            }

            public final void focusLost(FocusEvent e) {
                RoomMsgViewBean.this.fireRoomMsgUIListeners(RoomMsgViewBean.this.txtView, 2);
            }
        });
        Dimension dim = SwingUtils.getComponentSize(this.txtView, 70, 6);
        this.txtView.setPreferredSize(dim);
        this.chatLinkListener = new iIMLinkListener();
        this.txtView.addHyperlinkListener(this.chatLinkListener);
        Orientation.apply(this.txtView);
    }

    private void createMenu() {
        this.popup = new SmartJPopupMenu();
        this.source = new JMenuItem(chatPanelBundle.getString("View_Source"));
        this.print = new JMenuItem(chatPanelBundle.getString("Print"));
        this.save = new JMenuItem(chatPanelBundle.getString("Save"));
        this.source.addActionListener(this.lSymAction);
        this.print.addActionListener(this.lSymAction);
        this.save.addActionListener(this.lSymAction);
    }

    public void setFocus() {
        this.txtView.requestFocus();
    }

    private final void showPopup(int x, int y) {
        if (this.popup == null) {
            this.createMenu();
            this.popup.add(this.source);
            this.popup.add(this.print);
            this.popup.add(this.save);
        }
        this.popup.show(this.txtView, new Point(x, y));
    }

    public void close() {
        UserPropsManager.removePropertyChangeListener(this);
    }

    public String getHtmlSource() {
        return EditorUtility.getHtmlDocumentText(this.txtView);
    }

    public void setShowTimeStamp(boolean b) {
        this._showTimeStamp = b;
    }

    public boolean usingTimeStamp() {
        return this._showTimeStamp;
    }

    public JEditorPane getTextPane() {
        return this.txtView;
    }

    public final String getTimeStamp() {
        Calendar c = Calendar.getInstance();
        StringBuffer ret = new StringBuffer();
        if (c.get(11) > 12) {
            ret.append(c.get(11) - 12);
        } else {
            ret.append(c.get(11));
        }
        ret.append(":");
        if (c.get(12) < 10) {
            ret.append("0");
        }
        ret.append(c.get(12));
        ret.append(":");
        if (c.get(13) < 10) {
            ret.append("0");
        }
        ret.append(c.get(13));
        return ret.toString();
    }

    private final String colorDefaultUser(String body, String user) {
        StringBuffer buff = new StringBuffer();
        return buff.toString();
    }

    public final void displayMessage(String body) {
        this.displayMessage(false, body, null);
    }

    private void updateMessages() {
        for (int i = 0; i < this.messageBodies.size(); ++i) {
            Boolean b = (Boolean)this.messageFlags.get(i);
            this.doDisplayMessage(b, (String)this.messageBodies.get(i), (String)this.messageNames.get(i));
        }
        this.messageFlags.removeAllElements();
        this.messageBodies.removeAllElements();
        this.messageNames.removeAllElements();
    }

    public final synchronized void displayMessage(boolean is_me, String body, String name) {
        this.displayMessage(is_me, body, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void displayMessage(boolean is_me, String body, String name, String format) {
        Object object = this.displayLock;
        synchronized (object) {
            if (this.queueMessages) {
                this.messageFlags.add(new Boolean(is_me));
                this.messageBodies.add(body);
                this.messageNames.add(name);
            } else {
                this.doDisplayMessage(is_me, body, name, format);
            }
        }
    }

    private void doDisplayMessage(boolean is_me, String body, String name) {
        this.doDisplayMessage(is_me, body, name, null);
    }

    private void doDisplayMessage(boolean is_me, String body, String name, String format) {
        StringBuffer buf = new StringBuffer();
        buf.append("<" + HTML.Tag.P + ">");
        buf.append("<" + HTML.Tag.FONT + " " + HTML.Attribute.STYLE + "='");
        if (name == null) {
            buf.append(brandBundle.getString("message.header.style.anonymous-user"));
        } else if (is_me) {
            buf.append(brandBundle.getString("message.header.style.current-user"));
        } else {
            buf.append(brandBundle.getString("message.header.style.other-user"));
        }
        buf.append("'>");
        if (name != null) {
            buf.append(name);
            buf.append(" ");
        }
        if (this._showTimeStamp) {
            buf.append(this.getTimeStamp());
            buf.append(" ");
        }
        buf.append(brandBundle.getString("messanger_username_delimeter"));
        buf.append(" ");
        buf.append("</" + HTML.Tag.FONT + ">");
        body = EmoticonsManager.substituteHTMLEmoticons(body);
        body = HtmlUtility.convertLinks((String)body);
        StringBuffer contents = new StringBuffer();
        String[] msgParts = HtmlUtility.splitFirstParagraph((String)body, (HTML.Tag)HTML.Tag.P);
        if (msgParts == null) {
            contents.append(body);
        } else {
            String str = HtmlUtility.substitute((String)msgParts[0], (String)" ", (String)"&nbsp;");
            contents.append(str);
        }
        contents.append("</" + HTML.Tag.P + ">");
        if (msgParts != null && msgParts[1] != null && msgParts[1].length() > 0) {
            contents.append(msgParts[1]);
        }
        if (format != null) {
            buf.append(StringUtility.substitute((String)format, (String)"__MACRO__", (String)contents.toString()));
        } else {
            buf.append(contents);
        }
        Manager.Out("doDisplayMessage: " + buf.toString());
        try {
            EditorUtility.appendToDocument(buf.toString(), this.txtView);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setValidLineView();
    }

    public void clearText() {
        StringBuffer tmp = new StringBuffer();
        this.txtView.setDocument(this.txtView.getEditorKit().createDefaultDocument());
    }

    public final void setValidLineView() {
        int length = this.txtView.getDocument().getLength();
        if (length < 65) {
            this.txtView.select(0, 0);
        } else {
            this.txtView.select(length - 1, length - 1);
        }
    }

    public final void print() {
        iIMUtility.printDoc(this._parentFrame, this._parentFrame.getTitle(), this.txtView);
    }

    public final void viewSource() {
        EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(this.txtView), "Source");
    }

    public final void saveChat2File() {
        File file = null;
        try {
            file = StickyFileChooser.chooseSaveFile(this._parentFrame, null, ".html", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (file == null) {
            JOptionPane.showMessageDialog(this._parentFrame, chatPanelBundle.getString("error_opening_file"));
            return;
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            out.print(EditorUtility.getHtmlDocumentText(this.txtView));
            out.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this._parentFrame, chatPanelBundle.getString("error_writing_to_file"));
            return;
        }
    }

    public final void insertDocumentText(int pos, String text) {
        try {
            BufferedReader bufin = new BufferedReader(new StringReader(text));
            this.txtView.getEditorKit().read(bufin, this.txtView.getDocument(), pos);
            bufin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public void copy() {
        this.txtView.copy();
    }

    public final void addRoomMsgUIListener(RoomMsgUIListener l) {
        if (!this.chatListeners.contains(l)) {
            this.chatListeners.add(l);
        }
    }

    public final void removeRoomMsgUIListener(RoomMsgUIListener l) {
        if (this.chatListeners != null) {
            this.chatListeners.remove(l);
        }
    }

    public final void fireRoomMsgUIListeners(Object src, int type) {
        RoomMsgUIEvent event = new RoomMsgUIEvent(src, type);
        Iterator i = this.chatListeners.iterator();
        while (i.hasNext()) {
            RoomMsgUIListener listener = (RoomMsgUIListener)i.next();
            listener.newRoomMsgEvent(event);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._loadBgTexIcon();
    }

    private void _loadBgTexIcon() {
        String name = iIMPropsUtil.getBackgroundTexture(UserPropsManager.loadUserProperties(CurrentUserManager.getCurrentProfile()));
        ImageIcon icon = SwingImageManager.getBgPatternIcon(name);
        this.imagePaintingVP.setIcon(icon);
        this.txtView.setOpaque(icon == null);
    }

    static {
        try {
            brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Emoticon {
        public JMenuItem menuItem;
        public String shortCut;
        public String convShortCut;
        public String icon;
        public String imageTag;
    }

    final class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                RoomMsgViewBean.this.showPopup(e.getX(), e.getY());
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RoomMsgViewBean.this.source) {
                EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(RoomMsgViewBean.this.txtView), "Source");
            } else if (object == RoomMsgViewBean.this.print) {
                iIMUtility.printDoc(RoomMsgViewBean.this._parentFrame, RoomMsgViewBean.this._parentFrame.getTitle(), RoomMsgViewBean.this.txtView);
            } else if (object == RoomMsgViewBean.this.save) {
                RoomMsgViewBean.this.saveChat2File();
            }
        }
    }
}

