/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.Client;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.swing.chat.bean.RoomViewBean;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.IMHTMLEditorKit;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.util.HTMLConverter;
import com.sun.im.service.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class RoomModeratedBean
extends JPanel
implements ActionListener,
RoomViewBean {
    static SafeResourceBundle chatPanelBundle = Chat.chatPanelBundle;
    static SafeResourceBundle brandBundle = null;
    static final int MSG_RAWTEXT_MAX_SIZE = 100;
    JFrame _parentFrame;
    private QuestionsTableModel tblModel;
    private HTMLConverter _htmlConverter;
    private Vector _msgQueue;
    private static final int MSG_DATE = 0;
    private static final int MSG_SENDER = 1;
    private static final int MSG_BODY = 2;
    private static final int MSG_RAWTEXT = 3;
    private static final int MSG = 4;
    RoomView roomView;
    JSplitPane topSplitPane;
    JTable tblQuestions = new JTable(5, 1);
    JScrollPane scrollQuestions = new JScrollPane();
    JPanel pnlQuestions = new JPanel();
    JPanel pnlTblBtns = new JPanel();
    JButton btnAccept = new JButton();
    JButton btnReject = new JButton();
    JButton btnHelpMod = new JButton();
    JPanel pnlBot = new JPanel();
    JScrollPane scrollDetail = new JScrollPane();
    JTextPane txtMessage = new JTextPane();

    public RoomModeratedBean(RoomView rv, JFrame parentFrame) {
        this._parentFrame = parentFrame;
        this.roomView = rv;
        this._msgQueue = new Vector();
        this._htmlConverter = new HTMLConverter();
        this.initComponents();
        this.initTable();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.topSplitPane = new JSplitPane(0, this.pnlQuestions, this.pnlBot);
        this.topSplitPane.setResizeWeight(0.7);
        this.add("Center", this.topSplitPane);
        this.pnlQuestions.setLayout(new GridLayout(1, 0, 0, 0));
        this.scrollQuestions.setViewportView(this.tblQuestions);
        this.pnlQuestions.add(this.scrollQuestions);
        this.pnlBot.setLayout(new BorderLayout());
        this.scrollDetail.setViewportView(this.txtMessage);
        this.pnlBot.add("Center", this.scrollDetail);
        this.txtMessage.setContentType("text/html");
        this.txtMessage.setEditorKit(new IMHTMLEditorKit());
        this.txtMessage.setEditable(false);
        if (Manager.debugEnabled()) {
            this.txtMessage.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    Object o = event.getSource();
                    int k = event.getKeyCode();
                    if (event.isAltDown() && k == 83) {
                        EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(RoomModeratedBean.this.txtMessage), "Message details HTML source");
                    }
                }
            });
        }
        this.pnlTblBtns.setLayout(new FlowLayout());
        this.pnlTblBtns.add(this.btnAccept);
        this.pnlTblBtns.add(this.btnReject);
        this.pnlTblBtns.add(this.btnHelpMod);
        this.btnAccept.setText(chatPanelBundle.getString("ChatPanel_accept"));
        this.btnAccept.setEnabled(false);
        this.btnReject.setText(chatPanelBundle.getString("ChatPanel_reject"));
        this.btnReject.setEnabled(false);
        this.btnHelpMod.setText(chatPanelBundle.getString("ChatPanel_helpmod"));
        this.pnlBot.add("South", this.pnlTblBtns);
        this.btnAccept.addActionListener(this);
        this.btnReject.addActionListener(this);
        this.btnHelpMod.addActionListener(this);
    }

    private void initTable() {
        this.tblModel = new QuestionsTableModel();
        this.tblQuestions.setModel(this.tblModel);
        this.tblQuestions.setCellSelectionEnabled(false);
        this.tblQuestions.setRowSelectionAllowed(true);
        this.tblQuestions.getTableHeader().setReorderingAllowed(false);
        this.tblQuestions.sizeColumnsToFit(2);
        this.tblQuestions.setSelectionMode(2);
        this.tblQuestions.setRowHeight(20);
        iIMUtility.setColumn(this.tblQuestions, 0, true, 75, chatPanelBundle.getString("ChatPanel_question_from"));
        iIMUtility.setColumn(this.tblQuestions, 1, true, 475, chatPanelBundle.getString("ChatPanel_questions"));
        iIMUtility.setColumn(this.tblQuestions, 2, true, 50, chatPanelBundle.getString("ChatPanel_question_date"));
        ListSelectionModel rowSM = this.tblQuestions.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){
            int minRow;
            int maxRow;

            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                if (PlatformUtil.isJDK1_3() || PlatformUtil.isJDK1_4()) {
                    RoomModeratedBean.this.txtMessage.setDocument(RoomModeratedBean.this.txtMessage.getEditorKit().createDefaultDocument());
                } else {
                    RoomModeratedBean.this.txtMessage.setText("");
                }
                ListSelectionModel lsm = (ListSelectionModel)evt.getSource();
                if (lsm.isSelectionEmpty()) {
                    RoomModeratedBean.this.btnAccept.setEnabled(false);
                    RoomModeratedBean.this.btnReject.setEnabled(false);
                } else {
                    RoomModeratedBean.this.btnAccept.setEnabled(true);
                    RoomModeratedBean.this.btnReject.setEnabled(true);
                    this.minRow = lsm.getMinSelectionIndex();
                    this.maxRow = lsm.getMaxSelectionIndex();
                    HTMLDocument doc = (HTMLDocument)RoomModeratedBean.this.txtMessage.getDocument();
                    StringBuffer html = new StringBuffer();
                    html.append("<" + HTML.Tag.P + ">");
                    html.append((String)((Vector)RoomModeratedBean.this._msgQueue.get(this.minRow)).get(2));
                    html.append("</" + HTML.Tag.P + ">");
                    try {
                        ((HTMLEditorKit)RoomModeratedBean.this.txtMessage.getEditorKit()).insertHTML(doc, 0, html.toString(), 0, 0, null);
                    }
                    catch (Exception e) {
                        System.out.println("RoomModeratedBean - Table list selection listener, could not display message: " + e);
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public int getMessageQueueSize() {
        return this._msgQueue.size();
    }

    public void addQuestion(CollaborationPrincipal nu, Message m) {
        try {
            MessagePart[] parts = m.getParts();
            String body = ClientMessageFactory.getHTMLContent(parts[0]);
            Vector<String> vMessage = new Vector<String>();
            vMessage.add(0, iIMUtility.getTimeStampReg());
            vMessage.add(1, nu.getDisplayName());
            vMessage.add(2, body);
            String rawText = parts[0].getContent();
            vMessage.add(3, rawText.substring(0, Math.min(rawText.length(), 100)));
            vMessage.add(4, (String)m);
            this._msgQueue.addElement(vMessage);
            this.tblModel.fireTableDataChanged();
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    private void handleAccept() {
        int[] selectedRows = this.tblQuestions.getSelectedRows();
        if (!Manager.isConnected()) {
            String msg = chatPanelBundle.getString("Your_Connection_was_lost_to_the_server");
            this.roomView.displayMessage(msg);
            Client.RELOGIN_ATTEMPTS = 1000;
            return;
        }
        int alreadyRemoved = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            Message m = (Message)((Vector)this._msgQueue.get(selectedRows[i])).get(4);
            ClientMessageFactory.sendModeratedConferenceMsg(m, this.roomView.getConference(), 36, null);
            int rowToRemove = selectedRows[i] - alreadyRemoved;
            ((Vector)this._msgQueue.get(rowToRemove)).removeAllElements();
            this._msgQueue.removeElementAt(rowToRemove);
            ++alreadyRemoved;
        }
        Sound.play(3);
        this.tblModel.fireTableDataChanged();
    }

    private void handleReject() {
        int[] selectedRows = this.tblQuestions.getSelectedRows();
        int alreadyRemoved = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            Message m = (Message)((Vector)this._msgQueue.get(selectedRows[i])).get(4);
            ClientMessageFactory.sendModeratedConferenceMsg(m, this.roomView.getConference(), 40, null);
            int rowToRemove = selectedRows[i] - alreadyRemoved;
            ((Vector)this._msgQueue.get(rowToRemove)).removeAllElements();
            this._msgQueue.removeElementAt(rowToRemove);
            ++alreadyRemoved;
        }
        this.tblModel.fireTableDataChanged();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.btnAccept) {
            this.handleAccept();
        } else if (object == this.btnReject) {
            this.handleReject();
        } else if (object == this.btnHelpMod) {
            HelpManager.showHelp("modchat");
        }
    }

    public void print() {
        iIMUtility.printDoc(this._parentFrame, this._parentFrame.getTitle(), this.txtMessage);
    }

    public void viewSource() {
        EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(this.txtMessage), "");
    }

    static {
        try {
            brandBundle = new SafeResourceBundle("com.sun.im.desktop.brand.brand", "com.sun.im.desktop.default.brand.brand");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class QuestionsTableModel
    extends AbstractTableModel {
        private QuestionsTableModel() {
        }

        public final int getRowCount() {
            return RoomModeratedBean.this._msgQueue.size();
        }

        public final int getColumnCount() {
            return 3;
        }

        public final boolean isCellEditable(int row, int col) {
            return false;
        }

        public final Object getValueAt(int row, int col) {
            String o = null;
            Vector vMessage = (Vector)RoomModeratedBean.this._msgQueue.get(row);
            if (vMessage != null) {
                switch (col) {
                    case 0: {
                        o = (String)vMessage.get(1);
                        break;
                    }
                    case 1: {
                        o = (String)vMessage.get(3);
                        break;
                    }
                    case 2: {
                        o = (String)vMessage.get(0);
                    }
                }
            }
            return o;
        }
    }
}

