/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.swing.chat.bean.RoomViewContainer;
import com.iplanet.im.client.swing.iIMFrame;
import com.iplanet.im.client.util.ColorFillIcon;
import com.iplanet.im.client.util.ComboUtility;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.StyledEditorKit;

public class RoomFrame
extends iIMFrame {
    static SafeResourceBundle chatBundle = Chat.chatPanelBundle;
    boolean disposeOnClose = false;
    private RoomViewContainer _roomViewContainer;
    boolean frameSizeAdjusted = false;
    private JMenu fileMenu;
    private JMenuItem sendItem;
    private JCheckBoxMenuItem enterSendItem;
    private JMenuItem inviteItem;
    private JMenuItem moderateItem;
    private JMenuItem saveItem;
    private JMenuItem printItem;
    private JMenuItem exitChatItem;
    private JMenuItem exitItem;
    private JMenu editMenu;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenu formatMenu;
    private JCheckBoxMenuItem boldItem;
    private JCheckBoxMenuItem underlineItem;
    private JCheckBoxMenuItem italicItem;
    private JMenu fontSizeMenu;
    private JMenu fontColorMenu;
    private JRadioButtonMenuItem item;
    private JMenu viewMenu;
    private JCheckBoxMenuItem toolBarItem;
    private JCheckBoxMenuItem participantListItem;
    private JCheckBoxMenuItem timeStampItem;
    private JMenuItem clearItem;
    private JMenu toolsMenu;
    private JMenuItem chatItem;
    private JMenuItem alertItem;
    private JMenuItem addContactItem;
    private JMenuItem settingsItem;
    private JMenuItem viewSrcItem;
    private JMenuItem attachItem;
    private JMenu helpMenu;
    private JMenuItem helpItem;
    private JMenuBar menuBar;
    private boolean _showEditItems = true;
    private SendAction sendAction;
    private AttachAction attachAction;

    public RoomFrame() {
        this.setDefaultCloseOperation(0);
        this._roomViewContainer = new RoomViewContainer(this);
        this.initComponents();
        if (!iIMPropsUtil.getChatTab(CurrentUserManager.getCurrentUserProperties())) {
            this.disposeOnClose = true;
        }
    }

    private void initComponents() {
        this.setVisible(false);
        this.initMenuBar();
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("Center", this._roomViewContainer);
        boolean bParticipant = iIMPropsUtil.getParticipantList(CurrentUserManager.getCurrentUserProperties());
        boolean bToolbar = iIMPropsUtil.getToolBarVisible(CurrentUserManager.getCurrentUserProperties());
        boolean bTimeStamp = iIMPropsUtil.getTimeStampVisible(CurrentUserManager.getCurrentUserProperties());
        this.selectToolBarItem(bToolbar);
        this.selectParticipantListItem(bParticipant);
        this.selectTimeStampItem(bTimeStamp);
        this.addWindowListener(this);
    }

    private void initMenuBar() {
        this.fileMenu = new JMenu(chatBundle.getString("Chat"));
        this.fileMenu.setMnemonic(chatBundle.getString("Chat_M").charAt(0));
        this.sendAction = this.getSendAction();
        this.sendItem = new JMenuItem(this.sendAction);
        this.sendAction.setEnabled(false);
        this.enterSendItem = SwingUtils.checkBoxMenuItem(this, chatBundle, "sendmsg_enterkey", "sendmsg_enterkey_M", null);
        this.saveItem = SwingUtils.menuItem(this, chatBundle, "Save", "Save_M", null);
        this.printItem = SwingUtils.menuItem(this, chatBundle, "Print", "Print_M", null);
        this.exitChatItem = SwingUtils.menuItem(this, chatBundle, "Exit_Chat_Session", "Exit_Chat_Session_M", null);
        this.exitItem = SwingUtils.menuItem(this, chatBundle, "Exit", "Exit_M", "Exit_A");
        this.fileMenu.add(this.sendItem);
        this.fileMenu.add(this.enterSendItem);
        this.fileMenu.addSeparator();
        this.enterSendItem.setSelected(iIMPropsUtil.getChatEnterSend(CurrentUserManager.getCurrentUserProperties()));
        if (Manager.ALLOW_INVITE_OTHERS) {
            this.inviteItem = SwingUtils.menuItem(this, chatBundle, "Invite_Others", "Invite_Others_M", "Invite_Others_A");
            this.fileMenu.add(this.inviteItem);
        }
        this.moderateItem = SwingUtils.menuItem(this, chatBundle, "ChatPanel_moderate", "ChatPanel_moderate_M", "ChatPanel_moderate_A");
        this.fileMenu.add(this.moderateItem);
        if (Manager.ALLOW_MODERATE) {
            this.moderateItem.setVisible(true);
        }
        this.moderateItem.setEnabled(false);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitChatItem);
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu(chatBundle.getString("Edit"));
        this.editMenu.setMnemonic(chatBundle.getString("Edit_M").charAt(0));
        this.cutItem = this.editMenu.add(new DefaultEditorKit.CutAction());
        this.cutItem.setText(chatBundle.getString("Cut"));
        this.cutItem.setMnemonic(chatBundle.getString("Cut_M").charAt(0));
        this.cutItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyItem = this.editMenu.add(new DefaultEditorKit.CopyAction());
        this.copyItem.setText(chatBundle.getString("Copy"));
        this.copyItem.setMnemonic(chatBundle.getString("Copy_M").charAt(0));
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteItem = this.editMenu.add(new DefaultEditorKit.PasteAction());
        this.pasteItem.setText(chatBundle.getString("Paste"));
        this.pasteItem.setMnemonic(chatBundle.getString("Paste_M").charAt(0));
        this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.formatMenu = new JMenu(chatBundle.getString("Format"));
        this.formatMenu.setMnemonic(chatBundle.getString("Format_M").charAt(0));
        this.boldItem = new JCheckBoxMenuItem(new StyledEditorKit.BoldAction());
        this.boldItem.setText(chatBundle.getString("Bold"));
        this.boldItem.setMnemonic(chatBundle.getString("Bold_M").charAt(0));
        this.formatMenu.add(this.boldItem);
        this.underlineItem = new JCheckBoxMenuItem(new StyledEditorKit.UnderlineAction());
        this.underlineItem.setText(chatBundle.getString("Underline"));
        this.underlineItem.setMnemonic(chatBundle.getString("Underline_M").charAt(0));
        this.formatMenu.add(this.underlineItem);
        this.italicItem = new JCheckBoxMenuItem(new StyledEditorKit.ItalicAction());
        this.italicItem.setText(chatBundle.getString("Italic"));
        this.italicItem.setMnemonic(chatBundle.getString("Italic_M").charAt(0));
        this.formatMenu.add(this.italicItem);
        this.fontSizeMenu = new JMenu(chatBundle.getString("Font_Size"));
        this.fontSizeMenu.setMnemonic(chatBundle.getString("Font_Size_M").charAt(0));
        this.formatMenu.add(this.fontSizeMenu);
        ButtonGroup sizeGroup = new ButtonGroup();
        this.item = new JRadioButtonMenuItem(new StyledEditorKit.FontSizeAction("font-size-10", 10));
        this.item.setText("10");
        sizeGroup.add(this.item);
        this.fontSizeMenu.add(this.item);
        this.item = new JRadioButtonMenuItem(new StyledEditorKit.FontSizeAction("font-size-12", 12));
        this.item.setText("12");
        sizeGroup.add(this.item);
        this.fontSizeMenu.add(this.item);
        this.item = new JRadioButtonMenuItem(new StyledEditorKit.FontSizeAction("font-size-14", 14));
        this.item.setText("14");
        sizeGroup.add(this.item);
        this.fontSizeMenu.add(this.item);
        this.item = new JRadioButtonMenuItem(new StyledEditorKit.FontSizeAction("font-size-18", 18));
        this.item.setText("18");
        sizeGroup.add(this.item);
        this.fontSizeMenu.add(this.item);
        this.item = new JRadioButtonMenuItem(new StyledEditorKit.FontSizeAction("font-size-24", 24));
        this.item.setText("24");
        sizeGroup.add(this.item);
        this.fontSizeMenu.add(this.item);
        this.item = new JRadioButtonMenuItem(new StyledEditorKit.FontSizeAction("font-size-36", 36));
        this.item.setText("36");
        sizeGroup.add(this.item);
        this.fontSizeMenu.add(this.item);
        this.fontColorMenu = new JMenu(chatBundle.getString("Font_Color"));
        this.fontColorMenu.setMnemonic(chatBundle.getString("Font_Color_M").charAt(0));
        this.formatMenu.add(this.fontColorMenu);
        ButtonGroup colorGroup = new ButtonGroup();
        for (int i = 0; i < ComboUtility.colorTextChatData.length; ++i) {
            this.item = new JRadioButtonMenuItem(new StyledEditorKit.ForegroundAction("foreground-color-" + Integer.toHexString(((ColorFillIcon)ComboUtility.colorTextChatData[i]).getColor().getRGB()).substring(2), ((ColorFillIcon)ComboUtility.colorTextChatData[i]).getColor()));
            this.item.setText("");
            this.item.setIcon(ComboUtility.colorTextChatData[i]);
            colorGroup.add(this.item);
            this.fontColorMenu.add(this.item);
        }
        this.formatMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                int i = 0;
                String actionName = null;
                JTextPane jTP = RoomFrame.this._roomViewContainer.getActiveRoomView().getRoomEditorViewContainer().getBean().getTextEditorField();
                if (jTP != null) {
                    RoomFrame.this.boldItem.setSelected(EditorUtility.isCurrentCaretBold(jTP));
                    RoomFrame.this.underlineItem.setSelected(EditorUtility.isCurrentCaretUnderline(jTP));
                    RoomFrame.this.italicItem.setSelected(EditorUtility.isCurrentCaretItalic(jTP));
                    String color = Integer.toHexString(EditorUtility.getCurrentCaretFontColor(jTP).getRGB()).substring(2);
                    actionName = "foreground-color-" + color;
                    for (i = 0; i < RoomFrame.this.fontColorMenu.getItemCount(); ++i) {
                        if (!((String)((JRadioButtonMenuItem)RoomFrame.this.fontColorMenu.getItem(i)).getAction().getValue("Name")).equals(actionName)) continue;
                        ((JRadioButtonMenuItem)RoomFrame.this.fontColorMenu.getItem(i)).setSelected(true);
                        break;
                    }
                    actionName = "font-size-" + EditorUtility.getCurrentCaretFontSize(jTP);
                    for (i = 0; i < RoomFrame.this.fontSizeMenu.getItemCount(); ++i) {
                        if (!((String)((JRadioButtonMenuItem)RoomFrame.this.fontSizeMenu.getItem(i)).getAction().getValue("Name")).equals(actionName)) continue;
                        ((JRadioButtonMenuItem)RoomFrame.this.fontSizeMenu.getItem(i)).setSelected(true);
                        break;
                    }
                }
            }
        });
        this.viewMenu = new JMenu(chatBundle.getString("View"));
        this.viewMenu.setMnemonic(chatBundle.getString("View_M").charAt(0));
        this.toolBarItem = SwingUtils.checkBoxMenuItem(this, chatBundle, "Tool_Bar", "Tool_Bar_M", null);
        this.participantListItem = SwingUtils.checkBoxMenuItem(this, chatBundle, "Participant_List", "Participant_List_M", null);
        this.timeStampItem = SwingUtils.checkBoxMenuItem(this, chatBundle, "Show_Time_Stamp", "Show_Time_Stamp_M", null);
        this.clearItem = SwingUtils.menuItem(this, chatBundle, "Clear_Screen", "Clear_Screen_M", null);
        this.timeStampItem.setSelected(true);
        this.viewMenu.add(this.toolBarItem);
        this.viewMenu.add(this.participantListItem);
        this.viewMenu.add(this.timeStampItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.clearItem);
        this.viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                boolean isModerated = RoomFrame.this._roomViewContainer.isModetared();
                boolean hasWriteAccess = RoomFrame.this._roomViewContainer.hasWriteAccess();
                RoomFrame.this.toolBarItem.setEnabled(isModerated || hasWriteAccess);
            }
        });
        this.toolsMenu = new JMenu(chatBundle.getString("Tools"));
        this.toolsMenu.setMnemonic(chatBundle.getString("Tools_M").charAt(0));
        if (Manager.ALLOW_CHAT) {
            this.chatItem = SwingUtils.menuItem(this, chatBundle, "Side_Chat", "Side_Chat_M", null);
            this.chatItem.setEnabled(false);
            this.toolsMenu.add(this.chatItem);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.alertItem = SwingUtils.menuItem(this, chatBundle, "Alert", "Alert_M", "Alert_A");
            this.alertItem.setEnabled(false);
            this.toolsMenu.add(this.alertItem);
        }
        this.attachAction = this.getAttachAction();
        this.attachItem = new JMenuItem(this.attachAction);
        this.viewSrcItem = SwingUtils.menuItem(this, chatBundle, "View_Source", "View_Source_M", null);
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.addContactItem = SwingUtils.menuItem(this, chatBundle, "Add_to_Contact_List", "Add_to_Contact_List_M", null);
            this.addContactItem.setEnabled(false);
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.addContactItem);
        }
        if (Manager.ALLOW_ATTACHMENTS) {
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.attachItem);
        }
        this.toolsMenu.addSeparator();
        this.toolsMenu.add(this.viewSrcItem);
        if (Manager.ALLOW_SETTINGS_CHANGES) {
            this.settingsItem = SwingUtils.menuItem(this, chatBundle, "Settings", "Settings_M", "Settings_A");
            this.toolsMenu.addSeparator();
            this.toolsMenu.add(this.settingsItem);
        }
        this.toolsMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
            }
        });
        this.helpMenu = new JMenu(chatBundle.getString("Help"));
        this.helpMenu.setMnemonic(chatBundle.getString("Help_M").charAt(0));
        this.helpItem = SwingUtils.menuItem(this, chatBundle, "Help_Topics", "Help_Topics_M", "Help_Topics_A");
        this.helpMenu.add(this.helpItem);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.formatMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    public AttachAction getAttachAction() {
        if (this.attachAction == null) {
            this.attachAction = new AttachAction(chatBundle.getString("Attach_File"), null, chatBundle.getString("Attach_File_M"));
        }
        return this.attachAction;
    }

    public SendAction getSendAction() {
        if (this.sendAction == null) {
            this.sendAction = new SendAction(chatBundle.getString("Send"), chatBundle.getString("Send_M"), chatBundle.getString("Send_A"));
        }
        return this.sendAction;
    }

    public void selectToolBarItem(boolean b) {
        this.toolBarItem.setSelected(b);
    }

    public void selectParticipantListItem(boolean b) {
        this.participantListItem.setSelected(b);
    }

    public void selectTimeStampItem(boolean b) {
        this.timeStampItem.setSelected(b);
    }

    public void setSendMenu(boolean b) {
        this.sendItem.setEnabled(b);
    }

    public void setToolsMenu(boolean b) {
        if (Manager.ALLOW_CHAT) {
            this.chatItem.setEnabled(b);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.alertItem.setEnabled(b);
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT) {
            this.addContactItem.setEnabled(b);
        }
    }

    public void close() {
        iIMPropsUtil.setChatWindowPoint(CurrentUserManager.getCurrentUserProperties(), this.getLocation());
        this.setVisible(false);
        if (this.disposeOnClose) {
            this.removeWindowListener(this);
            Chat.removeFrame(this);
            this.dispose();
        }
    }

    public RoomViewContainer getRoomViewContainer() {
        return this._roomViewContainer;
    }

    public void setVisible(boolean b) {
        if (b && !this.isVisible()) {
            this.setLocation(iIMPropsUtil.getChatWindowPoint(CurrentUserManager.getCurrentUserProperties(), 0));
            super.pack();
        }
        super.setVisible(b);
    }

    public void addNotify() {
        super.addNotify();
        if (this.frameSizeAdjusted || PlatformUtil.isMac()) {
            return;
        }
        this.frameSizeAdjusted = true;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        JMenuBar menuBar = this.getRootPane().getJMenuBar();
        int menuBarHeight = 0;
        if (menuBar != null) {
            menuBarHeight = menuBar.getPreferredSize().height;
        }
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    public void windowActivated(WindowEvent e) {
        Manager.Out("DEBUG: RoomFrame.windowActivated()");
        this._roomViewContainer.setblinkActiveView(false);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this._roomViewContainer.close(true)) {
            this.close();
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.enterSendItem) {
            iIMPropsUtil.setChatEnterSend(CurrentUserManager.getCurrentUserProperties(), this.enterSendItem.isSelected());
            Vector v = this._roomViewContainer.getRoomViews();
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                RoomView rv = (RoomView)v.elementAt(i);
                rv.getRoomEditorViewContainer().getBean().evaluateEnterBinding();
            }
        } else if (object == this.inviteItem) {
            this._roomViewContainer.inviteOthers();
        } else if (object == this.saveItem) {
            this._roomViewContainer.save();
        } else if (object == this.printItem) {
            this._roomViewContainer.print();
        } else if (object == this.chatItem) {
            this._roomViewContainer.sideChat();
        } else if (object == this.alertItem) {
            this._roomViewContainer.alert();
        } else if (object == this.addContactItem) {
            this._roomViewContainer.addContacts();
        } else if (object == this.settingsItem) {
            iIM.showSettings(CurrentUserManager.getCurrentPrincipal(), null);
        } else if (object == this.exitChatItem) {
            this._roomViewContainer.removeTab();
        } else if (object == this.exitItem) {
            Manager.Out("DEBUG RoomFrame :exitItem action calling  _roomViewContainer.close()");
            this._roomViewContainer.close(true);
        } else if (object == this.toolBarItem) {
            Vector v = this._roomViewContainer.getRoomViews();
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                RoomView rv = (RoomView)v.elementAt(i);
                rv.showToolBar(this.toolBarItem.isSelected());
            }
            iIMPropsUtil.setToolBarVisible(CurrentUserManager.getCurrentUserProperties(), this.toolBarItem.isSelected());
        } else if (object == this.participantListItem) {
            iIMPropsUtil.setParticipantList(CurrentUserManager.getCurrentUserProperties(), this.participantListItem.isSelected());
        } else if (object == this.timeStampItem) {
            Vector v = this._roomViewContainer.getRoomViews();
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                RoomView rv = (RoomView)v.elementAt(i);
                rv.setShowTimeStamp(this.timeStampItem.isSelected());
            }
            iIMPropsUtil.setTimeStampVisible(CurrentUserManager.getCurrentUserProperties(), this.timeStampItem.isSelected());
        } else if (object == this.clearItem) {
            this._roomViewContainer.clearText();
        } else if (object == this.viewSrcItem) {
            this._roomViewContainer.viewSource();
        } else if (object == this.helpItem) {
            HelpManager.showHelp("chat");
        } else if (object == this.moderateItem) {
            this._roomViewContainer.moderate();
        }
    }

    public boolean isEditItemsEnabled() {
        return this._showEditItems;
    }

    public void setEditItemsEnabled(boolean b) {
        this._showEditItems = b;
        this.cutItem.setEnabled(b);
        this.pasteItem.setEnabled(b);
        this.menuBar.revalidate();
    }

    public void setModeratedMenuItemEnabled(boolean b) {
        this.moderateItem.setEnabled(b);
    }

    public void setModeratedMenuItemText(String text) {
        this.moderateItem.setText(text);
    }

    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RoomFrame.this._roomViewContainer.close(true);
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    class SendAction
    extends AbstractAction {
        public SendAction(String text, String mnemonic, String accelerator) {
            super(text);
            if (mnemonic != null && !"".equals(mnemonic)) {
                super.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
            }
            if (accelerator != null && !"".equals(accelerator)) {
                super.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)accelerator.charAt(0), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
        }

        public void actionPerformed(ActionEvent e) {
            RoomFrame.this._roomViewContainer.sendMessage();
        }
    }

    class AttachAction
    extends AbstractAction {
        public AttachAction(String text, ImageIcon icon, String mnemonic) {
            super(text, icon);
            if (mnemonic != null && !"".equals(mnemonic)) {
                this.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
            }
        }

        public void actionPerformed(ActionEvent e) {
            RoomFrame.this._roomViewContainer.attach();
            if (RoomFrame.this._roomViewContainer.getActiveRoomView().getRoomEditorViewContainer().isNotAttached()) {
                RoomFrame.this.attachAction.setEnabled(true);
            } else {
                RoomFrame.this.attachAction.setEnabled(false);
            }
        }
    }
}

