/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.manager.EmoticonsManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.swing.chat.bean.CustomTableCellRenderer;
import com.iplanet.im.client.swing.chat.bean.RoomEditorUIEvent;
import com.iplanet.im.client.swing.chat.bean.RoomEditorUIListener;
import com.iplanet.im.client.swing.chat.bean.RoomEditorViewBean;
import com.iplanet.im.client.swing.chat.bean.RoomFrame;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.swing.models.EmoticonTableModel;
import com.iplanet.im.client.util.ColorFillIcon;
import com.iplanet.im.client.util.ComboUtility;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.StickyFileChooser;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableColumnModel;
import javax.swing.text.StyledEditorKit;

public class RoomEditorViewContainer
extends JPanel
implements RoomEditorUIListener,
PopupMenuListener {
    private static SafeResourceBundle chatPanelBundle = Chat.chatPanelBundle;
    private static SafeResourceBundle chatBundle = Chat.chatBundle;
    static SafeResourceBundle emotiBundle = new SafeResourceBundle("com.sun.im.desktop.emoticons.emoticons");
    private RoomEditorViewBean bean;
    public File attach_file = null;
    public JPanel pnlBeans = new JPanel();
    JToolBar toolBar = new JToolBar();
    JComboBox cmbFontSize = new JComboBox();
    JComboBox cmbFontColor = new JComboBox();
    JButton btnInvite = new JButton();
    JButton btnLeave = new JButton();
    JToggleButton btnBold = new JToggleButton();
    JToggleButton btnItalic = new JToggleButton();
    JToggleButton btnUnderline = new JToggleButton();
    JButton btnAttach = new JButton();
    JButton btnEmoticons = new JButton();
    JList lstAttach = new JList();
    private SmartJPopupMenu popup;
    private EmoticonTableModel dataModel = new EmoticonTableModel();
    private JTable table = new JTable();
    private int Emoti_Table_Cols;
    RoomFrame.SendAction sendAction;
    RoomFrame.AttachAction attachAction;
    private CustomTableCellRenderer tableCellRenderer;
    SymAction lSymAction = new SymAction();
    private Vector attachments = new Vector(1);
    private AttachListModel attachModel;
    private Emoticon[] emoticons;
    SymKey sysKey = new SymKey();
    private JFrame _parentFrame;
    private Hashtable _commands = null;

    public RoomEditorViewContainer(JFrame f, RoomView rv) {
        this._parentFrame = f;
        this.bean = new RoomEditorViewBean(this._parentFrame, this, rv);
        this.bean.addRoomEditorUIListener(this);
        this._commands = new Hashtable();
        Action[] actions = this.getBean().getTextEditorField().getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this._commands.put(a.getValue("Name"), a);
        }
        Manager.Out("RoomEditorViewContainer.<init>");
        this.initComponents();
        this.bean.requestDefaultFocus();
        this.table.setBackground(SystemColor.control);
    }

    private void initComponents() {
        SymMouse sysMouse = new SymMouse();
        this.sendAction = ((RoomFrame)this._parentFrame).getSendAction();
        this.attachAction = ((RoomFrame)this._parentFrame).getAttachAction();
        this.tableCellRenderer = new CustomTableCellRenderer();
        SysMouseClick mouseClick = new SysMouseClick();
        this.table.addMouseMotionListener(sysMouse);
        this.table.addMouseListener(mouseClick);
        this.table.setSelectionMode(0);
        this.table.setModel(this.dataModel);
        try {
            this.table.setDefaultRenderer(Class.forName("javax.swing.ImageIcon"), this.tableCellRenderer);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("ClassNotFoundException");
        }
        this.table.setShowGrid(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setRowHeight(30);
        this.table.setRowMargin(5);
        if (!emotiBundle.getString("smile.table.cols").trim().equals(null)) {
            this.Emoti_Table_Cols = Integer.parseInt(emotiBundle.getString("smile.table.cols"));
        }
        for (int i = 0; i < this.Emoti_Table_Cols; ++i) {
            this.setColumnWidth(i, 30);
        }
        this.table.updateUI();
        ListSelectionModel rowSM = this.table.getSelectionModel();
        try {
            this.table.setEditingColumn(0);
            this.table.setEditingRow(this.table.getSelectedRow());
            this.table.setCellSelectionEnabled(true);
        }
        catch (Exception e1) {
            // empty catch block
        }
        this.popup = new SmartJPopupMenu();
        this.setLayout(new GridBagLayout());
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.add((Component)this.bean, new GridBagConstraints(0, -1, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.toolBar.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.btnInvite.setBorderPainted(false);
        this.btnInvite.setToolTipText(chatPanelBundle.getString("ChatPanel_inviteothers"));
        this.btnInvite.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_invite.png", (Object)this));
        this.btnInvite.setText(null);
        this.toolBar.add((Component)this.btnInvite, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.btnLeave.setBorderPainted(false);
        this.btnLeave.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_leavechat.png", (Object)this));
        this.btnLeave.setToolTipText(chatPanelBundle.getString("ChatPanel_exit_session"));
        this.btnLeave.setText(null);
        this.toolBar.add((Component)this.btnLeave, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.toolBar.add((Component)new JSeparator(1), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 3;
        this.btnBold.setAction(new StyledEditorKit.BoldAction());
        this.btnBold.setToolTipText(chatPanelBundle.getString("ChatPanel_bold"));
        this.btnBold.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_bold.png", (Object)this));
        this.btnBold.setText(null);
        this.toolBar.add((Component)this.btnBold, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.btnUnderline.setAction(new StyledEditorKit.UnderlineAction());
        this.btnUnderline.setToolTipText(chatPanelBundle.getString("Underline"));
        this.btnUnderline.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_underline.png", (Object)this));
        this.btnUnderline.setText(null);
        this.toolBar.add((Component)this.btnUnderline, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        this.btnItalic.setAction(new StyledEditorKit.ItalicAction());
        this.btnItalic.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_italic.png", (Object)this));
        this.btnItalic.setToolTipText(chatPanelBundle.getString("ChatPanel_italic"));
        this.btnItalic.setText(null);
        this.toolBar.add((Component)this.btnItalic, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        this.cmbFontColor.setToolTipText(chatPanelBundle.getString("Font_Color"));
        this.toolBar.add((Component)this.cmbFontColor, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        this.cmbFontSize.setToolTipText(chatPanelBundle.getString("Font_Size"));
        this.toolBar.add((Component)this.cmbFontSize, gridBagConstraints);
        gridBagConstraints.gridx = 8;
        this.btnEmoticons.setBorderPainted(false);
        this.btnEmoticons.setToolTipText(chatPanelBundle.getString("Emoticons"));
        this.btnEmoticons.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_smiley.png", "/com/iplanet/im/client/images/tb_smiley.png", this));
        if (EmoticonsManager.getEmoticonsCount() > 0) {
            this.toolBar.add((Component)this.btnEmoticons, gridBagConstraints);
            String[] emoticonsShortcuts = EmoticonsManager.getUniqueShortcuts();
            this.emoticons = new Emoticon[EmoticonsManager.getEmoticonsCount()];
            for (int i = 0; i < EmoticonsManager.getEmoticonsCount(); ++i) {
                this.emoticons[i] = new Emoticon();
                this.emoticons[i].menuItem = new JMenuItem(EmoticonsManager.getIconForShortcut(emoticonsShortcuts[i]));
                this.emoticons[i].menuItem.addActionListener(this.lSymAction);
                this.emoticons[i].shortcut = emoticonsShortcuts[i];
            }
        }
        if (Manager.ALLOW_ATTACHMENTS) {
            gridBagConstraints.gridx = 9;
            this.btnAttach.setBorderPainted(false);
            this.btnAttach.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_attach.png", (Object)this));
            this.btnAttach.setToolTipText(chatPanelBundle.getString("btnAddLink_toolTipText"));
            this.toolBar.add((Component)this.btnAttach, gridBagConstraints);
            gridBagConstraints.gridx = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            this.toolBar.add((Component)this.lstAttach, gridBagConstraints);
            this.lstAttach.setVisible(false);
        }
        this.initFontSizeCombo();
        this.initFontColorCombo();
        this.cmbFontSize.addActionListener(this.lSymAction);
        this.cmbFontColor.addActionListener(this.lSymAction);
        this.btnInvite.addActionListener(this.lSymAction);
        this.btnLeave.addActionListener(this.lSymAction);
        this.btnBold.addActionListener(this.lSymAction);
        this.btnItalic.addActionListener(this.lSymAction);
        this.btnUnderline.addActionListener(this.lSymAction);
        this.btnEmoticons.addActionListener(this.lSymAction);
        this.popup.addPopupMenuListener(this);
        if (Manager.ALLOW_ATTACHMENTS) {
            this.btnAttach.addActionListener(this.lSymAction);
            this.attachModel = new AttachListModel(this.lstAttach, this.attachments);
            this.lstAttach.setModel(this.attachModel);
            attachListRenderer attachRenderer = new attachListRenderer(this.attachModel);
            this.lstAttach.setCellRenderer(attachRenderer);
        }
    }

    public void setAttachmentEnabled(boolean b) {
        if (this.btnAttach != null) {
            this.btnAttach.setEnabled(b);
        }
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setColumnWidth(int pColumn, int pWidth) {
        TableColumnModel colModel = this.table.getColumnModel();
        colModel.getColumn(pColumn).setPreferredWidth(pWidth);
    }

    public void showToolBar(boolean b) {
        this.toolBar.setVisible(b);
    }

    public JButton getDefaultButton() {
        return this.bean.getDefaultButton();
    }

    public boolean isToolBarVisible() {
        return this.toolBar.isVisible();
    }

    public int getToolBarHeight() {
        return this.toolBar.getHeight();
    }

    public RoomEditorViewBean getBean() {
        return this.bean;
    }

    private final void showPopup(Component c) {
        if (c == this.btnEmoticons) {
            this.popup.add(this.table);
            this.popup.show(this.btnEmoticons, new Point(20, 10));
            this.table.addKeyListener(this.sysKey);
            this.table.setColumnSelectionInterval(0, 0);
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void removeListeners() {
        for (int i = 0; i < EmoticonsManager.getEmoticonsCount(); ++i) {
            this.emoticons[i].menuItem.removeActionListener(this.lSymAction);
        }
        this.popup.removePopupMenuListener(this);
        this.cmbFontSize.removeActionListener(this.lSymAction);
        this.cmbFontColor.removeActionListener(this.lSymAction);
        this.btnBold.removeActionListener(this.lSymAction);
        this.btnItalic.removeActionListener(this.lSymAction);
        this.btnUnderline.removeActionListener(this.lSymAction);
        this.btnInvite.removeActionListener(this.lSymAction);
        this.btnLeave.removeActionListener(this.lSymAction);
        this.btnEmoticons.removeActionListener(this.lSymAction);
    }

    public void close() {
        this.removeListeners();
        this.bean.close();
    }

    private final void initFontSizeCombo() {
        this.cmbFontSize.addItem("10");
        this.cmbFontSize.addItem("12");
        this.cmbFontSize.addItem("14");
        this.cmbFontSize.addItem("18");
        this.cmbFontSize.addItem("24");
        this.cmbFontSize.addItem("36");
        this.cmbFontSize.setSelectedItem(String.valueOf(this.bean.getFontSize()));
    }

    private final void initFontColorCombo() {
        for (int i = 0; i < ComboUtility.colorTextChatData.length; ++i) {
            this.cmbFontColor.addItem(ComboUtility.colorTextChatData[i]);
        }
        this.cmbFontColor.setSelectedIndex(ComboUtility.getTextColorIndex(ComboUtility.colorTextChatData, this.bean.getFontColor()));
    }

    public boolean isNotAttached() {
        return this.attach_file == null;
    }

    public final void attachFile() {
        File file = null;
        try {
            file = StickyFileChooser.chooseFile(this, null, null, chatBundle.getString("ChooserDialog_title"), chatBundle.getString("btnAttach_text"), chatBundle.getString("btnAttach_text_M"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null || !file.isFile()) {
            return;
        }
        this.bean.startTyping();
        this.attach_file = file;
        this.sendAction.setEnabled(true);
        this.attachAction.setEnabled(false);
        this.btnAttach.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_removeattach.gif", (Object)this));
        String toolTipStr = StringUtility.substitute((String)chatPanelBundle.getString("btnRemoveLink_toolTipText"), (String)"__MACRO__", (String)file.getName());
        this.btnAttach.setToolTipText(toolTipStr);
        this.lstAttach.setVisible(true);
        toolTipStr = StringUtility.substitute((String)chatPanelBundle.getString("AttachFileToolTip"), (String)"__MACRO__", (String)file.getName());
        this.lstAttach.setToolTipText(toolTipStr);
        this.attachments.addElement(file.getName());
        this.attachModel.changed();
        this.bean.requestDefaultFocus();
    }

    private void removeAttachment() {
        this.btnAttach.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_attach.png", (Object)this));
        this.btnAttach.setToolTipText(chatPanelBundle.getString("btnAddLink_toolTipText"));
        this.lstAttach.clearSelection();
        this.attachments.removeAllElements();
        if (this.bean.getTextEditorField().getDocument().getLength() <= 0) {
            this.sendAction.setEnabled(false);
        }
        this.attachAction.setEnabled(true);
        this.bean.requestDefaultFocus();
        this.lstAttach.setVisible(false);
        this.toolBar.updateUI();
        this.attach_file = null;
    }

    private final void changeFontSize() {
        String action = "font-size-" + (String)this.cmbFontSize.getSelectedItem();
        ((StyledEditorKit.StyledTextAction)this._commands.get(action)).actionPerformed(new ActionEvent(this.cmbFontSize, 1001, action));
        this.bean.requestDefaultFocus();
    }

    private final void changeFontColor() {
        int selectedIndex = this.cmbFontColor.getSelectedIndex();
        if (selectedIndex > -1) {
            ColorFillIcon icon = (ColorFillIcon)ComboUtility.colorTextChatData[selectedIndex];
            this.bean.setFontColor(icon.getColor());
        }
        this.bean.requestDefaultFocus();
    }

    public final void showFontAttributes() {
        this.btnBold.setSelected(EditorUtility.isCurrentCaretBold(this.bean.getTextEditorField()));
        this.btnItalic.setSelected(EditorUtility.isCurrentCaretItalic(this.bean.getTextEditorField()));
        this.btnUnderline.setSelected(EditorUtility.isCurrentCaretUnderline(this.bean.getTextEditorField()));
        this.cmbFontColor.removeActionListener(this.lSymAction);
        this.cmbFontColor.setSelectedIndex(ComboUtility.getTextColorIndex(ComboUtility.colorTextChatData, EditorUtility.getCurrentCaretFontColor(this.bean.getTextEditorField())));
        this.cmbFontColor.addActionListener(this.lSymAction);
        this.cmbFontSize.removeActionListener(this.lSymAction);
        this.cmbFontSize.setSelectedItem(String.valueOf(EditorUtility.getCurrentCaretFontSize(this.bean.getTextEditorField())));
        this.cmbFontSize.addActionListener(this.lSymAction);
    }

    public void validateView() {
        this.removeAttachment();
    }

    public void newRoomEditorEvent(RoomEditorUIEvent evt) {
        switch (evt.getType()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.showFontAttributes();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.showFontAttributes();
                break;
            }
            case 4: {
                break;
            }
            default: {
                return;
            }
        }
    }

    void inviteOthers() {
        this.bean.showInvite();
        this.bean.requestDefaultFocus();
    }

    void leave() {
        this.bean.leave();
    }

    void btnBold_actionPerformed(ActionEvent event) {
        this.bean.requestDefaultFocus();
    }

    void btnItalic_actionPerformed(ActionEvent event) {
        this.bean.requestDefaultFocus();
    }

    void btnUnderline_actionPerformed(ActionEvent event) {
        this.bean.requestDefaultFocus();
    }

    void btnEmoticon_actionPerformed(ActionEvent event) {
        this.showPopup(this.btnEmoticons);
    }

    void btnAttach_actionPerformed(ActionEvent event) {
        if (this.attach_file == null) {
            this.attachFile();
        } else {
            String title = chatPanelBundle.getString("chatPanel_Confirm_Remove");
            String msg = StringUtility.substitute((String)chatPanelBundle.getString("chatPanel_Remove_Attachment"), (String)"__MACRO__", (String)this.attach_file.getName());
            int opt = JOptionPane.showConfirmDialog(this, msg, title, 0);
            if (opt == 0) {
                this.removeAttachment();
            }
        }
    }

    public final void addRoomEditorUIListener(RoomEditorUIListener l) {
        this.bean.addRoomEditorUIListener(l);
    }

    public final void removeRoomEditorUIListener(RoomEditorUIListener l) {
        this.bean.removeRoomEditorUIListener(l);
        this.bean.removeRoomEditorUIListener(this);
    }

    public final void fireRoomEditorUIListeners(Object src, int type, String msg) {
        this.bean.fireRoomEditorUIListeners(src, type, msg);
    }

    public boolean requestDefaultFocus() {
        return this.bean.requestDefaultFocus();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.popup.removeAll();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    private void OK() {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        if (this.table.isRowSelected(this.table.getSelectedRow())) {
            this.bean.insertText((String)this.dataModel.getShortCutAt(row, col));
        }
        this.table.clearSelection();
        this.popup.setVisible(false);
        this.bean.requestDefaultFocus();
    }

    private void Close() {
        this.popup.setVisible(false);
    }

    private void keyDowns(KeyEvent e) {
        int row = this.table.rowAtPoint(new Point(e.getKeyLocation(), e.getKeyLocation()));
        int col = this.table.columnAtPoint(new Point(e.getKeyLocation(), e.getKeyLocation()));
        boolean repaint = false;
        if (this.tableCellRenderer.mouseCol != col || this.tableCellRenderer.mouseRow != row) {
            repaint = true;
        }
        this.tableCellRenderer.mouseCol = col;
        this.tableCellRenderer.mouseRow = row;
        if (repaint) {
            this.table.setColumnSelectionInterval(col, col);
            this.table.setRowSelectionInterval(row, row);
        }
    }

    class SymKey
    extends KeyAdapter {
        SymKey() {
        }

        public void keyPressed(KeyEvent event) {
            RoomEditorViewContainer.this.popup.setVisible(true);
            if (event.getKeyCode() == 10) {
                RoomEditorViewContainer.this.OK();
            }
            if (event.getKeyCode() == 27) {
                RoomEditorViewContainer.this.Close();
            }
            if (event.getKeyCode() != 40) {
                if (event.getKeyCode() != 38) {
                    if (event.getKeyCode() != 37) {
                        if (event.getKeyCode() != 39) {
                            return;
                        }
                    }
                }
            }
            RoomEditorViewContainer.this.keyDowns(event);
        }

        public void keyReleased(KeyEvent e) {
            block5: {
                block4: {
                    if (e.getKeyCode() == 40) break block4;
                    if (e.getKeyCode() == 38) break block4;
                    if (e.getKeyCode() == 37) break block4;
                    if (e.getKeyCode() != 39) break block5;
                }
                RoomEditorViewContainer.this.keyDowns(e);
            }
            if (e.getKeyCode() == 27) {
                RoomEditorViewContainer.this.Close();
            }
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    class SymMouse
    extends MouseMotionAdapter {
        SymMouse() {
        }

        public void mouseClicked(MouseEvent event) {
            RoomEditorViewContainer.this.popup.setVisible(true);
            if (event.getClickCount() >= 1) {
                RoomEditorViewContainer.this.popup.setVisible(false);
            } else {
                RoomEditorViewContainer.this.popup.setVisible(true);
            }
        }

        public void mouseMoved(MouseEvent e) {
            int row = RoomEditorViewContainer.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
            int col = RoomEditorViewContainer.this.table.columnAtPoint(new Point(e.getX(), e.getY()));
            boolean repaint = false;
            if (((RoomEditorViewContainer)RoomEditorViewContainer.this).tableCellRenderer.mouseCol != col || ((RoomEditorViewContainer)RoomEditorViewContainer.this).tableCellRenderer.mouseRow != row) {
                repaint = true;
                RoomEditorViewContainer.this.table.repaint(RoomEditorViewContainer.this.table.getCellRect(((RoomEditorViewContainer)RoomEditorViewContainer.this).tableCellRenderer.mouseRow, ((RoomEditorViewContainer)RoomEditorViewContainer.this).tableCellRenderer.mouseCol, true));
            }
            ((RoomEditorViewContainer)RoomEditorViewContainer.this).tableCellRenderer.mouseCol = col;
            ((RoomEditorViewContainer)RoomEditorViewContainer.this).tableCellRenderer.mouseRow = row;
            if (repaint) {
                RoomEditorViewContainer.this.table.setToolTipText((String)RoomEditorViewContainer.this.dataModel.getTooltipAt(row, col) + " " + (String)RoomEditorViewContainer.this.dataModel.getShortCutAt(row, col));
                RoomEditorViewContainer.this.table.setColumnSelectionInterval(col, col);
                RoomEditorViewContainer.this.table.setRowSelectionInterval(row, row);
            }
            if (e.getClickCount() >= 1) {
                RoomEditorViewContainer.this.popup.setVisible(false);
            } else {
                RoomEditorViewContainer.this.popup.setVisible(true);
            }
        }

        public void mousePressed(MouseEvent e) {
        }
    }

    class SysMouseClick
    extends MouseAdapter {
        SysMouseClick() {
        }

        public void mouseReleased(MouseEvent event) {
            RoomEditorViewContainer.this.OK();
        }
    }

    private class Emoticon {
        public String shortcut;
        public JMenuItem menuItem;

        private Emoticon() {
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RoomEditorViewContainer.this.btnBold) {
                RoomEditorViewContainer.this.btnBold_actionPerformed(event);
            } else if (object == RoomEditorViewContainer.this.btnItalic) {
                RoomEditorViewContainer.this.btnItalic_actionPerformed(event);
            } else if (object == RoomEditorViewContainer.this.btnUnderline) {
                RoomEditorViewContainer.this.btnUnderline_actionPerformed(event);
            } else if (object == RoomEditorViewContainer.this.btnAttach) {
                RoomEditorViewContainer.this.btnAttach_actionPerformed(event);
            } else if (object == RoomEditorViewContainer.this.btnInvite) {
                RoomEditorViewContainer.this.inviteOthers();
            } else if (object == RoomEditorViewContainer.this.btnLeave) {
                RoomEditorViewContainer.this.leave();
            } else if (object == RoomEditorViewContainer.this.cmbFontSize) {
                String action = "font-size-" + (String)RoomEditorViewContainer.this.cmbFontSize.getSelectedItem();
                ((StyledEditorKit.StyledTextAction)RoomEditorViewContainer.this._commands.get(action)).actionPerformed(event);
                RoomEditorViewContainer.this.bean.requestDefaultFocus();
            } else if (object == RoomEditorViewContainer.this.cmbFontColor) {
                RoomEditorViewContainer.this.changeFontColor();
            } else if (object == RoomEditorViewContainer.this.btnEmoticons) {
                RoomEditorViewContainer.this.btnEmoticon_actionPerformed(event);
            }
        }
    }

    public final class attachListRenderer
    extends JLabel
    implements ListCellRenderer {
        private AttachListModel model;

        public attachListRenderer(AttachListModel m) {
            this.model = m;
            this.setOpaque(true);
        }

        public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(this.model.getName(value));
            this.setIcon(SwingImageManager.getIcon("/com/iplanet/im/client/images/tb_attach.png", (Object)this));
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }

    public final class AttachListModel
    extends AbstractListModel {
        private JList list;
        private Vector v;

        public AttachListModel(JList list, Vector v) {
            this.v = v;
            this.list = list;
        }

        public final int getSize() {
            return this.v.size();
        }

        final String getName(Object o) {
            return o.toString();
        }

        public final Object getElementAt(int index) {
            return this.v.elementAt(index);
        }

        public final void changed() {
            this.fireContentsChanged(this.list, 0, 0);
        }

        public final void changed(Vector v) {
            this.v = v;
            this.fireContentsChanged(this.list, 0, 0);
        }
    }
}

