/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.chat.bean;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.chat.bean.RoomEditorUIEvent;
import com.iplanet.im.client.swing.chat.bean.RoomEditorUIListener;
import com.iplanet.im.client.swing.chat.bean.RoomEditorViewContainer;
import com.iplanet.im.client.swing.chat.bean.RoomFrame;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.swing.chat.bean.RoomViewBean;
import com.iplanet.im.client.util.AutoOrientationJPanel;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.IMHTMLEditorKit;
import com.iplanet.im.client.util.JFixedTextPane;
import com.iplanet.im.client.util.Orientation;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.util.HtmlUtility;
import com.sun.im.service.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;

public class RoomEditorViewBean
extends AutoOrientationJPanel
implements ActionListener,
CaretListener,
RoomViewBean,
KeyListener {
    static SafeResourceBundle chatBundle = Chat.chatPanelBundle;
    static SafeResourceBundle otherChatBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    private boolean _bold = false;
    private boolean _italic = false;
    private boolean _underline = false;
    private int _fontSize = iIMPropsUtil.getChatFontSize(CurrentUserManager.getCurrentUserProperties());
    private Color _fontColor = iIMPropsUtil.getChatFontColor(CurrentUserManager.getCurrentUserProperties());
    private boolean isTyping = false;
    RoomFrame.AttachAction attachAction;
    RoomFrame.SendAction sendAction;
    private int TYPE_TIMER_INTERVAL = 8000;
    private Timer _typingTimer;
    SymMouse aSymMouse = new SymMouse();
    private SmartJPopupMenu popup;
    private JMenuItem source;
    private JMenuItem print;
    private JButton btnSend;
    private SymAction lSymAction = new SymAction();
    private LinkedList chatListeners = new LinkedList();
    JFrame _parentFrame;
    RoomEditorViewContainer _container;
    RoomView thisRoomView;
    static final int MAX_CHARACTERS = 300;
    private Hashtable _commands = null;
    int htmlPaddingLen = 0;
    MessageDocumentListener mdl = new MessageDocumentListener();
    private boolean bug4979834Happens = false;
    JScrollPane scrollPane = new JScrollPane();
    JTextPane txtMessage = new JFixedTextPane();

    public RoomEditorViewBean(JFrame f, RoomEditorViewContainer revc, RoomView rv) {
        this._parentFrame = f;
        this._container = revc;
        this.thisRoomView = rv;
        String lang = Locale.getDefault().getLanguage();
        if (lang.equals("ar") || lang.equals("he")) {
            this.bug4979834Happens = true;
        }
        this.initComponents();
    }

    private void initComponents() {
        this._typingTimer = new Timer(this.TYPE_TIMER_INTERVAL, this);
        this._typingTimer.setRepeats(false);
        this.btnSend = new JButton();
        this.setLayout(new BorderLayout(5, 5));
        this.btnSend.setText(chatBundle.getString("Send"));
        this.btnSend.setMnemonic(chatBundle.getString("Send_M").charAt(0));
        this.scrollPane.setAutoscrolls(true);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setOpaque(true);
        this.add("Center", this.scrollPane);
        this.add("East", this.btnSend);
        this.scrollPane.setViewportView(this.txtMessage);
        this.txtMessage.setContentType("text/html");
        this.txtMessage.setEditorKit(new IMHTMLEditorKit());
        this.restoreTxtFormat();
        this.txtMessage.addCaretListener(this);
        this.evaluateEnterBinding();
        this.txtMessage.getInputMap().put(KeyStroke.getKeyStroke("ctrl ENTER"), new IMHTMLEditorKit.InsertBreakAction());
        this.txtMessage.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RoomEditorViewBean.this.fireRoomEditorUIListeners(RoomEditorViewBean.this.txtMessage, 4, null);
                RoomEditorViewBean.this.txtMessage.getDocument().addDocumentListener(RoomEditorViewBean.this.mdl);
            }

            public void focusLost(FocusEvent e) {
                RoomEditorViewBean.this.fireRoomEditorUIListeners(RoomEditorViewBean.this.txtMessage, 5, null);
                RoomEditorViewBean.this.txtMessage.getDocument().addDocumentListener(RoomEditorViewBean.this.mdl);
            }
        });
        this.txtMessage.addKeyListener(this);
        Dimension dim = SwingUtils.getComponentSize(this.txtMessage, 50, 3);
        this.txtMessage.setPreferredSize(dim);
        this.txtMessage.addMouseListener(this.aSymMouse);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        this.sendAction = ((RoomFrame)this._parentFrame).getSendAction();
        this.btnSend.setAction(this.sendAction);
        SymPropertyChange lSymPropertyChange = new SymPropertyChange();
        this.addPropertyChangeListener(lSymPropertyChange);
        this.sendAction.setEnabled(false);
        Orientation.apply(this.txtMessage);
    }

    public void evaluateEnterBinding() {
        if (iIMPropsUtil.getChatEnterSend(CurrentUserManager.getCurrentUserProperties())) {
            EditorUtility.installEnterBinding(this.txtMessage);
        } else {
            Keymap map = this.txtMessage.getKeymap();
            if (map != null) {
                this.txtMessage.setKeymap(map.getResolveParent());
            }
        }
    }

    private void createPopupMenu() {
        this.popup = new SmartJPopupMenu();
        this.source = new JMenuItem(chatBundle.getString("View_Source"));
        this.print = new JMenuItem(chatBundle.getString("Print"));
        this.source.addActionListener(this.lSymAction);
        this.print.addActionListener(this.lSymAction);
        this.attachAction = ((RoomFrame)this._parentFrame).getAttachAction();
        this.popup.add(this.attachAction);
    }

    private final void showPopup(int x, int y) {
        if (this.popup == null) {
            this.createPopupMenu();
            this.popup.add(this.source);
            this.popup.add(this.print);
        }
        this.popup.show(this.txtMessage, new Point(x, y));
    }

    public JButton getDefaultButton() {
        return this.btnSend;
    }

    public void showInvite() {
        try {
            this.thisRoomView.showInviteDialog();
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e:" + (Object)((Object)e));
        }
    }

    public void leave() {
        this.thisRoomView.exit();
    }

    public boolean requestDefaultFocus() {
        if (PlatformUtil.isJDK1_4()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RoomEditorViewBean.this.txtMessage.requestFocus();
                }
            });
        } else {
            this.txtMessage.requestFocus();
        }
        return this.txtMessage.hasFocus();
    }

    private void resetTxtView() {
        this.resetTxtView("");
    }

    private void resetTxtView(String msg) {
        if (this.bug4979834Happens && (PlatformUtil.isJDK1_3() || PlatformUtil.isJDK1_4())) {
            AbstractDocument ad = (AbstractDocument)this.txtMessage.getEditorKit().createDefaultDocument();
            ad.putProperty("i18n", Boolean.TRUE);
            this.txtMessage.setDocument(ad);
        }
        this.txtMessage.setText(msg);
    }

    public void insertText(String s) {
        this.txtMessage.replaceSelection(s);
        this.txtMessage.requestFocus();
    }

    public JTextPane getTextEditorField() {
        return this.txtMessage;
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public Color getFontColor() {
        return this._fontColor;
    }

    private final void saveTxtFormat() {
        this._bold = EditorUtility.isCurrentCaretBold(this.txtMessage);
        this._underline = EditorUtility.isCurrentCaretUnderline(this.txtMessage);
        this._italic = EditorUtility.isCurrentCaretItalic(this.txtMessage);
        this._fontSize = EditorUtility.getCurrentCaretFontSize(this.txtMessage);
        this._fontColor = EditorUtility.getCurrentCaretFontColor(this.txtMessage);
    }

    private final void restoreTxtFormat() {
        EditorUtility.setTextBold(this.txtMessage, this._bold);
        EditorUtility.setTextUnderline(this.txtMessage, this._underline);
        EditorUtility.setTextItalic(this.txtMessage, this._italic);
        EditorUtility.setFontSize(this.txtMessage, this._fontSize);
        EditorUtility.setFontColor(this.txtMessage, this._fontColor);
    }

    private final void resetTxtFormat() {
        this.setItalic(this._italic);
        this.setBold(this._bold);
        this.setUnderline(this._underline);
        this.setFontColor(this._fontColor);
        this.setFontSize(this._fontSize);
    }

    private final void removeListeners() {
        this.txtMessage.removeKeyListener(this);
        this.txtMessage.removeCaretListener(this);
    }

    public void close() {
        Manager.Out("   DEBUG CHAT: Closing Chat Editor");
        this.removeListeners();
        this.chatListeners.clear();
    }

    public final boolean isUnderline() {
        return this._underline;
    }

    public final boolean isBold() {
        return this._bold;
    }

    public final boolean isItalic() {
        return this._italic;
    }

    public final void setUnderline(boolean b) {
        EditorUtility.setTextUnderline(this.txtMessage, b);
        this._underline = b;
    }

    public final void setBold(boolean b) {
        EditorUtility.setTextBold(this.txtMessage, b);
        this._bold = b;
    }

    public final void setItalic(boolean b) {
        EditorUtility.setTextItalic(this.txtMessage, b);
        this._italic = b;
    }

    public final void setFontSize(int size) {
        EditorUtility.setFontSize(this.txtMessage, size);
        this._fontSize = size;
    }

    public final void setFontColor(Color c) {
        this._fontColor = c;
        EditorUtility.setFontColor(this.txtMessage, c);
    }

    public void startTyping() {
        if (this._typingTimer != null) {
            if (this._typingTimer.isRunning()) {
                this._typingTimer.restart();
            } else {
                this.fireRoomEditorUIListeners(this.txtMessage, 2, null);
                this._typingTimer.start();
            }
        }
    }

    public final void stopTyping() {
        this.fireRoomEditorUIListeners(this.txtMessage, 1, null);
        this._typingTimer.stop();
    }

    public String getHtmlSource() {
        return EditorUtility.getHtmlDocumentText(this.txtMessage);
    }

    public void print() {
        iIMUtility.printDoc(this._parentFrame, this._parentFrame.getTitle(), this.txtMessage);
    }

    public final void viewSource() {
        EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(this.txtMessage), chatBundle.getString("Source of compose panel"));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._typingTimer) {
            this.stopTyping();
        }
    }

    public void sendMessage() {
        String msg = HtmlUtility.getBody((String)EditorUtility.getHtmlDocumentText(this.txtMessage));
        this.fireRoomEditorUIListeners(this.txtMessage, 0, msg);
        this.stopTyping();
        Sound.play(3);
        this.txtMessage.removeCaretListener(this);
        this.resetTxtView();
        this.restoreTxtFormat();
        this.txtMessage.requestFocus();
        this.txtMessage.addCaretListener(this);
        this.sendAction.setEnabled(false);
    }

    private void showInsufficientPrivilegeDialog() {
        String msg = otherChatBundle.getString("You_do_not_have_access_privilege_to_that");
        JOptionPane.showMessageDialog(this._parentFrame, msg);
    }

    public void keyPressed(KeyEvent event) {
        Object o = event.getSource();
        int k = event.getKeyCode();
        this.txtMessage.getDocument().addDocumentListener(this.mdl);
        if (event.isControlDown()) {
            if (k == 85) {
                this.txtMessage.removeCaretListener(this);
                this.resetTxtView();
                this.restoreTxtFormat();
                this.txtMessage.addCaretListener(this);
            }
        } else {
            this.startTyping();
            if (k == 8 && this.txtMessage.getCaretPosition() == 1 || k == 127 && this.txtMessage.getCaretPosition() == 0) {
                this.txtMessage.removeCaretListener(this);
                try {
                    int pos = this.txtMessage.getCaretPosition();
                    this.txtMessage.setCaretPosition(2);
                    this.txtMessage.setCaretPosition(pos);
                }
                catch (Exception e) {
                    this.resetTxtView();
                    this.restoreTxtFormat();
                    this.sendAction.setEnabled(false);
                }
                this.txtMessage.addCaretListener(this);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public final void addRoomEditorUIListener(RoomEditorUIListener l) {
        if (!this.chatListeners.contains(l)) {
            this.chatListeners.add(l);
        }
    }

    public final void removeRoomEditorUIListener(RoomEditorUIListener l) {
        if (this.chatListeners != null) {
            this.chatListeners.remove(l);
        }
    }

    public final void fireRoomEditorUIListeners(Object src, int type, String msg) {
        RoomEditorUIEvent event = new RoomEditorUIEvent(src, type, msg);
        Iterator i = this.chatListeners.iterator();
        while (i.hasNext()) {
            RoomEditorUIListener listener = (RoomEditorUIListener)i.next();
            listener.newRoomEditorEvent(event);
        }
    }

    void RoomEditorViewBean_mouseClicked(MouseEvent event) {
    }

    void RoomEditorViewBean_propertyChange(PropertyChangeEvent event) {
    }

    public void caretUpdate(CaretEvent e) {
        this.saveTxtFormat();
        this.fireRoomEditorUIListeners(e.getSource(), 7, null);
    }

    protected class MessageDocumentListener
    implements DocumentListener {
        protected MessageDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.displayEditInfo(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.displayEditInfo(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.displayEditInfo(e);
        }

        private void displayEditInfo(DocumentEvent e) {
            Document document = e.getDocument();
            try {
                int docLen = document.getLength();
                Segment text = new Segment();
                boolean offs = false;
                text.setPartialReturn(true);
                String docText = document.getText(0, docLen).toString().trim();
                int textLen = docText.length();
                RoomEditorViewBean.this.sendAction.setEnabled(docLen > 0 && textLen > 0 || !RoomEditorViewBean.this._container.isNotAttached());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class SymPropertyChange
    implements PropertyChangeListener {
        SymPropertyChange() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object object = event.getSource();
            if (object == RoomEditorViewBean.this) {
                RoomEditorViewBean.this.RoomEditorViewBean_propertyChange(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RoomEditorViewBean.this.source) {
                EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(RoomEditorViewBean.this.txtMessage), chatBundle.getString("Source"));
            } else if (object == RoomEditorViewBean.this.print) {
                iIMUtility.printDoc(RoomEditorViewBean.this._parentFrame, RoomEditorViewBean.this._parentFrame.getTitle(), RoomEditorViewBean.this.txtMessage);
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                RoomEditorViewBean.this.showPopup(e.getX(), e.getY());
            }
        }
    }
}

