/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.calendar;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.im.desktop.MessengerAppContext;
import com.sun.im.desktop.MessengerBeanFactory;
import com.sun.im.desktop.MessengerException;
import com.sun.im.desktop.MessengerMessageListener;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.util.StringUtility;
import java.util.TimeZone;

public class CalendarBean
extends MessengerBeanFactory
implements MessengerMessageListener {
    private static final String CONTENTTYPE_TEXTCALENDAR = "text/calendar";
    private static final String DESCRIPTION_MACRO = "{DESCRIPTION}";
    private static final String LOCATION_MACRO = "{LOCATION}";
    private static final String SUMMARY_MACRO = "{SUMMARY}";
    private static final String DTSTART_MACRO = "{DTSTART}";
    private static final String DTEND_MACRO = "{DTEND}";
    private static final String DTDUE_MACRO = "{DTDUE}";
    private static final String OWNER_MACRO = "{OWNER}";
    private static final String ALARM_DESCRIPTION_MACRO = "{ALARM_DESCRIPTION}";
    private static SafeResourceBundle rb = new SafeResourceBundle("com.iplanet.im.client.swing.calendar.calendar");
    MessengerAppContext appContext = null;
    private static String _originator = rb.getString("calendar.originator");
    private static String _defaultAlarmSubject;
    private static String _defaultSubject;
    private static String _defaultAlarmText;
    private static String _defaultText;
    private static String _eventTextFormat;
    private static String _todoTextFormat;

    private void showCalendarPopup(String originator, String subject, String body) {
        Manager.Out("[calreminder] originator: " + originator);
        Manager.Out("[calreminder] subject   : " + subject);
        Manager.Out("[calreminder] content   : " + body);
        this.appContext.displayBotAlert(originator, subject, body);
    }

    public void onMessage(ReadOnlyMessage message) {
        String body = null;
        String originator = _originator;
        try {
            String localizedSubject;
            String subject = message.getHeader("subject");
            String content = message.getContent();
            Manager.Out("New Calendar reminder received: \n" + content);
            Manager.Out("[calreminder] subject   : " + subject);
            Manager.Out("[calreminder] parsing:\n" + content);
            if (!iIMPropsUtil.getCalendarReminder(CurrentUserManager.getCurrentUserProperties())) {
                Manager.Out("Calendar popup is disabled.");
                return;
            }
            if (originator == null) {
                originator = message.getOriginator();
            }
            if ((localizedSubject = rb.getString(subject)) == null) {
                localizedSubject = subject.indexOf(".alarm.") > 0 ? _defaultAlarmSubject : _defaultSubject;
            }
            if (subject.endsWith(".event")) {
                try {
                    body = this.getEventContent(_eventTextFormat, content);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    try {
                        body = this.getTodoContent(_todoTextFormat, content);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            } else {
                try {
                    body = this.getTodoContent(_todoTextFormat, content);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    try {
                        body = this.getEventContent(_eventTextFormat, content);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            if (body == null) {
                body = subject.indexOf(".alarm.") > 0 ? _defaultAlarmText : _defaultText;
            }
            this.showCalendarPopup(originator, localizedSubject, body);
        }
        catch (Exception e0) {
            e0.printStackTrace();
        }
    }

    public void init() {
        try {
            Manager.Out("[calreminder] init");
            this.appContext = MessengerAppContext.getAppContext();
            this.appContext.addMessageListener(CONTENTTYPE_TEXTCALENDAR, (MessengerMessageListener)this);
        }
        catch (MessengerException e) {
            e.printStackTrace();
        }
    }

    private String substituteDate(String in, String macro, DateTime dt) {
        if (dt != null) {
            dt.setTimeZone(TimeZone.getDefault());
            return StringUtility.substitute((String)in, (String)macro, (String)dt.toString());
        }
        return in;
    }

    private String unescape(String in) {
        String out = StringUtility.substitute((String)in, (String)"\\r\\n", (String)"<br>");
        out = StringUtility.substitute((String)out, (String)"\\;", (String)";");
        out = StringUtility.substitute((String)out, (String)"\\:", (String)":");
        return out;
    }

    private String getEventContent(String format, String content) throws Exception {
        String s = content;
        int bindex = content.indexOf("BEGIN:VEVENT");
        int eindex = content.indexOf("END:VEVENT");
        if (bindex > 0 && eindex > bindex) {
            s = content.substring(bindex, eindex + 10);
        }
        VEvent c = new VEvent(s);
        String out = StringUtility.substitute((String)format, (String)LOCATION_MACRO, (String)c.getLocation());
        out = this.substituteDate(out, DTSTART_MACRO, c.getStart());
        out = this.substituteDate(out, DTEND_MACRO, c.getEndTime());
        out = StringUtility.substitute((String)out, (String)DTEND_MACRO, (String)c.getEndTime().toString());
        out = StringUtility.substitute((String)out, (String)SUMMARY_MACRO, (String)c.getSummary());
        out = c.getDescription() != null ? StringUtility.substitute((String)out, (String)DESCRIPTION_MACRO, (String)this.unescape(c.getDescription())) : StringUtility.substitute((String)out, (String)DESCRIPTION_MACRO, (String)"");
        VAlarm[] alarm = c.getAlarmComponents();
        out = alarm != null && alarm.length > 0 ? this.substituteAlarm(out, alarm[0]) : StringUtility.substitute((String)out, (String)ALARM_DESCRIPTION_MACRO, (String)"");
        return out;
    }

    private String substituteAlarm(String in, VAlarm alarm) {
        String desc = alarm.getDescription();
        if (desc != null) {
            return StringUtility.substitute((String)in, (String)ALARM_DESCRIPTION_MACRO, (String)this.unescape(desc));
        }
        return StringUtility.substitute((String)in, (String)ALARM_DESCRIPTION_MACRO, (String)"");
    }

    private String getTodoContent(String format, String content) throws Exception {
        String s = content;
        int bindex = content.indexOf("BEGIN:VTODO");
        int eindex = content.indexOf("END:VTODO");
        if (bindex > 0 && eindex > bindex) {
            s = content.substring(bindex, eindex + 10);
        }
        VTodo c = new VTodo(s);
        String out = this.substituteDate(format, DTDUE_MACRO, c.getDueTime());
        out = StringUtility.substitute((String)out, (String)SUMMARY_MACRO, (String)c.getSummary());
        out = c.getDescription() != null ? StringUtility.substitute((String)out, (String)DESCRIPTION_MACRO, (String)this.unescape(c.getDescription())) : StringUtility.substitute((String)out, (String)DESCRIPTION_MACRO, (String)"");
        VAlarm[] alarm = c.getAlarmComponents();
        out = alarm != null && alarm.length > 0 ? this.substituteAlarm(out, alarm[0]) : StringUtility.substitute((String)out, (String)ALARM_DESCRIPTION_MACRO, (String)"");
        return out;
    }

    static {
        if (_originator != null && (_originator = _originator.trim()).length() == 0) {
            _originator = null;
        }
        _defaultAlarmSubject = rb.getString("calendar.alarm");
        _defaultSubject = rb.getString("calendar.notification");
        _defaultAlarmText = rb.getString("calendar.alarm.text");
        _defaultText = rb.getString("calendar.notification.text");
        _eventTextFormat = rb.getString("calendar.format.event");
        _todoTextFormat = rb.getString("calendar.format.todo");
    }
}

