/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing.archive;

import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.desktop.MessengerAppContext;
import com.sun.im.desktop.MessengerPreferencesPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ArchiveBeanSettingsPanel
extends MessengerPreferencesPanel
implements ItemListener {
    private JCheckBox chkEnableArchive;
    private JCheckBox chkEverything;
    private JPanel pnlSettings;
    private JCheckBox chkAlerts;
    private JCheckBox chkConferences;
    private JCheckBox chkPolls;
    private MessengerAppContext _appContext = MessengerAppContext.getAppContext();
    private static SafeResourceBundle archivePanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.archive.archive");

    public ArchiveBeanSettingsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.chkEnableArchive = new JCheckBox();
        this.pnlSettings = new JPanel();
        this.chkEverything = new JCheckBox();
        this.chkConferences = new JCheckBox();
        this.chkAlerts = new JCheckBox();
        this.chkPolls = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.chkEnableArchive.setText(archivePanelBundle.getString("chkEnableArchive_text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 10, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.chkEnableArchive, gridBagConstraints);
        this.pnlSettings.setLayout(new GridBagLayout());
        this.pnlSettings.setBorder(new TitledBorder(archivePanelBundle.getString("pnlSettings_Border_Title")));
        this.chkEverything.setText(archivePanelBundle.getString("chkEverything_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlSettings.add((Component)this.chkEverything, gridBagConstraints);
        this.chkConferences.setText(archivePanelBundle.getString("chkConferences_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 20, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlSettings.add((Component)this.chkConferences, gridBagConstraints);
        this.chkAlerts.setText(archivePanelBundle.getString("chkAlerts_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(2, 20, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlSettings.add((Component)this.chkAlerts, gridBagConstraints);
        this.chkPolls.setText(archivePanelBundle.getString("chkPolls_text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 20, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlSettings.add((Component)this.chkPolls, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagConstraints.weightx = 1.0;
        this.add(this.pnlSettings, gridBagConstraints);
        this.chkEnableArchive.addItemListener(this);
        this.chkEverything.addItemListener(this);
    }

    public String getTitle() {
        return archivePanelBundle.getString("settingsPanel_title");
    }

    public void loadPreferences() throws Exception {
        this.loadPreferences(CurrentUserManager.getCurrentUserProperties());
    }

    public void loadPreferences(Properties userProperties) throws Exception {
        if (this._appContext == null) {
            throw new Exception("com.iplanet.im.client.swing.archiveArchiveBeanSettingsPanel.loadPreferences(): Application context is null");
        }
        this.chkEnableArchive.setSelected(iIMPropsUtil.isArchiveEnabled(userProperties));
        this.chkEverything.setSelected(iIMPropsUtil.isArchiveOptionEnabled(userProperties, 30));
        this.chkConferences.setSelected(iIMPropsUtil.isArchiveOptionEnabled(userProperties, 2));
        this.chkAlerts.setSelected(iIMPropsUtil.isArchiveOptionEnabled(userProperties, 4));
        this.chkPolls.setSelected(iIMPropsUtil.isArchiveOptionEnabled(userProperties, 8));
        this.chkEverything.setEnabled(this.chkEnableArchive.isSelected());
        if (!this.chkEnableArchive.isSelected() || !this.chkEverything.isEnabled()) {
            this.chkAlerts.setEnabled(false);
            this.chkConferences.setEnabled(false);
            this.chkPolls.setEnabled(false);
        }
    }

    public void savePreferences() throws Exception {
        this.savePreferences(CurrentUserManager.getCurrentUserProperties());
    }

    public void savePreferences(Properties userProperties) throws Exception {
        if (this._appContext == null) {
            throw new Exception("com.iplanet.im.client.swing.archiveArchiveBeanSettingsPanel.savePreferences(): Application context is null");
        }
        iIMPropsUtil.setArchiveEnabled(userProperties, this.chkEnableArchive.isSelected());
        if (this.chkEverything.isSelected()) {
            iIMPropsUtil.setArchiveOptionEnabled(userProperties, 30, this.chkEverything.isSelected());
            return;
        }
        iIMPropsUtil.setArchiveOptionEnabled(userProperties, 2, this.chkConferences.isSelected());
        iIMPropsUtil.setArchiveOptionEnabled(userProperties, 4, this.chkAlerts.isSelected());
        iIMPropsUtil.setArchiveOptionEnabled(userProperties, 8, this.chkPolls.isSelected());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object o = itemEvent.getSource();
        if (o == this.chkEnableArchive) {
            boolean b = itemEvent.getStateChange() == 1;
            this.chkEverything.setEnabled(b);
            this.chkAlerts.setEnabled(b);
            this.chkConferences.setEnabled(b);
            this.chkPolls.setEnabled(b);
        } else if (o == this.chkEverything) {
            boolean b = itemEvent.getStateChange() != 1;
            this.chkAlerts.setEnabled(b);
            this.chkConferences.setEnabled(b);
            this.chkPolls.setEnabled(b);
        }
    }
}

