/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.TopicManager;
import com.iplanet.im.client.swing.Client;
import com.iplanet.im.client.swing.SubscriptionEvent;
import com.iplanet.im.client.swing.SubscriptionListener;
import com.iplanet.im.client.swing.login.DefaultLoginDialog;
import com.iplanet.im.client.swing.topic.TopicManagement;
import com.iplanet.im.client.swing.topic.TopicSubscriptionFrame;
import com.iplanet.im.client.swing.topic.TopicView;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.ConflictException;
import com.sun.im.service.Message;
import com.sun.im.service.NewsChannel;
import java.util.Vector;

public class Topics {
    static SafeResourceBundle topicsBundle = new SafeResourceBundle("com.iplanet.im.client.swing.topic.topic");
    private Client parent;
    private DefaultLoginDialog login;
    private TopicManagement topicManager;
    public static final String ID_ITEM_EXISTS = topicsBundle.getString("TopicManagement_topic_already_exists");
    private static Vector subscriptionListeners = null;
    private static TopicSubscriptionFrame tsFrame = null;
    private TopicView _topicView = null;

    public Topics(Client c, DefaultLoginDialog d) {
        this.parent = c;
        this.login = d;
    }

    public void init() {
        this.initTopicConnections();
    }

    public void close() {
        if (this._topicView != null) {
            this._topicView.dispose();
        }
        this._topicView = null;
    }

    private static final synchronized void addSubscriptionListener(SubscriptionListener l) {
        if (subscriptionListeners == null) {
            subscriptionListeners = new Vector(2);
        }
        if (subscriptionListeners.contains(l)) {
            return;
        }
        subscriptionListeners.addElement(l);
    }

    public final boolean addTopic(String name, String server, int access) {
        Topics topics = this;
        if (!topics.parent.isConnected()) {
            return false;
        }
        name = Manager.getValidDestinationName(name);
        try {
            NewsChannel t = Manager._newsSession.newNewsChannel(name, null, access);
            TopicManager.addTopicToServer(t);
        }
        catch (ConflictException ce) {
            ApplicationManager.showMessageBox(ID_ITEM_EXISTS);
            return false;
        }
        catch (CollaborationException collexp) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.refreshTopicViews(true);
        return true;
    }

    public static final synchronized Vector cloneListeners() {
        return (Vector)subscriptionListeners.clone();
    }

    public final void deleteTopic(NewsChannel t) {
        if (TopicManager.isTopicSubscribed(t.getDestination())) {
            Topics.fireSubscriptionListeners(t.getDestination(), 1, null);
        }
        TopicManager.deleteTopic(t);
        this.refreshTopicViews(true);
    }

    public static final void fireSubscriptionListeners(String name, int type, String id) {
        if (subscriptionListeners == null) {
            return;
        }
        Vector tl = Topics.cloneListeners();
        int size = tl.size();
        if (size == 0) {
            return;
        }
        SubscriptionEvent event = new SubscriptionEvent(name, type, id);
        for (int i = 0; i < size; ++i) {
            SubscriptionListener listener = (SubscriptionListener)tl.elementAt(i);
            listener.subscriptionChange(event);
        }
    }

    public static void handleAlertMsg(Message m) {
        if (TopicManager.isTopicAlertChannelEnabled()) {
            TopicManager.addTopicMessage(TopicManager.ID_ALERT_ID, m, true);
        }
    }

    public final void handleNewTopicMsg(Message m, NewsChannel nc) {
        String cname = nc.getDestination();
        TopicManager.addTopicMessage(cname, m, false);
        Topics.fireSubscriptionListeners(cname, 2, m.getMessageId());
        this.refreshTopicViews(false);
    }

    public final void initTopicConnections() {
        Manager.Out("DEBUG: Topics.initTopicConnections()");
        TopicManager.refreshTopics();
    }

    public final void openTopicManager() {
        if (TopicManagement.isTopicManagementOpened()) {
            this.topicManager.setVisible(true);
            return;
        }
        this.topicManager = new TopicManagement(this.login);
        this.topicManager.setVisible(true);
    }

    public static void refreshTopics() {
        Manager.worker.addRunnable((Runnable)new TopicRefreshRunnable());
    }

    public final void refreshTopicViews(boolean update) {
        if (this.topicManager != null) {
            this.topicManager.refresh(update);
        }
        if (tsFrame != null) {
            tsFrame.refresh();
        }
    }

    public static final synchronized void removeSubscriptionListener(SubscriptionListener l) {
        if (subscriptionListeners == null) {
            subscriptionListeners = new Vector(2);
        }
        subscriptionListeners.removeElement(l);
    }

    public void showTopicSubscription() {
        if (TopicSubscriptionFrame._OPEN) {
            return;
        }
        tsFrame = new TopicSubscriptionFrame();
        tsFrame.setVisible(true);
        tsFrame.refresh();
    }

    public final void showTopicView() {
        Manager.Out("DEBUG: Topics.showTopicView()");
        if (TopicView.getOpenedTopicsCount() > 0) {
            this._topicView.setVisible(true);
            this._topicView.setState(0);
            this._topicView.toFront();
        } else {
            this._topicView = new TopicView();
            Topics.addSubscriptionListener(this._topicView);
        }
    }

    public final TopicView getTopicView() {
        return this._topicView;
    }

    public final void updatePauseButton() {
        if (this._topicView != null) {
            this._topicView.updatePauseButton();
        }
    }

    private static final class TopicUpdateThread
    implements Runnable {
        private TopicUpdateThread() {
        }

        public void run() {
        }
    }

    private static final class TopicRefreshRunnable
    implements Runnable {
        private TopicRefreshRunnable() {
        }

        public void run() {
            TopicManager.refreshTopics();
        }
    }
}

