/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.manager.Manager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class SwingImageManager {
    private static ImageIcon iconOnline = null;
    private static ImageIcon iconJustOnline = null;
    private static ImageIcon iconOffline = null;
    private static ImageIcon iconJustOffline = null;
    private static ImageIcon iconFolder_Col = null;
    private static ImageIcon iconFolder_Exp = null;
    private static ImageIcon iconServerGroup = null;
    private static ImageIcon iconOfflineFwd = null;
    private static ImageIcon iconError = null;
    private static ImageIcon iconIdle = null;
    private static ImageIcon iconAway = null;
    private static ImageIcon iconPending = null;
    private static ImageIcon iconBusy = null;
    private static ImageIcon iconChat = null;
    public static final int STATUS_ICON_ONLINE = 0;
    public static final int STATUS_ICON_JUST_ONLINE = 1;
    public static final int STATUS_ICON_OFFLINE = 2;
    public static final int STATUS_ICON_JUST_OFFLINE = 3;
    public static final int STATUS_ICON_OFFLINE_FWD = 4;
    public static final int STATUS_ICON_IDLE = 5;
    public static final int STATUS_ICON_AWAY = 6;
    public static final int USER_ICON_FOLDER_COL = 7;
    public static final int USER_ICON_FOLDER_EXP = 8;
    public static final int USER_SERVER_GROUP = 9;
    public static final int STATUS_ICON_PENDING = 10;
    public static final int STATUS_ICON_BUSY = 12;
    public static final int STATUS_ICON_CHAT = 13;
    static boolean _errorIconLoaded = false;
    private static ImageIcon[] _bgPltTexIcons;
    private static ArrayList _bgPltTextStylesList;
    private static HashMap _bgStylesMap;
    private static HashMap _bgIcons;
    private static final String PREFIX_BGPLT_TEX = "bgplt_tex_";
    private static final String PREFIX_BG_TEX = "bg_tex_";
    private static final String COLS_BGPLT_TEX = "cols_bgplt_tex";
    private static final String ROWS_BGPLT_TEX = "rows_bgplt_tex";

    public static final ImageIcon getIcon(int n, Object o) {
        switch (n) {
            case 0: {
                if (iconOnline == null) {
                    iconOnline = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_online.png", "/com/sun/im/desktop/default/presenceicons/cl_online.png", o);
                }
                return iconOnline;
            }
            case 2: {
                if (iconOffline == null) {
                    iconOffline = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_offline.png", "/com/sun/im/desktop/default/presenceicons/cl_offline.png", o);
                }
                return iconOffline;
            }
            case 5: {
                if (iconIdle == null) {
                    iconIdle = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_idle.png", "/com/sun/im/desktop/default/presenceicons/cl_idle.png", o);
                }
                return iconIdle;
            }
            case 6: {
                if (iconAway == null) {
                    iconAway = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_away.png", "/com/sun/im/desktop/default/presenceicons/cl_away.png", o);
                }
                return iconAway;
            }
            case 10: {
                if (iconPending == null) {
                    iconPending = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_pending.png", "/com/sun/im/desktop/default/presenceicons/cl_pending.png", o);
                }
                return iconPending;
            }
            case 12: {
                if (iconBusy == null) {
                    iconBusy = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_dnd.png", "/com/sun/im/desktop/default/presenceicons/cl_dnd.png", o);
                }
                return iconBusy;
            }
            case 7: {
                if (iconFolder_Col == null) {
                    iconFolder_Col = SwingImageManager.getIcon("/com/sun/im/desktop/brand/cl_folder_closed.png", "/com/sun/im/desktop/default/brand/cl_folder_closed.png", o);
                }
                return iconFolder_Col;
            }
            case 8: {
                if (iconFolder_Exp == null) {
                    iconFolder_Exp = SwingImageManager.getIcon("/com/sun/im/desktop/brand/cl_folder_open.png", "/com/sun/im/desktop/default/brand/cl_folder_open.png", o);
                }
                return iconFolder_Exp;
            }
            case 9: {
                if (iconServerGroup == null) {
                    iconServerGroup = SwingImageManager.getIcon("/com/iplanet/im/client/images/sr_group.png", o);
                }
                return iconServerGroup;
            }
        }
        if (iconOffline == null) {
            iconOffline = SwingImageManager.getIcon("/com/sun/im/desktop/presenceicons/cl_offline.png", "/com/sun/im/desktop/default/presenceicons/cl_offline.png", o);
        }
        return iconOffline;
    }

    public static final void flushIcon(String path) {
        ImageIcon icon = new ImageIcon(path);
        if (icon != null) {
            icon.getImage().flush();
        }
    }

    public static final ImageIcon getIcon(String name, Object o) {
        return SwingImageManager.getIcon(name, null, o);
    }

    public static final ImageIcon getIcon(String name, String nameDefault, Object o) {
        URL u = o.getClass().getResource(name);
        if (u == null && nameDefault != null) {
            u = o.getClass().getResource(nameDefault);
        }
        if (u == null) {
            System.out.println("Error: icon not found: " + name + " [" + nameDefault + "]");
            _errorIconLoaded = true;
            URL uErr = o.getClass().getResource("/com/iplanet/im/client/images/cp_blank.gif");
            return SwingImageManager.getIcon(uErr);
        }
        return SwingImageManager.getIcon(u);
    }

    public static final URL getImageURL(String name, String nameDefault, Object o) {
        URL u = o.getClass().getResource(name);
        if (u == null && nameDefault != null) {
            u = o.getClass().getResource(nameDefault);
        }
        return u;
    }

    public static final ImageIcon getAppIcon(Object o) {
        return SwingImageManager.getIcon("/com/sun/im/desktop/brand/im_app_icon_16.png", "/com/sun/im/desktop/default/brand/sunIM.png", o);
    }

    public static final ImageIcon getIcon(URL u) {
        if (u == null) {
            return null;
        }
        return new ImageIcon(u);
    }

    private static ImageIcon _loadBgIcon(String name) {
        String fileName;
        if (_bgStylesMap == null) {
            SwingImageManager._initBgStyles();
        }
        if ((fileName = (String)_bgStylesMap.get(name)) != null) {
            URL url = SwingImageManager.class.getResource("/com/sun/im/desktop/brand/bgstyles/" + fileName);
            if (url == null) {
                url = SwingImageManager.class.getResource("/com/sun/im/desktop/default/brand/bgstyles/" + fileName);
            }
            if (url != null) {
                return new ImageIcon(url, name);
            }
        }
        return null;
    }

    public static ImageIcon[] getBgPltTexIcons() {
        if (_bgPltTexIcons == null) {
            SwingImageManager._initBgPltTextIcons();
        }
        return _bgPltTexIcons;
    }

    private static void _initBgPltTextIcons() {
        if (_bgPltTextStylesList == null) {
            SwingImageManager._initBgStyles();
        }
        int size = _bgPltTextStylesList.size();
        _bgPltTexIcons = new ImageIcon[size];
        for (int i = 0; i < size; ++i) {
            SwingImageManager._bgPltTexIcons[i] = SwingImageManager.getBgIcon((String)_bgPltTextStylesList.get(i));
        }
    }

    public static ImageIcon getBgIcon(String name) {
        ImageIcon icon = (ImageIcon)_bgIcons.get(name);
        if (icon == null) {
            icon = SwingImageManager._loadBgIcon(name);
            _bgIcons.put(name, icon);
        }
        return icon;
    }

    public static ImageIcon getBgPatternIcon(String name) {
        ImageIcon icon = null;
        String patName = name;
        if (name.startsWith(PREFIX_BGPLT_TEX)) {
            patName = PREFIX_BG_TEX + patName.substring(PREFIX_BGPLT_TEX.length());
            icon = SwingImageManager.getBgIcon(patName);
            if (icon == null) {
                icon = SwingImageManager.getBgIcon(name);
            }
        } else {
            icon = SwingImageManager.getBgIcon(patName);
        }
        return icon;
    }

    public static int getPrefBgTexPltCols() {
        if (_bgStylesMap == null) {
            SwingImageManager._initBgStyles();
        }
        String data = (String)_bgStylesMap.get(COLS_BGPLT_TEX);
        int cols = -1;
        try {
            cols = Integer.parseInt(data);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return cols;
    }

    public static int getPrefBgTexPltRows() {
        if (_bgStylesMap == null) {
            SwingImageManager._initBgStyles();
        }
        String data = (String)_bgStylesMap.get(ROWS_BGPLT_TEX);
        int rows = -1;
        try {
            rows = Integer.parseInt(data);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return rows;
    }

    private static void _initBgStyles() {
        _bgStylesMap = new HashMap();
        _bgPltTextStylesList = new ArrayList();
        InputStream in = SwingImageManager.class.getResourceAsStream("/com/sun/im/desktop/brand/bgstyles/bgstyles.properties");
        if (in != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                String data = null;
                while ((data = reader.readLine()) != null) {
                    int equalIndex;
                    if ("".equals(data = data.trim()) || data.startsWith("#") || (equalIndex = data.indexOf("=")) == -1) continue;
                    String name = data.substring(0, equalIndex);
                    String fileName = data.substring(equalIndex + 1);
                    if ("".equals(name) || "".equals(fileName)) continue;
                    _bgStylesMap.put(name, fileName);
                    if (!name.startsWith(PREFIX_BGPLT_TEX)) continue;
                    _bgPltTextStylesList.add(name);
                }
            }
            catch (IOException e) {
                Manager.warning("Exception happened while reading bgstyles.properties file " + e);
                return;
            }
        } else {
            Manager.warning("Unable to find the bgstyles.properties file");
            return;
        }
        if (_bgStylesMap.size() == 0) {
            Manager.warning("No Entries in bgstyles.properties file");
        } else if (_bgPltTextStylesList.size() == 0) {
            Manager.warning("No Palatte icons in bgstyles.properties file");
        }
    }

    static {
        _bgIcons = new HashMap();
    }
}

