/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.SwingImageManager;
import com.iplanet.im.client.util.AutoOrientationJFrame;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.JComponentCellEditor;
import com.iplanet.im.client.util.JComponentCellRenderer;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.StyleUtility;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.MessageStatusListener;
import com.sun.im.service.Poll;
import com.sun.im.service.util.StringUtility;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public final class MsgStatus
extends AutoOrientationJFrame
implements MessageStatusListener {
    static SafeResourceBundle msgStatusBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    private static final String ID_RECEIVED = msgStatusBundle.getString("MsgStatus_status_received");
    private static final String ID_READ = msgStatusBundle.getString("MsgStatus_status_read");
    private static final String ID_AWAY = msgStatusBundle.getString("MsgStatus_status_received_but_away");
    private static final String ID_SENT = msgStatusBundle.getString("MsgStatus_status_sent");
    private static final String ID_UNKNOWN = msgStatusBundle.getString("MsgStatus_status_unknown");
    private static final String ID_OFFLINEFWD = msgStatusBundle.getString("MsgStatus_status_offline_forwarded");
    private SymWindow aSymWindow = new SymWindow();
    private SymAction lSymAction = new SymAction();
    private Point position;
    private Vector users = new Vector();
    private Vector IDs = new Vector();
    private String[] status;
    private Integer[] status_values;
    private Message message;
    private MsgTableModel msgModel;
    private Vector answerList = new Vector();
    private int[] answerStat;
    private Poll poll = null;
    private int TALLY_RECEIVED = 0;
    private int TALLY_READ = 0;
    private boolean isPollStatus = false;
    static final String ID_TALLY_RECEIVED = msgStatusBundle.getString("received");
    static final String ID_TALLY_READ = msgStatusBundle.getString("read");
    public static final String ID_USERS = msgStatusBundle.getString("users");
    public static final String ID_STATUS = msgStatusBundle.getString("status");
    public static final String ID_STATUS_VALUES = msgStatusBundle.getString("values");
    JScrollPane scrollStatus;
    JTable tblStatus;
    JPanel pnlButtons;
    JButton btnClose;
    JButton btnHelp;
    JLabel lblSummary;
    JScrollPane scrollSummary;
    JTextPane txtSummary;

    public MsgStatus(Point p, Message m, boolean poll) {
        this.position = p;
        this.isPollStatus = poll;
        this.message = m;
        this.initComponents();
        ApplicationManager.addActiveObject(this);
    }

    public MsgStatus(Point p, Message m, Vector lst) {
        this(p, m, false);
        this.fillQMessageList(lst);
        this.doInit();
    }

    public MsgStatus(Point p, Message m, Vector lst, Vector answers) {
        this(p, m, true);
        this.answerList = answers;
        this.answerStat = new int[answers.size() + 1];
        this.fillQMessageList(lst);
        this.doInit();
    }

    public MsgStatus(Point p, Message m, Vector lst, Vector answers, Poll poll) {
        this(p, m, lst, answers);
        this.poll = poll;
    }

    public MsgStatus(Point p, Message m) {
        this(p, m, false);
        Hashtable ht = null;
        MessagePart[] parts = m.getParts();
        for (int i = 0; i < parts.length; ++i) {
            Manager.Out("    Part " + i);
            Manager.Out("        Content-type: " + parts[i].getContentType());
            try {
                String body = parts[0].getContent();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Vector u = (Vector)ht.get(ID_USERS);
        Vector s = (Vector)ht.get(ID_STATUS);
        this.status_values = (Integer[])ht.get(ID_STATUS_VALUES);
        this.fillQMessageListStorage(s, u);
        if (!m.getOriginator().equals(CurrentUserManager.getCurrentUserID()) || m.getContentType().equals("application/x-iim-poll")) {
            this.pnlButtons.setVisible(false);
        }
        this.doInit();
    }

    private void initComponents() {
        this.scrollStatus = new JScrollPane();
        this.tblStatus = new JTable();
        this.pnlButtons = new JPanel();
        this.btnClose = new JButton();
        this.btnHelp = new JButton();
        this.lblSummary = new JLabel();
        this.scrollSummary = new JScrollPane();
        this.txtSummary = new JTextPane();
        if (this.message != null) {
            this.setTitle(StringUtility.substitute((String)msgStatusBundle.getString("MsgStatus_title_"), (String)"__MACRO__", (String)this.message.getHeader("subject")));
        } else {
            Manager.Out("MsgStatus.initComponents(): message is null");
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.getRootPane().setDefaultButton(this.btnClose);
        this.setSize(600, 240);
        this.setVisible(false);
        this.scrollStatus.setOpaque(true);
        this.scrollStatus.setToolTipText(msgStatusBundle.getString("scrollStatus_toolTipText").length() != 0 ? msgStatusBundle.getString("scrollStatus_toolTipText") : null);
        this.getContentPane().add((Component)this.scrollStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 5, 2, 5), 0, 0));
        this.tblStatus.setToolTipText(msgStatusBundle.getString("tblStatus_toolTipText").length() != 0 ? msgStatusBundle.getString("tblStatus_toolTipText") : null);
        this.scrollStatus.setViewportView(this.tblStatus);
        if (this.isPollStatus) {
            this.tblStatus.setAutoResizeMode(0);
            this.scrollStatus.setHorizontalScrollBarPolicy(30);
            this.lblSummary.setText(msgStatusBundle.getString("summary_responses"));
            this.lblSummary.setLabelFor(this.scrollSummary);
            this.getContentPane().add((Component)this.lblSummary, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(7, 5, 2, 5), 0, 0));
            this.txtSummary.setEditable(false);
            this.txtSummary.setLogicalStyle(StyleUtility.getPlainStyle());
            this.scrollSummary.setOpaque(true);
            this.scrollSummary.setToolTipText(msgStatusBundle.getString("scrollStatus_toolTipText").length() != 0 ? msgStatusBundle.getString("scrollStatus_toolTipText") : null);
            this.scrollSummary.setViewportView(this.txtSummary);
            this.getContentPane().add((Component)this.scrollSummary, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
        }
        this.btnClose.setText(msgStatusBundle.getString("btnClose_text"));
        this.btnClose.setMnemonic(msgStatusBundle.getString("btnClose_text_M").charAt(0));
        this.btnClose.setActionCommand(msgStatusBundle.getString("btnClose_actionCommand"));
        this.btnClose.setToolTipText(msgStatusBundle.getString("btnClose_toolTipText").length() != 0 ? msgStatusBundle.getString("btnClose_toolTipText") : null);
        this.pnlButtons.add(this.btnClose);
        this.btnHelp.setText(msgStatusBundle.getString("btnHelp_text"));
        this.btnHelp.setMnemonic(msgStatusBundle.getString("btnHelp_text_M").charAt(0));
        this.btnHelp.setActionCommand(msgStatusBundle.getString("btnHelp_actionCommand"));
        this.btnHelp.setToolTipText(msgStatusBundle.getString("btnHelp_toolTipText").length() != 0 ? msgStatusBundle.getString("btnHelp_toolTipText") : null);
        this.pnlButtons.add(this.btnHelp);
        this.pnlButtons.setToolTipText(msgStatusBundle.getString("pnlButtons_toolTipText").length() != 0 ? msgStatusBundle.getString("pnlButtons_toolTipText") : null);
        this.pnlButtons.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)this.pnlButtons, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 15, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.btnClose.addActionListener(this.lSymAction);
        this.btnHelp.addActionListener(this.lSymAction);
    }

    public void setSummaryText() {
        StringBuffer summary = new StringBuffer();
        for (int i = 0; i < this.answerList.size(); ++i) {
            String tmpStr = StringUtility.substitute((String)msgStatusBundle.getString("poll_summary_answer_"), (String)"__MACRO__", (String)((String)this.answerList.get(i)));
            tmpStr = StringUtility.substitute((String)tmpStr, (String)"__MACRO1__", (String)String.valueOf(this.answerStat[i]));
            summary.append(tmpStr);
            if (i == this.answerList.size() - 1) continue;
            summary.append(StringUtility.lineSeparator);
        }
        if (this.answerStat[this.answerList.size()] > 0) {
            summary.append(StringUtility.lineSeparator);
            summary.append(StringUtility.substitute((String)msgStatusBundle.getString("poll_summary_other_"), (String)"__MACRO__", (String)String.valueOf(this.answerStat[this.answerList.size()])));
        }
        this.txtSummary.setText(summary.toString());
    }

    private final void fillQMessageListStorage(Vector stat, Vector ids) {
        this.status = new String[stat.size()];
        stat.copyInto(this.status);
        for (int n = 0; n < ids.size(); ++n) {
            CollaborationPrincipal nu = (CollaborationPrincipal)ids.elementAt(n);
            if (this.IDs.contains(nu.getUID())) continue;
            this.IDs.addElement(nu.getUID());
            this.users.addElement(nu.getDisplayName());
        }
    }

    private final void fillQMessageList(Vector v) {
        this.status = new String[v.size()];
        this.status_values = new Integer[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            CollaborationPrincipal nu = (CollaborationPrincipal)v.elementAt(n);
            if (!this.IDs.contains(nu.getUID())) {
                this.IDs.addElement(nu.getUID());
                this.users.addElement(nu.getDisplayName());
                this.status[n] = ID_SENT;
                continue;
            }
            this.status[n] = "";
        }
    }

    private final void doInit() {
        this.addWindowListener(this.aSymWindow);
        this.setIconImage(SwingImageManager.getAppIcon(this).getImage());
        this.initTable();
        this.setVisible(true);
    }

    private void initTable() {
        this.msgModel = new MsgTableModel();
        this.tblStatus.setModel(this.msgModel);
        this.tblStatus.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
        this.tblStatus.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        this.tblStatus.setCellSelectionEnabled(false);
        this.tblStatus.setRowSelectionAllowed(true);
        this.tblStatus.getTableHeader().setReorderingAllowed(false);
        iIMUtility.setColumn(this.tblStatus, 0, true, 100, msgStatusBundle.getString("User"));
        iIMUtility.setColumn(this.tblStatus, 1, true, 470, msgStatusBundle.getString("Status"));
        this.tblStatus.setSelectionMode(0);
    }

    private final void updateSummary(String u) {
        boolean found = false;
        for (int i = 0; i < this.answerList.size(); ++i) {
            if (!((String)this.answerList.get(i)).equals(u)) continue;
            found = true;
            int n = i;
            this.answerStat[n] = this.answerStat[n] + 1;
        }
        if (!found) {
            int n = this.answerList.size();
            this.answerStat[n] = this.answerStat[n] + 1;
        }
        this.setSummaryText();
    }

    private final void setStatus(int n, String s) {
        if (n < 0) {
            return;
        }
        this.status[n] = s;
        this.msgModel.changed(n);
    }

    private final Message createStatusMsg(String type) {
        try {
            Message m = Manager._messageSession.createMessage();
            String[] d = this.message.getRecipients();
            for (int i = 0; i < d.length; ++i) {
                m.addRecipient(d[i]);
            }
            Hashtable<String, Object[]> ht = new Hashtable<String, Object[]>();
            ht.put(ID_STATUS, this.status);
            ht.put(ID_USERS, d);
            ht.put(ID_STATUS_VALUES, this.status_values);
            ClientMessageFactory.addHeaders(m, ht);
            ClientMessageFactory.addSubject(m, ClientMessageFactory.getSubject(this.message));
            ClientMessageFactory.addPart(m, type, "");
            return m;
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final void close() {
        this.setVisible(false);
        Random r1 = new Random();
        Random r = new Random(r1.nextLong());
        int x = r.nextInt();
        if (x < 0) {
            x *= -1;
        }
        ApplicationManager.removeActiveObject(this);
        this.btnClose.removeActionListener(this.lSymAction);
        this.btnHelp.removeActionListener(this.lSymAction);
        this.removeWindowListener(this.aSymWindow);
        this.dispose();
        iIM.GarbageCollect();
    }

    public final void setVisible(boolean b) {
        if (b) {
            this.setLocation(this.position);
        }
        super.setVisible(b);
    }

    public void onReply(Message m) {
        try {
            ClientMessageFactory.printMessage(m);
            if (m.getContentType().equalsIgnoreCase("application/x-iim-poll-reply")) {
                MessagePart[] parts = m.getParts();
                String ans = this.poll.parseAnswer(parts[0].getContent());
                Manager.Out("Answer is " + ans);
                StringBuffer tmp = new StringBuffer("<html><body>");
                tmp.append("<font size=\"2\"><b>");
                tmp.append(ans);
                tmp.append("</b></font>");
                tmp.append("</body></html>");
                this.setStatus(this.IDs.indexOf(StringUtility.removeResource((String)m.getOriginator())), tmp.toString());
                this.updateSummary(ans);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onReceipt(String destination, int deliveryStatus) {
        destination = StringUtility.removeResource((String)destination);
        SwingUtilities.invokeLater(new StatusChangeRunnable(destination, deliveryStatus));
        Manager.Out("Destination = " + destination + " deliverstatus = " + deliveryStatus);
        return true;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == MsgStatus.this.btnHelp) {
                HelpManager.showHelp("statusalert");
            } else if (object == MsgStatus.this.btnClose) {
                MsgStatus.this.close();
            }
        }
    }

    private class MsgTableModel
    extends AbstractTableModel {
        private MsgTableModel() {
        }

        public final int getRowCount() {
            return MsgStatus.this.users.size();
        }

        public final int getColumnCount() {
            return 2;
        }

        public final boolean isCellEditable(int row, int col) {
            return false;
        }

        public final Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return (String)MsgStatus.this.users.elementAt(row);
                }
                case 1: {
                    return MsgStatus.this.status[row];
                }
            }
            return null;
        }

        public final void changed(int r) {
            this.fireTableCellUpdated(r, 0);
            this.fireTableCellUpdated(r, 1);
        }
    }

    final class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MsgStatus.this) {
                MsgStatus.this.close();
            }
        }
    }

    final class StatusChangeRunnable
    implements Runnable {
        private String destination;
        private int deliveryStatus;

        public StatusChangeRunnable(String dest, int status) {
            this.destination = dest;
            this.deliveryStatus = status;
        }

        public void run() {
            int n = MsgStatus.this.IDs.indexOf(this.destination);
            ((MsgStatus)MsgStatus.this).status_values[n] = new Integer(this.deliveryStatus);
            switch (this.deliveryStatus) {
                case 1: {
                    MsgStatus.this.TALLY_RECEIVED++;
                    MsgStatus.this.setStatus(n, ID_RECEIVED);
                    break;
                }
                case 7: {
                    MsgStatus.this.TALLY_READ++;
                    MsgStatus.this.setStatus(n, ID_READ);
                    break;
                }
                case 4: {
                    MsgStatus.this.setStatus(n, StringUtility.substitute((String)ID_AWAY, (String)"__MACRO__", (String)"Forwarded"));
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    MsgStatus.this.setStatus(n, ID_OFFLINEFWD);
                    break;
                }
                case 2: 
                case 6: {
                    MsgStatus.this.setStatus(n, ID_UNKNOWN);
                    break;
                }
                default: {
                    MsgStatus.this.setStatus(n, ID_UNKNOWN);
                }
            }
        }
    }
}

