/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.FileStreaming;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.util.StringUtility;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MessagePanel
extends JScrollPane
implements HyperlinkListener {
    static SafeResourceBundle messagePanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    private static final String ID_UNKNOWN_MSG = messagePanelBundle.getString("UNKNOWN_MESSAGE_RECEIVED_FROM");
    public boolean IS_SCROLLING = false;
    public static int SCROLL_SLEEP_INTERVAL = 30;
    public static int SCROLL_STEP_RATE = 130;
    private boolean SCROLL_MSG = true;
    private JEditorPane txtMessage;
    public static Message currentMsg = null;
    private static JFrame parent = null;

    public MessagePanel() {
        this.setToolTipText(messagePanelBundle.getString("MessagePanel_toolTipText").length() != 0 ? messagePanelBundle.getString("MessagePanel_toolTipText") : null);
    }

    public MessagePanel(int v, int h) {
        super(v, h);
    }

    public void setParent(JFrame f) {
        parent = f;
    }

    public final void setView(JEditorPane txt) {
        txt.removeHyperlinkListener(this);
        this.txtMessage = txt;
        this.getViewport().add(this.txtMessage);
        this.txtMessage.addHyperlinkListener(this);
    }

    public final void close() {
        this.txtMessage.removeHyperlinkListener(this);
    }

    public final void addView(JEditorPane txt) {
        this.txtMessage = txt;
    }

    public final JEditorPane getView() {
        return this.txtMessage;
    }

    public final void resetView() {
        this.getViewport().add(this.txtMessage);
    }

    public final void hyperlinkUpdate(HyperlinkEvent evt) {
        this.handleHyperlinkUpdate(evt, currentMsg);
    }

    public final void handleHyperlinkUpdate(HyperlinkEvent evt, Message m) {
        URL url = evt.getURL();
        if (url == null || m == null) {
            return;
        }
        JEditorPane o = this.txtMessage;
        if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            o.setCursor(Cursor.getPredefinedCursor(12));
        } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
            o.setCursor(Cursor.getPredefinedCursor(0));
        } else if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Manager.openLink(url.toString(), "_blank");
        }
    }

    private JFrame getFrame() {
        if (parent != null) {
            return parent;
        }
        Container c = this.getParent();
        if (c instanceof JFrame) {
            return (JFrame)c;
        }
        if (c != null && (c = c.getParent()) instanceof Frame) {
            return (JFrame)c;
        }
        return null;
    }

    public final void resetScrollPosition() {
        this.getViewport().setViewPosition(new Point(0, 0));
    }

    public final void setScroll(boolean scroll) {
        this.SCROLL_MSG = scroll;
    }

    public final void doEffect() {
        this.IS_SCROLLING = true;
        JViewport view = this.getViewport();
        Rectangle rec = this.getBounds();
        view.setViewPosition(new Point(0 - rec.width, 0));
        Manager.worker.addRunnable((Runnable)new effectsRunnable(view, this.txtMessage, rec));
    }

    public static final void displayMessage(JEditorPane pane, Message m, boolean cache_img) {
        try {
            currentMsg = m;
            MessagePart[] parts = m.getParts();
            String type = m.getContentType();
            if ("text/html".equals(type)) {
                String body = ClientMessageFactory.getHTMLContent(parts[0]);
                String replace = m.getHeader("PATH");
                if (replace != null) {
                    String with = FileStreaming.getInstance().getDefaultDir().getAbsolutePath();
                    if (!with.endsWith(File.separator)) {
                        with = with + File.separator;
                    }
                    body = StringUtility.replaceString((String)replace, (String)with, (String)body);
                }
                MessagePanel.displayTextMessage(pane, body);
            } else {
                String tmp = parts[0].getContent();
                if (tmp.length() <= 0) {
                    return;
                }
                MessagePanel.displayTextMessage(pane, tmp);
            }
        }
        catch (CollaborationException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void displayTextMessage(JEditorPane editorPane, String body) {
        EditorUtility.insertDocumentText(0, body, editorPane, true);
    }

    private final class effectsRunnable
    implements Runnable {
        private JEditorPane pane;
        private JViewport view;
        private Rectangle rec;

        public effectsRunnable(JViewport view, JEditorPane pane, Rectangle rec) {
            this.pane = pane;
            this.view = view;
            this.rec = rec;
        }

        public void run() {
            int movy = 0;
            int movx = 0 - this.rec.width;
            Point p = new Point(movx, movy);
            while (movx < this.rec.width && (movx += SCROLL_STEP_RATE) <= 0) {
                p.x = movx;
                SwingUtilities.invokeLater(new scrollRunnable(this.view, p));
                try {
                    Thread.sleep(SCROLL_SLEEP_INTERVAL);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            p.y = movy;
            p.x = 0;
            SwingUtilities.invokeLater(new scrollRunnable(this.view, p));
            MessagePanel.this.IS_SCROLLING = false;
            Container c = MessagePanel.this.getParent();
            if (c != null) {
                c.repaint();
            }
        }
    }

    private final class scrollRunnable
    implements Runnable {
        private JViewport view;
        private Point p;

        public scrollRunnable(JViewport view, Point p) {
            this.p = p;
            this.view = view;
        }

        public void run() {
            this.view.setViewPosition(this.p);
        }
    }
}

