/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.HelpManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.AttachmentPanel;
import com.iplanet.im.client.swing.MessagePanel;
import com.iplanet.im.client.swing.dialogs.AddContact;
import com.iplanet.im.client.swing.iIMFrame;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.EditorUtility;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.SmartJPopupMenu;
import com.iplanet.im.client.util.StickyFileChooser;
import com.iplanet.im.client.util.SwingUtils;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.iplanet.im.client.util.iIMUtility;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Message;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.util.Worker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public final class InstantMessageBar
extends iIMFrame {
    static SafeResourceBundle instantMessageBarBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    static SafeResourceBundle communicatorBundle = new SafeResourceBundle("com.iplanet.im.client.swing.communicator.communicator");
    private JMenuItem miClose;
    private JMenuItem miForward;
    private JMenuItem miReply;
    private JMenuItem miAddContact;
    private JMenuItem miSaveAs;
    private JMenuItem miPrint;
    private JMenuItem miHelp;
    private JMenu mFile;
    private JMenu mTools;
    private JMenu mHelp;
    private JMenuBar menuBar;
    private SmartJPopupMenu popup;
    private Message _message;
    private JLabel lblFrom;
    private JLabel lblSubject;
    private AttachmentPanel attachments;
    private JEditorPane txtMessage;
    private boolean ALLOWNEWPOSITION = true;
    private int TYPE = -1;
    private MessagePanel scroller;
    private boolean messageRead = false;

    public InstantMessageBar(Message m, int type) {
        Manager.Out("DEBUG: InstantMessageBar.<init>: Starting");
        this._message = m;
        this.TYPE = type;
        String title = instantMessageBarBundle.getString("InstantMessageBar_title");
        this.setTitle(title);
        this.getAccessibleContext().setAccessibleDescription(title);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setVisible(false);
        this.initComponents();
        this.setVisible(true);
        this.initTitle();
        Manager.Out("DEBUG: InstantMessageBar.<init>: Terminating");
    }

    public final void windowOpened(WindowEvent e) {
        if (!iIMPropsUtil.getMinimizeAlerts(CurrentUserManager.getCurrentUserProperties()) && iIMPropsUtil.getAlertOnTopStatus(CurrentUserManager.getCurrentUserProperties()) && this.TYPE != 6) {
            this.setOnTop(true);
        }
    }

    public final void windowClosing(WindowEvent event) {
        this.dispose();
    }

    private final void initTitle() {
        if (this.TYPE == 1 || this.TYPE == 9) {
            this.toBack();
            String title = StringUtility.substitute((String)instantMessageBarBundle.getString("InstantMessageBar_Alert"), (String)"__MACRO__", (String)iIMUtility.getTimeStamp());
            this.setTitle(title);
            this.getAccessibleContext().setAccessibleDescription(title);
            this.startBlinkThread();
        } else {
            StringBuffer buf = new StringBuffer(instantMessageBarBundle.getString("InstantMessageBar_StringBuffer_buf___new_StringBuffer"));
            this.setTitle(buf.toString());
            this.getAccessibleContext().setAccessibleDescription(buf.toString());
        }
    }

    private final void sendReply() {
        if (this.TYPE == 6) {
            return;
        }
        CollaborationPrincipal[] tmp = new CollaborationPrincipal[]{UserCache.getPrincipal(this._message.getOriginator())};
        iIM.startNewChat(tmp);
    }

    private final void initComponents() {
        this.txtMessage = new JEditorPane();
        this.lblFrom = new JLabel();
        this.lblSubject = new JLabel();
        this.attachments = new AttachmentPanel(this);
        this.miClose = SwingUtils.menuItem(this, instantMessageBarBundle, "InstantMessageBar_miClose___new_JMenuItem", "InstantMessageBar_miClose___new_JMenuItem_M", null);
        this.miForward = SwingUtils.menuItem(this, instantMessageBarBundle, "InstantMessageBar_miForward___new_JMenuItem", "InstantMessageBar_miForward___new_JMenuItem_M", null);
        this.miReply = SwingUtils.menuItem(null, instantMessageBarBundle, "InstantMessageBar_miReply___new_JMenuItem", "InstantMessageBar_miReply___new_JMenuItem_M", null);
        this.miAddContact = SwingUtils.menuItem(this, instantMessageBarBundle, "InstantMessageBar_miAddContact_text", "InstantMessageBar_miAddContact_text_M", null);
        this.miSaveAs = SwingUtils.menuItem(this, instantMessageBarBundle, "InstantMessageBar_miSave___new_JMenuItem", "InstantMessageBar_miSave___new_JMenuItem_M", null);
        this.miPrint = SwingUtils.menuItem(this, instantMessageBarBundle, "InstantMessageBar_miPrint___new_JMenuItem", "InstantMessageBar_miPrint___new_JMenuItem_M", null);
        this.miHelp = SwingUtils.menuItem(this, instantMessageBarBundle, "InstantMessageBar_miHelp___new_JMenuItem", "InstantMessageBar_miHelp___new_JMenuItem_M", null);
        this.setLocation(iIMPropsUtil.getAlertWindowPoint(CurrentUserManager.getCurrentUserProperties()));
        this.txtMessage.setContentType("text/html");
        this.txtMessage.setEditable(false);
        String from = this._message.getOriginator() == null ? "" : UserCache.getDisplayName(this._message.getOriginator());
        this.lblFrom.setText(StringUtility.substitute((String)instantMessageBarBundle.getString("fromHeader_"), (String)"__MACRO__", (String)from));
        this.getContentPane().add((Component)this.lblFrom, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 5), 0, 0));
        this.lblSubject.setText(StringUtility.substitute((String)instantMessageBarBundle.getString("subjectHeader_"), (String)"__MACRO__", (String)ClientMessageFactory.getSubject(this._message)));
        this.getContentPane().add((Component)this.lblSubject, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 2, 5), 0, 0));
        this.scroller = new MessagePanel(20, 30);
        this.scroller.setView(this.txtMessage);
        this.scroller.setOpaque(true);
        MessagePanel.currentMsg = this._message;
        this.scroller.setParent(this);
        MessagePanel.displayMessage(this.txtMessage, this._message, this.TYPE != 6);
        this.getContentPane().add((Component)this.scroller, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.attachments.updateAttachmentPanelForMessage(this._message);
        if (this.attachments.attachmentsPresent() && Manager.ALLOW_ATTACHMENTS) {
            this.getContentPane().add((Component)this.attachments.getAttachmentPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 15, 1, new Insets(2, 2, 2, 2), 0, 0));
            this.setSize(new Dimension(510, 270));
        } else {
            this.setSize(new Dimension(530, 200));
        }
        this.createMenuBar();
        this.toFront(true);
        if (this.TYPE != 9) {
            ClientMessageFactory.markMessage(this._message, 1);
        }
    }

    private final void createMenuBar() {
        this.mFile = new JMenu(instantMessageBarBundle.getString("menuTitle_File"));
        this.mFile.setMnemonic(instantMessageBarBundle.getString("menuTitle_File_M").charAt(0));
        this.mTools = new JMenu(instantMessageBarBundle.getString("menuTitle_Tools"));
        this.mTools.setMnemonic(instantMessageBarBundle.getString("menuTitle_Tools_M").charAt(0));
        this.mHelp = new JMenu(instantMessageBarBundle.getString("menuTitle_Help"));
        this.mHelp.setMnemonic(instantMessageBarBundle.getString("menuTitle_Help_M").charAt(0));
        this.mFile.add(this.miSaveAs);
        this.mFile.add(this.miPrint);
        this.mFile.addSeparator();
        this.mFile.add(this.miClose);
        if (Manager.ALLOW_CHAT && this.TYPE != 9) {
            this.mTools.add(this.miReply);
            this.miReply.addActionListener(this);
            this.miReply.setVisible(true);
        } else {
            this.miReply.setEnabled(false);
        }
        if (Manager.ALLOW_SEND_ALERTS) {
            this.mTools.add(this.miForward);
        } else {
            this.miForward.setEnabled(false);
        }
        if (Manager.ALLOW_CONTACT_MANAGEMENT && this.TYPE != 9) {
            this.mTools.addSeparator();
            this.mTools.add(this.miAddContact);
        } else {
            this.miAddContact.setEnabled(false);
        }
        this.mHelp.add(this.miHelp);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.mFile);
        this.menuBar.add(this.mTools);
        this.menuBar.add(this.mHelp);
        this.setJMenuBar(this.menuBar);
    }

    private final void forwardMsg() {
        Manager.Out("  DEBUG IMBAR: forwardMsg()");
        if (!UserAccessControl.canSendAlerts()) {
            JOptionPane.showMessageDialog(this, iIM.ID_NO_PRIVILEGE);
            return;
        }
        this.toBack();
        iIM.AddMsg(this._message);
    }

    private final void removeMenu() {
        this.miSaveAs.removeActionListener(this);
        if (Manager.ALLOW_CHAT) {
            this.miReply.removeActionListener(this);
        }
        this.miClose.removeActionListener(this);
        if (Manager.ALLOW_SEND_ALERTS) {
            this.miForward.removeActionListener(this);
        }
        this.miAddContact.removeActionListener(this);
        this.miPrint.removeActionListener(this);
        this.miHelp.removeActionListener(this);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private final void removeListeners() {
        this.removeMenu();
    }

    public final void dispose() {
        this.markRead();
        this.removeListeners();
        this.attachments.dispose();
        this.setVisible(false);
        this.txtMessage = null;
        this.scroller = null;
        this.removeAll();
        this._message = null;
        super.dispose();
    }

    private final void markRead() {
        this.setOnTop(false);
        this.setFrameBlinking(false);
        if (this.TYPE == 6 || this.TYPE == 9) {
            return;
        }
        if (!this.messageRead) {
            ClientMessageFactory.markMessage(this._message, 7);
            this.messageRead = true;
        }
    }

    private final void showProperties() {
        Manager.Out("   DEBUG IMBAR: show props");
        iIMUtility.showMessageProperties(this._message);
    }

    private final void saveMessage() {
        File f = StickyFileChooser.chooseSaveFile(this, this._message.getHeader("subject"), ".html", instantMessageBarBundle.getString("HTML_Files"));
        if (f == null) {
            return;
        }
        FileUtility.save((File)f, (String)EditorUtility.getHtmlDocumentText(this.txtMessage), (Worker)Manager.worker);
    }

    private final void viewSource() {
        EditorUtility.viewSource(EditorUtility.getHtmlDocumentText(this.txtMessage), instantMessageBarBundle.getString("Source"));
    }

    public final void actionPerformed(ActionEvent event) {
        this.setOnTop(false);
        Object o = event.getSource();
        if (o == this.miReply) {
            this.sendReply();
        } else if (o == this.miSaveAs) {
            this.saveMessage();
        } else if (o == this.miClose) {
            this.dispose();
        } else if (o == this.miForward) {
            this.forwardMsg();
        } else if (o == this.miAddContact) {
            this.addSenderToContactList();
        } else if (o == this.miPrint) {
            iIMUtility.printDoc(this, this._message.getHeader("subject"), this.txtMessage);
        } else if (o == this.miHelp) {
            HelpManager.showHelp("receivealert");
        }
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        this.markRead();
    }

    private void addSenderToContactList() {
        Object[] users = new CollaborationPrincipal[]{UserCache.getPrincipal(this._message.getOriginator())};
        Vector uv = Manager.getVectorFromArray(users);
        AddContact addContactDialog = new AddContact((Frame)this, uv, false);
        addContactDialog.setModal(true);
        addContactDialog.setVisible(true);
    }
}

