/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.Client;
import com.iplanet.im.client.swing.ContentStreamListenerImpl;
import com.iplanet.im.client.swing.MessageBoxListenerImpl;
import com.iplanet.im.client.swing.dialogs.MessageBox;
import com.iplanet.im.client.swing.iIMFrame;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.ContentStream;
import com.sun.im.service.ContentStreamListener;
import com.sun.im.service.Message;
import com.sun.im.service.ReceiverFileStreamingProfile;
import com.sun.im.service.ReceiverStreamingProfile;
import com.sun.im.service.StreamingServiceListener;
import com.sun.im.service.util.FileUtility;
import com.sun.im.service.util.StringUtility;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;

public class FileStreaming
implements StreamingServiceListener {
    private static FileStreaming _fs = null;
    private File _defaultDir;
    private Hashtable _alertMessages = new Hashtable();
    private List _badFiles = new ArrayList();
    private List _activeStreams = new LinkedList();
    public static SafeResourceBundle bundle = Chat.chatPanelBundle;
    public static long CLEANUP_PERIOD = 120000L;

    private FileStreaming() {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            public void run() {
                FileStreaming.this.cleanQueuedAlertMessages();
            }
        }, 0L, CLEANUP_PERIOD);
    }

    public static FileStreaming getInstance() {
        if (_fs == null) {
            _fs = new FileStreaming();
        }
        return _fs;
    }

    public static void reset() {
        _fs = null;
    }

    public void setDefaultFileStorageDir(File dir) {
        try {
            this._defaultDir = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this._defaultDir = dir;
        }
        if (!this._defaultDir.exists()) {
            this._defaultDir.mkdirs();
        }
    }

    public File getFile(String fileName) {
        return new File(this._defaultDir, fileName);
    }

    public File getDefaultDir() {
        return this._defaultDir;
    }

    public void onContentStream(String sender, ReceiverStreamingProfile profile, ContentStream stream) {
        Manager.debug("Received a request for streaming.");
        try {
            if (profile instanceof ReceiverFileStreamingProfile) {
                String name = ((ReceiverFileStreamingProfile)profile).getName();
                this._activeStreams.add(name);
                File f = new File(this._defaultDir, name);
                if (f.exists()) {
                    f = FileUtility.getNewFile((File)this._defaultDir, (String)name);
                    name = f.getName();
                }
                f.deleteOnExit();
                ((ReceiverFileStreamingProfile)profile).addOutput(f);
                ContentStreamListenerImpl listener = new ContentStreamListenerImpl((ReceiverFileStreamingProfile)profile, sender, name);
                String[] availableMethods = stream.getSupportedMethods();
                String preferredMethod = availableMethods[0];
                if (StringUtility.contains((String[])availableMethods, (String)"http://jabber.org/protocol/ibb")) {
                    preferredMethod = "http://jabber.org/protocol/ibb";
                } else if (StringUtility.contains((String[])availableMethods, (String)"jabber:iq:oob")) {
                    preferredMethod = "jabber:iq:oob";
                }
                stream.accept(preferredMethod, profile, (ContentStreamListener)listener);
            } else {
                Manager.debug("Cannot understand profile. Rejecting it");
                stream.reject("bad-profile");
            }
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public void closed(ReceiverFileStreamingProfile profile, String sender, String name, int status, String reason) {
        Message m = null;
        this._activeStreams.remove(profile.getName());
        Iterator itr = this._alertMessages.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            List list = (List)entry.getValue();
            if (!list.remove(profile.getName())) continue;
            if (status != 0) {
                this._badFiles.add(name);
            } else {
                try {
                    if (profile.checkIntegrity() == 1) {
                        this._badFiles.add(name);
                    }
                }
                catch (IllegalStateException e) {
                    this._badFiles.add(name);
                }
                m = (Message)entry.getKey();
                if (!name.equals(profile.getName())) {
                    ClientMessageFactory.changeAttachmentName(m, profile.getName(), name);
                }
                if (list.size() == 0) {
                    this._alertMessages.remove(m);
                    Client.handleAlertMsg(m);
                    return;
                }
            }
            return;
        }
        iIMFrame frame = iIM.getBuddyList().getCommunicator();
        if (frame == null) {
            frame = iIM.getTopics().getTopicView();
        }
        if (!this._badFiles.contains(name)) {
            this.handleReceivedFile(frame, sender, this.getFile(name));
        }
    }

    public void queueAlertMessage(Message message, List list) {
        this._alertMessages.put(message, list);
    }

    private void cleanQueuedAlertMessages() {
        Iterator msgItr = this._alertMessages.entrySet().iterator();
        block0: while (msgItr.hasNext()) {
            Map.Entry entry = msgItr.next();
            List list = (List)entry.getValue();
            Iterator listItr = list.iterator();
            while (listItr.hasNext()) {
                if (!this._activeStreams.contains(listItr.next())) continue;
                continue block0;
            }
            Message m = (Message)entry.getKey();
            Manager.Out("Removing message from the alert queue");
            this._alertMessages.remove(m);
            Client.handleAlertMsg(m);
        }
    }

    public boolean isBadFile(String name) {
        return this._badFiles.contains(name);
    }

    public void handleReceivedFile(JFrame frame, String sender, File file) {
        String name = UserCache.getDisplayName(sender);
        String msg = StringUtility.substitute((String)bundle.getString("You_have_been_sent_the_file"), (String)"__MACRO__", (String)name);
        String title = StringUtility.substitute((String)bundle.getString("Received_a_file_from_"), (String)"__MACRO__", (String)name);
        String save = bundle.getString("Save");
        String ignore = bundle.getString("Ignore");
        String open = bundle.getString("Open");
        MessageBox mb = null;
        frame.toFront();
        Point p = frame.getLocation();
        MessageBoxListenerImpl msgBoxListener = new MessageBoxListenerImpl(frame, file);
        mb = Manager.isFileLaunchable(file.getName()) ? new MessageBox((Frame)frame, p, title, StringUtility.substitute((String)msg, (String)"__MACRO1__", (String)file.getName()), open, save, ignore, true, msgBoxListener) : new MessageBox((Frame)frame, p, title, StringUtility.substitute((String)msg, (String)"__MACRO1__", (String)file.getName()), null, save, ignore, true, msgBoxListener);
    }
}

