/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.Sound;
import com.iplanet.im.client.iIM;
import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.BuddyListManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.MBeanManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.manager.RoomManager;
import com.iplanet.im.client.manager.ScriptManager;
import com.iplanet.im.client.manager.ServerGroupManager;
import com.iplanet.im.client.manager.StorageManager;
import com.iplanet.im.client.manager.UserAccessControl;
import com.iplanet.im.client.manager.UserCache;
import com.iplanet.im.client.manager.UserInfo;
import com.iplanet.im.client.manager.UserStatusManager;
import com.iplanet.im.client.swing.Alert;
import com.iplanet.im.client.swing.Chat;
import com.iplanet.im.client.swing.FileStreaming;
import com.iplanet.im.client.swing.Poll;
import com.iplanet.im.client.swing.Topics;
import com.iplanet.im.client.swing.communicator.Communicator;
import com.iplanet.im.client.swing.config.DestinationAdmin;
import com.iplanet.im.client.swing.config.Settings;
import com.iplanet.im.client.swing.dialogs.MessageBox;
import com.iplanet.im.client.swing.login.DefaultLoginDialog;
import com.iplanet.im.client.util.ClientMessageFactory;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.desktop.MessengerAppContext;
import com.sun.im.desktop.MessengerException;
import com.sun.im.desktop.MessengerMessageListener;
import com.sun.im.desktop.util.MNamingContext;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceServiceListener;
import com.sun.im.service.ConflictException;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.Message;
import com.sun.im.service.NotificationServiceListener;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalStoreEvent;
import com.sun.im.service.PersonalStoreServiceListener;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceServiceListener;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.StreamingServiceListener;
import com.sun.im.service.util.StringUtility;
import java.awt.Cursor;
import java.awt.Point;
import java.io.File;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Client
extends MessengerAppContext
implements SecureSessionListener,
ConferenceServiceListener,
NotificationServiceListener,
PresenceServiceListener,
PersonalStoreServiceListener {
    static SafeResourceBundle clientBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    static SafeResourceBundle iIMBundle = new SafeResourceBundle("com.iplanet.im.client.client");
    public static boolean _ssl_connection = false;
    private DefaultLoginDialog parent;
    public static boolean RELOAD_MANAGERS = false;
    public static boolean RELOGIN_THREAD_RUNNING = false;
    private boolean IMMEDIATE_STOP = false;
    public static int RELOGIN_ATTEMPTS = 0;
    private static final int RELOGIN_COUNT = 12;
    private static Settings userSettings = null;
    DestinationAdmin dManageConfAdmin = null;
    DestinationAdmin dManageNewsAdmin = null;

    public Client(DefaultLoginDialog d) {
        this.parent = d;
        Manager.Out("DEBUG: Client.<init>: Client Loaded");
        try {
            MNamingContext.bind((String)"mbean.appcontext", (Object)((Object)this));
            MessengerAppContext ac = MessengerAppContext.getAppContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init() {
        Manager.Out("DEBUG: Client.init()");
        if (RELOAD_MANAGERS) {
            Manager.reloadManager();
            RELOAD_MANAGERS = false;
        } else if (!ScriptManager.LOADED && !Manager._is_applet) {
            File f = new File(StorageManager.USER_CACHE, "scripts");
            ScriptManager.loadScriptProperties(new File(f, "scripts.txt"));
        }
        Manager.Out("\n\n" + CurrentUserManager.getCurrentUserProperties());
        Sound.initSound();
        MBeanManager.load();
        iIMPropsUtil.setFirstTimeIn(CurrentUserManager.getCurrentUserProperties(), false);
        StorageManager.clearCache();
    }

    public void showViews(int flavor) {
        this.openNetlertViews(flavor);
    }

    public void stop() {
        this.IMMEDIATE_STOP = true;
        RELOGIN_THREAD_RUNNING = false;
    }

    public DefaultLoginDialog getParent() {
        return this.parent;
    }

    public final void reLogOn() {
        this.close();
        if (Manager._is_portal_env) {
            iIM.startLogon(true);
        } else {
            iIM.startLogon(false);
        }
    }

    public void close() {
        if (iIMPropsUtil.getCacheDeleteTime(Manager.userSettings) < 0) {
            StorageManager.initStorage(this.getUserId());
        }
        if (iIM._buddylist != null) {
            iIM._buddylist.removeTrayIcon();
        }
        Manager.saveAllPropertiesToServer(false, true);
        ApplicationManager.close();
        Manager._session.logout();
        RELOAD_MANAGERS = false;
        Manager.clearCache();
    }

    private void initStreamingService() throws CollaborationException {
        FileStreaming.reset();
        FileStreaming fs = FileStreaming.getInstance();
        Manager._streamingService.initialize((StreamingServiceListener)fs);
        File dir = new File(StorageManager.USER_CACHE);
        fs.setDefaultFileStorageDir(dir);
    }

    private final void openNetlertViews(int flavor) {
        block17: {
            try {
                Manager.Out("SETTING THE SESSION LISTENER ");
                Manager._session.setSessionListener((CollaborationSessionListener)this);
                Manager._presenceSession.initialize((PresenceServiceListener)this);
                Manager._personalStoreSession.initialize((PersonalStoreServiceListener)this);
                Manager._messageSession.initialize((NotificationServiceListener)this);
                Manager._conferenceSession.initialize((ConferenceServiceListener)this);
                this.initStreamingService();
                Properties p = CurrentUserManager.getCurrentUserProperties();
                if ((Manager.ALLOW_PRESENCE_ACCESS || Manager.ALLOW_ROOM_ACCESS) && iIMPropsUtil.getShowBuddyWin(p)) {
                    iIM.showBuddyList(false);
                }
                if (Manager.ALLOW_NEWS_ACCESS && iIMPropsUtil.isShowTopicEnabled(p)) {
                    iIM.showTopicView();
                }
                this.parent.setVisible(false);
                if (iIM._buddylist != null && iIM._buddylist.getCommunicator() != null) {
                    Communicator com = iIM._buddylist.getCommunicator();
                    if (Manager.ALLOW_CHAT) {
                        if (RoomManager.getAutoJoin().size() > 0) {
                            RoomManager.refreshRooms();
                        }
                        Iterator i = RoomManager.getAutoJoin().iterator();
                        while (i.hasNext()) {
                            String uid = (String)i.next();
                            Conference c = Manager._conferenceSession.getPublicConference(uid);
                            if (c != null) {
                                iIM.enterRoom(c);
                                continue;
                            }
                            System.out.println("Room " + uid + " cannot be auto-joined - not found");
                        }
                        i = RoomManager.getAutoInvite().iterator();
                        while (i.hasNext()) {
                            List l = (List)i.next();
                            CollaborationPrincipal[] u = new CollaborationPrincipal[l.size()];
                            int k = 0;
                            Iterator j = l.iterator();
                            while (j.hasNext()) {
                                u[k++] = UserCache.getPrincipal((String)j.next());
                            }
                            iIM.startNewChat(u);
                        }
                        RoomManager.getAutoInvite().clear();
                    }
                    String plist = null;
                    try {
                        plist = UserAccessControl.getDefaultPrivacyList();
                    }
                    catch (CollaborationException ce) {
                        Manager.Out((Object)ce);
                    }
                    if (plist != null && plist.equals(UserAccessControl.localizedInvisibleToAll)) {
                        UserInfo ui;
                        UserInfo.ResourceInfo ri;
                        SafeResourceBundle communicatorBundle = com.getCommBundle();
                        UserStatusManager.setCurrentUserStatusToServerNow(CurrentUserManager.getCurrentUserID(), "OPEN", communicatorBundle.getString("Online"));
                        if (!UserAccessControl.isActivePrivacyList(UserAccessControl.localizedInvisibleToAll)) {
                            UserAccessControl.setActivePrivacyList(UserAccessControl.localizedInvisibleToAll);
                        }
                        if ((ri = (ui = UserStatusManager.getUserInfoObject(CurrentUserManager.getCurrentUserID())).getResourceInfo(CurrentUserManager.getCurrUsrUIDWithResource())) != null) {
                            UserStatusManager.setCurrUsersPrevResourceInfo(ri);
                        }
                        ImageIcon icon = UserStatusManager.getIcon("CLOSED", (Object)this);
                        com.setCurrentStatus("Invisible", communicatorBundle.getString("mi_status_invisibleMenuItem"), icon, false);
                    } else {
                        com.sendInitialOnlinePresence();
                    }
                    break block17;
                }
                UserStatusManager.setCurrentUserStatusToServerNow(CurrentUserManager.getCurrUsrUIDWithResource(), "OPEN", null);
            }
            catch (CollaborationException e) {
                Manager.Out("Exception e:" + (Object)((Object)e));
                e.printStackTrace();
            }
        }
    }

    public static final boolean isConnected() {
        if (RELOGIN_THREAD_RUNNING) {
            RELOGIN_ATTEMPTS = 1000;
            return false;
        }
        return true;
    }

    public final void openUserAdmin() {
    }

    public final void openDestinationAdmin(JFrame parentComp, int type) {
        if (DestinationAdmin.getNumInstances(type) > 1) {
            this.dManageNewsAdmin.setLocationRelativeTo(parentComp);
            this.dManageNewsAdmin.setVisible(true);
            this.dManageNewsAdmin.setState(0);
            this.dManageNewsAdmin.toFront();
        } else {
            this.dManageNewsAdmin = new DestinationAdmin(parentComp, ServerGroupManager.getServerList(), type);
            this.dManageNewsAdmin.setLocationRelativeTo(parentComp);
            this.dManageNewsAdmin.setVisible(true);
        }
    }

    public final void openDestinationAdmin(JFrame parentComp, int type, Conference selectedRoom) {
        if (DestinationAdmin.getNumInstances(type) > 1) {
            this.dManageConfAdmin.setLocationRelativeTo(parentComp);
            this.dManageConfAdmin.setVisible(true);
            this.dManageConfAdmin.setState(0);
            this.dManageConfAdmin.toFront();
        } else {
            this.dManageConfAdmin = new DestinationAdmin(parentComp, ServerGroupManager.getServerList(), type, selectedRoom);
            this.dManageConfAdmin.setLocationRelativeTo(parentComp);
            this.dManageConfAdmin.setVisible(true);
        }
    }

    public static final void showSettings(String value) {
        Client.showSettings(CurrentUserManager.getCurrentPrincipal(), value);
    }

    public static final void showSettings(CollaborationPrincipal user, String value) {
        Manager.Out("DEBUG: Client.showSettings()", true);
        if (Settings.isSettingsViewOpen()) {
            if (userSettings != null) {
                userSettings.toFront();
                return;
            }
        } else if (userSettings != null) {
            userSettings.close();
            userSettings = null;
        }
        try {
            userSettings = new Settings(Manager._personalStoreSession.getProfile(user), value);
            userSettings.setLocation(iIMPropsUtil.getConfigWindowPoint(CurrentUserManager.getCurrentUserProperties()));
            ApplicationManager.refreshFrame(userSettings, false, true);
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
    }

    public static final void handleAlertMsg(Message m) {
        Alert.handleAlertMsg(m);
        Topics.handleAlertMsg(m);
    }

    private static final void handleModeratedChatMsg(Message m) {
        try {
            iIM._chat.attachModeratedMessageToConference(m);
        }
        catch (CollaborationException e) {
            Manager.Out("Exception e:" + (Object)((Object)e));
        }
    }

    private static final void handleReloadMsg(Message m) {
        Manager.Out("   DEBUG: ****Getting Reload Msg");
    }

    private static final void handleUserStatusChange(String uid, String status, String reason, float priority) {
        if (uid.equals(CurrentUserManager.getCurrUsrUIDWithResource())) {
            return;
        }
        String id = StringUtility.removeResource((String)uid);
        Manager.Out("uid <" + id + "> status <" + status + "> reason <" + reason + ">");
        UserStatusManager.storeUserStatus(uid, status, reason, priority);
        if (iIM._buddylist == null || iIM._buddylist.getCommunicator() == null) {
            return;
        }
        iIM._buddylist.getCommunicator().handleUserStatusChange(id, status, reason);
    }

    private static final void handleOnSubscribeRequest(Presence p) {
        Manager.Out("Received a onSubcription request");
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        if (pt.getContact().startsWith(CurrentUserManager.getCurrentUserID())) {
            return;
        }
        if (iIM._buddylist == null || iIM._buddylist.getCommunicator() == null) {
            return;
        }
        iIM._buddylist.getCommunicator().handleOnSubscribeRequest(p);
    }

    public String getUserId() {
        return CurrentUserManager.getCurrentUserID();
    }

    public String getProperty(String name) {
        Manager.Out("\n   DEBUG:query parameter " + name);
        String val = CurrentUserManager.getAttribute(name);
        if (val != null) {
            return val;
        }
        val = Manager.getParameter(name, null);
        if (val != null) {
            return val;
        }
        val = CurrentUserManager.getCurrentUserProperties().getProperty(name);
        return val;
    }

    public void showURL(String url, String target) throws MessengerException {
        Manager.openLink(url, target);
    }

    public void setUserPreference(String prefix, String name, String value) throws MessengerException {
        Properties p = CurrentUserManager.getCurrentUserProperties();
        p.put(prefix + "." + name, value);
    }

    public String getUserPreference(String prefix, String name, String defaultValue) throws MessengerException {
        Properties p = CurrentUserManager.getCurrentUserProperties();
        String s = p.getProperty(prefix + "." + name);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public void addMessageListener(String contentType, MessengerMessageListener listener) throws MessengerException {
        MBeanManager.addMessageListener(contentType, listener);
    }

    public void addMessageListener(MessengerMessageListener listener) throws MessengerException {
        MBeanManager.addMessageListener(listener);
    }

    public void onPresenceInfo(String presenceInfo) {
        Manager.Out(" on presence info called :" + presenceInfo);
    }

    public void onCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onX509Certificate(X509Certificate[] chain) {
        LinkedList<BigInteger> trustedCerts = new LinkedList<BigInteger>();
        SafeResourceBundle defaultLoginDialogBundle = new SafeResourceBundle("com.iplanet.im.client.swing.login.login");
        boolean trust = false;
        BigInteger sn = null;
        if (chain.length > 0 && trustedCerts.contains(sn = chain[0].getSerialNumber())) {
            return true;
        }
        try {
            StringBuffer chainS = new StringBuffer();
            chainS.append(defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_certificate_alert"));
            chainS.append(StringUtility.lineSeparator);
            chainS.append("-------------" + StringUtility.lineSeparator);
            SimpleDateFormat dfmt = new SimpleDateFormat();
            for (int i = 0; i < chain.length; ++i) {
                chainS.append(StringUtility.substitute((String)defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_issuer_dn"), (String)"__MACRO__", (String)((Object)chain[i].getIssuerDN()).toString()));
                chainS.append(StringUtility.lineSeparator);
                chainS.append(StringUtility.substitute((String)defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_subject_dn"), (String)"__MACRO__", (String)((Object)chain[i].getSubjectDN()).toString()));
                chainS.append(StringUtility.lineSeparator);
                String validity = defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_validity");
                validity = StringUtility.substitute((String)validity, (String)"__BEGIN__", (String)dfmt.format(chain[i].getNotBefore()));
                validity = StringUtility.substitute((String)validity, (String)"__END__", (String)dfmt.format(chain[i].getNotAfter()));
                chainS.append(validity + StringUtility.lineSeparator);
                chainS.append("-------------" + StringUtility.lineSeparator);
            }
            chainS.append(defaultLoginDialogBundle.getString("DefaultLoginDialog_ssl_do_you_trust"));
            int choice = 1;
            choice = JOptionPane.showConfirmDialog(this.parent, chainS.toString(), defaultLoginDialogBundle.getString("SSL_Status"), 2, 0);
            boolean bl = trust = choice == 0;
            if (trust && sn != null) {
                trustedCerts.add(sn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.parent.setCursor(Cursor.getPredefinedCursor(0));
        }
        return trust;
    }

    public void onError(CollaborationException e) {
        Manager.Out("\n\n\n\n.... Connection Lost .... ", true);
        try {
            iIM.connectionLost();
        }
        catch (Exception ex) {
            System.out.println("onError listener invoked" + ex);
        }
        Thread t = new Thread(new ConnectionLostThread(e instanceof ConflictException));
        t.start();
    }

    public void onInvite(Conference conference, InviteMessage message) {
        Chat.handleInviteMsg(conference, message);
    }

    public void onMessage(Message message) {
        ClientMessageFactory.printMessage(message);
        String type = message.getContentType();
        Manager.Out("Message received: content-type=" + type + " from=" + message.getOriginator());
        MBeanManager.processMessage((ReadOnlyMessage)message);
        if (type == null || type.equals("text/plain") || type.equals("text/html")) {
            List list = ClientMessageFactory.getAttachmentList(message);
            if (list == null || list.size() == 0) {
                Client.handleAlertMsg(message);
            } else {
                FileStreaming.getInstance().queueAlertMessage(message, list);
            }
        } else if (type.equals("application/x-iim-poll")) {
            Poll.handlePollMsg(message);
        } else if (type.equals("application/x-iim-poll-reply")) {
            Poll.handlePollMsgReply(message);
        } else if (type.equals("application/x-iim-moderated")) {
            Client.handleModeratedChatMsg(message);
        } else if (type.equals("application/x-iim-url")) {
            Client.handleAlertMsg(message);
        } else {
            Manager.Out(" *** RECEIVED MSG OF UNKNOWN TYPE " + message.getContentType());
        }
    }

    public void onPresence(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        Client.handleUserStatusChange(pt.getContact(), pt.getStatus(), pt.getNote(), pt.getPriority());
    }

    public void onPresenceNotify(String presentityURL, String presenceInfo, Date expires) {
    }

    public void onSubscribeRequest(Presence p) {
        Manager.Out("Subscribe request called");
        Client.handleOnSubscribeRequest(p);
    }

    public void onSubscribed(Presence p) {
    }

    public void onUnsubscribed(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        String uid = StringUtility.removeResource((String)pt.getContact());
        UserInfo ui = UserStatusManager.getUserInfoObject(uid);
        Communicator c = null;
        if (iIM._buddylist != null) {
            c = iIM._buddylist.getCommunicator();
        }
        if (ui != null) {
            if (ui.isPending() && c != null) {
                iIM._buddylist.getCommunicator().showAccessDenied(pt.getContact());
            } else if (UserStatusManager.isUserSetForAlertAny(uid)) {
                ui.cleanResources();
                Client.handleUserStatusChange(uid, "CLOSED", "", 1.0f);
            }
            UserStatusManager.removeUserInfoObject(uid);
            if (c != null) {
                c.notifyContactInfoChanged(uid);
            }
        }
        Manager.debug("onUnsubscribed called: " + uid);
    }

    public void onUnsubscribe(Presence p) {
        Object[] o = p.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        try {
            PersonalContact contact = (PersonalContact)Manager._personalStoreSession.getEntry("contact", pt.getContact());
            if (contact != null && contact.getInboundSubscriptionStatus() == 0) {
                contact.remove();
                contact.save();
            }
        }
        catch (CollaborationException e) {
            Manager.warning("Unable to remove contact " + (Object)((Object)e));
        }
    }

    public void displayAlert(String originator, String subject, String content) {
        this.displayAlert(originator, subject, content, 1);
    }

    public void displayBotAlert(String originator, String subject, String content) {
        this.displayAlert(originator, subject, content, 9);
    }

    private void displayAlert(String originator, String subject, String content, int type) {
        Message m = null;
        try {
            m = Manager._messageSession.createMessage();
            m.setOriginator(originator);
            m.addRecipient(CurrentUserManager.getCurrentUserID());
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            Manager.error("Unable to display Alert");
            return;
        }
        ClientMessageFactory.updateMessage(m, content, "text/plain", subject);
        Alert.handleAlertMsg(m, type);
    }

    public void onEvent(PersonalStoreEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    BuddyListManager.clear();
                    BuddyListManager.loadBuddyListNow();
                    BuddyListManager.loadGateways();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iIM.updateBuddyList(false);
            }
        });
    }

    class ConnectionLostThread
    implements Runnable {
        boolean duplicate = false;

        public ConnectionLostThread(boolean b) {
            this.duplicate = b;
        }

        public void run() {
            RELOGIN_ATTEMPTS = 0;
            RELOGIN_THREAD_RUNNING = true;
            RELOAD_MANAGERS = true;
            while (RELOGIN_THREAD_RUNNING) {
                String msg;
                if (RELOGIN_ATTEMPTS <= 12) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (Client.this.IMMEDIATE_STOP) break;
                UserInfo info = UserStatusManager.getUserInfoObject(CurrentUserManager.getCurrentUserID());
                System.out.println("INFO IS " + info);
                if (this.duplicate) {
                    System.out.println(" *********************** DUPLICATE DETECTED");
                    RELOGIN_ATTEMPTS = 10000;
                    UserStatusManager.clearCache();
                } else {
                    Manager.Out("trying to connect");
                    System.out.println("trying to connect");
                    if (Client.this.parent.connect(Manager.NetLertProperties) == null) {
                        RELOGIN_THREAD_RUNNING = false;
                        System.out.println("Connected");
                        iIM.revertPreviousStatus();
                        System.out.println("reverted");
                        break;
                    }
                    if (Client.this.parent.getAuthError() == 2) {
                        String pass = (String)Manager.NetLertProperties.get("net.password");
                        if (Manager._is_portal_secure || !Manager.TRY_LDAP_LOGIN) {
                            RELOGIN_THREAD_RUNNING = false;
                            msg = iIMBundle.getString("login_failed");
                            JOptionPane.showMessageDialog(Client.this.parent, msg, iIMBundle.getString("login_failed_title"), 0);
                            iIM.exit(true);
                        } else {
                            RELOGIN_THREAD_RUNNING = false;
                            Client.this.close();
                            iIM.startLogon(false);
                            break;
                        }
                    }
                }
                for (int i = 0; i < 3; ++i) {
                    if (RELOGIN_ATTEMPTS <= 12) {
                        try {
                            Thread.sleep(4000L);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (Client.this.IMMEDIATE_STOP) break;
                }
                if (Client.this.IMMEDIATE_STOP) break;
                ++RELOGIN_ATTEMPTS;
                if (iIM._buddylist != null) {
                    iIM._buddylist.updateReconnectStatusLabel("(" + RELOGIN_ATTEMPTS + ")");
                }
                if (RELOGIN_ATTEMPTS <= 12) continue;
                MessageBox mb = null;
                if (!this.duplicate) {
                    mb = new MessageBox(null, new Point(150, 150), clientBundle.getString("Connection_lost"), clientBundle.getString("Connection_lost_message"), clientBundle.getString("Keep_trying"), clientBundle.getString("btnCancel_text"), null, true);
                    if (mb.getClickedButton() == 0) {
                        RELOGIN_ATTEMPTS = 0;
                        if (iIM._buddylist != null) {
                            iIM._buddylist.updateReconnectStatusLabel("(" + RELOGIN_ATTEMPTS + ")");
                        }
                    } else if (mb.getClickedButton() == 1) {
                        RELOGIN_THREAD_RUNNING = false;
                        iIM.exit(true);
                    }
                } else {
                    Client.this.close();
                    msg = clientBundle.getString("You_may_be_running_more_than_one_iIM");
                    mb = new MessageBox(null, new Point(150, 150), clientBundle.getString("Connection_lost"), msg, clientBundle.getString("ReLogon"), clientBundle.getString("btnCancel_text"), null, true);
                    if (mb.getClickedButton() == 0) {
                        RELOGIN_THREAD_RUNNING = false;
                        Client.this.reLogOn();
                    } else if (mb.getClickedButton() == 1) {
                        RELOGIN_THREAD_RUNNING = false;
                        iIM.exit(true);
                    }
                    this.duplicate = false;
                }
                Object var2_5 = null;
            }
        }
    }
}

