/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.swing;

import com.iplanet.im.client.manager.ApplicationManager;
import com.iplanet.im.client.manager.CurrentUserManager;
import com.iplanet.im.client.manager.Manager;
import com.iplanet.im.client.swing.Client;
import com.iplanet.im.client.swing.chat.bean.RoomFrame;
import com.iplanet.im.client.swing.chat.bean.RoomView;
import com.iplanet.im.client.swing.chat.bean.RoomViewContainer;
import com.iplanet.im.client.util.SafeResourceBundle;
import com.iplanet.im.client.util.iIMPropsUtil;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.Message;
import java.util.Iterator;
import java.util.Vector;

public class Chat {
    public static SafeResourceBundle chatBundle = new SafeResourceBundle("com.iplanet.im.client.swing.swing");
    public static SafeResourceBundle chatPanelBundle = new SafeResourceBundle("com.iplanet.im.client.swing.chat.chat");
    private static Client parent;
    private static RoomFrame roomFrame;
    private static RoomViewContainer roomView;
    private static Vector roomFrameVector;
    private static Vector roomViewVector;

    public Chat(Client c) {
        parent = c;
    }

    public final void enterRoom(Conference conf) {
        Manager.Out("   DEBUG EnterRoom() " + conf.getDestination());
        if (!parent.isConnected() || conf == null) {
            return;
        }
        Iterator rvContainerItr = roomViewVector.iterator();
        while (rvContainerItr.hasNext()) {
            RoomViewContainer rvc = (RoomViewContainer)rvContainerItr.next();
            Iterator rvItr = rvc.getRoomViews().iterator();
            while (rvItr.hasNext()) {
                RoomView rv = (RoomView)rvItr.next();
                if (!rv.getConference().getDestination().equals(conf.getDestination())) continue;
                ApplicationManager.showMessageBox(chatBundle.getString("already_in_room"));
                if (roomFrame != null) {
                    roomFrame.setState(0);
                    roomFrame.toFront();
                }
                return;
            }
        }
        try {
            Chat.validateRoomView(true);
            roomView.addNewRoom(conf, true);
            roomView.setRoomFocus(conf.getDestination());
            roomFrame.setVisible(true);
        }
        catch (CollaborationException e) {
            ApplicationManager.showMessageBox(chatBundle.getString("access_error"));
            return;
        }
    }

    public static final void handleInviteMsg(Conference conference, InviteMessage message) {
        StringBuffer l = new StringBuffer("handleInviteMsg - rcpts: ");
        try {
            String[] da = message.getRecipients();
            for (int i = 0; i < da.length; ++i) {
                l.append(da[i] + " ");
            }
            Manager.Out(l.toString());
            Chat.receiveChatInvite(conference, message);
        }
        catch (CollaborationException e) {
            Manager.Out("Exception " + e.toString());
        }
    }

    public static final void receiveChatInvite(Conference conference, InviteMessage message) throws CollaborationException {
        Chat.validateRoomView(false);
        message.rsvp(true);
        roomView.addNewRoom(conference, conference.isPublic());
        roomView.showInviteMsg(conference.getDestination(), (Message)message);
        roomFrame.setVisible(true);
    }

    public final void startNewChat(CollaborationPrincipal[] users) throws CollaborationException {
        if (!parent.isConnected()) {
            return;
        }
        Chat.validateRoomView(true);
        Conference conf = roomView.addNewChatRoom(CurrentUserManager.getCurrentUserServer(), false);
        roomView.setInviteList(users, conf.getDestination());
        roomView.setRoomFocus(conf.getDestination());
        roomFrame.setVisible(true);
    }

    public final RoomView getRoomViewFor(String roomUid) {
        RoomView found = null;
        int sz = roomViewVector.size();
        for (int i = 0; i < sz; ++i) {
            RoomViewContainer rvc = (RoomViewContainer)roomViewVector.get(i);
            Vector rvs = rvc.getRoomViews();
            for (int x = 0; x < rvs.size(); ++x) {
                RoomView rv = (RoomView)rvs.elementAt(x);
                if (!rv.getConference().getDestination().equals(roomUid)) continue;
                found = rv;
            }
        }
        return found;
    }

    private static void validateRoomView(boolean focus) {
        if (!iIMPropsUtil.getChatTab(CurrentUserManager.getCurrentUserProperties()) || roomFrame == null) {
            roomFrame = new RoomFrame();
            roomView = roomFrame.getRoomViewContainer();
            if (!roomFrameVector.contains(roomFrame)) {
                Manager.Out("[Chat] adding Frame");
                roomFrameVector.add(roomFrame);
                roomViewVector.add(roomView);
            } else {
                Manager.Out("[Chat] Frame already added !!");
            }
        }
        roomFrame.toFront(focus);
        if (focus) {
            roomFrame.requestFocus();
        }
    }

    public void attachModeratedMessageToConference(Message m) throws CollaborationException {
        if (m.getContentType().equals("application/x-iim-moderated")) {
            String roomUid = m.getHeader("room");
            if (roomUid == null) {
                return;
            }
            int sz = roomViewVector.size();
            for (int i = 0; i < sz; ++i) {
                RoomViewContainer rvc = (RoomViewContainer)roomViewVector.get(i);
                Vector rvs = rvc.getRoomViews();
                for (int x = 0; x < rvs.size(); ++x) {
                    RoomView rv = (RoomView)rvs.elementAt(x);
                    if (!rv.getConference().getDestination().equals(roomUid)) continue;
                    rv.handleNewMsg(m);
                }
            }
        }
    }

    public static final void removeFrame(RoomFrame frame) {
        roomViewVector.remove(frame.getRoomViewContainer());
        if (roomFrameVector.remove(frame)) {
            Manager.Out("[Chat] Removing Frame");
        }
    }

    public void close() {
        int i;
        int sz = roomViewVector.size();
        int x = 0;
        for (i = 0; i < sz; ++i) {
            RoomViewContainer rv = (RoomViewContainer)roomViewVector.get(i - x);
            if (rv == null) continue;
            rv.close(false);
            ++x;
        }
        roomViewVector.removeAllElements();
        sz = roomFrameVector.size();
        x = 0;
        for (i = 0; i < sz; ++i) {
            RoomFrame rf = (RoomFrame)roomFrameVector.get(i - x);
            if (rf == null) continue;
            rf.dispose();
            roomFrameVector.remove(i - x);
            ++x;
        }
        if (roomFrame != null) {
            roomFrame.dispose();
        }
        if (roomView != null) {
            roomView.close(false);
        }
        roomFrame = null;
        roomView = null;
    }

    public void localStatusMessage(String msg) {
        if (roomView != null) {
            roomView.localStatusMessage(msg);
        }
    }

    static {
        roomFrame = null;
        roomView = null;
        roomFrameVector = new Vector(2);
        roomViewVector = new Vector(2);
    }
}

